/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eksauth.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object with the permanent IAM role identity and the temporary session name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssumedRoleUser implements SdkPojo, Serializable, ToCopyableBuilder<AssumedRoleUser.Builder, AssumedRoleUser> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AssumedRoleUser::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ASSUME_ROLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assumeRoleId").getter(getter(AssumedRoleUser::assumeRoleId)).setter(setter(Builder::assumeRoleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assumeRoleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            ASSUME_ROLE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String assumeRoleId;

    private AssumedRoleUser(BuilderImpl builder) {
        this.arn = builder.arn;
        this.assumeRoleId = builder.assumeRoleId;
    }

    /**
     * <p>
     * The ARN of the IAM role that the temporary credentials authenticate to.
     * </p>
     * 
     * @return The ARN of the IAM role that the temporary credentials authenticate to.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The session name of the temporary session requested to STS. The value is a unique identifier that contains the
     * role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The role ID is
     * generated by IAM when the role is created. The role session name part of the value follows this format:
     * <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     * </p>
     * 
     * @return The session name of the temporary session requested to STS. The value is a unique identifier that
     *         contains the role ID, a colon (<code>:</code>), and the role session name of the role that is being
     *         assumed. The role ID is generated by IAM when the role is created. The role session name part of the
     *         value follows this format: <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     */
    public final String assumeRoleId() {
        return assumeRoleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(assumeRoleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumedRoleUser)) {
            return false;
        }
        AssumedRoleUser other = (AssumedRoleUser) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(assumeRoleId(), other.assumeRoleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssumedRoleUser").add("Arn", arn()).add("AssumeRoleId", assumeRoleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "assumeRoleId":
            return Optional.ofNullable(clazz.cast(assumeRoleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssumedRoleUser, T> g) {
        return obj -> g.apply((AssumedRoleUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssumedRoleUser> {
        /**
         * <p>
         * The ARN of the IAM role that the temporary credentials authenticate to.
         * </p>
         * 
         * @param arn
         *        The ARN of the IAM role that the temporary credentials authenticate to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The session name of the temporary session requested to STS. The value is a unique identifier that contains
         * the role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The role
         * ID is generated by IAM when the role is created. The role session name part of the value follows this format:
         * <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
         * </p>
         * 
         * @param assumeRoleId
         *        The session name of the temporary session requested to STS. The value is a unique identifier that
         *        contains the role ID, a colon (<code>:</code>), and the role session name of the role that is being
         *        assumed. The role ID is generated by IAM when the role is created. The role session name part of the
         *        value follows this format: <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumeRoleId(String assumeRoleId);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String assumeRoleId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumedRoleUser model) {
            arn(model.arn);
            assumeRoleId(model.assumeRoleId);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAssumeRoleId() {
            return assumeRoleId;
        }

        public final void setAssumeRoleId(String assumeRoleId) {
            this.assumeRoleId = assumeRoleId;
        }

        @Override
        public final Builder assumeRoleId(String assumeRoleId) {
            this.assumeRoleId = assumeRoleId;
            return this;
        }

        @Override
        public AssumedRoleUser build() {
            return new AssumedRoleUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
