/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.elasticache.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.elasticache.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.elasticache.model.ApiCallRateForCustomerExceededException;
import software.amazon.awssdk.services.elasticache.model.AuthorizationAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest;
import software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse;
import software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionRequest;
import software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionResponse;
import software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionRequest;
import software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionResponse;
import software.amazon.awssdk.services.elasticache.model.CacheClusterAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheClusterNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupInUseException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.ClusterQuotaForCustomerExceededException;
import software.amazon.awssdk.services.elasticache.model.CompleteMigrationRequest;
import software.amazon.awssdk.services.elasticache.model.CompleteMigrationResponse;
import software.amazon.awssdk.services.elasticache.model.CopySnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.CopySnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.CreateUserGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateUserGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateUserRequest;
import software.amazon.awssdk.services.elasticache.model.CreateUserResponse;
import software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest;
import software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountResponse;
import software.amazon.awssdk.services.elasticache.model.DefaultUserAssociatedToUserGroupException;
import software.amazon.awssdk.services.elasticache.model.DefaultUserRequiredException;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteUserGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteUserGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteUserRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteUserResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeEventsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeUsersResponse;
import software.amazon.awssdk.services.elasticache.model.DisassociateGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DisassociateGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DuplicateUserNameException;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheException;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountRequest;
import software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountResponse;
import software.amazon.awssdk.services.elasticache.model.InsufficientCacheClusterCapacityException;
import software.amazon.awssdk.services.elasticache.model.InvalidArnException;
import software.amazon.awssdk.services.elasticache.model.InvalidCacheClusterStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidCacheParameterGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidCacheSecurityGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidGlobalReplicationGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidKmsKeyException;
import software.amazon.awssdk.services.elasticache.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.elasticache.model.InvalidParameterValueException;
import software.amazon.awssdk.services.elasticache.model.InvalidReplicationGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidSnapshotStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidSubnetException;
import software.amazon.awssdk.services.elasticache.model.InvalidUserGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidUserStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsRequest;
import software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsResponse;
import software.amazon.awssdk.services.elasticache.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.elasticache.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyUserGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyUserGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyUserRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyUserResponse;
import software.amazon.awssdk.services.elasticache.model.NoOperationException;
import software.amazon.awssdk.services.elasticache.model.NodeGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.NodeGroupsPerReplicationGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.NodeQuotaForClusterExceededException;
import software.amazon.awssdk.services.elasticache.model.NodeQuotaForCustomerExceededException;
import software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest;
import software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingResponse;
import software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.RebootCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.RebootCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupAlreadyUnderMigrationException;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupNotUnderMigrationException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodeAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodeNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodeQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOfferingNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest;
import software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressResponse;
import software.amazon.awssdk.services.elasticache.model.ServiceLinkedRoleNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdateNotFoundException;
import software.amazon.awssdk.services.elasticache.model.SnapshotAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.SnapshotFeatureNotSupportedException;
import software.amazon.awssdk.services.elasticache.model.SnapshotNotFoundException;
import software.amazon.awssdk.services.elasticache.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.StartMigrationRequest;
import software.amazon.awssdk.services.elasticache.model.StartMigrationResponse;
import software.amazon.awssdk.services.elasticache.model.SubnetInUseException;
import software.amazon.awssdk.services.elasticache.model.SubnetNotAllowedException;
import software.amazon.awssdk.services.elasticache.model.TagNotFoundException;
import software.amazon.awssdk.services.elasticache.model.TagQuotaPerResourceExceededException;
import software.amazon.awssdk.services.elasticache.model.TestFailoverNotAvailableException;
import software.amazon.awssdk.services.elasticache.model.TestFailoverRequest;
import software.amazon.awssdk.services.elasticache.model.TestFailoverResponse;
import software.amazon.awssdk.services.elasticache.model.UserAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.UserGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.UserGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.UserGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.UserNotFoundException;
import software.amazon.awssdk.services.elasticache.model.UserQuotaExceededException;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheClustersPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheEngineVersionsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParameterGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParametersPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSecurityGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSubnetGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeEngineDefaultParametersPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeGlobalReplicationGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeReplicationGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesOfferingsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeServiceUpdatesPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeSnapshotsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeUpdateActionsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeUserGroupsPublisher;
import software.amazon.awssdk.services.elasticache.paginators.DescribeUsersPublisher;
import software.amazon.awssdk.services.elasticache.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.AuthorizeCacheSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.BatchApplyUpdateActionRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.BatchStopUpdateActionRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CompleteMigrationRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateUserGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DecreaseNodeGroupsInGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DecreaseReplicaCountRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteUserGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheClustersRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheParametersRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeEngineDefaultParametersRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeGlobalReplicationGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeReplicationGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeReservedCacheNodesOfferingsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeReservedCacheNodesRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeServiceUpdatesRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeUpdateActionsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeUserGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeUsersRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DisassociateGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.FailoverGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.IncreaseNodeGroupsInGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.IncreaseReplicaCountRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ListAllowedNodeTypeModificationsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyCacheSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyReplicationGroupShardConfigurationRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyUserGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyUserRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.PurchaseReservedCacheNodesOfferingRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.RebalanceSlotsInGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.RebootCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ResetCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.RevokeCacheSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.StartMigrationRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.TestFailoverRequestMarshaller;
import software.amazon.awssdk.services.elasticache.waiters.ElastiCacheAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ElastiCacheAsyncClient}.
 *
 * @see ElastiCacheAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultElastiCacheAsyncClient implements ElastiCacheAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultElastiCacheAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultElastiCacheAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track
     * all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on
     * replication groups, those actions will be replicated to all nodes in the replication group. For more information,
     * see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html">Resource
     * -level permissions</a>.
     * </p>
     * <p>
     * For example, you can use cost-allocation tags to your ElastiCache resources, Amazon generates a cost allocation
     * report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply
     * tags that represent business categories (such as cost centers, application names, or owners) to organize your
     * costs across multiple services.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html">Using Cost Allocation Tags in
     * Amazon ElastiCache</a> in the <i>ElastiCache User Guide</i>.
     * </p>
     *
     * @param addTagsToResourceRequest
     *        Represents the input of an AddTagsToResource operation.
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidArnException The requested Amazon Resource Name (ARN) does not refer to an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/AddTagsToResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToResource");

            HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(AddTagsToResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AddTagsToResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                            .withOperationName("AddTagsToResource")
                            .withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(addTagsToResourceRequest));
            CompletableFuture<AddTagsToResourceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows network ingress to a cache security group. Applications using ElastiCache must be running on Amazon EC2,
     * and Amazon EC2 security groups are used as the authorization mechanism.
     * </p>
     * <note>
     * <p>
     * You cannot authorize ingress from an Amazon EC2 security group in one region to an ElastiCache cluster in another
     * region.
     * </p>
     * </note>
     *
     * @param authorizeCacheSecurityGroupIngressRequest
     *        Represents the input of an AuthorizeCacheSecurityGroupIngress operation.
     * @return A Java Future containing the result of the AuthorizeCacheSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>InvalidCacheSecurityGroupStateException The current state of the cache security group does not allow
     *         deletion.</li>
     *         <li>AuthorizationAlreadyExistsException The specified Amazon EC2 security group is already authorized for
     *         the specified cache security group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.AuthorizeCacheSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/AuthorizeCacheSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AuthorizeCacheSecurityGroupIngressResponse> authorizeCacheSecurityGroupIngress(
            AuthorizeCacheSecurityGroupIngressRequest authorizeCacheSecurityGroupIngressRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                authorizeCacheSecurityGroupIngressRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeCacheSecurityGroupIngress");

            HttpResponseHandler<AuthorizeCacheSecurityGroupIngressResponse> responseHandler = protocolFactory
                    .createResponseHandler(AuthorizeCacheSecurityGroupIngressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AuthorizeCacheSecurityGroupIngressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AuthorizeCacheSecurityGroupIngressRequest, AuthorizeCacheSecurityGroupIngressResponse>()
                            .withOperationName("AuthorizeCacheSecurityGroupIngress")
                            .withMarshaller(new AuthorizeCacheSecurityGroupIngressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(authorizeCacheSecurityGroupIngressRequest));
            CompletableFuture<AuthorizeCacheSecurityGroupIngressResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Apply the service update. For more information on service updates and applying them, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/applying-updates.html">Applying Service
     * Updates</a>.
     * </p>
     *
     * @param batchApplyUpdateActionRequest
     * @return A Java Future containing the result of the BatchApplyUpdateAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUpdateNotFoundException The service update doesn't exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.BatchApplyUpdateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/BatchApplyUpdateAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchApplyUpdateActionResponse> batchApplyUpdateAction(
            BatchApplyUpdateActionRequest batchApplyUpdateActionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchApplyUpdateActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchApplyUpdateAction");

            HttpResponseHandler<BatchApplyUpdateActionResponse> responseHandler = protocolFactory
                    .createResponseHandler(BatchApplyUpdateActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<BatchApplyUpdateActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchApplyUpdateActionRequest, BatchApplyUpdateActionResponse>()
                            .withOperationName("BatchApplyUpdateAction")
                            .withMarshaller(new BatchApplyUpdateActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchApplyUpdateActionRequest));
            CompletableFuture<BatchApplyUpdateActionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stop the service update. For more information on service updates and stopping them, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/stopping-self-service-updates.html">Stopping
     * Service Updates</a>.
     * </p>
     *
     * @param batchStopUpdateActionRequest
     * @return A Java Future containing the result of the BatchStopUpdateAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUpdateNotFoundException The service update doesn't exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.BatchStopUpdateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/BatchStopUpdateAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchStopUpdateActionResponse> batchStopUpdateAction(
            BatchStopUpdateActionRequest batchStopUpdateActionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchStopUpdateActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchStopUpdateAction");

            HttpResponseHandler<BatchStopUpdateActionResponse> responseHandler = protocolFactory
                    .createResponseHandler(BatchStopUpdateActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<BatchStopUpdateActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchStopUpdateActionRequest, BatchStopUpdateActionResponse>()
                            .withOperationName("BatchStopUpdateAction")
                            .withMarshaller(new BatchStopUpdateActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchStopUpdateActionRequest));
            CompletableFuture<BatchStopUpdateActionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Complete the migration of data.
     * </p>
     *
     * @param completeMigrationRequest
     * @return A Java Future containing the result of the CompleteMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>ReplicationGroupNotUnderMigrationException The designated replication group is not available for data
     *         migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CompleteMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CompleteMigration" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CompleteMigrationResponse> completeMigration(CompleteMigrationRequest completeMigrationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, completeMigrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CompleteMigration");

            HttpResponseHandler<CompleteMigrationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CompleteMigrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CompleteMigrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CompleteMigrationRequest, CompleteMigrationResponse>()
                            .withOperationName("CompleteMigration")
                            .withMarshaller(new CompleteMigrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(completeMigrationRequest));
            CompletableFuture<CompleteMigrationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Makes a copy of an existing snapshot.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note> <important>
     * <p>
     * Users or groups that have permissions to use the <code>CopySnapshot</code> operation can create their own Amazon
     * S3 buckets and copy snapshots to it. To control access to your snapshots, use an IAM policy to control who has
     * the ability to use the <code>CopySnapshot</code> operation. For more information about using IAM to control the
     * use of ElastiCache operations, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html">Exporting Snapshots</a>
     * and <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.html">Authentication &amp; Access
     * Control</a>.
     * </p>
     * </important>
     * <p>
     * You could receive the following error messages.
     * </p>
     * <p class="title">
     * <b>Error Messages</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s is outside of the region.
     * </p>
     * <p>
     * <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket"
     * >Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s does not exist.
     * </p>
     * <p>
     * <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket"
     * >Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s is not owned by the authenticated user.
     * </p>
     * <p>
     * <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket"
     * >Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The authenticated user does not have sufficient permissions to perform the desired
     * activity.
     * </p>
     * <p>
     * <b>Solution:</b> Contact your system administrator to get the needed permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s already contains an object with key %s.
     * </p>
     * <p>
     * <b>Solution:</b> Give the <code>TargetSnapshotName</code> a new and unique value. If exporting a snapshot, you
     * could alternatively create a new Amazon S3 bucket and use this same value for <code>TargetSnapshotName</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message: </b> ElastiCache has not been granted READ permissions %s on the S3 Bucket.
     * </p>
     * <p>
     * <b>Solution:</b> Add List and Read permissions on the bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
     * >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message: </b> ElastiCache has not been granted WRITE permissions %s on the S3 Bucket.
     * </p>
     * <p>
     * <b>Solution:</b> Add Upload/Delete permissions on the bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
     * >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message: </b> ElastiCache has not been granted READ_ACP permissions %s on the S3 Bucket.
     * </p>
     * <p>
     * <b>Solution:</b> Add View Permissions on the bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
     * >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * </ul>
     *
     * @param copySnapshotRequest
     *        Represents the input of a <code>CopySnapshotMessage</code> operation.
     * @return A Java Future containing the result of the CopySnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotAlreadyExistsException You already have a snapshot with the given name.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>SnapshotQuotaExceededException The request cannot be processed because it would exceed the maximum
     *         number of snapshots.</li>
     *         <li>InvalidSnapshotStateException The current state of the snapshot does not allow the requested
     *         operation to occur.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CopySnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopySnapshotResponse> copySnapshot(CopySnapshotRequest copySnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copySnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopySnapshot");

            HttpResponseHandler<CopySnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(CopySnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CopySnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopySnapshotRequest, CopySnapshotResponse>()
                            .withOperationName("CopySnapshot").withMarshaller(new CopySnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(copySnapshotRequest));
            CompletableFuture<CopySnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant cache engine software, either
     * Memcached or Redis.
     * </p>
     * <p>
     * This operation is not supported for Redis (cluster mode enabled) clusters.
     * </p>
     *
     * @param createCacheClusterRequest
     *        Represents the input of a CreateCacheCluster operation.
     * @return A Java Future containing the result of the CreateCacheCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>CacheClusterAlreadyExistsException You already have a cluster with the given identifier.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>ClusterQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of clusters per customer.</li>
     *         <li>NodeQuotaForClusterExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes in a single cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCacheClusterResponse> createCacheCluster(CreateCacheClusterRequest createCacheClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCacheClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCacheCluster");

            HttpResponseHandler<CreateCacheClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateCacheClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateCacheClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCacheClusterRequest, CreateCacheClusterResponse>()
                            .withOperationName("CreateCacheCluster")
                            .withMarshaller(new CreateCacheClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCacheClusterRequest));
            CompletableFuture<CreateCacheClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter group is a collection of
     * parameters and their values that are applied to all of the nodes in any cluster or replication group using the
     * CacheParameterGroup.
     * </p>
     * <p>
     * A newly created CacheParameterGroup is an exact duplicate of the default parameter group for the
     * CacheParameterGroupFamily. To customize the newly created CacheParameterGroup you can change the values of
     * specific parameters. For more information, see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheParameterGroup.html">
     * ModifyCacheParameterGroup</a> in the ElastiCache API Reference.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ParameterGroups.html">Parameters and
     * Parameter Groups</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * </ul>
     *
     * @param createCacheParameterGroupRequest
     *        Represents the input of a <code>CreateCacheParameterGroup</code> operation.
     * @return A Java Future containing the result of the CreateCacheParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupQuotaExceededException The request cannot be processed because it would exceed the
     *         maximum number of cache security groups.</li>
     *         <li>CacheParameterGroupAlreadyExistsException A cache parameter group with the requested name already
     *         exists.</li>
     *         <li>InvalidCacheParameterGroupStateException The current state of the cache parameter group does not
     *         allow the requested operation to occur.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCacheParameterGroupResponse> createCacheParameterGroup(
            CreateCacheParameterGroupRequest createCacheParameterGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCacheParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCacheParameterGroup");

            HttpResponseHandler<CreateCacheParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateCacheParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateCacheParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCacheParameterGroupRequest, CreateCacheParameterGroupResponse>()
                            .withOperationName("CreateCacheParameterGroup")
                            .withMarshaller(new CreateCacheParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCacheParameterGroupRequest));
            CompletableFuture<CreateCacheParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new cache security group. Use a cache security group to control access to one or more clusters.
     * </p>
     * <p>
     * Cache security groups are only used when you are creating a cluster outside of an Amazon Virtual Private Cloud
     * (Amazon VPC). If you are creating a cluster inside of a VPC, use a cache subnet group instead. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html"
     * >CreateCacheSubnetGroup</a>.
     * </p>
     *
     * @param createCacheSecurityGroupRequest
     *        Represents the input of a <code>CreateCacheSecurityGroup</code> operation.
     * @return A Java Future containing the result of the CreateCacheSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSecurityGroupAlreadyExistsException A cache security group with the specified name already
     *         exists.</li>
     *         <li>CacheSecurityGroupQuotaExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache security groups.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateCacheSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCacheSecurityGroupResponse> createCacheSecurityGroup(
            CreateCacheSecurityGroupRequest createCacheSecurityGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCacheSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCacheSecurityGroup");

            HttpResponseHandler<CreateCacheSecurityGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateCacheSecurityGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateCacheSecurityGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCacheSecurityGroupRequest, CreateCacheSecurityGroupResponse>()
                            .withOperationName("CreateCacheSecurityGroup")
                            .withMarshaller(new CreateCacheSecurityGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCacheSecurityGroupRequest));
            CompletableFuture<CreateCacheSecurityGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new cache subnet group.
     * </p>
     * <p>
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     * </p>
     *
     * @param createCacheSubnetGroupRequest
     *        Represents the input of a <code>CreateCacheSubnetGroup</code> operation.
     * @return A Java Future containing the result of the CreateCacheSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupAlreadyExistsException The requested cache subnet group name is already in use by an
     *         existing cache subnet group.</li>
     *         <li>CacheSubnetGroupQuotaExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache subnet groups.</li>
     *         <li>CacheSubnetQuotaExceededException The request cannot be processed because it would exceed the allowed
     *         number of subnets in a cache subnet group.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidSubnetException An invalid subnet identifier was specified.</li>
     *         <li>SubnetNotAllowedException At least one subnet ID does not match the other subnet IDs. This mismatch
     *         typically occurs when a user sets one subnet ID to a regional Availability Zone and a different one to an
     *         outpost. Or when a user sets the subnet ID to an Outpost when not subscribed on this service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateCacheSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCacheSubnetGroupResponse> createCacheSubnetGroup(
            CreateCacheSubnetGroupRequest createCacheSubnetGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCacheSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCacheSubnetGroup");

            HttpResponseHandler<CreateCacheSubnetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateCacheSubnetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateCacheSubnetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCacheSubnetGroupRequest, CreateCacheSubnetGroupResponse>()
                            .withOperationName("CreateCacheSubnetGroup")
                            .withMarshaller(new CreateCacheSubnetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCacheSubnetGroupRequest));
            CompletableFuture<CreateCacheSubnetGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Global Datastore for Redis offers fully managed, fast, reliable and secure cross-region replication. Using Global
     * Datastore for Redis, you can create cross-region read replica clusters for ElastiCache for Redis to enable
     * low-latency reads and disaster recovery across regions. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastore.html">Replication Across
     * Regions Using Global Datastore</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <b>GlobalReplicationGroupIdSuffix</b> is the name of the Global datastore.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <b>PrimaryReplicationGroupId</b> represents the name of the primary cluster that accepts writes and will
     * replicate updates to the secondary cluster.
     * </p>
     * </li>
     * </ul>
     *
     * @param createGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the CreateGlobalReplicationGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>GlobalReplicationGroupAlreadyExistsException The Global datastore name already exists.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGlobalReplicationGroupResponse> createGlobalReplicationGroup(
            CreateGlobalReplicationGroupRequest createGlobalReplicationGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGlobalReplicationGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGlobalReplicationGroup");

            HttpResponseHandler<CreateGlobalReplicationGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateGlobalReplicationGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateGlobalReplicationGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGlobalReplicationGroupRequest, CreateGlobalReplicationGroupResponse>()
                            .withOperationName("CreateGlobalReplicationGroup")
                            .withMarshaller(new CreateGlobalReplicationGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createGlobalReplicationGroupRequest));
            CompletableFuture<CreateGlobalReplicationGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group.
     * </p>
     * <p>
     * This API can be used to create a standalone regional replication group or a secondary replication group
     * associated with a Global datastore.
     * </p>
     * <p>
     * A Redis (cluster mode disabled) replication group is a collection of clusters, where one of the clusters is a
     * read/write primary and the others are read-only replicas. Writes to the primary are asynchronously propagated to
     * the replicas.
     * </p>
     * <p>
     * A Redis cluster-mode enabled cluster is comprised of from 1 to 90 shards (API/CLI: node groups). Each shard has a
     * primary node and up to 5 read-only replica nodes. The configuration can range from 90 shards and 0 replicas to 15
     * shards and 5 replicas, which is the maximum number or replicas allowed.
     * </p>
     * <p>
     * The node or shard limit can be increased to a maximum of 500 per cluster if the Redis engine version is 5.0.6 or
     * higher. For example, you can choose to configure a 500 node cluster that ranges between 83 shards (one primary
     * and 5 replicas per shard) and 500 shards (single primary and no replicas). Make sure there are enough available
     * IP addresses to accommodate the increase. Common pitfalls include the subnets in the subnet group have too small
     * a CIDR range or the subnets are shared and heavily used by other clusters. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.Creating.html">Creating a Subnet
     * Group</a>. For versions below 5.0.6, the limit is 250 per cluster.
     * </p>
     * <p>
     * To request a limit increase, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Service Limits</a> and choose
     * the limit type <b>Nodes per cluster per instance type</b>.
     * </p>
     * <p>
     * When a Redis (cluster mode disabled) replication group has been successfully created, you can add one or more
     * read replicas to it, up to a total of 5 read replicas. If you need to increase or decrease the number of node
     * groups (console: shards), you can avail yourself of ElastiCache for Redis' scaling. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Scaling.html">Scaling ElastiCache for Redis
     * Clusters</a> in the <i>ElastiCache User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @param createReplicationGroupRequest
     *        Represents the input of a <code>CreateReplicationGroup</code> operation.
     * @return A Java Future containing the result of the CreateReplicationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>ReplicationGroupAlreadyExistsException The specified replication group already exists.</li>
     *         <li>InvalidUserGroupStateException The user group is not in an active state.</li>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>ClusterQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of clusters per customer.</li>
     *         <li>NodeQuotaForClusterExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes in a single cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>NodeGroupsPerReplicationGroupQuotaExceededException The request cannot be processed because it would
     *         exceed the maximum allowed number of node groups (shards) in a single replication group. The default
     *         maximum is 90</li>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateReplicationGroupResponse> createReplicationGroup(
            CreateReplicationGroupRequest createReplicationGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReplicationGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReplicationGroup");

            HttpResponseHandler<CreateReplicationGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateReplicationGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateReplicationGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateReplicationGroupRequest, CreateReplicationGroupResponse>()
                            .withOperationName("CreateReplicationGroup")
                            .withMarshaller(new CreateReplicationGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createReplicationGroupRequest));
            CompletableFuture<CreateReplicationGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a copy of an entire cluster or replication group at a specific moment in time.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @param createSnapshotRequest
     *        Represents the input of a <code>CreateSnapshot</code> operation.
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotAlreadyExistsException You already have a snapshot with the given name.</li>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>SnapshotQuotaExceededException The request cannot be processed because it would exceed the maximum
     *         number of snapshots.</li>
     *         <li>SnapshotFeatureNotSupportedException You attempted one of the following operations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Creating a snapshot of a Redis cluster running on a <code>cache.t1.micro</code> cache node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Creating a snapshot of a cluster that is running Memcached rather than Redis.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Neither of these are supported by ElastiCache.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshot");

            HttpResponseHandler<CreateSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSnapshotRequest, CreateSnapshotResponse>()
                            .withOperationName("CreateSnapshot")
                            .withMarshaller(new CreateSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSnapshotRequest));
            CompletableFuture<CreateSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For Redis engine version 6.0 onwards: Creates a Redis user. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserAlreadyExistsException A user with this ID already exists.</li>
     *         <li>UserQuotaExceededException The quota of users has been exceeded.</li>
     *         <li>DuplicateUserNameException A user with this username already exists.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUser");

            HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>().withOperationName("CreateUser")
                            .withMarshaller(new CreateUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createUserRequest));
            CompletableFuture<CreateUserResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For Redis engine version 6.0 onwards: Creates a Redis user group. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>
     * </p>
     *
     * @param createUserGroupRequest
     * @return A Java Future containing the result of the CreateUserGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>DuplicateUserNameException A user with this username already exists.</li>
     *         <li>UserGroupAlreadyExistsException The user group with this ID already exists.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>DefaultUserRequiredException You must add default user to a user group.</li>
     *         <li>UserGroupQuotaExceededException The number of users exceeds the user group limit.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.CreateUserGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateUserGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserGroupResponse> createUserGroup(CreateUserGroupRequest createUserGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserGroup");

            HttpResponseHandler<CreateUserGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateUserGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateUserGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserGroupRequest, CreateUserGroupResponse>()
                            .withOperationName("CreateUserGroup")
                            .withMarshaller(new CreateUserGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createUserGroupRequest));
            CompletableFuture<CreateUserGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Decreases the number of node groups in a Global datastore
     * </p>
     *
     * @param decreaseNodeGroupsInGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the DecreaseNodeGroupsInGlobalReplicationGroup operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DecreaseNodeGroupsInGlobalReplicationGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DecreaseNodeGroupsInGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DecreaseNodeGroupsInGlobalReplicationGroupResponse> decreaseNodeGroupsInGlobalReplicationGroup(
            DecreaseNodeGroupsInGlobalReplicationGroupRequest decreaseNodeGroupsInGlobalReplicationGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                decreaseNodeGroupsInGlobalReplicationGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DecreaseNodeGroupsInGlobalReplicationGroup");

            HttpResponseHandler<DecreaseNodeGroupsInGlobalReplicationGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DecreaseNodeGroupsInGlobalReplicationGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DecreaseNodeGroupsInGlobalReplicationGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DecreaseNodeGroupsInGlobalReplicationGroupRequest, DecreaseNodeGroupsInGlobalReplicationGroupResponse>()
                            .withOperationName("DecreaseNodeGroupsInGlobalReplicationGroup")
                            .withMarshaller(new DecreaseNodeGroupsInGlobalReplicationGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(decreaseNodeGroupsInGlobalReplicationGroupRequest));
            CompletableFuture<DecreaseNodeGroupsInGlobalReplicationGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Dynamically decreases the number of replicas in a Redis (cluster mode disabled) replication group or the number
     * of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This
     * operation is performed with no cluster down time.
     * </p>
     *
     * @param decreaseReplicaCountRequest
     * @return A Java Future containing the result of the DecreaseReplicaCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>ClusterQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of clusters per customer.</li>
     *         <li>NodeGroupsPerReplicationGroupQuotaExceededException The request cannot be processed because it would
     *         exceed the maximum allowed number of node groups (shards) in a single replication group. The default
     *         maximum is 90</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>NoOperationException The operation was not performed because no changes were required.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DecreaseReplicaCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DecreaseReplicaCount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DecreaseReplicaCountResponse> decreaseReplicaCount(
            DecreaseReplicaCountRequest decreaseReplicaCountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, decreaseReplicaCountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DecreaseReplicaCount");

            HttpResponseHandler<DecreaseReplicaCountResponse> responseHandler = protocolFactory
                    .createResponseHandler(DecreaseReplicaCountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DecreaseReplicaCountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DecreaseReplicaCountRequest, DecreaseReplicaCountResponse>()
                            .withOperationName("DecreaseReplicaCount")
                            .withMarshaller(new DecreaseReplicaCountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(decreaseReplicaCountRequest));
            CompletableFuture<DecreaseReplicaCountResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a previously provisioned cluster. <code>DeleteCacheCluster</code> deletes all associated cache nodes,
     * node endpoints and the cluster itself. When you receive a successful response from this operation, Amazon
     * ElastiCache immediately begins deleting the cluster; you cannot cancel or revert this operation.
     * </p>
     * <p>
     * This operation is not valid for:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Redis (cluster mode enabled) clusters
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis (cluster mode disabled) clusters
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster that is the last read replica of a replication group
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster that is the primary node of a replication group
     * </p>
     * </li>
     * <li>
     * <p>
     * A node group (shard) that has Multi-AZ mode enabled
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster from a Redis (cluster mode enabled) replication group
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster that is not in the <code>available</code> state
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteCacheClusterRequest
     *        Represents the input of a <code>DeleteCacheCluster</code> operation.
     * @return A Java Future containing the result of the DeleteCacheCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>SnapshotAlreadyExistsException You already have a snapshot with the given name.</li>
     *         <li>SnapshotFeatureNotSupportedException You attempted one of the following operations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Creating a snapshot of a Redis cluster running on a <code>cache.t1.micro</code> cache node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Creating a snapshot of a cluster that is running Memcached rather than Redis.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Neither of these are supported by ElastiCache.</li>
     *         <li>SnapshotQuotaExceededException The request cannot be processed because it would exceed the maximum
     *         number of snapshots.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCacheClusterResponse> deleteCacheCluster(DeleteCacheClusterRequest deleteCacheClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCacheClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCacheCluster");

            HttpResponseHandler<DeleteCacheClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteCacheClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteCacheClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCacheClusterRequest, DeleteCacheClusterResponse>()
                            .withOperationName("DeleteCacheCluster")
                            .withMarshaller(new DeleteCacheClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteCacheClusterRequest));
            CompletableFuture<DeleteCacheClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified cache parameter group. You cannot delete a cache parameter group if it is associated with
     * any cache clusters. You cannot delete the default cache parameter groups in your account.
     * </p>
     *
     * @param deleteCacheParameterGroupRequest
     *        Represents the input of a <code>DeleteCacheParameterGroup</code> operation.
     * @return A Java Future containing the result of the DeleteCacheParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidCacheParameterGroupStateException The current state of the cache parameter group does not
     *         allow the requested operation to occur.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCacheParameterGroupResponse> deleteCacheParameterGroup(
            DeleteCacheParameterGroupRequest deleteCacheParameterGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCacheParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCacheParameterGroup");

            HttpResponseHandler<DeleteCacheParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteCacheParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteCacheParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCacheParameterGroupRequest, DeleteCacheParameterGroupResponse>()
                            .withOperationName("DeleteCacheParameterGroup")
                            .withMarshaller(new DeleteCacheParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteCacheParameterGroupRequest));
            CompletableFuture<DeleteCacheParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a cache security group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a cache security group if it is associated with any clusters.
     * </p>
     * </note>
     *
     * @param deleteCacheSecurityGroupRequest
     *        Represents the input of a <code>DeleteCacheSecurityGroup</code> operation.
     * @return A Java Future containing the result of the DeleteCacheSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidCacheSecurityGroupStateException The current state of the cache security group does not allow
     *         deletion.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteCacheSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCacheSecurityGroupResponse> deleteCacheSecurityGroup(
            DeleteCacheSecurityGroupRequest deleteCacheSecurityGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCacheSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCacheSecurityGroup");

            HttpResponseHandler<DeleteCacheSecurityGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteCacheSecurityGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteCacheSecurityGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCacheSecurityGroupRequest, DeleteCacheSecurityGroupResponse>()
                            .withOperationName("DeleteCacheSecurityGroup")
                            .withMarshaller(new DeleteCacheSecurityGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteCacheSecurityGroupRequest));
            CompletableFuture<DeleteCacheSecurityGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a cache subnet group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a default cache subnet group or one that is associated with any clusters.
     * </p>
     * </note>
     *
     * @param deleteCacheSubnetGroupRequest
     *        Represents the input of a <code>DeleteCacheSubnetGroup</code> operation.
     * @return A Java Future containing the result of the DeleteCacheSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupInUseException The requested cache subnet group is currently in use.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteCacheSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCacheSubnetGroupResponse> deleteCacheSubnetGroup(
            DeleteCacheSubnetGroupRequest deleteCacheSubnetGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCacheSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCacheSubnetGroup");

            HttpResponseHandler<DeleteCacheSubnetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteCacheSubnetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteCacheSubnetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCacheSubnetGroupRequest, DeleteCacheSubnetGroupResponse>()
                            .withOperationName("DeleteCacheSubnetGroup")
                            .withMarshaller(new DeleteCacheSubnetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteCacheSubnetGroupRequest));
            CompletableFuture<DeleteCacheSubnetGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deleting a Global datastore is a two-step process:
     * </p>
     * <ul>
     * <li>
     * <p>
     * First, you must <a>DisassociateGlobalReplicationGroup</a> to remove the secondary clusters in the Global
     * datastore.
     * </p>
     * </li>
     * <li>
     * <p>
     * Once the Global datastore contains only the primary cluster, you can use the
     * <code>DeleteGlobalReplicationGroup</code> API to delete the Global datastore while retainining the primary
     * cluster using <code>RetainPrimaryReplicationGroup=true</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Since the Global Datastore has only a primary cluster, you can delete the Global Datastore while retaining the
     * primary by setting <code>RetainPrimaryReplicationGroup=true</code>. The primary cluster is never deleted when
     * deleting a Global Datastore. It can only be deleted when it no longer is associated with any Global Datastore.
     * </p>
     * <p>
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the
     * selected resources; you cannot cancel or revert this operation.
     * </p>
     *
     * @param deleteGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the DeleteGlobalReplicationGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGlobalReplicationGroupResponse> deleteGlobalReplicationGroup(
            DeleteGlobalReplicationGroupRequest deleteGlobalReplicationGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGlobalReplicationGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGlobalReplicationGroup");

            HttpResponseHandler<DeleteGlobalReplicationGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteGlobalReplicationGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteGlobalReplicationGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGlobalReplicationGroupRequest, DeleteGlobalReplicationGroupResponse>()
                            .withOperationName("DeleteGlobalReplicationGroup")
                            .withMarshaller(new DeleteGlobalReplicationGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteGlobalReplicationGroupRequest));
            CompletableFuture<DeleteGlobalReplicationGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing replication group. By default, this operation deletes the entire replication group, including
     * the primary/primaries and all of the read replicas. If the replication group has only one primary, you can
     * optionally delete only the read replicas, while retaining the primary by setting
     * <code>RetainPrimaryCluster=true</code>.
     * </p>
     * <p>
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the
     * selected resources; you cannot cancel or revert this operation.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @param deleteReplicationGroupRequest
     *        Represents the input of a <code>DeleteReplicationGroup</code> operation.
     * @return A Java Future containing the result of the DeleteReplicationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>SnapshotAlreadyExistsException You already have a snapshot with the given name.</li>
     *         <li>SnapshotFeatureNotSupportedException You attempted one of the following operations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Creating a snapshot of a Redis cluster running on a <code>cache.t1.micro</code> cache node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Creating a snapshot of a cluster that is running Memcached rather than Redis.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Neither of these are supported by ElastiCache.</li>
     *         <li>SnapshotQuotaExceededException The request cannot be processed because it would exceed the maximum
     *         number of snapshots.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteReplicationGroupResponse> deleteReplicationGroup(
            DeleteReplicationGroupRequest deleteReplicationGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReplicationGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReplicationGroup");

            HttpResponseHandler<DeleteReplicationGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteReplicationGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteReplicationGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteReplicationGroupRequest, DeleteReplicationGroupResponse>()
                            .withOperationName("DeleteReplicationGroup")
                            .withMarshaller(new DeleteReplicationGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteReplicationGroupRequest));
            CompletableFuture<DeleteReplicationGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing snapshot. When you receive a successful response from this operation, ElastiCache immediately
     * begins deleting the snapshot; you cannot cancel or revert this operation.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @param deleteSnapshotRequest
     *        Represents the input of a <code>DeleteSnapshot</code> operation.
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>InvalidSnapshotStateException The current state of the snapshot does not allow the requested
     *         operation to occur.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSnapshot");

            HttpResponseHandler<DeleteSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSnapshotRequest, DeleteSnapshotResponse>()
                            .withOperationName("DeleteSnapshot")
                            .withMarshaller(new DeleteSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteSnapshotRequest));
            CompletableFuture<DeleteSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For Redis engine version 6.0 onwards: Deletes a user. The user will be removed from all user groups and in turn
     * removed from all replication groups. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidUserStateException The user is not in active state.</li>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>DefaultUserAssociatedToUserGroupException The default user assigned to the user group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");

            HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>().withOperationName("DeleteUser")
                            .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteUserRequest));
            CompletableFuture<DeleteUserResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For Redis engine version 6.0 onwards: Deletes a user group. The user group must first be disassociated from the
     * replication group before it can be deleted. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>.
     * </p>
     *
     * @param deleteUserGroupRequest
     * @return A Java Future containing the result of the DeleteUserGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>InvalidUserGroupStateException The user group is not in an active state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DeleteUserGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteUserGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserGroupResponse> deleteUserGroup(DeleteUserGroupRequest deleteUserGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserGroup");

            HttpResponseHandler<DeleteUserGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteUserGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteUserGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserGroupRequest, DeleteUserGroupResponse>()
                            .withOperationName("DeleteUserGroup")
                            .withMarshaller(new DeleteUserGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteUserGroupRequest));
            CompletableFuture<DeleteUserGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cache cluster if a cluster identifier is supplied.
     * </p>
     * <p>
     * By default, abbreviated information about the clusters is returned. You can use the optional
     * <i>ShowCacheNodeInfo</i> flag to retrieve detailed information about the cache nodes associated with the
     * clusters. These details include the DNS address and port for the cache node endpoint.
     * </p>
     * <p>
     * If the cluster is in the <i>creating</i> state, only cluster-level information is displayed until all of the
     * nodes are successfully provisioned.
     * </p>
     * <p>
     * If the cluster is in the <i>deleting</i> state, only cluster-level information is displayed.
     * </p>
     * <p>
     * If cache nodes are currently being added to the cluster, node endpoint information and creation time for the
     * additional nodes are not displayed until they are completely provisioned. When the cluster state is
     * <i>available</i>, the cluster is ready for use.
     * </p>
     * <p>
     * If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is
     * displayed.
     * </p>
     *
     * @param describeCacheClustersRequest
     *        Represents the input of a <code>DescribeCacheClusters</code> operation.
     * @return A Java Future containing the result of the DescribeCacheClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheClusters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCacheClustersResponse> describeCacheClusters(
            DescribeCacheClustersRequest describeCacheClustersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCacheClustersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCacheClusters");

            HttpResponseHandler<DescribeCacheClustersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeCacheClustersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeCacheClustersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCacheClustersRequest, DescribeCacheClustersResponse>()
                            .withOperationName("DescribeCacheClusters")
                            .withMarshaller(new DescribeCacheClustersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeCacheClustersRequest));
            CompletableFuture<DescribeCacheClustersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cache cluster if a cluster identifier is supplied.
     * </p>
     * <p>
     * By default, abbreviated information about the clusters is returned. You can use the optional
     * <i>ShowCacheNodeInfo</i> flag to retrieve detailed information about the cache nodes associated with the
     * clusters. These details include the DNS address and port for the cache node endpoint.
     * </p>
     * <p>
     * If the cluster is in the <i>creating</i> state, only cluster-level information is displayed until all of the
     * nodes are successfully provisioned.
     * </p>
     * <p>
     * If the cluster is in the <i>deleting</i> state, only cluster-level information is displayed.
     * </p>
     * <p>
     * If cache nodes are currently being added to the cluster, node endpoint information and creation time for the
     * additional nodes are not displayed until they are completely provisioned. When the cluster state is
     * <i>available</i>, the cluster is ready for use.
     * </p>
     * <p>
     * If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is
     * displayed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheClusters(software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheClustersPublisher publisher = client.describeCacheClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheClustersPublisher publisher = client.describeCacheClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheClusters(software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCacheClustersRequest
     *        Represents the input of a <code>DescribeCacheClusters</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheClusters"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeCacheClustersPublisher describeCacheClustersPaginator(DescribeCacheClustersRequest describeCacheClustersRequest) {
        return new DescribeCacheClustersPublisher(this, applyPaginatorUserAgent(describeCacheClustersRequest));
    }

    /**
     * <p>
     * Returns a list of the available cache engines and their versions.
     * </p>
     *
     * @param describeCacheEngineVersionsRequest
     *        Represents the input of a <code>DescribeCacheEngineVersions</code> operation.
     * @return A Java Future containing the result of the DescribeCacheEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCacheEngineVersionsResponse> describeCacheEngineVersions(
            DescribeCacheEngineVersionsRequest describeCacheEngineVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCacheEngineVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCacheEngineVersions");

            HttpResponseHandler<DescribeCacheEngineVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeCacheEngineVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeCacheEngineVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCacheEngineVersionsRequest, DescribeCacheEngineVersionsResponse>()
                            .withOperationName("DescribeCacheEngineVersions")
                            .withMarshaller(new DescribeCacheEngineVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeCacheEngineVersionsRequest));
            CompletableFuture<DescribeCacheEngineVersionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the available cache engines and their versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheEngineVersions(software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheEngineVersionsPublisher publisher = client.describeCacheEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheEngineVersionsPublisher publisher = client.describeCacheEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheEngineVersions(software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCacheEngineVersionsRequest
     *        Represents the input of a <code>DescribeCacheEngineVersions</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeCacheEngineVersionsPublisher describeCacheEngineVersionsPaginator(
            DescribeCacheEngineVersionsRequest describeCacheEngineVersionsRequest) {
        return new DescribeCacheEngineVersionsPublisher(this, applyPaginatorUserAgent(describeCacheEngineVersionsRequest));
    }

    /**
     * <p>
     * Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list
     * contains only the descriptions for that group.
     * </p>
     *
     * @param describeCacheParameterGroupsRequest
     *        Represents the input of a <code>DescribeCacheParameterGroups</code> operation.
     * @return A Java Future containing the result of the DescribeCacheParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCacheParameterGroupsResponse> describeCacheParameterGroups(
            DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCacheParameterGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCacheParameterGroups");

            HttpResponseHandler<DescribeCacheParameterGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeCacheParameterGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeCacheParameterGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCacheParameterGroupsRequest, DescribeCacheParameterGroupsResponse>()
                            .withOperationName("DescribeCacheParameterGroups")
                            .withMarshaller(new DescribeCacheParameterGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeCacheParameterGroupsRequest));
            CompletableFuture<DescribeCacheParameterGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list
     * contains only the descriptions for that group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheParameterGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParameterGroupsPublisher publisher = client.describeCacheParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParameterGroupsPublisher publisher = client.describeCacheParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheParameterGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCacheParameterGroupsRequest
     *        Represents the input of a <code>DescribeCacheParameterGroups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeCacheParameterGroupsPublisher describeCacheParameterGroupsPaginator(
            DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest) {
        return new DescribeCacheParameterGroupsPublisher(this, applyPaginatorUserAgent(describeCacheParameterGroupsRequest));
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular cache parameter group.
     * </p>
     *
     * @param describeCacheParametersRequest
     *        Represents the input of a <code>DescribeCacheParameters</code> operation.
     * @return A Java Future containing the result of the DescribeCacheParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCacheParametersResponse> describeCacheParameters(
            DescribeCacheParametersRequest describeCacheParametersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCacheParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCacheParameters");

            HttpResponseHandler<DescribeCacheParametersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeCacheParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeCacheParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCacheParametersRequest, DescribeCacheParametersResponse>()
                            .withOperationName("DescribeCacheParameters")
                            .withMarshaller(new DescribeCacheParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeCacheParametersRequest));
            CompletableFuture<DescribeCacheParametersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular cache parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheParameters(software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParametersPublisher publisher = client.describeCacheParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParametersPublisher publisher = client.describeCacheParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheParameters(software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCacheParametersRequest
     *        Represents the input of a <code>DescribeCacheParameters</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameters"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeCacheParametersPublisher describeCacheParametersPaginator(
            DescribeCacheParametersRequest describeCacheParametersRequest) {
        return new DescribeCacheParametersPublisher(this, applyPaginatorUserAgent(describeCacheParametersRequest));
    }

    /**
     * <p>
     * Returns a list of cache security group descriptions. If a cache security group name is specified, the list
     * contains only the description of that group. This applicable only when you have ElastiCache in Classic setup
     * </p>
     *
     * @param describeCacheSecurityGroupsRequest
     *        Represents the input of a <code>DescribeCacheSecurityGroups</code> operation.
     * @return A Java Future containing the result of the DescribeCacheSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCacheSecurityGroupsResponse> describeCacheSecurityGroups(
            DescribeCacheSecurityGroupsRequest describeCacheSecurityGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCacheSecurityGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCacheSecurityGroups");

            HttpResponseHandler<DescribeCacheSecurityGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeCacheSecurityGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeCacheSecurityGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCacheSecurityGroupsRequest, DescribeCacheSecurityGroupsResponse>()
                            .withOperationName("DescribeCacheSecurityGroups")
                            .withMarshaller(new DescribeCacheSecurityGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeCacheSecurityGroupsRequest));
            CompletableFuture<DescribeCacheSecurityGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of cache security group descriptions. If a cache security group name is specified, the list
     * contains only the description of that group. This applicable only when you have ElastiCache in Classic setup
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheSecurityGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSecurityGroupsPublisher publisher = client.describeCacheSecurityGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSecurityGroupsPublisher publisher = client.describeCacheSecurityGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheSecurityGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCacheSecurityGroupsRequest
     *        Represents the input of a <code>DescribeCacheSecurityGroups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeCacheSecurityGroupsPublisher describeCacheSecurityGroupsPaginator(
            DescribeCacheSecurityGroupsRequest describeCacheSecurityGroupsRequest) {
        return new DescribeCacheSecurityGroupsPublisher(this, applyPaginatorUserAgent(describeCacheSecurityGroupsRequest));
    }

    /**
     * <p>
     * Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only
     * the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache
     * clusters now launch in VPC by default.
     * </p>
     *
     * @param describeCacheSubnetGroupsRequest
     *        Represents the input of a <code>DescribeCacheSubnetGroups</code> operation.
     * @return A Java Future containing the result of the DescribeCacheSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCacheSubnetGroupsResponse> describeCacheSubnetGroups(
            DescribeCacheSubnetGroupsRequest describeCacheSubnetGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCacheSubnetGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCacheSubnetGroups");

            HttpResponseHandler<DescribeCacheSubnetGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeCacheSubnetGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeCacheSubnetGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCacheSubnetGroupsRequest, DescribeCacheSubnetGroupsResponse>()
                            .withOperationName("DescribeCacheSubnetGroups")
                            .withMarshaller(new DescribeCacheSubnetGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeCacheSubnetGroupsRequest));
            CompletableFuture<DescribeCacheSubnetGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only
     * the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache
     * clusters now launch in VPC by default.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCacheSubnetGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSubnetGroupsPublisher publisher = client.describeCacheSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSubnetGroupsPublisher publisher = client.describeCacheSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCacheSubnetGroups(software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCacheSubnetGroupsRequest
     *        Represents the input of a <code>DescribeCacheSubnetGroups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeCacheSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeCacheSubnetGroupsPublisher describeCacheSubnetGroupsPaginator(
            DescribeCacheSubnetGroupsRequest describeCacheSubnetGroupsRequest) {
        return new DescribeCacheSubnetGroupsPublisher(this, applyPaginatorUserAgent(describeCacheSubnetGroupsRequest));
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified cache engine.
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     *        Represents the input of a <code>DescribeEngineDefaultParameters</code> operation.
     * @return A Java Future containing the result of the DescribeEngineDefaultParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEngineDefaultParametersResponse> describeEngineDefaultParameters(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeEngineDefaultParametersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEngineDefaultParameters");

            HttpResponseHandler<DescribeEngineDefaultParametersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEngineDefaultParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEngineDefaultParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEngineDefaultParametersRequest, DescribeEngineDefaultParametersResponse>()
                            .withOperationName("DescribeEngineDefaultParameters")
                            .withMarshaller(new DescribeEngineDefaultParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEngineDefaultParametersRequest));
            CompletableFuture<DescribeEngineDefaultParametersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified cache engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     *        Represents the input of a <code>DescribeEngineDefaultParameters</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeEngineDefaultParametersPublisher describeEngineDefaultParametersPaginator(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        return new DescribeEngineDefaultParametersPublisher(this, applyPaginatorUserAgent(describeEngineDefaultParametersRequest));
    }

    /**
     * <p>
     * Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events
     * specific to a particular cluster, cache security group, or cache parameter group by providing the name as a
     * parameter.
     * </p>
     * <p>
     * By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days'
     * worth of events if necessary.
     * </p>
     *
     * @param describeEventsRequest
     *        Represents the input of a <code>DescribeEvents</code> operation.
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEvents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEvents");

            HttpResponseHandler<DescribeEventsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventsRequest, DescribeEventsResponse>()
                            .withOperationName("DescribeEvents")
                            .withMarshaller(new DescribeEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEventsRequest));
            CompletableFuture<DescribeEventsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events
     * specific to a particular cluster, cache security group, or cache parameter group by providing the name as a
     * parameter.
     * </p>
     * <p>
     * By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days'
     * worth of events if necessary.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     *        Represents the input of a <code>DescribeEvents</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEvents" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        return new DescribeEventsPublisher(this, applyPaginatorUserAgent(describeEventsRequest));
    }

    /**
     * <p>
     * Returns information about a particular global replication group. If no identifier is specified, returns
     * information about all Global datastores.
     * </p>
     *
     * @param describeGlobalReplicationGroupsRequest
     * @return A Java Future containing the result of the DescribeGlobalReplicationGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeGlobalReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeGlobalReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGlobalReplicationGroupsResponse> describeGlobalReplicationGroups(
            DescribeGlobalReplicationGroupsRequest describeGlobalReplicationGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeGlobalReplicationGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGlobalReplicationGroups");

            HttpResponseHandler<DescribeGlobalReplicationGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeGlobalReplicationGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeGlobalReplicationGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGlobalReplicationGroupsRequest, DescribeGlobalReplicationGroupsResponse>()
                            .withOperationName("DescribeGlobalReplicationGroups")
                            .withMarshaller(new DescribeGlobalReplicationGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeGlobalReplicationGroupsRequest));
            CompletableFuture<DescribeGlobalReplicationGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a particular global replication group. If no identifier is specified, returns
     * information about all Global datastores.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeGlobalReplicationGroups(software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeGlobalReplicationGroupsPublisher publisher = client.describeGlobalReplicationGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeGlobalReplicationGroupsPublisher publisher = client.describeGlobalReplicationGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGlobalReplicationGroups(software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeGlobalReplicationGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeGlobalReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeGlobalReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeGlobalReplicationGroupsPublisher describeGlobalReplicationGroupsPaginator(
            DescribeGlobalReplicationGroupsRequest describeGlobalReplicationGroupsRequest) {
        return new DescribeGlobalReplicationGroupsPublisher(this, applyPaginatorUserAgent(describeGlobalReplicationGroupsRequest));
    }

    /**
     * <p>
     * Returns information about a particular replication group. If no identifier is specified,
     * <code>DescribeReplicationGroups</code> returns information about all replication groups.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @param describeReplicationGroupsRequest
     *        Represents the input of a <code>DescribeReplicationGroups</code> operation.
     * @return A Java Future containing the result of the DescribeReplicationGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReplicationGroupsResponse> describeReplicationGroups(
            DescribeReplicationGroupsRequest describeReplicationGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReplicationGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationGroups");

            HttpResponseHandler<DescribeReplicationGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeReplicationGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeReplicationGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationGroupsRequest, DescribeReplicationGroupsResponse>()
                            .withOperationName("DescribeReplicationGroups")
                            .withMarshaller(new DescribeReplicationGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeReplicationGroupsRequest));
            CompletableFuture<DescribeReplicationGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a particular replication group. If no identifier is specified,
     * <code>DescribeReplicationGroups</code> returns information about all replication groups.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationGroups(software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReplicationGroupsPublisher publisher = client.describeReplicationGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReplicationGroupsPublisher publisher = client.describeReplicationGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationGroups(software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationGroupsRequest
     *        Represents the input of a <code>DescribeReplicationGroups</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeReplicationGroupsPublisher describeReplicationGroupsPaginator(
            DescribeReplicationGroupsRequest describeReplicationGroupsRequest) {
        return new DescribeReplicationGroupsPublisher(this, applyPaginatorUserAgent(describeReplicationGroupsRequest));
    }

    /**
     * <p>
     * Returns information about reserved cache nodes for this account, or about a specified reserved cache node.
     * </p>
     *
     * @param describeReservedCacheNodesRequest
     *        Represents the input of a <code>DescribeReservedCacheNodes</code> operation.
     * @return A Java Future containing the result of the DescribeReservedCacheNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservedCacheNodesResponse> describeReservedCacheNodes(
            DescribeReservedCacheNodesRequest describeReservedCacheNodesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReservedCacheNodesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedCacheNodes");

            HttpResponseHandler<DescribeReservedCacheNodesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeReservedCacheNodesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeReservedCacheNodesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedCacheNodesRequest, DescribeReservedCacheNodesResponse>()
                            .withOperationName("DescribeReservedCacheNodes")
                            .withMarshaller(new DescribeReservedCacheNodesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeReservedCacheNodesRequest));
            CompletableFuture<DescribeReservedCacheNodesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists available reserved cache node offerings.
     * </p>
     *
     * @param describeReservedCacheNodesOfferingsRequest
     *        Represents the input of a <code>DescribeReservedCacheNodesOfferings</code> operation.
     * @return A Java Future containing the result of the DescribeReservedCacheNodesOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodesOfferingNotFoundException The requested cache node offering does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservedCacheNodesOfferingsResponse> describeReservedCacheNodesOfferings(
            DescribeReservedCacheNodesOfferingsRequest describeReservedCacheNodesOfferingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReservedCacheNodesOfferingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedCacheNodesOfferings");

            HttpResponseHandler<DescribeReservedCacheNodesOfferingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeReservedCacheNodesOfferingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeReservedCacheNodesOfferingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedCacheNodesOfferingsRequest, DescribeReservedCacheNodesOfferingsResponse>()
                            .withOperationName("DescribeReservedCacheNodesOfferings")
                            .withMarshaller(new DescribeReservedCacheNodesOfferingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeReservedCacheNodesOfferingsRequest));
            CompletableFuture<DescribeReservedCacheNodesOfferingsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists available reserved cache node offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedCacheNodesOfferings(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesOfferingsPublisher publisher = client.describeReservedCacheNodesOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesOfferingsPublisher publisher = client.describeReservedCacheNodesOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedCacheNodesOfferings(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedCacheNodesOfferingsRequest
     *        Represents the input of a <code>DescribeReservedCacheNodesOfferings</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodesOfferingNotFoundException The requested cache node offering does not exist.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeReservedCacheNodesOfferingsPublisher describeReservedCacheNodesOfferingsPaginator(
            DescribeReservedCacheNodesOfferingsRequest describeReservedCacheNodesOfferingsRequest) {
        return new DescribeReservedCacheNodesOfferingsPublisher(this,
                applyPaginatorUserAgent(describeReservedCacheNodesOfferingsRequest));
    }

    /**
     * <p>
     * Returns information about reserved cache nodes for this account, or about a specified reserved cache node.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedCacheNodes(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesPublisher publisher = client.describeReservedCacheNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesPublisher publisher = client.describeReservedCacheNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedCacheNodes(software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedCacheNodesRequest
     *        Represents the input of a <code>DescribeReservedCacheNodes</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeReservedCacheNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodes"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeReservedCacheNodesPublisher describeReservedCacheNodesPaginator(
            DescribeReservedCacheNodesRequest describeReservedCacheNodesRequest) {
        return new DescribeReservedCacheNodesPublisher(this, applyPaginatorUserAgent(describeReservedCacheNodesRequest));
    }

    /**
     * <p>
     * Returns details of the service updates
     * </p>
     *
     * @param describeServiceUpdatesRequest
     * @return A Java Future containing the result of the DescribeServiceUpdates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUpdateNotFoundException The service update doesn't exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeServiceUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeServiceUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeServiceUpdatesResponse> describeServiceUpdates(
            DescribeServiceUpdatesRequest describeServiceUpdatesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeServiceUpdatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeServiceUpdates");

            HttpResponseHandler<DescribeServiceUpdatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeServiceUpdatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeServiceUpdatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeServiceUpdatesRequest, DescribeServiceUpdatesResponse>()
                            .withOperationName("DescribeServiceUpdates")
                            .withMarshaller(new DescribeServiceUpdatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeServiceUpdatesRequest));
            CompletableFuture<DescribeServiceUpdatesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns details of the service updates
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeServiceUpdates(software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeServiceUpdatesPublisher publisher = client.describeServiceUpdatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeServiceUpdatesPublisher publisher = client.describeServiceUpdatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeServiceUpdates(software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeServiceUpdatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUpdateNotFoundException The service update doesn't exist</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeServiceUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeServiceUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeServiceUpdatesPublisher describeServiceUpdatesPaginator(
            DescribeServiceUpdatesRequest describeServiceUpdatesRequest) {
        return new DescribeServiceUpdatesPublisher(this, applyPaginatorUserAgent(describeServiceUpdatesRequest));
    }

    /**
     * <p>
     * Returns information about cluster or replication group snapshots. By default, <code>DescribeSnapshots</code>
     * lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with
     * a particular cache cluster.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @param describeSnapshotsRequest
     *        Represents the input of a <code>DescribeSnapshotsMessage</code> operation.
     * @return A Java Future containing the result of the DescribeSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSnapshots");

            HttpResponseHandler<DescribeSnapshotsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSnapshotsRequest, DescribeSnapshotsResponse>()
                            .withOperationName("DescribeSnapshots")
                            .withMarshaller(new DescribeSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeSnapshotsRequest));
            CompletableFuture<DescribeSnapshotsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about cluster or replication group snapshots. By default, <code>DescribeSnapshots</code>
     * lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with
     * a particular cache cluster.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshots(software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeSnapshotsPublisher publisher = client.describeSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshots(software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSnapshotsRequest
     *        Represents the input of a <code>DescribeSnapshotsMessage</code> operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeSnapshotsPublisher describeSnapshotsPaginator(DescribeSnapshotsRequest describeSnapshotsRequest) {
        return new DescribeSnapshotsPublisher(this, applyPaginatorUserAgent(describeSnapshotsRequest));
    }

    /**
     * <p>
     * Returns details of the update actions
     * </p>
     *
     * @param describeUpdateActionsRequest
     * @return A Java Future containing the result of the DescribeUpdateActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUpdateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUpdateActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUpdateActionsResponse> describeUpdateActions(
            DescribeUpdateActionsRequest describeUpdateActionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUpdateActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUpdateActions");

            HttpResponseHandler<DescribeUpdateActionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeUpdateActionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeUpdateActionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUpdateActionsRequest, DescribeUpdateActionsResponse>()
                            .withOperationName("DescribeUpdateActions")
                            .withMarshaller(new DescribeUpdateActionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeUpdateActionsRequest));
            CompletableFuture<DescribeUpdateActionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns details of the update actions
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeUpdateActions(software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUpdateActionsPublisher publisher = client.describeUpdateActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUpdateActionsPublisher publisher = client.describeUpdateActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUpdateActions(software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeUpdateActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUpdateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUpdateActions"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeUpdateActionsPublisher describeUpdateActionsPaginator(DescribeUpdateActionsRequest describeUpdateActionsRequest) {
        return new DescribeUpdateActionsPublisher(this, applyPaginatorUserAgent(describeUpdateActionsRequest));
    }

    /**
     * <p>
     * Returns a list of user groups.
     * </p>
     *
     * @param describeUserGroupsRequest
     * @return A Java Future containing the result of the DescribeUserGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUserGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUserGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserGroupsResponse> describeUserGroups(DescribeUserGroupsRequest describeUserGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUserGroups");

            HttpResponseHandler<DescribeUserGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeUserGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeUserGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUserGroupsRequest, DescribeUserGroupsResponse>()
                            .withOperationName("DescribeUserGroups")
                            .withMarshaller(new DescribeUserGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeUserGroupsRequest));
            CompletableFuture<DescribeUserGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of user groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeUserGroups(software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUserGroupsPublisher publisher = client.describeUserGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUserGroupsPublisher publisher = client.describeUserGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUserGroups(software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeUserGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUserGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUserGroups"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeUserGroupsPublisher describeUserGroupsPaginator(DescribeUserGroupsRequest describeUserGroupsRequest) {
        return new DescribeUserGroupsPublisher(this, applyPaginatorUserAgent(describeUserGroupsRequest));
    }

    /**
     * <p>
     * Returns a list of users.
     * </p>
     *
     * @param describeUsersRequest
     * @return A Java Future containing the result of the DescribeUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUsersResponse> describeUsers(DescribeUsersRequest describeUsersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUsers");

            HttpResponseHandler<DescribeUsersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeUsersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeUsersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUsersRequest, DescribeUsersResponse>()
                            .withOperationName("DescribeUsers")
                            .withMarshaller(new DescribeUsersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeUsersRequest));
            CompletableFuture<DescribeUsersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeUsers(software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUsersPublisher publisher = client.describeUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticache.paginators.DescribeUsersPublisher publisher = client.describeUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elasticache.model.DescribeUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elasticache.model.DescribeUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUsers(software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest)} operation.</b>
     * </p>
     *
     * @param describeUsersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeUsersPublisher describeUsersPaginator(DescribeUsersRequest describeUsersRequest) {
        return new DescribeUsersPublisher(this, applyPaginatorUserAgent(describeUsersRequest));
    }

    /**
     * <p>
     * Remove a secondary cluster from the Global datastore using the Global datastore name. The secondary cluster will
     * no longer receive updates from the primary cluster, but will remain as a standalone cluster in that Amazon
     * region.
     * </p>
     *
     * @param disassociateGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the DisassociateGlobalReplicationGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.DisassociateGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DisassociateGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateGlobalReplicationGroupResponse> disassociateGlobalReplicationGroup(
            DisassociateGlobalReplicationGroupRequest disassociateGlobalReplicationGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateGlobalReplicationGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateGlobalReplicationGroup");

            HttpResponseHandler<DisassociateGlobalReplicationGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DisassociateGlobalReplicationGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DisassociateGlobalReplicationGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateGlobalReplicationGroupRequest, DisassociateGlobalReplicationGroupResponse>()
                            .withOperationName("DisassociateGlobalReplicationGroup")
                            .withMarshaller(new DisassociateGlobalReplicationGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateGlobalReplicationGroupRequest));
            CompletableFuture<DisassociateGlobalReplicationGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Used to failover the primary region to a secondary region. The secondary region will become primary, and all
     * other clusters will become secondary.
     * </p>
     *
     * @param failoverGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the FailoverGlobalReplicationGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.FailoverGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/FailoverGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<FailoverGlobalReplicationGroupResponse> failoverGlobalReplicationGroup(
            FailoverGlobalReplicationGroupRequest failoverGlobalReplicationGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                failoverGlobalReplicationGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FailoverGlobalReplicationGroup");

            HttpResponseHandler<FailoverGlobalReplicationGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(FailoverGlobalReplicationGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<FailoverGlobalReplicationGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<FailoverGlobalReplicationGroupRequest, FailoverGlobalReplicationGroupResponse>()
                            .withOperationName("FailoverGlobalReplicationGroup")
                            .withMarshaller(new FailoverGlobalReplicationGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(failoverGlobalReplicationGroupRequest));
            CompletableFuture<FailoverGlobalReplicationGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Increase the number of node groups in the Global datastore
     * </p>
     *
     * @param increaseNodeGroupsInGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the IncreaseNodeGroupsInGlobalReplicationGroup operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.IncreaseNodeGroupsInGlobalReplicationGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/IncreaseNodeGroupsInGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<IncreaseNodeGroupsInGlobalReplicationGroupResponse> increaseNodeGroupsInGlobalReplicationGroup(
            IncreaseNodeGroupsInGlobalReplicationGroupRequest increaseNodeGroupsInGlobalReplicationGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                increaseNodeGroupsInGlobalReplicationGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "IncreaseNodeGroupsInGlobalReplicationGroup");

            HttpResponseHandler<IncreaseNodeGroupsInGlobalReplicationGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(IncreaseNodeGroupsInGlobalReplicationGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<IncreaseNodeGroupsInGlobalReplicationGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<IncreaseNodeGroupsInGlobalReplicationGroupRequest, IncreaseNodeGroupsInGlobalReplicationGroupResponse>()
                            .withOperationName("IncreaseNodeGroupsInGlobalReplicationGroup")
                            .withMarshaller(new IncreaseNodeGroupsInGlobalReplicationGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(increaseNodeGroupsInGlobalReplicationGroupRequest));
            CompletableFuture<IncreaseNodeGroupsInGlobalReplicationGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Dynamically increases the number of replicas in a Redis (cluster mode disabled) replication group or the number
     * of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This
     * operation is performed with no cluster down time.
     * </p>
     *
     * @param increaseReplicaCountRequest
     * @return A Java Future containing the result of the IncreaseReplicaCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>ClusterQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of clusters per customer.</li>
     *         <li>NodeGroupsPerReplicationGroupQuotaExceededException The request cannot be processed because it would
     *         exceed the maximum allowed number of node groups (shards) in a single replication group. The default
     *         maximum is 90</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>NoOperationException The operation was not performed because no changes were required.</li>
     *         <li>InvalidKmsKeyException The KMS key supplied is not valid.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.IncreaseReplicaCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/IncreaseReplicaCount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<IncreaseReplicaCountResponse> increaseReplicaCount(
            IncreaseReplicaCountRequest increaseReplicaCountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, increaseReplicaCountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "IncreaseReplicaCount");

            HttpResponseHandler<IncreaseReplicaCountResponse> responseHandler = protocolFactory
                    .createResponseHandler(IncreaseReplicaCountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<IncreaseReplicaCountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<IncreaseReplicaCountRequest, IncreaseReplicaCountResponse>()
                            .withOperationName("IncreaseReplicaCount")
                            .withMarshaller(new IncreaseReplicaCountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(increaseReplicaCountRequest));
            CompletableFuture<IncreaseReplicaCountResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all available node types that you can scale your Redis cluster's or replication group's current node type.
     * </p>
     * <p>
     * When you use the <code>ModifyCacheCluster</code> or <code>ModifyReplicationGroup</code> operations to scale your
     * cluster or replication group, the value of the <code>CacheNodeType</code> parameter must be one of the node types
     * returned by this operation.
     * </p>
     *
     * @param listAllowedNodeTypeModificationsRequest
     *        The input parameters for the <code>ListAllowedNodeTypeModifications</code> operation.
     * @return A Java Future containing the result of the ListAllowedNodeTypeModifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ListAllowedNodeTypeModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ListAllowedNodeTypeModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAllowedNodeTypeModificationsResponse> listAllowedNodeTypeModifications(
            ListAllowedNodeTypeModificationsRequest listAllowedNodeTypeModificationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAllowedNodeTypeModificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAllowedNodeTypeModifications");

            HttpResponseHandler<ListAllowedNodeTypeModificationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListAllowedNodeTypeModificationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListAllowedNodeTypeModificationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAllowedNodeTypeModificationsRequest, ListAllowedNodeTypeModificationsResponse>()
                            .withOperationName("ListAllowedNodeTypeModifications")
                            .withMarshaller(new ListAllowedNodeTypeModificationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAllowedNodeTypeModificationsRequest));
            CompletableFuture<ListAllowedNodeTypeModificationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all tags currently on a named resource.
     * </p>
     * <p>
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track
     * all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on
     * replication groups, those actions will be replicated to all nodes in the replication group. For more information,
     * see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html">Resource
     * -level permissions</a>.
     * </p>
     * <p>
     * If the cluster is not in the <i>available</i> state, <code>ListTagsForResource</code> returns an error.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The input parameters for the <code>ListTagsForResource</code> operation.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>InvalidArnException The requested Amazon Resource Name (ARN) does not refer to an existing resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration
     * parameters by specifying the parameters and the new values.
     * </p>
     *
     * @param modifyCacheClusterRequest
     *        Represents the input of a <code>ModifyCacheCluster</code> operation.
     * @return A Java Future containing the result of the ModifyCacheCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidCacheSecurityGroupStateException The current state of the cache security group does not allow
     *         deletion.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>NodeQuotaForClusterExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes in a single cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyCacheClusterResponse> modifyCacheCluster(ModifyCacheClusterRequest modifyCacheClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyCacheClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCacheCluster");

            HttpResponseHandler<ModifyCacheClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyCacheClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyCacheClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyCacheClusterRequest, ModifyCacheClusterResponse>()
                            .withOperationName("ModifyCacheCluster")
                            .withMarshaller(new ModifyCacheClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyCacheClusterRequest));
            CompletableFuture<ModifyCacheClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the parameters of a cache parameter group. You can modify up to 20 parameters in a single request by
     * submitting a list parameter name and value pairs.
     * </p>
     *
     * @param modifyCacheParameterGroupRequest
     *        Represents the input of a <code>ModifyCacheParameterGroup</code> operation.
     * @return A Java Future containing the result of the ModifyCacheParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidCacheParameterGroupStateException The current state of the cache parameter group does not
     *         allow the requested operation to occur.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyCacheParameterGroupResponse> modifyCacheParameterGroup(
            ModifyCacheParameterGroupRequest modifyCacheParameterGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyCacheParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCacheParameterGroup");

            HttpResponseHandler<ModifyCacheParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyCacheParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyCacheParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyCacheParameterGroupRequest, ModifyCacheParameterGroupResponse>()
                            .withOperationName("ModifyCacheParameterGroup")
                            .withMarshaller(new ModifyCacheParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyCacheParameterGroupRequest));
            CompletableFuture<ModifyCacheParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies an existing cache subnet group.
     * </p>
     *
     * @param modifyCacheSubnetGroupRequest
     *        Represents the input of a <code>ModifyCacheSubnetGroup</code> operation.
     * @return A Java Future containing the result of the ModifyCacheSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>CacheSubnetQuotaExceededException The request cannot be processed because it would exceed the allowed
     *         number of subnets in a cache subnet group.</li>
     *         <li>SubnetInUseException The requested subnet is being used by another cache subnet group.</li>
     *         <li>InvalidSubnetException An invalid subnet identifier was specified.</li>
     *         <li>SubnetNotAllowedException At least one subnet ID does not match the other subnet IDs. This mismatch
     *         typically occurs when a user sets one subnet ID to a regional Availability Zone and a different one to an
     *         outpost. Or when a user sets the subnet ID to an Outpost when not subscribed on this service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyCacheSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyCacheSubnetGroupResponse> modifyCacheSubnetGroup(
            ModifyCacheSubnetGroupRequest modifyCacheSubnetGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyCacheSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCacheSubnetGroup");

            HttpResponseHandler<ModifyCacheSubnetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyCacheSubnetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyCacheSubnetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyCacheSubnetGroupRequest, ModifyCacheSubnetGroupResponse>()
                            .withOperationName("ModifyCacheSubnetGroup")
                            .withMarshaller(new ModifyCacheSubnetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyCacheSubnetGroupRequest));
            CompletableFuture<ModifyCacheSubnetGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the settings for a Global datastore.
     * </p>
     *
     * @param modifyGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the ModifyGlobalReplicationGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyGlobalReplicationGroupResponse> modifyGlobalReplicationGroup(
            ModifyGlobalReplicationGroupRequest modifyGlobalReplicationGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyGlobalReplicationGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyGlobalReplicationGroup");

            HttpResponseHandler<ModifyGlobalReplicationGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyGlobalReplicationGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyGlobalReplicationGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyGlobalReplicationGroupRequest, ModifyGlobalReplicationGroupResponse>()
                            .withOperationName("ModifyGlobalReplicationGroup")
                            .withMarshaller(new ModifyGlobalReplicationGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyGlobalReplicationGroupRequest));
            CompletableFuture<ModifyGlobalReplicationGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the settings for a replication group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/scaling-redis-cluster-mode-enabled.html">
     * Scaling for Amazon ElastiCache for Redis (cluster mode enabled)</a> in the ElastiCache User Guide
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyReplicationGroupShardConfiguration.html"
     * >ModifyReplicationGroupShardConfiguration</a> in the ElastiCache API Reference
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This operation is valid for Redis only.
     * </p>
     * </note>
     *
     * @param modifyReplicationGroupRequest
     *        Represents the input of a <code>ModifyReplicationGroups</code> operation.
     * @return A Java Future containing the result of the ModifyReplicationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>InvalidUserGroupStateException The user group is not in an active state.</li>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidCacheSecurityGroupStateException The current state of the cache security group does not allow
     *         deletion.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>NodeQuotaForClusterExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes in a single cluster.</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>InvalidKmsKeyException The KMS key supplied is not valid.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyReplicationGroupResponse> modifyReplicationGroup(
            ModifyReplicationGroupRequest modifyReplicationGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyReplicationGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyReplicationGroup");

            HttpResponseHandler<ModifyReplicationGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyReplicationGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyReplicationGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyReplicationGroupRequest, ModifyReplicationGroupResponse>()
                            .withOperationName("ModifyReplicationGroup")
                            .withMarshaller(new ModifyReplicationGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyReplicationGroupRequest));
            CompletableFuture<ModifyReplicationGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies a replication group's shards (node groups) by allowing you to add shards, remove shards, or rebalance
     * the keyspaces among existing shards.
     * </p>
     *
     * @param modifyReplicationGroupShardConfigurationRequest
     *        Represents the input for a <code>ModifyReplicationGroupShardConfiguration</code> operation.
     * @return A Java Future containing the result of the ModifyReplicationGroupShardConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidVpcNetworkStateException The VPC network is in an invalid state.</li>
     *         <li>InsufficientCacheClusterCapacityException The requested cache node type is not available in the
     *         specified Availability Zone. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</li>
     *         <li>NodeGroupsPerReplicationGroupQuotaExceededException The request cannot be processed because it would
     *         exceed the maximum allowed number of node groups (shards) in a single replication group. The default
     *         maximum is 90</li>
     *         <li>NodeQuotaForCustomerExceededException The request cannot be processed because it would exceed the
     *         allowed number of cache nodes per customer.</li>
     *         <li>InvalidKmsKeyException The KMS key supplied is not valid.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyReplicationGroupShardConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyReplicationGroupShardConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyReplicationGroupShardConfigurationResponse> modifyReplicationGroupShardConfiguration(
            ModifyReplicationGroupShardConfigurationRequest modifyReplicationGroupShardConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyReplicationGroupShardConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyReplicationGroupShardConfiguration");

            HttpResponseHandler<ModifyReplicationGroupShardConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyReplicationGroupShardConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyReplicationGroupShardConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyReplicationGroupShardConfigurationRequest, ModifyReplicationGroupShardConfigurationResponse>()
                            .withOperationName("ModifyReplicationGroupShardConfiguration")
                            .withMarshaller(new ModifyReplicationGroupShardConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyReplicationGroupShardConfigurationRequest));
            CompletableFuture<ModifyReplicationGroupShardConfigurationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes user password(s) and/or access string.
     * </p>
     *
     * @param modifyUserRequest
     * @return A Java Future containing the result of the ModifyUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>InvalidUserStateException The user is not in active state.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyUserResponse> modifyUser(ModifyUserRequest modifyUserRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyUser");

            HttpResponseHandler<ModifyUserResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyUserRequest, ModifyUserResponse>().withOperationName("ModifyUser")
                            .withMarshaller(new ModifyUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyUserRequest));
            CompletableFuture<ModifyUserResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the list of users that belong to the user group.
     * </p>
     *
     * @param modifyUserGroupRequest
     * @return A Java Future containing the result of the ModifyUserGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>DuplicateUserNameException A user with this username already exists.</li>
     *         <li>ServiceLinkedRoleNotFoundException The specified service linked role (SLR) was not found.</li>
     *         <li>DefaultUserRequiredException You must add default user to a user group.</li>
     *         <li>InvalidUserGroupStateException The user group is not in an active state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ModifyUserGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyUserGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyUserGroupResponse> modifyUserGroup(ModifyUserGroupRequest modifyUserGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyUserGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyUserGroup");

            HttpResponseHandler<ModifyUserGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyUserGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyUserGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyUserGroupRequest, ModifyUserGroupResponse>()
                            .withOperationName("ModifyUserGroup")
                            .withMarshaller(new ModifyUserGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(modifyUserGroupRequest));
            CompletableFuture<ModifyUserGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows you to purchase a reserved cache node offering. Reserved nodes are not eligible for cancellation and are
     * non-refundable. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/reserved-nodes.html">Managing Costs with
     * Reserved Nodes</a> for Redis or <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/reserved-nodes.html">Managing Costs with
     * Reserved Nodes</a> for Memcached.
     * </p>
     *
     * @param purchaseReservedCacheNodesOfferingRequest
     *        Represents the input of a <code>PurchaseReservedCacheNodesOffering</code> operation.
     * @return A Java Future containing the result of the PurchaseReservedCacheNodesOffering operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedCacheNodesOfferingNotFoundException The requested cache node offering does not exist.</li>
     *         <li>ReservedCacheNodeAlreadyExistsException You already have a reservation with the given identifier.</li>
     *         <li>ReservedCacheNodeQuotaExceededException The request cannot be processed because it would exceed the
     *         user's cache node quota.</li>
     *         <li>TagQuotaPerResourceExceededException The request cannot be processed because it would cause the
     *         resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource
     *         is 50.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.PurchaseReservedCacheNodesOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/PurchaseReservedCacheNodesOffering"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PurchaseReservedCacheNodesOfferingResponse> purchaseReservedCacheNodesOffering(
            PurchaseReservedCacheNodesOfferingRequest purchaseReservedCacheNodesOfferingRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                purchaseReservedCacheNodesOfferingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PurchaseReservedCacheNodesOffering");

            HttpResponseHandler<PurchaseReservedCacheNodesOfferingResponse> responseHandler = protocolFactory
                    .createResponseHandler(PurchaseReservedCacheNodesOfferingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<PurchaseReservedCacheNodesOfferingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PurchaseReservedCacheNodesOfferingRequest, PurchaseReservedCacheNodesOfferingResponse>()
                            .withOperationName("PurchaseReservedCacheNodesOffering")
                            .withMarshaller(new PurchaseReservedCacheNodesOfferingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(purchaseReservedCacheNodesOfferingRequest));
            CompletableFuture<PurchaseReservedCacheNodesOfferingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Redistribute slots to ensure uniform distribution across existing shards in the cluster.
     * </p>
     *
     * @param rebalanceSlotsInGlobalReplicationGroupRequest
     * @return A Java Future containing the result of the RebalanceSlotsInGlobalReplicationGroup operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GlobalReplicationGroupNotFoundException The Global datastore does not exist</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.RebalanceSlotsInGlobalReplicationGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RebalanceSlotsInGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RebalanceSlotsInGlobalReplicationGroupResponse> rebalanceSlotsInGlobalReplicationGroup(
            RebalanceSlotsInGlobalReplicationGroupRequest rebalanceSlotsInGlobalReplicationGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                rebalanceSlotsInGlobalReplicationGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebalanceSlotsInGlobalReplicationGroup");

            HttpResponseHandler<RebalanceSlotsInGlobalReplicationGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(RebalanceSlotsInGlobalReplicationGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RebalanceSlotsInGlobalReplicationGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RebalanceSlotsInGlobalReplicationGroupRequest, RebalanceSlotsInGlobalReplicationGroupResponse>()
                            .withOperationName("RebalanceSlotsInGlobalReplicationGroup")
                            .withMarshaller(new RebalanceSlotsInGlobalReplicationGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(rebalanceSlotsInGlobalReplicationGroupRequest));
            CompletableFuture<RebalanceSlotsInGlobalReplicationGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Reboots some, or all, of the cache nodes within a provisioned cluster. This operation applies any modified cache
     * parameter groups to the cluster. The reboot operation takes place as soon as possible, and results in a momentary
     * outage to the cluster. During the reboot, the cluster status is set to REBOOTING.
     * </p>
     * <p>
     * The reboot causes the contents of the cache (for each cache node being rebooted) to be lost.
     * </p>
     * <p>
     * When the reboot is complete, a cluster event is created.
     * </p>
     * <p>
     * Rebooting a cluster is currently supported on Memcached and Redis (cluster mode disabled) clusters. Rebooting is
     * not supported on Redis (cluster mode enabled) clusters.
     * </p>
     * <p>
     * If you make changes to parameters that require a Redis (cluster mode enabled) cluster reboot for the changes to
     * be applied, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes.rebooting.html">Rebooting a Cluster</a>
     * for an alternate process.
     * </p>
     *
     * @param rebootCacheClusterRequest
     *        Represents the input of a <code>RebootCacheCluster</code> operation.
     * @return A Java Future containing the result of the RebootCacheCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.RebootCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RebootCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RebootCacheClusterResponse> rebootCacheCluster(RebootCacheClusterRequest rebootCacheClusterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootCacheClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootCacheCluster");

            HttpResponseHandler<RebootCacheClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(RebootCacheClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RebootCacheClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RebootCacheClusterRequest, RebootCacheClusterResponse>()
                            .withOperationName("RebootCacheCluster")
                            .withMarshaller(new RebootCacheClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(rebootCacheClusterRequest));
            CompletableFuture<RebootCacheClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the tags identified by the <code>TagKeys</code> list from the named resource. A tag is a key-value pair
     * where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache
     * resources, with the exception of global replication group. When you add or remove tags on replication groups,
     * those actions will be replicated to all nodes in the replication group. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html"
     * >Resource-level permissions</a>.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        Represents the input of a <code>RemoveTagsFromResource</code> operation.
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheClusterNotFoundException The requested cluster ID does not refer to an existing cluster.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>CacheSubnetGroupNotFoundException The requested cache subnet group name does not refer to an existing
     *         cache subnet group.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>ReservedCacheNodeNotFoundException The requested reserved cache node was not found.</li>
     *         <li>SnapshotNotFoundException The requested snapshot name does not refer to an existing snapshot.</li>
     *         <li>UserNotFoundException The user does not exist or could not be found.</li>
     *         <li>UserGroupNotFoundException The user group was not found or does not exist</li>
     *         <li>InvalidArnException The requested Amazon Resource Name (ARN) does not refer to an existing resource.</li>
     *         <li>TagNotFoundException The requested tag was not found on this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RemoveTagsFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsFromResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTagsFromResource");

            HttpResponseHandler<RemoveTagsFromResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(RemoveTagsFromResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RemoveTagsFromResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse>()
                            .withOperationName("RemoveTagsFromResource")
                            .withMarshaller(new RemoveTagsFromResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(removeTagsFromResourceRequest));
            CompletableFuture<RemoveTagsFromResourceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the parameters of a cache parameter group to the engine or system default value. You can reset specific
     * parameters by submitting a list of parameter names. To reset the entire cache parameter group, specify the
     * <code>ResetAllParameters</code> and <code>CacheParameterGroupName</code> parameters.
     * </p>
     *
     * @param resetCacheParameterGroupRequest
     *        Represents the input of a <code>ResetCacheParameterGroup</code> operation.
     * @return A Java Future containing the result of the ResetCacheParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidCacheParameterGroupStateException The current state of the cache parameter group does not
     *         allow the requested operation to occur.</li>
     *         <li>CacheParameterGroupNotFoundException The requested cache parameter group name does not refer to an
     *         existing cache parameter group.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>InvalidGlobalReplicationGroupStateException The Global datastore is not available or in primary-only
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.ResetCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ResetCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResetCacheParameterGroupResponse> resetCacheParameterGroup(
            ResetCacheParameterGroupRequest resetCacheParameterGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetCacheParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetCacheParameterGroup");

            HttpResponseHandler<ResetCacheParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ResetCacheParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ResetCacheParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetCacheParameterGroupRequest, ResetCacheParameterGroupResponse>()
                            .withOperationName("ResetCacheParameterGroup")
                            .withMarshaller(new ResetCacheParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(resetCacheParameterGroupRequest));
            CompletableFuture<ResetCacheParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Revokes ingress from a cache security group. Use this operation to disallow access from an Amazon EC2 security
     * group that had been previously authorized.
     * </p>
     *
     * @param revokeCacheSecurityGroupIngressRequest
     *        Represents the input of a <code>RevokeCacheSecurityGroupIngress</code> operation.
     * @return A Java Future containing the result of the RevokeCacheSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CacheSecurityGroupNotFoundException The requested cache security group name does not refer to an
     *         existing cache security group.</li>
     *         <li>AuthorizationNotFoundException The specified Amazon EC2 security group is not authorized for the
     *         specified cache security group.</li>
     *         <li>InvalidCacheSecurityGroupStateException The current state of the cache security group does not allow
     *         deletion.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.RevokeCacheSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RevokeCacheSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RevokeCacheSecurityGroupIngressResponse> revokeCacheSecurityGroupIngress(
            RevokeCacheSecurityGroupIngressRequest revokeCacheSecurityGroupIngressRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                revokeCacheSecurityGroupIngressRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokeCacheSecurityGroupIngress");

            HttpResponseHandler<RevokeCacheSecurityGroupIngressResponse> responseHandler = protocolFactory
                    .createResponseHandler(RevokeCacheSecurityGroupIngressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RevokeCacheSecurityGroupIngressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RevokeCacheSecurityGroupIngressRequest, RevokeCacheSecurityGroupIngressResponse>()
                            .withOperationName("RevokeCacheSecurityGroupIngress")
                            .withMarshaller(new RevokeCacheSecurityGroupIngressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(revokeCacheSecurityGroupIngressRequest));
            CompletableFuture<RevokeCacheSecurityGroupIngressResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Start the migration of data.
     * </p>
     *
     * @param startMigrationRequest
     * @return A Java Future containing the result of the StartMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>ReplicationGroupAlreadyUnderMigrationException The targeted replication group is not available.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.StartMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/StartMigration" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartMigrationResponse> startMigration(StartMigrationRequest startMigrationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMigrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMigration");

            HttpResponseHandler<StartMigrationResponse> responseHandler = protocolFactory
                    .createResponseHandler(StartMigrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<StartMigrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartMigrationRequest, StartMigrationResponse>()
                            .withOperationName("StartMigration")
                            .withMarshaller(new StartMigrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startMigrationRequest));
            CompletableFuture<StartMigrationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents the input of a <code>TestFailover</code> operation which test automatic failover on a specified node
     * group (called shard in the console) in a replication group (called cluster in the console).
     * </p>
     * <p>
     * This API is designed for testing the behavior of your application in case of ElastiCache failover. It is not
     * designed to be an operational tool for initiating a failover to overcome a problem you may have with the cluster.
     * Moreover, in certain conditions such as large-scale operational events, Amazon may block this API.
     * </p>
     * <p class="title">
     * <b>Note the following</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A customer can use this operation to test automatic failover on up to 5 shards (called node groups in the
     * ElastiCache API and Amazon CLI) in any rolling 24-hour period.
     * </p>
     * </li>
     * <li>
     * <p>
     * If calling this operation on shards in different clusters (called replication groups in the API and CLI), the
     * calls can be made concurrently.
     * </p>
     * <p>
     * </p></li>
     * <li>
     * <p>
     * If calling this operation multiple times on different shards in the same Redis (cluster mode enabled) replication
     * group, the first node replacement must complete before a subsequent call can be made.
     * </p>
     * </li>
     * <li>
     * <p>
     * To determine whether the node replacement is complete you can check Events using the Amazon ElastiCache console,
     * the Amazon CLI, or the ElastiCache API. Look for the following automatic failover related events, listed here in
     * order of occurrance:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Replication group message: <code>Test Failover API called for node group &lt;node-group-id&gt;</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache cluster message:
     * <code>Failover from primary node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Replication group message:
     * <code>Failover from primary node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache cluster message: <code>Recovering cache nodes &lt;node-id&gt;</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache cluster message: <code>Finished recovery for cache nodes &lt;node-id&gt;</code>
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ECEvents.Viewing.html">Viewing ElastiCache
     * Events</a> in the <i>ElastiCache User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html">DescribeEvents
     * </a> in the ElastiCache API Reference
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Also see, <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html#auto-failover-test">Testing
     * Multi-AZ </a> in the <i>ElastiCache User Guide</i>.
     * </p>
     *
     * @param testFailoverRequest
     * @return A Java Future containing the result of the TestFailover operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApiCallRateForCustomerExceededException The customer has exceeded the allowed rate of API calls.</li>
     *         <li>InvalidCacheClusterStateException The requested cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidReplicationGroupStateException The requested replication group is not in the
     *         <code>available</code> state.</li>
     *         <li>NodeGroupNotFoundException The node group specified by the <code>NodeGroupId</code> parameter could
     *         not be found. Please verify that the node group exists and that you spelled the <code>NodeGroupId</code>
     *         value correctly.</li>
     *         <li>ReplicationGroupNotFoundException The specified replication group does not exist.</li>
     *         <li>TestFailoverNotAvailableException The <code>TestFailover</code> action is not available.</li>
     *         <li>InvalidKmsKeyException The KMS key supplied is not valid.</li>
     *         <li>InvalidParameterValueException The value for a parameter is invalid.</li>
     *         <li>InvalidParameterCombinationException Two or more incompatible parameters were specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElastiCacheException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElastiCacheAsyncClient.TestFailover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/TestFailover" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TestFailoverResponse> testFailover(TestFailoverRequest testFailoverRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testFailoverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestFailover");

            HttpResponseHandler<TestFailoverResponse> responseHandler = protocolFactory
                    .createResponseHandler(TestFailoverResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<TestFailoverResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestFailoverRequest, TestFailoverResponse>()
                            .withOperationName("TestFailover").withMarshaller(new TestFailoverRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(testFailoverRequest));
            CompletableFuture<TestFailoverResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheSubnetGroupNotFoundFault")
                                .exceptionBuilderSupplier(CacheSubnetGroupNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetInUse")
                                .exceptionBuilderSupplier(SubnetInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheClusterAlreadyExists")
                                .exceptionBuilderSupplier(CacheClusterAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheSecurityGroupAlreadyExists")
                                .exceptionBuilderSupplier(CacheSecurityGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidGlobalReplicationGroupState")
                                .exceptionBuilderSupplier(InvalidGlobalReplicationGroupStateException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCacheSecurityGroupState")
                                .exceptionBuilderSupplier(InvalidCacheSecurityGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QuotaExceeded.CacheSecurityGroup")
                                .exceptionBuilderSupplier(CacheSecurityGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheParameterGroupQuotaExceeded")
                                .exceptionBuilderSupplier(CacheParameterGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedCacheNodesOfferingNotFound")
                                .exceptionBuilderSupplier(ReservedCacheNodesOfferingNotFoundException::builder)
                                .httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReplicationGroupNotUnderMigrationFault")
                                .exceptionBuilderSupplier(ReplicationGroupNotUnderMigrationException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheParameterGroupAlreadyExists")
                                .exceptionBuilderSupplier(CacheParameterGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidARN")
                                .exceptionBuilderSupplier(InvalidArnException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault")
                                .exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault")
                                .exceptionBuilderSupplier(InvalidKmsKeyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateUserName")
                                .exceptionBuilderSupplier(DuplicateUserNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheParameterGroupNotFound")
                                .exceptionBuilderSupplier(CacheParameterGroupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault")
                                .exceptionBuilderSupplier(SubnetNotAllowedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault")
                                .exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault")
                                .exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserNotFound")
                                .exceptionBuilderSupplier(UserNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NodeGroupNotFoundFault")
                                .exceptionBuilderSupplier(NodeGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GlobalReplicationGroupNotFoundFault")
                                .exceptionBuilderSupplier(GlobalReplicationGroupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientCacheClusterCapacity")
                                .exceptionBuilderSupplier(InsufficientCacheClusterCapacityException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedCacheNodeNotFound")
                                .exceptionBuilderSupplier(ReservedCacheNodeNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheSubnetGroupInUse")
                                .exceptionBuilderSupplier(CacheSubnetGroupInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReplicationGroupNotFoundFault")
                                .exceptionBuilderSupplier(ReplicationGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubnet")
                                .exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoOperationFault")
                                .exceptionBuilderSupplier(NoOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NodeGroupsPerReplicationGroupQuotaExceeded")
                                .exceptionBuilderSupplier(NodeGroupsPerReplicationGroupQuotaExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedCacheNodeQuotaExceeded")
                                .exceptionBuilderSupplier(ReservedCacheNodeQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedCacheNodeAlreadyExists")
                                .exceptionBuilderSupplier(ReservedCacheNodeAlreadyExistsException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheClusterNotFound")
                                .exceptionBuilderSupplier(CacheClusterNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GlobalReplicationGroupAlreadyExistsFault")
                                .exceptionBuilderSupplier(GlobalReplicationGroupAlreadyExistsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValue")
                                .exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault")
                                .exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserGroupQuotaExceeded")
                                .exceptionBuilderSupplier(UserGroupQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidReplicationGroupState")
                                .exceptionBuilderSupplier(InvalidReplicationGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault")
                                .exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserGroupAlreadyExists")
                                .exceptionBuilderSupplier(UserGroupAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DefaultUserRequired")
                                .exceptionBuilderSupplier(DefaultUserRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceeded")
                                .exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserAlreadyExists")
                                .exceptionBuilderSupplier(UserAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidUserGroupState")
                                .exceptionBuilderSupplier(InvalidUserGroupStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagNotFound")
                                .exceptionBuilderSupplier(TagNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceeded")
                                .exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceeded")
                                .exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceeded")
                                .exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault")
                                .exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCacheClusterState")
                                .exceptionBuilderSupplier(InvalidCacheClusterStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheSubnetQuotaExceededFault")
                                .exceptionBuilderSupplier(CacheSubnetQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotFeatureNotSupportedFault")
                                .exceptionBuilderSupplier(SnapshotFeatureNotSupportedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSnapshotState")
                                .exceptionBuilderSupplier(InvalidSnapshotStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReplicationGroupAlreadyUnderMigrationFault")
                                .exceptionBuilderSupplier(ReplicationGroupAlreadyUnderMigrationException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheSubnetGroupAlreadyExists")
                                .exceptionBuilderSupplier(CacheSubnetGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheSubnetGroupQuotaExceeded")
                                .exceptionBuilderSupplier(CacheSubnetGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReplicationGroupAlreadyExists")
                                .exceptionBuilderSupplier(ReplicationGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DefaultUserAssociatedToUserGroup")
                                .exceptionBuilderSupplier(DefaultUserAssociatedToUserGroupException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterCombination")
                                .exceptionBuilderSupplier(InvalidParameterCombinationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidUserState")
                                .exceptionBuilderSupplier(InvalidUserStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserGroupNotFound")
                                .exceptionBuilderSupplier(UserGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault")
                                .exceptionBuilderSupplier(SnapshotNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserQuotaExceeded")
                                .exceptionBuilderSupplier(UserQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheSecurityGroupNotFound")
                                .exceptionBuilderSupplier(CacheSecurityGroupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCacheParameterGroupState")
                                .exceptionBuilderSupplier(InvalidCacheParameterGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded")
                                .exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorizationAlreadyExists")
                                .exceptionBuilderSupplier(AuthorizationAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorizationNotFound")
                                .exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(404).build())
                .clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(ElastiCacheException::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends ElastiCacheRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    @Override
    public ElastiCacheAsyncWaiter waiter() {
        return ElastiCacheAsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }
}
