/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncreaseNodeGroupsInGlobalReplicationGroupRequest extends ElastiCacheRequest
        implements
        ToCopyableBuilder<IncreaseNodeGroupsInGlobalReplicationGroupRequest.Builder, IncreaseNodeGroupsInGlobalReplicationGroupRequest> {
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalReplicationGroupId")
            .getter(getter(IncreaseNodeGroupsInGlobalReplicationGroupRequest::globalReplicationGroupId))
            .setter(setter(Builder::globalReplicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupId").build())
            .build();

    private static final SdkField<Integer> NODE_GROUP_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NodeGroupCount").getter(getter(IncreaseNodeGroupsInGlobalReplicationGroupRequest::nodeGroupCount))
            .setter(setter(Builder::nodeGroupCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupCount").build()).build();

    private static final SdkField<List<RegionalConfiguration>> REGIONAL_CONFIGURATIONS_FIELD = SdkField
            .<List<RegionalConfiguration>> builder(MarshallingType.LIST)
            .memberName("RegionalConfigurations")
            .getter(getter(IncreaseNodeGroupsInGlobalReplicationGroupRequest::regionalConfigurations))
            .setter(setter(Builder::regionalConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionalConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("RegionalConfiguration")
                            .memberFieldInfo(
                                    SdkField.<RegionalConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegionalConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("RegionalConfiguration").build()).build()).build()).build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApplyImmediately").getter(getter(IncreaseNodeGroupsInGlobalReplicationGroupRequest::applyImmediately))
            .setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_REPLICATION_GROUP_ID_FIELD, NODE_GROUP_COUNT_FIELD, REGIONAL_CONFIGURATIONS_FIELD, APPLY_IMMEDIATELY_FIELD));

    private final String globalReplicationGroupId;

    private final Integer nodeGroupCount;

    private final List<RegionalConfiguration> regionalConfigurations;

    private final Boolean applyImmediately;

    private IncreaseNodeGroupsInGlobalReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.globalReplicationGroupId = builder.globalReplicationGroupId;
        this.nodeGroupCount = builder.nodeGroupCount;
        this.regionalConfigurations = builder.regionalConfigurations;
        this.applyImmediately = builder.applyImmediately;
    }

    /**
     * <p>
     * The name of the Global datastore
     * </p>
     * 
     * @return The name of the Global datastore
     */
    public final String globalReplicationGroupId() {
        return globalReplicationGroupId;
    }

    /**
     * <p>
     * The number of node groups you wish to add
     * </p>
     * 
     * @return The number of node groups you wish to add
     */
    public final Integer nodeGroupCount() {
        return nodeGroupCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegionalConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRegionalConfigurations() {
        return regionalConfigurations != null && !(regionalConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the replication group IDs, the Amazon regions where they are stored and the shard configuration for
     * each that comprise the Global datastore
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionalConfigurations} method.
     * </p>
     * 
     * @return Describes the replication group IDs, the Amazon regions where they are stored and the shard configuration
     *         for each that comprise the Global datastore
     */
    public final List<RegionalConfiguration> regionalConfigurations() {
        return regionalConfigurations;
    }

    /**
     * <p>
     * Indicates that the process begins immediately. At present, the only permitted value for this parameter is true.
     * </p>
     * 
     * @return Indicates that the process begins immediately. At present, the only permitted value for this parameter is
     *         true.
     */
    public final Boolean applyImmediately() {
        return applyImmediately;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeGroupCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionalConfigurations() ? regionalConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncreaseNodeGroupsInGlobalReplicationGroupRequest)) {
            return false;
        }
        IncreaseNodeGroupsInGlobalReplicationGroupRequest other = (IncreaseNodeGroupsInGlobalReplicationGroupRequest) obj;
        return Objects.equals(globalReplicationGroupId(), other.globalReplicationGroupId())
                && Objects.equals(nodeGroupCount(), other.nodeGroupCount())
                && hasRegionalConfigurations() == other.hasRegionalConfigurations()
                && Objects.equals(regionalConfigurations(), other.regionalConfigurations())
                && Objects.equals(applyImmediately(), other.applyImmediately());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IncreaseNodeGroupsInGlobalReplicationGroupRequest")
                .add("GlobalReplicationGroupId", globalReplicationGroupId()).add("NodeGroupCount", nodeGroupCount())
                .add("RegionalConfigurations", hasRegionalConfigurations() ? regionalConfigurations() : null)
                .add("ApplyImmediately", applyImmediately()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalReplicationGroupId":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupId()));
        case "NodeGroupCount":
            return Optional.ofNullable(clazz.cast(nodeGroupCount()));
        case "RegionalConfigurations":
            return Optional.ofNullable(clazz.cast(regionalConfigurations()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IncreaseNodeGroupsInGlobalReplicationGroupRequest, T> g) {
        return obj -> g.apply((IncreaseNodeGroupsInGlobalReplicationGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, IncreaseNodeGroupsInGlobalReplicationGroupRequest> {
        /**
         * <p>
         * The name of the Global datastore
         * </p>
         * 
         * @param globalReplicationGroupId
         *        The name of the Global datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupId(String globalReplicationGroupId);

        /**
         * <p>
         * The number of node groups you wish to add
         * </p>
         * 
         * @param nodeGroupCount
         *        The number of node groups you wish to add
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupCount(Integer nodeGroupCount);

        /**
         * <p>
         * Describes the replication group IDs, the Amazon regions where they are stored and the shard configuration for
         * each that comprise the Global datastore
         * </p>
         * 
         * @param regionalConfigurations
         *        Describes the replication group IDs, the Amazon regions where they are stored and the shard
         *        configuration for each that comprise the Global datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionalConfigurations(Collection<RegionalConfiguration> regionalConfigurations);

        /**
         * <p>
         * Describes the replication group IDs, the Amazon regions where they are stored and the shard configuration for
         * each that comprise the Global datastore
         * </p>
         * 
         * @param regionalConfigurations
         *        Describes the replication group IDs, the Amazon regions where they are stored and the shard
         *        configuration for each that comprise the Global datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionalConfigurations(RegionalConfiguration... regionalConfigurations);

        /**
         * <p>
         * Describes the replication group IDs, the Amazon regions where they are stored and the shard configuration for
         * each that comprise the Global datastore
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.RegionalConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.RegionalConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.RegionalConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #regionalConfigurations(List<RegionalConfiguration>)}.
         * 
         * @param regionalConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.RegionalConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regionalConfigurations(java.util.Collection<RegionalConfiguration>)
         */
        Builder regionalConfigurations(Consumer<RegionalConfiguration.Builder>... regionalConfigurations);

        /**
         * <p>
         * Indicates that the process begins immediately. At present, the only permitted value for this parameter is
         * true.
         * </p>
         * 
         * @param applyImmediately
         *        Indicates that the process begins immediately. At present, the only permitted value for this parameter
         *        is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String globalReplicationGroupId;

        private Integer nodeGroupCount;

        private List<RegionalConfiguration> regionalConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Boolean applyImmediately;

        private BuilderImpl() {
        }

        private BuilderImpl(IncreaseNodeGroupsInGlobalReplicationGroupRequest model) {
            super(model);
            globalReplicationGroupId(model.globalReplicationGroupId);
            nodeGroupCount(model.nodeGroupCount);
            regionalConfigurations(model.regionalConfigurations);
            applyImmediately(model.applyImmediately);
        }

        public final String getGlobalReplicationGroupId() {
            return globalReplicationGroupId;
        }

        public final void setGlobalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
        }

        @Override
        public final Builder globalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        public final Integer getNodeGroupCount() {
            return nodeGroupCount;
        }

        public final void setNodeGroupCount(Integer nodeGroupCount) {
            this.nodeGroupCount = nodeGroupCount;
        }

        @Override
        public final Builder nodeGroupCount(Integer nodeGroupCount) {
            this.nodeGroupCount = nodeGroupCount;
            return this;
        }

        public final List<RegionalConfiguration.Builder> getRegionalConfigurations() {
            List<RegionalConfiguration.Builder> result = RegionalConfigurationListCopier
                    .copyToBuilder(this.regionalConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegionalConfigurations(Collection<RegionalConfiguration.BuilderImpl> regionalConfigurations) {
            this.regionalConfigurations = RegionalConfigurationListCopier.copyFromBuilder(regionalConfigurations);
        }

        @Override
        public final Builder regionalConfigurations(Collection<RegionalConfiguration> regionalConfigurations) {
            this.regionalConfigurations = RegionalConfigurationListCopier.copy(regionalConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionalConfigurations(RegionalConfiguration... regionalConfigurations) {
            regionalConfigurations(Arrays.asList(regionalConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionalConfigurations(Consumer<RegionalConfiguration.Builder>... regionalConfigurations) {
            regionalConfigurations(Stream.of(regionalConfigurations)
                    .map(c -> RegionalConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IncreaseNodeGroupsInGlobalReplicationGroupRequest build() {
            return new IncreaseNodeGroupsInGlobalReplicationGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
