/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The usage limits for storage and ElastiCache Processing Units for the cache.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CacheUsageLimits implements SdkPojo, Serializable,
        ToCopyableBuilder<CacheUsageLimits.Builder, CacheUsageLimits> {
    private static final SdkField<DataStorage> DATA_STORAGE_FIELD = SdkField.<DataStorage> builder(MarshallingType.SDK_POJO)
            .memberName("DataStorage").getter(getter(CacheUsageLimits::dataStorage)).setter(setter(Builder::dataStorage))
            .constructor(DataStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStorage").build()).build();

    private static final SdkField<ECPUPerSecond> ECPU_PER_SECOND_FIELD = SdkField
            .<ECPUPerSecond> builder(MarshallingType.SDK_POJO).memberName("ECPUPerSecond")
            .getter(getter(CacheUsageLimits::ecpuPerSecond)).setter(setter(Builder::ecpuPerSecond))
            .constructor(ECPUPerSecond::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ECPUPerSecond").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_STORAGE_FIELD,
            ECPU_PER_SECOND_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataStorage dataStorage;

    private final ECPUPerSecond ecpuPerSecond;

    private CacheUsageLimits(BuilderImpl builder) {
        this.dataStorage = builder.dataStorage;
        this.ecpuPerSecond = builder.ecpuPerSecond;
    }

    /**
     * <p>
     * The maximum data storage limit in the cache, expressed in Gigabytes.
     * </p>
     * 
     * @return The maximum data storage limit in the cache, expressed in Gigabytes.
     */
    public final DataStorage dataStorage() {
        return dataStorage;
    }

    /**
     * Returns the value of the ECPUPerSecond property for this object.
     * 
     * @return The value of the ECPUPerSecond property for this object.
     */
    public final ECPUPerSecond ecpuPerSecond() {
        return ecpuPerSecond;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataStorage());
        hashCode = 31 * hashCode + Objects.hashCode(ecpuPerSecond());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheUsageLimits)) {
            return false;
        }
        CacheUsageLimits other = (CacheUsageLimits) obj;
        return Objects.equals(dataStorage(), other.dataStorage()) && Objects.equals(ecpuPerSecond(), other.ecpuPerSecond());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CacheUsageLimits").add("DataStorage", dataStorage()).add("ECPUPerSecond", ecpuPerSecond())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataStorage":
            return Optional.ofNullable(clazz.cast(dataStorage()));
        case "ECPUPerSecond":
            return Optional.ofNullable(clazz.cast(ecpuPerSecond()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CacheUsageLimits, T> g) {
        return obj -> g.apply((CacheUsageLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CacheUsageLimits> {
        /**
         * <p>
         * The maximum data storage limit in the cache, expressed in Gigabytes.
         * </p>
         * 
         * @param dataStorage
         *        The maximum data storage limit in the cache, expressed in Gigabytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStorage(DataStorage dataStorage);

        /**
         * <p>
         * The maximum data storage limit in the cache, expressed in Gigabytes.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataStorage.Builder} avoiding the need to
         * create one manually via {@link DataStorage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataStorage.Builder#build()} is called immediately and its result
         * is passed to {@link #dataStorage(DataStorage)}.
         * 
         * @param dataStorage
         *        a consumer that will call methods on {@link DataStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataStorage(DataStorage)
         */
        default Builder dataStorage(Consumer<DataStorage.Builder> dataStorage) {
            return dataStorage(DataStorage.builder().applyMutation(dataStorage).build());
        }

        /**
         * Sets the value of the ECPUPerSecond property for this object.
         *
         * @param ecpuPerSecond
         *        The new value for the ECPUPerSecond property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecpuPerSecond(ECPUPerSecond ecpuPerSecond);

        /**
         * Sets the value of the ECPUPerSecond property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ECPUPerSecond.Builder} avoiding the need
         * to create one manually via {@link ECPUPerSecond#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ECPUPerSecond.Builder#build()} is called immediately and its
         * result is passed to {@link #ecpuPerSecond(ECPUPerSecond)}.
         * 
         * @param ecpuPerSecond
         *        a consumer that will call methods on {@link ECPUPerSecond.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecpuPerSecond(ECPUPerSecond)
         */
        default Builder ecpuPerSecond(Consumer<ECPUPerSecond.Builder> ecpuPerSecond) {
            return ecpuPerSecond(ECPUPerSecond.builder().applyMutation(ecpuPerSecond).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataStorage dataStorage;

        private ECPUPerSecond ecpuPerSecond;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheUsageLimits model) {
            dataStorage(model.dataStorage);
            ecpuPerSecond(model.ecpuPerSecond);
        }

        public final DataStorage.Builder getDataStorage() {
            return dataStorage != null ? dataStorage.toBuilder() : null;
        }

        public final void setDataStorage(DataStorage.BuilderImpl dataStorage) {
            this.dataStorage = dataStorage != null ? dataStorage.build() : null;
        }

        @Override
        public final Builder dataStorage(DataStorage dataStorage) {
            this.dataStorage = dataStorage;
            return this;
        }

        public final ECPUPerSecond.Builder getEcpuPerSecond() {
            return ecpuPerSecond != null ? ecpuPerSecond.toBuilder() : null;
        }

        public final void setEcpuPerSecond(ECPUPerSecond.BuilderImpl ecpuPerSecond) {
            this.ecpuPerSecond = ecpuPerSecond != null ? ecpuPerSecond.build() : null;
        }

        @Override
        public final Builder ecpuPerSecond(ECPUPerSecond ecpuPerSecond) {
            this.ecpuPerSecond = ecpuPerSecond;
            return this;
        }

        @Override
        public CacheUsageLimits build() {
            return new CacheUsageLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
