/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServerlessCachesRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<DescribeServerlessCachesRequest.Builder, DescribeServerlessCachesRequest> {
    private static final SdkField<String> SERVERLESS_CACHE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerlessCacheName").getter(getter(DescribeServerlessCachesRequest::serverlessCacheName))
            .setter(setter(Builder::serverlessCacheName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheName").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeServerlessCachesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeServerlessCachesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERLESS_CACHE_NAME_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String serverlessCacheName;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeServerlessCachesRequest(BuilderImpl builder) {
        super(builder);
        this.serverlessCacheName = builder.serverlessCacheName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier for the serverless cache. If this parameter is specified, only information about that specific
     * serverless cache is returned. Default: NULL
     * </p>
     * 
     * @return The identifier for the serverless cache. If this parameter is specified, only information about that
     *         specific serverless cache is returned. Default: NULL
     */
    public final String serverlessCacheName() {
        return serverlessCacheName;
    }

    /**
     * <p>
     * The maximum number of records in the response. If more records exist than the specified max-records value, the
     * next token is included in the response so that remaining results can be retrieved. The default is 50.
     * </p>
     * 
     * @return The maximum number of records in the response. If more records exist than the specified max-records
     *         value, the next token is included in the response so that remaining results can be retrieved. The default
     *         is 50.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An optional marker returned from a prior request to support pagination of results from this operation. If this
     * parameter is specified, the response includes only records beyond the marker, up to the value specified by
     * MaxResults.
     * </p>
     * 
     * @return An optional marker returned from a prior request to support pagination of results from this operation. If
     *         this parameter is specified, the response includes only records beyond the marker, up to the value
     *         specified by MaxResults.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverlessCacheName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServerlessCachesRequest)) {
            return false;
        }
        DescribeServerlessCachesRequest other = (DescribeServerlessCachesRequest) obj;
        return Objects.equals(serverlessCacheName(), other.serverlessCacheName())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeServerlessCachesRequest").add("ServerlessCacheName", serverlessCacheName())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerlessCacheName":
            return Optional.ofNullable(clazz.cast(serverlessCacheName()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServerlessCachesRequest, T> g) {
        return obj -> g.apply((DescribeServerlessCachesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeServerlessCachesRequest> {
        /**
         * <p>
         * The identifier for the serverless cache. If this parameter is specified, only information about that specific
         * serverless cache is returned. Default: NULL
         * </p>
         * 
         * @param serverlessCacheName
         *        The identifier for the serverless cache. If this parameter is specified, only information about that
         *        specific serverless cache is returned. Default: NULL
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCacheName(String serverlessCacheName);

        /**
         * <p>
         * The maximum number of records in the response. If more records exist than the specified max-records value,
         * the next token is included in the response so that remaining results can be retrieved. The default is 50.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of records in the response. If more records exist than the specified max-records
         *        value, the next token is included in the response so that remaining results can be retrieved. The
         *        default is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An optional marker returned from a prior request to support pagination of results from this operation. If
         * this parameter is specified, the response includes only records beyond the marker, up to the value specified
         * by MaxResults.
         * </p>
         * 
         * @param nextToken
         *        An optional marker returned from a prior request to support pagination of results from this operation.
         *        If this parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by MaxResults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String serverlessCacheName;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServerlessCachesRequest model) {
            super(model);
            serverlessCacheName(model.serverlessCacheName);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getServerlessCacheName() {
            return serverlessCacheName;
        }

        public final void setServerlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
        }

        @Override
        public final Builder serverlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeServerlessCachesRequest build() {
            return new DescribeServerlessCachesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
