/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticinference.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAcceleratorOfferingsResponse extends ElasticInferenceResponse implements
        ToCopyableBuilder<DescribeAcceleratorOfferingsResponse.Builder, DescribeAcceleratorOfferingsResponse> {
    private static final SdkField<List<AcceleratorTypeOffering>> ACCELERATOR_TYPE_OFFERINGS_FIELD = SdkField
            .<List<AcceleratorTypeOffering>> builder(MarshallingType.LIST)
            .memberName("acceleratorTypeOfferings")
            .getter(getter(DescribeAcceleratorOfferingsResponse::acceleratorTypeOfferings))
            .setter(setter(Builder::acceleratorTypeOfferings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorTypeOfferings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AcceleratorTypeOffering> builder(MarshallingType.SDK_POJO)
                                            .constructor(AcceleratorTypeOffering::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ACCELERATOR_TYPE_OFFERINGS_FIELD));

    private final List<AcceleratorTypeOffering> acceleratorTypeOfferings;

    private DescribeAcceleratorOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.acceleratorTypeOfferings = builder.acceleratorTypeOfferings;
    }

    /**
     * For responses, this returns true if the service returned a value for the AcceleratorTypeOfferings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAcceleratorTypeOfferings() {
        return acceleratorTypeOfferings != null && !(acceleratorTypeOfferings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of accelerator type offerings for a specific location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceleratorTypeOfferings} method.
     * </p>
     * 
     * @return The list of accelerator type offerings for a specific location.
     */
    public final List<AcceleratorTypeOffering> acceleratorTypeOfferings() {
        return acceleratorTypeOfferings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceleratorTypeOfferings() ? acceleratorTypeOfferings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAcceleratorOfferingsResponse)) {
            return false;
        }
        DescribeAcceleratorOfferingsResponse other = (DescribeAcceleratorOfferingsResponse) obj;
        return hasAcceleratorTypeOfferings() == other.hasAcceleratorTypeOfferings()
                && Objects.equals(acceleratorTypeOfferings(), other.acceleratorTypeOfferings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAcceleratorOfferingsResponse")
                .add("AcceleratorTypeOfferings", hasAcceleratorTypeOfferings() ? acceleratorTypeOfferings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acceleratorTypeOfferings":
            return Optional.ofNullable(clazz.cast(acceleratorTypeOfferings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAcceleratorOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeAcceleratorOfferingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticInferenceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAcceleratorOfferingsResponse> {
        /**
         * <p>
         * The list of accelerator type offerings for a specific location.
         * </p>
         * 
         * @param acceleratorTypeOfferings
         *        The list of accelerator type offerings for a specific location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypeOfferings(Collection<AcceleratorTypeOffering> acceleratorTypeOfferings);

        /**
         * <p>
         * The list of accelerator type offerings for a specific location.
         * </p>
         * 
         * @param acceleratorTypeOfferings
         *        The list of accelerator type offerings for a specific location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypeOfferings(AcceleratorTypeOffering... acceleratorTypeOfferings);

        /**
         * <p>
         * The list of accelerator type offerings for a specific location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticinference.model.AcceleratorTypeOffering.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.elasticinference.model.AcceleratorTypeOffering#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticinference.model.AcceleratorTypeOffering.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #acceleratorTypeOfferings(List<AcceleratorTypeOffering>)}.
         * 
         * @param acceleratorTypeOfferings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticinference.model.AcceleratorTypeOffering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acceleratorTypeOfferings(java.util.Collection<AcceleratorTypeOffering>)
         */
        Builder acceleratorTypeOfferings(Consumer<AcceleratorTypeOffering.Builder>... acceleratorTypeOfferings);
    }

    static final class BuilderImpl extends ElasticInferenceResponse.BuilderImpl implements Builder {
        private List<AcceleratorTypeOffering> acceleratorTypeOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAcceleratorOfferingsResponse model) {
            super(model);
            acceleratorTypeOfferings(model.acceleratorTypeOfferings);
        }

        public final List<AcceleratorTypeOffering.Builder> getAcceleratorTypeOfferings() {
            List<AcceleratorTypeOffering.Builder> result = AcceleratorTypeOfferingListCopier
                    .copyToBuilder(this.acceleratorTypeOfferings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAcceleratorTypeOfferings(Collection<AcceleratorTypeOffering.BuilderImpl> acceleratorTypeOfferings) {
            this.acceleratorTypeOfferings = AcceleratorTypeOfferingListCopier.copyFromBuilder(acceleratorTypeOfferings);
        }

        @Override
        public final Builder acceleratorTypeOfferings(Collection<AcceleratorTypeOffering> acceleratorTypeOfferings) {
            this.acceleratorTypeOfferings = AcceleratorTypeOfferingListCopier.copy(acceleratorTypeOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypeOfferings(AcceleratorTypeOffering... acceleratorTypeOfferings) {
            acceleratorTypeOfferings(Arrays.asList(acceleratorTypeOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypeOfferings(Consumer<AcceleratorTypeOffering.Builder>... acceleratorTypeOfferings) {
            acceleratorTypeOfferings(Stream.of(acceleratorTypeOfferings)
                    .map(c -> AcceleratorTypeOffering.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAcceleratorOfferingsResponse build() {
            return new DescribeAcceleratorOfferingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
