/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The codes to use when checking for a successful response from a target. If the protocol version is gRPC, these are
 * gRPC codes. Otherwise, these are HTTP codes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Matcher implements SdkPojo, Serializable, ToCopyableBuilder<Matcher.Builder, Matcher> {
    private static final SdkField<String> HTTP_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpCode").getter(getter(Matcher::httpCode)).setter(setter(Builder::httpCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpCode").build()).build();

    private static final SdkField<String> GRPC_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrpcCode").getter(getter(Matcher::grpcCode)).setter(setter(Builder::grpcCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrpcCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_CODE_FIELD,
            GRPC_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String httpCode;

    private final String grpcCode;

    private Matcher(BuilderImpl builder) {
        this.httpCode = builder.httpCode;
        this.grpcCode = builder.grpcCode;
    }

    /**
     * <p>
     * For Application Load Balancers, you can specify values between 200 and 499, and the default value is 200. You can
     * specify multiple values (for example, "200,202") or a range of values (for example, "200-299").
     * </p>
     * <p>
     * For Network Load Balancers and Gateway Load Balancers, this must be "200–399".
     * </p>
     * <p>
     * Note that when using shorthand syntax, some values such as commas need to be escaped.
     * </p>
     * 
     * @return For Application Load Balancers, you can specify values between 200 and 499, and the default value is 200.
     *         You can specify multiple values (for example, "200,202") or a range of values (for example,
     *         "200-299").</p>
     *         <p>
     *         For Network Load Balancers and Gateway Load Balancers, this must be "200–399".
     *         </p>
     *         <p>
     *         Note that when using shorthand syntax, some values such as commas need to be escaped.
     */
    public final String httpCode() {
        return httpCode;
    }

    /**
     * <p>
     * You can specify values between 0 and 99. You can specify multiple values (for example, "0,1") or a range of
     * values (for example, "0-5"). The default value is 12.
     * </p>
     * 
     * @return You can specify values between 0 and 99. You can specify multiple values (for example, "0,1") or a range
     *         of values (for example, "0-5"). The default value is 12.
     */
    public final String grpcCode() {
        return grpcCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpCode());
        hashCode = 31 * hashCode + Objects.hashCode(grpcCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Matcher)) {
            return false;
        }
        Matcher other = (Matcher) obj;
        return Objects.equals(httpCode(), other.httpCode()) && Objects.equals(grpcCode(), other.grpcCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Matcher").add("HttpCode", httpCode()).add("GrpcCode", grpcCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HttpCode":
            return Optional.ofNullable(clazz.cast(httpCode()));
        case "GrpcCode":
            return Optional.ofNullable(clazz.cast(grpcCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Matcher, T> g) {
        return obj -> g.apply((Matcher) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Matcher> {
        /**
         * <p>
         * For Application Load Balancers, you can specify values between 200 and 499, and the default value is 200. You
         * can specify multiple values (for example, "200,202") or a range of values (for example, "200-299").
         * </p>
         * <p>
         * For Network Load Balancers and Gateway Load Balancers, this must be "200–399".
         * </p>
         * <p>
         * Note that when using shorthand syntax, some values such as commas need to be escaped.
         * </p>
         * 
         * @param httpCode
         *        For Application Load Balancers, you can specify values between 200 and 499, and the default value is
         *        200. You can specify multiple values (for example, "200,202") or a range of values (for example,
         *        "200-299").</p>
         *        <p>
         *        For Network Load Balancers and Gateway Load Balancers, this must be "200–399".
         *        </p>
         *        <p>
         *        Note that when using shorthand syntax, some values such as commas need to be escaped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpCode(String httpCode);

        /**
         * <p>
         * You can specify values between 0 and 99. You can specify multiple values (for example, "0,1") or a range of
         * values (for example, "0-5"). The default value is 12.
         * </p>
         * 
         * @param grpcCode
         *        You can specify values between 0 and 99. You can specify multiple values (for example, "0,1") or a
         *        range of values (for example, "0-5"). The default value is 12.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grpcCode(String grpcCode);
    }

    static final class BuilderImpl implements Builder {
        private String httpCode;

        private String grpcCode;

        private BuilderImpl() {
        }

        private BuilderImpl(Matcher model) {
            httpCode(model.httpCode);
            grpcCode(model.grpcCode);
        }

        public final String getHttpCode() {
            return httpCode;
        }

        public final void setHttpCode(String httpCode) {
            this.httpCode = httpCode;
        }

        @Override
        public final Builder httpCode(String httpCode) {
            this.httpCode = httpCode;
            return this;
        }

        public final String getGrpcCode() {
            return grpcCode;
        }

        public final void setGrpcCode(String grpcCode) {
            this.grpcCode = grpcCode;
        }

        @Override
        public final Builder grpcCode(String grpcCode) {
            this.grpcCode = grpcCode;
            return this;
        }

        @Override
        public Matcher build() {
            return new Matcher(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
