/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.AccessDeniedException;
import software.amazon.awssdk.services.elasticsearch.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.AssociatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.AssociatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.AuthorizeVpcEndpointAccessRequest;
import software.amazon.awssdk.services.elasticsearch.model.AuthorizeVpcEndpointAccessResponse;
import software.amazon.awssdk.services.elasticsearch.model.BaseException;
import software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.elasticsearch.model.ConflictException;
import software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.CreatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchServiceRoleRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchServiceRoleResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeletePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeletePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteVpcEndpointRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteVpcEndpointResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DisabledOperationException;
import software.amazon.awssdk.services.elasticsearch.model.DissociatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.DissociatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchException;
import software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse;
import software.amazon.awssdk.services.elasticsearch.model.InternalException;
import software.amazon.awssdk.services.elasticsearch.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.elasticsearch.model.InvalidTypeException;
import software.amazon.awssdk.services.elasticsearch.model.LimitExceededException;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointAccessRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointAccessResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsForDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsForDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsResponse;
import software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest;
import software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse;
import software.amazon.awssdk.services.elasticsearch.model.RejectInboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.elasticsearch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.elasticsearch.model.RevokeVpcEndpointAccessRequest;
import software.amazon.awssdk.services.elasticsearch.model.RevokeVpcEndpointAccessResponse;
import software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpdatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpdatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.ValidationException;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribeDomainAutoTunesIterable;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribeInboundCrossClusterSearchConnectionsIterable;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribeOutboundCrossClusterSearchConnectionsIterable;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribePackagesIterable;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsIterable;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesIterable;
import software.amazon.awssdk.services.elasticsearch.paginators.GetPackageVersionHistoryIterable;
import software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryIterable;
import software.amazon.awssdk.services.elasticsearch.paginators.ListDomainsForPackageIterable;
import software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesIterable;
import software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsIterable;
import software.amazon.awssdk.services.elasticsearch.paginators.ListPackagesForDomainIterable;

/**
 * Service client for accessing Amazon Elasticsearch Service. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Amazon Elasticsearch Configuration Service</fullname>
 * <p>
 * Use the Amazon Elasticsearch Configuration API to create, configure, and manage Elasticsearch domains.
 * </p>
 * <p>
 * For sample code that uses the Configuration API, see the <a
 * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-configuration-samples.html">Amazon
 * Elasticsearch Service Developer Guide</a>. The guide also contains <a
 * href="https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-request-signing.html">sample code
 * for sending signed HTTP requests to the Elasticsearch APIs</a>.
 * </p>
 * <p>
 * The endpoint for configuration service requests is region-specific: es.<i>region</i>.amazonaws.com. For example,
 * es.us-east-1.amazonaws.com. For a current list of supported regions and endpoints, see <a
 * href="http://docs.aws.amazon.com/general/latest/gr/rande.html#elasticsearch-service-regions" target="_blank">Regions
 * and Endpoints</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ElasticsearchClient extends SdkClient {
    String SERVICE_NAME = "es";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "es";

    /**
     * Create a {@link ElasticsearchClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ElasticsearchClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ElasticsearchClient}.
     */
    static ElasticsearchClientBuilder builder() {
        return new DefaultElasticsearchClientBuilder();
    }

    /**
     * <p>
     * Allows the destination domain owner to accept an inbound cross-cluster search connection request.
     * </p>
     *
     * @param acceptInboundCrossClusterSearchConnectionRequest
     *        Container for the parameters to the <code><a>AcceptInboundCrossClusterSearchConnection</a></code>
     *        operation.
     * @return Result of the AcceptInboundCrossClusterSearchConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.AcceptInboundCrossClusterSearchConnection
     */
    default AcceptInboundCrossClusterSearchConnectionResponse acceptInboundCrossClusterSearchConnection(
            AcceptInboundCrossClusterSearchConnectionRequest acceptInboundCrossClusterSearchConnectionRequest)
            throws ResourceNotFoundException, LimitExceededException, DisabledOperationException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the destination domain owner to accept an inbound cross-cluster search connection request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AcceptInboundCrossClusterSearchConnectionRequest.Builder} avoiding the need to create one manually via
     * {@link AcceptInboundCrossClusterSearchConnectionRequest#builder()}
     * </p>
     *
     * @param acceptInboundCrossClusterSearchConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AcceptInboundCrossClusterSearchConnectionRequest.Builder} to create a request. Container for the
     *        parameters to the <code><a>AcceptInboundCrossClusterSearchConnection</a></code> operation.
     * @return Result of the AcceptInboundCrossClusterSearchConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.AcceptInboundCrossClusterSearchConnection
     */
    default AcceptInboundCrossClusterSearchConnectionResponse acceptInboundCrossClusterSearchConnection(
            Consumer<AcceptInboundCrossClusterSearchConnectionRequest.Builder> acceptInboundCrossClusterSearchConnectionRequest)
            throws ResourceNotFoundException, LimitExceededException, DisabledOperationException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        return acceptInboundCrossClusterSearchConnection(AcceptInboundCrossClusterSearchConnectionRequest.builder()
                .applyMutation(acceptInboundCrossClusterSearchConnectionRequest).build());
    }

    /**
     * <p>
     * Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An
     * Elasticsearch domain may have up to 10 tags. See <a href=
     * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging"
     * target="_blank"> Tagging Amazon Elasticsearch Service Domains for more information.</a>
     * </p>
     *
     * @param addTagsRequest
     *        Container for the parameters to the <code><a>AddTags</a></code> operation. Specify the tags that you want
     *        to attach to the Elasticsearch domain.
     * @return Result of the AddTags operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.AddTags
     */
    default AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws BaseException, LimitExceededException,
            ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An
     * Elasticsearch domain may have up to 10 tags. See <a href=
     * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging"
     * target="_blank"> Tagging Amazon Elasticsearch Service Domains for more information.</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsRequest.Builder} avoiding the need to create
     * one manually via {@link AddTagsRequest#builder()}
     * </p>
     *
     * @param addTagsRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsRequest.Builder} to create a request. Container
     *        for the parameters to the <code><a>AddTags</a></code> operation. Specify the tags that you want to attach
     *        to the Elasticsearch domain.
     * @return Result of the AddTags operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.AddTags
     */
    default AddTagsResponse addTags(Consumer<AddTagsRequest.Builder> addTagsRequest) throws BaseException,
            LimitExceededException, ValidationException, InternalException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return addTags(AddTagsRequest.builder().applyMutation(addTagsRequest).build());
    }

    /**
     * <p>
     * Associates a package with an Amazon ES domain.
     * </p>
     *
     * @param associatePackageRequest
     *        Container for request parameters to <code> <a>AssociatePackage</a> </code> operation.
     * @return Result of the AssociatePackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP
     *         status code 409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.AssociatePackage
     */
    default AssociatePackageResponse associatePackage(AssociatePackageRequest associatePackageRequest) throws BaseException,
            InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a package with an Amazon ES domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociatePackageRequest.Builder} avoiding the need
     * to create one manually via {@link AssociatePackageRequest#builder()}
     * </p>
     *
     * @param associatePackageRequest
     *        A {@link Consumer} that will call methods on {@link AssociatePackageRequest.Builder} to create a request.
     *        Container for request parameters to <code> <a>AssociatePackage</a> </code> operation.
     * @return Result of the AssociatePackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP
     *         status code 409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.AssociatePackage
     */
    default AssociatePackageResponse associatePackage(Consumer<AssociatePackageRequest.Builder> associatePackageRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ConflictException, AwsServiceException, SdkClientException, ElasticsearchException {
        return associatePackage(AssociatePackageRequest.builder().applyMutation(associatePackageRequest).build());
    }

    /**
     * <p>
     * Provides access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
     * </p>
     *
     * @param authorizeVpcEndpointAccessRequest
     *        Container for request parameters to the <code><a>AuthorizeVpcEndpointAccess</a></code> operation.
     *        Specifies the account to be permitted to manage VPC endpoints against the domain.
     * @return Result of the AuthorizeVpcEndpointAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.AuthorizeVpcEndpointAccess
     */
    default AuthorizeVpcEndpointAccessResponse authorizeVpcEndpointAccess(
            AuthorizeVpcEndpointAccessRequest authorizeVpcEndpointAccessRequest) throws ResourceNotFoundException,
            DisabledOperationException, LimitExceededException, ValidationException, InternalException, BaseException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeVpcEndpointAccessRequest.Builder} avoiding
     * the need to create one manually via {@link AuthorizeVpcEndpointAccessRequest#builder()}
     * </p>
     *
     * @param authorizeVpcEndpointAccessRequest
     *        A {@link Consumer} that will call methods on {@link AuthorizeVpcEndpointAccessRequest.Builder} to create a
     *        request. Container for request parameters to the <code><a>AuthorizeVpcEndpointAccess</a></code> operation.
     *        Specifies the account to be permitted to manage VPC endpoints against the domain.
     * @return Result of the AuthorizeVpcEndpointAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.AuthorizeVpcEndpointAccess
     */
    default AuthorizeVpcEndpointAccessResponse authorizeVpcEndpointAccess(
            Consumer<AuthorizeVpcEndpointAccessRequest.Builder> authorizeVpcEndpointAccessRequest)
            throws ResourceNotFoundException, DisabledOperationException, LimitExceededException, ValidationException,
            InternalException, BaseException, AwsServiceException, SdkClientException, ElasticsearchException {
        return authorizeVpcEndpointAccess(AuthorizeVpcEndpointAccessRequest.builder()
                .applyMutation(authorizeVpcEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before
     * the <code>AutomatedUpdateDate</code> and when the <code>UpdateStatus</code> is in the <code>PENDING_UPDATE</code>
     * state.
     * </p>
     *
     * @param cancelElasticsearchServiceSoftwareUpdateRequest
     *        Container for the parameters to the <code><a>CancelElasticsearchServiceSoftwareUpdate</a></code>
     *        operation. Specifies the name of the Elasticsearch domain that you wish to cancel a service software
     *        update on.
     * @return Result of the CancelElasticsearchServiceSoftwareUpdate operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.CancelElasticsearchServiceSoftwareUpdate
     */
    default CancelElasticsearchServiceSoftwareUpdateResponse cancelElasticsearchServiceSoftwareUpdate(
            CancelElasticsearchServiceSoftwareUpdateRequest cancelElasticsearchServiceSoftwareUpdateRequest)
            throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before
     * the <code>AutomatedUpdateDate</code> and when the <code>UpdateStatus</code> is in the <code>PENDING_UPDATE</code>
     * state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CancelElasticsearchServiceSoftwareUpdateRequest.Builder} avoiding the need to create one manually via
     * {@link CancelElasticsearchServiceSoftwareUpdateRequest#builder()}
     * </p>
     *
     * @param cancelElasticsearchServiceSoftwareUpdateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link CancelElasticsearchServiceSoftwareUpdateRequest.Builder} to create a request. Container for the
     *        parameters to the <code><a>CancelElasticsearchServiceSoftwareUpdate</a></code> operation. Specifies the
     *        name of the Elasticsearch domain that you wish to cancel a service software update on.
     * @return Result of the CancelElasticsearchServiceSoftwareUpdate operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.CancelElasticsearchServiceSoftwareUpdate
     */
    default CancelElasticsearchServiceSoftwareUpdateResponse cancelElasticsearchServiceSoftwareUpdate(
            Consumer<CancelElasticsearchServiceSoftwareUpdateRequest.Builder> cancelElasticsearchServiceSoftwareUpdateRequest)
            throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        return cancelElasticsearchServiceSoftwareUpdate(CancelElasticsearchServiceSoftwareUpdateRequest.builder()
                .applyMutation(cancelElasticsearchServiceSoftwareUpdateRequest).build());
    }

    /**
     * <p>
     * Creates a new Elasticsearch domain. For more information, see <a href=
     * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains"
     * target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.
     * </p>
     *
     * @param createElasticsearchDomainRequest
     * @return Result of the CreateElasticsearchDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws InvalidTypeException
     *         An exception for trying to create or access sub-resource that is either invalid or not supported. Gives
     *         http status code of 409.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws ResourceAlreadyExistsException
     *         An exception for creating a resource that already exists. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.CreateElasticsearchDomain
     */
    default CreateElasticsearchDomainResponse createElasticsearchDomain(
            CreateElasticsearchDomainRequest createElasticsearchDomainRequest) throws BaseException, DisabledOperationException,
            InternalException, InvalidTypeException, LimitExceededException, ResourceAlreadyExistsException, ValidationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Elasticsearch domain. For more information, see <a href=
     * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains"
     * target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateElasticsearchDomainRequest.Builder} avoiding
     * the need to create one manually via {@link CreateElasticsearchDomainRequest#builder()}
     * </p>
     *
     * @param createElasticsearchDomainRequest
     *        A {@link Consumer} that will call methods on {@link CreateElasticsearchDomainRequest.Builder} to create a
     *        request.
     * @return Result of the CreateElasticsearchDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws InvalidTypeException
     *         An exception for trying to create or access sub-resource that is either invalid or not supported. Gives
     *         http status code of 409.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws ResourceAlreadyExistsException
     *         An exception for creating a resource that already exists. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.CreateElasticsearchDomain
     */
    default CreateElasticsearchDomainResponse createElasticsearchDomain(
            Consumer<CreateElasticsearchDomainRequest.Builder> createElasticsearchDomainRequest) throws BaseException,
            DisabledOperationException, InternalException, InvalidTypeException, LimitExceededException,
            ResourceAlreadyExistsException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        return createElasticsearchDomain(CreateElasticsearchDomainRequest.builder()
                .applyMutation(createElasticsearchDomainRequest).build());
    }

    /**
     * <p>
     * Creates a new cross-cluster search connection from a source domain to a destination domain.
     * </p>
     *
     * @param createOutboundCrossClusterSearchConnectionRequest
     *        Container for the parameters to the <code><a>CreateOutboundCrossClusterSearchConnection</a></code>
     *        operation.
     * @return Result of the CreateOutboundCrossClusterSearchConnection operation returned by the service.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceAlreadyExistsException
     *         An exception for creating a resource that already exists. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.CreateOutboundCrossClusterSearchConnection
     */
    default CreateOutboundCrossClusterSearchConnectionResponse createOutboundCrossClusterSearchConnection(
            CreateOutboundCrossClusterSearchConnectionRequest createOutboundCrossClusterSearchConnectionRequest)
            throws LimitExceededException, InternalException, ResourceAlreadyExistsException, DisabledOperationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new cross-cluster search connection from a source domain to a destination domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateOutboundCrossClusterSearchConnectionRequest.Builder} avoiding the need to create one manually via
     * {@link CreateOutboundCrossClusterSearchConnectionRequest#builder()}
     * </p>
     *
     * @param createOutboundCrossClusterSearchConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link CreateOutboundCrossClusterSearchConnectionRequest.Builder} to create a request. Container for the
     *        parameters to the <code><a>CreateOutboundCrossClusterSearchConnection</a></code> operation.
     * @return Result of the CreateOutboundCrossClusterSearchConnection operation returned by the service.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceAlreadyExistsException
     *         An exception for creating a resource that already exists. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.CreateOutboundCrossClusterSearchConnection
     */
    default CreateOutboundCrossClusterSearchConnectionResponse createOutboundCrossClusterSearchConnection(
            Consumer<CreateOutboundCrossClusterSearchConnectionRequest.Builder> createOutboundCrossClusterSearchConnectionRequest)
            throws LimitExceededException, InternalException, ResourceAlreadyExistsException, DisabledOperationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        return createOutboundCrossClusterSearchConnection(CreateOutboundCrossClusterSearchConnectionRequest.builder()
                .applyMutation(createOutboundCrossClusterSearchConnectionRequest).build());
    }

    /**
     * <p>
     * Create a package for use with Amazon ES domains.
     * </p>
     *
     * @param createPackageRequest
     *        Container for request parameters to <code> <a>CreatePackage</a> </code> operation.
     * @return Result of the CreatePackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws InvalidTypeException
     *         An exception for trying to create or access sub-resource that is either invalid or not supported. Gives
     *         http status code of 409.
     * @throws ResourceAlreadyExistsException
     *         An exception for creating a resource that already exists. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.CreatePackage
     */
    default CreatePackageResponse createPackage(CreatePackageRequest createPackageRequest) throws BaseException,
            InternalException, LimitExceededException, InvalidTypeException, ResourceAlreadyExistsException,
            AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a package for use with Amazon ES domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePackageRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePackageRequest#builder()}
     * </p>
     *
     * @param createPackageRequest
     *        A {@link Consumer} that will call methods on {@link CreatePackageRequest.Builder} to create a request.
     *        Container for request parameters to <code> <a>CreatePackage</a> </code> operation.
     * @return Result of the CreatePackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws InvalidTypeException
     *         An exception for trying to create or access sub-resource that is either invalid or not supported. Gives
     *         http status code of 409.
     * @throws ResourceAlreadyExistsException
     *         An exception for creating a resource that already exists. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.CreatePackage
     */
    default CreatePackageResponse createPackage(Consumer<CreatePackageRequest.Builder> createPackageRequest)
            throws BaseException, InternalException, LimitExceededException, InvalidTypeException,
            ResourceAlreadyExistsException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return createPackage(CreatePackageRequest.builder().applyMutation(createPackageRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon OpenSearch Service-managed VPC endpoint.
     * </p>
     *
     * @param createVpcEndpointRequest
     *        Container for the parameters to the <code><a>CreateVpcEndpointRequest</a></code> operation.
     * @return Result of the CreateVpcEndpoint operation returned by the service.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP
     *         status code 409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.CreateVpcEndpoint
     */
    default CreateVpcEndpointResponse createVpcEndpoint(CreateVpcEndpointRequest createVpcEndpointRequest)
            throws ConflictException, ValidationException, LimitExceededException, InternalException, DisabledOperationException,
            BaseException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon OpenSearch Service-managed VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVpcEndpointRequest#builder()}
     * </p>
     *
     * @param createVpcEndpointRequest
     *        A {@link Consumer} that will call methods on {@link CreateVpcEndpointRequest.Builder} to create a request.
     *        Container for the parameters to the <code><a>CreateVpcEndpointRequest</a></code> operation.
     * @return Result of the CreateVpcEndpoint operation returned by the service.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP
     *         status code 409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.CreateVpcEndpoint
     */
    default CreateVpcEndpointResponse createVpcEndpoint(Consumer<CreateVpcEndpointRequest.Builder> createVpcEndpointRequest)
            throws ConflictException, ValidationException, LimitExceededException, InternalException, DisabledOperationException,
            BaseException, AwsServiceException, SdkClientException, ElasticsearchException {
        return createVpcEndpoint(CreateVpcEndpointRequest.builder().applyMutation(createVpcEndpointRequest).build());
    }

    /**
     * <p>
     * Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot
     * be recovered.
     * </p>
     *
     * @param deleteElasticsearchDomainRequest
     *        Container for the parameters to the <code><a>DeleteElasticsearchDomain</a></code> operation. Specifies the
     *        name of the Elasticsearch domain that you want to delete.
     * @return Result of the DeleteElasticsearchDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DeleteElasticsearchDomain
     */
    default DeleteElasticsearchDomainResponse deleteElasticsearchDomain(
            DeleteElasticsearchDomainRequest deleteElasticsearchDomainRequest) throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot
     * be recovered.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteElasticsearchDomainRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteElasticsearchDomainRequest#builder()}
     * </p>
     *
     * @param deleteElasticsearchDomainRequest
     *        A {@link Consumer} that will call methods on {@link DeleteElasticsearchDomainRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DeleteElasticsearchDomain</a></code> operation.
     *        Specifies the name of the Elasticsearch domain that you want to delete.
     * @return Result of the DeleteElasticsearchDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DeleteElasticsearchDomain
     */
    default DeleteElasticsearchDomainResponse deleteElasticsearchDomain(
            Consumer<DeleteElasticsearchDomainRequest.Builder> deleteElasticsearchDomainRequest) throws BaseException,
            InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return deleteElasticsearchDomain(DeleteElasticsearchDomainRequest.builder()
                .applyMutation(deleteElasticsearchDomainRequest).build());
    }

    /**
     * <p>
     * Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion
     * will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before
     * deleting the role. See <a
     * href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr"
     * target="_blank">Deleting Elasticsearch Service Role</a> in <i>VPC Endpoints for Amazon Elasticsearch Service
     * Domains</i>.
     * </p>
     *
     * @return Result of the DeleteElasticsearchServiceRole operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DeleteElasticsearchServiceRole
     * @see #deleteElasticsearchServiceRole(DeleteElasticsearchServiceRoleRequest)
     */
    default DeleteElasticsearchServiceRoleResponse deleteElasticsearchServiceRole() throws BaseException, InternalException,
            ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        return deleteElasticsearchServiceRole(DeleteElasticsearchServiceRoleRequest.builder().build());
    }

    /**
     * <p>
     * Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion
     * will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before
     * deleting the role. See <a
     * href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr"
     * target="_blank">Deleting Elasticsearch Service Role</a> in <i>VPC Endpoints for Amazon Elasticsearch Service
     * Domains</i>.
     * </p>
     *
     * @param deleteElasticsearchServiceRoleRequest
     * @return Result of the DeleteElasticsearchServiceRole operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DeleteElasticsearchServiceRole
     */
    default DeleteElasticsearchServiceRoleResponse deleteElasticsearchServiceRole(
            DeleteElasticsearchServiceRoleRequest deleteElasticsearchServiceRoleRequest) throws BaseException, InternalException,
            ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion
     * will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before
     * deleting the role. See <a
     * href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr"
     * target="_blank">Deleting Elasticsearch Service Role</a> in <i>VPC Endpoints for Amazon Elasticsearch Service
     * Domains</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteElasticsearchServiceRoleRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteElasticsearchServiceRoleRequest#builder()}
     * </p>
     *
     * @param deleteElasticsearchServiceRoleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteElasticsearchServiceRoleRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteElasticsearchServiceRole operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DeleteElasticsearchServiceRole
     */
    default DeleteElasticsearchServiceRoleResponse deleteElasticsearchServiceRole(
            Consumer<DeleteElasticsearchServiceRoleRequest.Builder> deleteElasticsearchServiceRoleRequest) throws BaseException,
            InternalException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        return deleteElasticsearchServiceRole(DeleteElasticsearchServiceRoleRequest.builder()
                .applyMutation(deleteElasticsearchServiceRoleRequest).build());
    }

    /**
     * <p>
     * Allows the destination domain owner to delete an existing inbound cross-cluster search connection.
     * </p>
     *
     * @param deleteInboundCrossClusterSearchConnectionRequest
     *        Container for the parameters to the <code><a>DeleteInboundCrossClusterSearchConnection</a></code>
     *        operation.
     * @return Result of the DeleteInboundCrossClusterSearchConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DeleteInboundCrossClusterSearchConnection
     */
    default DeleteInboundCrossClusterSearchConnectionResponse deleteInboundCrossClusterSearchConnection(
            DeleteInboundCrossClusterSearchConnectionRequest deleteInboundCrossClusterSearchConnectionRequest)
            throws ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the destination domain owner to delete an existing inbound cross-cluster search connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteInboundCrossClusterSearchConnectionRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteInboundCrossClusterSearchConnectionRequest#builder()}
     * </p>
     *
     * @param deleteInboundCrossClusterSearchConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteInboundCrossClusterSearchConnectionRequest.Builder} to create a request. Container for the
     *        parameters to the <code><a>DeleteInboundCrossClusterSearchConnection</a></code> operation.
     * @return Result of the DeleteInboundCrossClusterSearchConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DeleteInboundCrossClusterSearchConnection
     */
    default DeleteInboundCrossClusterSearchConnectionResponse deleteInboundCrossClusterSearchConnection(
            Consumer<DeleteInboundCrossClusterSearchConnectionRequest.Builder> deleteInboundCrossClusterSearchConnectionRequest)
            throws ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return deleteInboundCrossClusterSearchConnection(DeleteInboundCrossClusterSearchConnectionRequest.builder()
                .applyMutation(deleteInboundCrossClusterSearchConnectionRequest).build());
    }

    /**
     * <p>
     * Allows the source domain owner to delete an existing outbound cross-cluster search connection.
     * </p>
     *
     * @param deleteOutboundCrossClusterSearchConnectionRequest
     *        Container for the parameters to the <code><a>DeleteOutboundCrossClusterSearchConnection</a></code>
     *        operation.
     * @return Result of the DeleteOutboundCrossClusterSearchConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DeleteOutboundCrossClusterSearchConnection
     */
    default DeleteOutboundCrossClusterSearchConnectionResponse deleteOutboundCrossClusterSearchConnection(
            DeleteOutboundCrossClusterSearchConnectionRequest deleteOutboundCrossClusterSearchConnectionRequest)
            throws ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the source domain owner to delete an existing outbound cross-cluster search connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteOutboundCrossClusterSearchConnectionRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteOutboundCrossClusterSearchConnectionRequest#builder()}
     * </p>
     *
     * @param deleteOutboundCrossClusterSearchConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteOutboundCrossClusterSearchConnectionRequest.Builder} to create a request. Container for the
     *        parameters to the <code><a>DeleteOutboundCrossClusterSearchConnection</a></code> operation.
     * @return Result of the DeleteOutboundCrossClusterSearchConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DeleteOutboundCrossClusterSearchConnection
     */
    default DeleteOutboundCrossClusterSearchConnectionResponse deleteOutboundCrossClusterSearchConnection(
            Consumer<DeleteOutboundCrossClusterSearchConnectionRequest.Builder> deleteOutboundCrossClusterSearchConnectionRequest)
            throws ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return deleteOutboundCrossClusterSearchConnection(DeleteOutboundCrossClusterSearchConnectionRequest.builder()
                .applyMutation(deleteOutboundCrossClusterSearchConnectionRequest).build());
    }

    /**
     * <p>
     * Delete the package.
     * </p>
     *
     * @param deletePackageRequest
     *        Container for request parameters to <code> <a>DeletePackage</a> </code> operation.
     * @return Result of the DeletePackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP
     *         status code 409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DeletePackage
     */
    default DeletePackageResponse deletePackage(DeletePackageRequest deletePackageRequest) throws BaseException,
            InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the package.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePackageRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePackageRequest#builder()}
     * </p>
     *
     * @param deletePackageRequest
     *        A {@link Consumer} that will call methods on {@link DeletePackageRequest.Builder} to create a request.
     *        Container for request parameters to <code> <a>DeletePackage</a> </code> operation.
     * @return Result of the DeletePackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP
     *         status code 409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DeletePackage
     */
    default DeletePackageResponse deletePackage(Consumer<DeletePackageRequest.Builder> deletePackageRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ConflictException, AwsServiceException, SdkClientException, ElasticsearchException {
        return deletePackage(DeletePackageRequest.builder().applyMutation(deletePackageRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
     * </p>
     *
     * @param deleteVpcEndpointRequest
     *        Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
     * @return Result of the DeleteVpcEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DeleteVpcEndpoint
     */
    default DeleteVpcEndpointResponse deleteVpcEndpoint(DeleteVpcEndpointRequest deleteVpcEndpointRequest)
            throws ResourceNotFoundException, DisabledOperationException, InternalException, BaseException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteVpcEndpointRequest#builder()}
     * </p>
     *
     * @param deleteVpcEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVpcEndpointRequest.Builder} to create a request.
     *        Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
     * @return Result of the DeleteVpcEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DeleteVpcEndpoint
     */
    default DeleteVpcEndpointResponse deleteVpcEndpoint(Consumer<DeleteVpcEndpointRequest.Builder> deleteVpcEndpointRequest)
            throws ResourceNotFoundException, DisabledOperationException, InternalException, BaseException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        return deleteVpcEndpoint(DeleteVpcEndpointRequest.builder().applyMutation(deleteVpcEndpointRequest).build());
    }

    /**
     * <p>
     * Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type,
     * description, severity, and scheduled date.
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return Result of the DescribeDomainAutoTunes operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeDomainAutoTunes
     */
    default DescribeDomainAutoTunesResponse describeDomainAutoTunes(DescribeDomainAutoTunesRequest describeDomainAutoTunesRequest)
            throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type,
     * description, severity, and scheduled date.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainAutoTunesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDomainAutoTunesRequest#builder()}
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDomainAutoTunesRequest.Builder} to create a
     *        request. Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return Result of the DescribeDomainAutoTunes operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeDomainAutoTunes
     */
    default DescribeDomainAutoTunesResponse describeDomainAutoTunes(
            Consumer<DescribeDomainAutoTunesRequest.Builder> describeDomainAutoTunesRequest) throws BaseException,
            InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return describeDomainAutoTunes(DescribeDomainAutoTunesRequest.builder().applyMutation(describeDomainAutoTunesRequest)
                .build());
    }

    /**
     * <p>
     * Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type,
     * description, severity, and scheduled date.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDomainAutoTunes(software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeDomainAutoTunesIterable responses = client.describeDomainAutoTunesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.DescribeDomainAutoTunesIterable responses = client
     *             .describeDomainAutoTunesPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeDomainAutoTunesIterable responses = client.describeDomainAutoTunesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDomainAutoTunes(software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeDomainAutoTunes
     */
    default DescribeDomainAutoTunesIterable describeDomainAutoTunesPaginator(
            DescribeDomainAutoTunesRequest describeDomainAutoTunesRequest) throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type,
     * description, severity, and scheduled date.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDomainAutoTunes(software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeDomainAutoTunesIterable responses = client.describeDomainAutoTunesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.DescribeDomainAutoTunesIterable responses = client
     *             .describeDomainAutoTunesPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeDomainAutoTunesIterable responses = client.describeDomainAutoTunesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDomainAutoTunes(software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainAutoTunesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDomainAutoTunesRequest#builder()}
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDomainAutoTunesRequest.Builder} to create a
     *        request. Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeDomainAutoTunes
     */
    default DescribeDomainAutoTunesIterable describeDomainAutoTunesPaginator(
            Consumer<DescribeDomainAutoTunesRequest.Builder> describeDomainAutoTunesRequest) throws BaseException,
            InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return describeDomainAutoTunesPaginator(DescribeDomainAutoTunesRequest.builder()
                .applyMutation(describeDomainAutoTunesRequest).build());
    }

    /**
     * <p>
     * Returns information about the current blue/green deployment happening on a domain, including a change ID, status,
     * and progress stages.
     * </p>
     *
     * @param describeDomainChangeProgressRequest
     *        Container for the parameters to the <code>DescribeDomainChangeProgress</code> operation. Specifies the
     *        domain name and optional change specific identity for which you want progress information.
     * @return Result of the DescribeDomainChangeProgress operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeDomainChangeProgress
     */
    default DescribeDomainChangeProgressResponse describeDomainChangeProgress(
            DescribeDomainChangeProgressRequest describeDomainChangeProgressRequest) throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the current blue/green deployment happening on a domain, including a change ID, status,
     * and progress stages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainChangeProgressRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDomainChangeProgressRequest#builder()}
     * </p>
     *
     * @param describeDomainChangeProgressRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDomainChangeProgressRequest.Builder} to create
     *        a request. Container for the parameters to the <code>DescribeDomainChangeProgress</code> operation.
     *        Specifies the domain name and optional change specific identity for which you want progress information.
     * @return Result of the DescribeDomainChangeProgress operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeDomainChangeProgress
     */
    default DescribeDomainChangeProgressResponse describeDomainChangeProgress(
            Consumer<DescribeDomainChangeProgressRequest.Builder> describeDomainChangeProgressRequest) throws BaseException,
            InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return describeDomainChangeProgress(DescribeDomainChangeProgressRequest.builder()
                .applyMutation(describeDomainChangeProgressRequest).build());
    }

    /**
     * <p>
     * Returns domain configuration information about the specified Elasticsearch domain, including the domain ID,
     * domain endpoint, and domain ARN.
     * </p>
     *
     * @param describeElasticsearchDomainRequest
     *        Container for the parameters to the <code><a>DescribeElasticsearchDomain</a></code> operation.
     * @return Result of the DescribeElasticsearchDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeElasticsearchDomain
     */
    default DescribeElasticsearchDomainResponse describeElasticsearchDomain(
            DescribeElasticsearchDomainRequest describeElasticsearchDomainRequest) throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns domain configuration information about the specified Elasticsearch domain, including the domain ID,
     * domain endpoint, and domain ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeElasticsearchDomainRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeElasticsearchDomainRequest#builder()}
     * </p>
     *
     * @param describeElasticsearchDomainRequest
     *        A {@link Consumer} that will call methods on {@link DescribeElasticsearchDomainRequest.Builder} to create
     *        a request. Container for the parameters to the <code><a>DescribeElasticsearchDomain</a></code> operation.
     * @return Result of the DescribeElasticsearchDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeElasticsearchDomain
     */
    default DescribeElasticsearchDomainResponse describeElasticsearchDomain(
            Consumer<DescribeElasticsearchDomainRequest.Builder> describeElasticsearchDomainRequest) throws BaseException,
            InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return describeElasticsearchDomain(DescribeElasticsearchDomainRequest.builder()
                .applyMutation(describeElasticsearchDomainRequest).build());
    }

    /**
     * <p>
     * Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation
     * date, update version, and update date for cluster options.
     * </p>
     *
     * @param describeElasticsearchDomainConfigRequest
     *        Container for the parameters to the <code>DescribeElasticsearchDomainConfig</code> operation. Specifies
     *        the domain name for which you want configuration information.
     * @return Result of the DescribeElasticsearchDomainConfig operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeElasticsearchDomainConfig
     */
    default DescribeElasticsearchDomainConfigResponse describeElasticsearchDomainConfig(
            DescribeElasticsearchDomainConfigRequest describeElasticsearchDomainConfigRequest) throws BaseException,
            InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation
     * date, update version, and update date for cluster options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeElasticsearchDomainConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeElasticsearchDomainConfigRequest#builder()}
     * </p>
     *
     * @param describeElasticsearchDomainConfigRequest
     *        A {@link Consumer} that will call methods on {@link DescribeElasticsearchDomainConfigRequest.Builder} to
     *        create a request. Container for the parameters to the <code>DescribeElasticsearchDomainConfig</code>
     *        operation. Specifies the domain name for which you want configuration information.
     * @return Result of the DescribeElasticsearchDomainConfig operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeElasticsearchDomainConfig
     */
    default DescribeElasticsearchDomainConfigResponse describeElasticsearchDomainConfig(
            Consumer<DescribeElasticsearchDomainConfigRequest.Builder> describeElasticsearchDomainConfigRequest)
            throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        return describeElasticsearchDomainConfig(DescribeElasticsearchDomainConfigRequest.builder()
                .applyMutation(describeElasticsearchDomainConfigRequest).build());
    }

    /**
     * <p>
     * Returns domain configuration information about the specified Elasticsearch domains, including the domain ID,
     * domain endpoint, and domain ARN.
     * </p>
     *
     * @param describeElasticsearchDomainsRequest
     *        Container for the parameters to the <code><a>DescribeElasticsearchDomains</a></code> operation. By
     *        default, the API returns the status of all Elasticsearch domains.
     * @return Result of the DescribeElasticsearchDomains operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeElasticsearchDomains
     */
    default DescribeElasticsearchDomainsResponse describeElasticsearchDomains(
            DescribeElasticsearchDomainsRequest describeElasticsearchDomainsRequest) throws BaseException, InternalException,
            ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns domain configuration information about the specified Elasticsearch domains, including the domain ID,
     * domain endpoint, and domain ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeElasticsearchDomainsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeElasticsearchDomainsRequest#builder()}
     * </p>
     *
     * @param describeElasticsearchDomainsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeElasticsearchDomainsRequest.Builder} to create
     *        a request. Container for the parameters to the <code><a>DescribeElasticsearchDomains</a></code> operation.
     *        By default, the API returns the status of all Elasticsearch domains.
     * @return Result of the DescribeElasticsearchDomains operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeElasticsearchDomains
     */
    default DescribeElasticsearchDomainsResponse describeElasticsearchDomains(
            Consumer<DescribeElasticsearchDomainsRequest.Builder> describeElasticsearchDomainsRequest) throws BaseException,
            InternalException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        return describeElasticsearchDomains(DescribeElasticsearchDomainsRequest.builder()
                .applyMutation(describeElasticsearchDomainsRequest).build());
    }

    /**
     * <p>
     * Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain,
     * specify the <code> <a>DomainName</a> </code> to know what Limits are supported for modifying.
     * </p>
     *
     * @param describeElasticsearchInstanceTypeLimitsRequest
     *        Container for the parameters to <code> <a>DescribeElasticsearchInstanceTypeLimits</a> </code> operation.
     * @return Result of the DescribeElasticsearchInstanceTypeLimits operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws InvalidTypeException
     *         An exception for trying to create or access sub-resource that is either invalid or not supported. Gives
     *         http status code of 409.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeElasticsearchInstanceTypeLimits
     */
    default DescribeElasticsearchInstanceTypeLimitsResponse describeElasticsearchInstanceTypeLimits(
            DescribeElasticsearchInstanceTypeLimitsRequest describeElasticsearchInstanceTypeLimitsRequest) throws BaseException,
            InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain,
     * specify the <code> <a>DomainName</a> </code> to know what Limits are supported for modifying.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeElasticsearchInstanceTypeLimitsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeElasticsearchInstanceTypeLimitsRequest#builder()}
     * </p>
     *
     * @param describeElasticsearchInstanceTypeLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeElasticsearchInstanceTypeLimitsRequest.Builder} to create a request. Container for the
     *        parameters to <code> <a>DescribeElasticsearchInstanceTypeLimits</a> </code> operation.
     * @return Result of the DescribeElasticsearchInstanceTypeLimits operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws InvalidTypeException
     *         An exception for trying to create or access sub-resource that is either invalid or not supported. Gives
     *         http status code of 409.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeElasticsearchInstanceTypeLimits
     */
    default DescribeElasticsearchInstanceTypeLimitsResponse describeElasticsearchInstanceTypeLimits(
            Consumer<DescribeElasticsearchInstanceTypeLimitsRequest.Builder> describeElasticsearchInstanceTypeLimitsRequest)
            throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        return describeElasticsearchInstanceTypeLimits(DescribeElasticsearchInstanceTypeLimitsRequest.builder()
                .applyMutation(describeElasticsearchInstanceTypeLimitsRequest).build());
    }

    /**
     * <p>
     * Lists all the inbound cross-cluster search connections for a destination domain.
     * </p>
     *
     * @param describeInboundCrossClusterSearchConnectionsRequest
     *        Container for the parameters to the <code><a>DescribeInboundCrossClusterSearchConnections</a></code>
     *        operation.
     * @return Result of the DescribeInboundCrossClusterSearchConnections operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The request processing has failed because of invalid pagination token provided by customer. Returns an
     *         HTTP status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeInboundCrossClusterSearchConnections
     */
    default DescribeInboundCrossClusterSearchConnectionsResponse describeInboundCrossClusterSearchConnections(
            DescribeInboundCrossClusterSearchConnectionsRequest describeInboundCrossClusterSearchConnectionsRequest)
            throws InvalidPaginationTokenException, DisabledOperationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the inbound cross-cluster search connections for a destination domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeInboundCrossClusterSearchConnectionsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeInboundCrossClusterSearchConnectionsRequest#builder()}
     * </p>
     *
     * @param describeInboundCrossClusterSearchConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeInboundCrossClusterSearchConnectionsRequest.Builder} to create a request. Container for the
     *        parameters to the <code><a>DescribeInboundCrossClusterSearchConnections</a></code> operation.
     * @return Result of the DescribeInboundCrossClusterSearchConnections operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The request processing has failed because of invalid pagination token provided by customer. Returns an
     *         HTTP status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeInboundCrossClusterSearchConnections
     */
    default DescribeInboundCrossClusterSearchConnectionsResponse describeInboundCrossClusterSearchConnections(
            Consumer<DescribeInboundCrossClusterSearchConnectionsRequest.Builder> describeInboundCrossClusterSearchConnectionsRequest)
            throws InvalidPaginationTokenException, DisabledOperationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return describeInboundCrossClusterSearchConnections(DescribeInboundCrossClusterSearchConnectionsRequest.builder()
                .applyMutation(describeInboundCrossClusterSearchConnectionsRequest).build());
    }

    /**
     * <p>
     * Lists all the inbound cross-cluster search connections for a destination domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInboundCrossClusterSearchConnections(software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeInboundCrossClusterSearchConnectionsIterable responses = client.describeInboundCrossClusterSearchConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.DescribeInboundCrossClusterSearchConnectionsIterable responses = client
     *             .describeInboundCrossClusterSearchConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeInboundCrossClusterSearchConnectionsIterable responses = client.describeInboundCrossClusterSearchConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInboundCrossClusterSearchConnections(software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInboundCrossClusterSearchConnectionsRequest
     *        Container for the parameters to the <code><a>DescribeInboundCrossClusterSearchConnections</a></code>
     *        operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The request processing has failed because of invalid pagination token provided by customer. Returns an
     *         HTTP status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeInboundCrossClusterSearchConnections
     */
    default DescribeInboundCrossClusterSearchConnectionsIterable describeInboundCrossClusterSearchConnectionsPaginator(
            DescribeInboundCrossClusterSearchConnectionsRequest describeInboundCrossClusterSearchConnectionsRequest)
            throws InvalidPaginationTokenException, DisabledOperationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the inbound cross-cluster search connections for a destination domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInboundCrossClusterSearchConnections(software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeInboundCrossClusterSearchConnectionsIterable responses = client.describeInboundCrossClusterSearchConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.DescribeInboundCrossClusterSearchConnectionsIterable responses = client
     *             .describeInboundCrossClusterSearchConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeInboundCrossClusterSearchConnectionsIterable responses = client.describeInboundCrossClusterSearchConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInboundCrossClusterSearchConnections(software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeInboundCrossClusterSearchConnectionsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeInboundCrossClusterSearchConnectionsRequest#builder()}
     * </p>
     *
     * @param describeInboundCrossClusterSearchConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeInboundCrossClusterSearchConnectionsRequest.Builder} to create a request. Container for the
     *        parameters to the <code><a>DescribeInboundCrossClusterSearchConnections</a></code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The request processing has failed because of invalid pagination token provided by customer. Returns an
     *         HTTP status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeInboundCrossClusterSearchConnections
     */
    default DescribeInboundCrossClusterSearchConnectionsIterable describeInboundCrossClusterSearchConnectionsPaginator(
            Consumer<DescribeInboundCrossClusterSearchConnectionsRequest.Builder> describeInboundCrossClusterSearchConnectionsRequest)
            throws InvalidPaginationTokenException, DisabledOperationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return describeInboundCrossClusterSearchConnectionsPaginator(DescribeInboundCrossClusterSearchConnectionsRequest
                .builder().applyMutation(describeInboundCrossClusterSearchConnectionsRequest).build());
    }

    /**
     * <p>
     * Lists all the outbound cross-cluster search connections for a source domain.
     * </p>
     *
     * @param describeOutboundCrossClusterSearchConnectionsRequest
     *        Container for the parameters to the <code><a>DescribeOutboundCrossClusterSearchConnections</a></code>
     *        operation.
     * @return Result of the DescribeOutboundCrossClusterSearchConnections operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The request processing has failed because of invalid pagination token provided by customer. Returns an
     *         HTTP status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeOutboundCrossClusterSearchConnections
     */
    default DescribeOutboundCrossClusterSearchConnectionsResponse describeOutboundCrossClusterSearchConnections(
            DescribeOutboundCrossClusterSearchConnectionsRequest describeOutboundCrossClusterSearchConnectionsRequest)
            throws InvalidPaginationTokenException, DisabledOperationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the outbound cross-cluster search connections for a source domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOutboundCrossClusterSearchConnectionsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOutboundCrossClusterSearchConnectionsRequest#builder()}
     * </p>
     *
     * @param describeOutboundCrossClusterSearchConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeOutboundCrossClusterSearchConnectionsRequest.Builder} to create a request. Container for
     *        the parameters to the <code><a>DescribeOutboundCrossClusterSearchConnections</a></code> operation.
     * @return Result of the DescribeOutboundCrossClusterSearchConnections operation returned by the service.
     * @throws InvalidPaginationTokenException
     *         The request processing has failed because of invalid pagination token provided by customer. Returns an
     *         HTTP status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeOutboundCrossClusterSearchConnections
     */
    default DescribeOutboundCrossClusterSearchConnectionsResponse describeOutboundCrossClusterSearchConnections(
            Consumer<DescribeOutboundCrossClusterSearchConnectionsRequest.Builder> describeOutboundCrossClusterSearchConnectionsRequest)
            throws InvalidPaginationTokenException, DisabledOperationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return describeOutboundCrossClusterSearchConnections(DescribeOutboundCrossClusterSearchConnectionsRequest.builder()
                .applyMutation(describeOutboundCrossClusterSearchConnectionsRequest).build());
    }

    /**
     * <p>
     * Lists all the outbound cross-cluster search connections for a source domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOutboundCrossClusterSearchConnections(software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeOutboundCrossClusterSearchConnectionsIterable responses = client.describeOutboundCrossClusterSearchConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.DescribeOutboundCrossClusterSearchConnectionsIterable responses = client
     *             .describeOutboundCrossClusterSearchConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeOutboundCrossClusterSearchConnectionsIterable responses = client.describeOutboundCrossClusterSearchConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOutboundCrossClusterSearchConnections(software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOutboundCrossClusterSearchConnectionsRequest
     *        Container for the parameters to the <code><a>DescribeOutboundCrossClusterSearchConnections</a></code>
     *        operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The request processing has failed because of invalid pagination token provided by customer. Returns an
     *         HTTP status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeOutboundCrossClusterSearchConnections
     */
    default DescribeOutboundCrossClusterSearchConnectionsIterable describeOutboundCrossClusterSearchConnectionsPaginator(
            DescribeOutboundCrossClusterSearchConnectionsRequest describeOutboundCrossClusterSearchConnectionsRequest)
            throws InvalidPaginationTokenException, DisabledOperationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the outbound cross-cluster search connections for a source domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOutboundCrossClusterSearchConnections(software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeOutboundCrossClusterSearchConnectionsIterable responses = client.describeOutboundCrossClusterSearchConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.DescribeOutboundCrossClusterSearchConnectionsIterable responses = client
     *             .describeOutboundCrossClusterSearchConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeOutboundCrossClusterSearchConnectionsIterable responses = client.describeOutboundCrossClusterSearchConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOutboundCrossClusterSearchConnections(software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOutboundCrossClusterSearchConnectionsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOutboundCrossClusterSearchConnectionsRequest#builder()}
     * </p>
     *
     * @param describeOutboundCrossClusterSearchConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeOutboundCrossClusterSearchConnectionsRequest.Builder} to create a request. Container for
     *        the parameters to the <code><a>DescribeOutboundCrossClusterSearchConnections</a></code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPaginationTokenException
     *         The request processing has failed because of invalid pagination token provided by customer. Returns an
     *         HTTP status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeOutboundCrossClusterSearchConnections
     */
    default DescribeOutboundCrossClusterSearchConnectionsIterable describeOutboundCrossClusterSearchConnectionsPaginator(
            Consumer<DescribeOutboundCrossClusterSearchConnectionsRequest.Builder> describeOutboundCrossClusterSearchConnectionsRequest)
            throws InvalidPaginationTokenException, DisabledOperationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return describeOutboundCrossClusterSearchConnectionsPaginator(DescribeOutboundCrossClusterSearchConnectionsRequest
                .builder().applyMutation(describeOutboundCrossClusterSearchConnectionsRequest).build());
    }

    /**
     * <p>
     * Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results,
     * and pagination.
     * </p>
     *
     * @param describePackagesRequest
     *        Container for request parameters to <code> <a>DescribePackage</a> </code> operation.
     * @return Result of the DescribePackages operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribePackages
     */
    default DescribePackagesResponse describePackages(DescribePackagesRequest describePackagesRequest) throws BaseException,
            InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results,
     * and pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackagesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePackagesRequest#builder()}
     * </p>
     *
     * @param describePackagesRequest
     *        A {@link Consumer} that will call methods on {@link DescribePackagesRequest.Builder} to create a request.
     *        Container for request parameters to <code> <a>DescribePackage</a> </code> operation.
     * @return Result of the DescribePackages operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribePackages
     */
    default DescribePackagesResponse describePackages(Consumer<DescribePackagesRequest.Builder> describePackagesRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        return describePackages(DescribePackagesRequest.builder().applyMutation(describePackagesRequest).build());
    }

    /**
     * <p>
     * Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results,
     * and pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePackages(software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribePackagesIterable responses = client.describePackagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.DescribePackagesIterable responses = client
     *             .describePackagesPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribePackagesIterable responses = client.describePackagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePackages(software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePackagesRequest
     *        Container for request parameters to <code> <a>DescribePackage</a> </code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribePackages
     */
    default DescribePackagesIterable describePackagesPaginator(DescribePackagesRequest describePackagesRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results,
     * and pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePackages(software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribePackagesIterable responses = client.describePackagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.DescribePackagesIterable responses = client
     *             .describePackagesPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribePackagesIterable responses = client.describePackagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePackages(software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePackagesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePackagesRequest#builder()}
     * </p>
     *
     * @param describePackagesRequest
     *        A {@link Consumer} that will call methods on {@link DescribePackagesRequest.Builder} to create a request.
     *        Container for request parameters to <code> <a>DescribePackage</a> </code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribePackages
     */
    default DescribePackagesIterable describePackagesPaginator(Consumer<DescribePackagesRequest.Builder> describePackagesRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        return describePackagesPaginator(DescribePackagesRequest.builder().applyMutation(describePackagesRequest).build());
    }

    /**
     * <p>
     * Lists available reserved Elasticsearch instance offerings.
     * </p>
     *
     * @return Result of the DescribeReservedElasticsearchInstanceOfferings operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeReservedElasticsearchInstanceOfferings
     * @see #describeReservedElasticsearchInstanceOfferings(DescribeReservedElasticsearchInstanceOfferingsRequest)
     */
    default DescribeReservedElasticsearchInstanceOfferingsResponse describeReservedElasticsearchInstanceOfferings()
            throws ResourceNotFoundException, ValidationException, DisabledOperationException, InternalException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        return describeReservedElasticsearchInstanceOfferings(DescribeReservedElasticsearchInstanceOfferingsRequest.builder()
                .build());
    }

    /**
     * <p>
     * Lists available reserved Elasticsearch instance offerings.
     * </p>
     *
     * @param describeReservedElasticsearchInstanceOfferingsRequest
     *        Container for parameters to <code>DescribeReservedElasticsearchInstanceOfferings</code>
     * @return Result of the DescribeReservedElasticsearchInstanceOfferings operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeReservedElasticsearchInstanceOfferings
     */
    default DescribeReservedElasticsearchInstanceOfferingsResponse describeReservedElasticsearchInstanceOfferings(
            DescribeReservedElasticsearchInstanceOfferingsRequest describeReservedElasticsearchInstanceOfferingsRequest)
            throws ResourceNotFoundException, ValidationException, DisabledOperationException, InternalException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available reserved Elasticsearch instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReservedElasticsearchInstanceOfferingsRequest.Builder} avoiding the need to create one manually
     * via {@link DescribeReservedElasticsearchInstanceOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedElasticsearchInstanceOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReservedElasticsearchInstanceOfferingsRequest.Builder} to create a request. Container for
     *        parameters to <code>DescribeReservedElasticsearchInstanceOfferings</code>
     * @return Result of the DescribeReservedElasticsearchInstanceOfferings operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeReservedElasticsearchInstanceOfferings
     */
    default DescribeReservedElasticsearchInstanceOfferingsResponse describeReservedElasticsearchInstanceOfferings(
            Consumer<DescribeReservedElasticsearchInstanceOfferingsRequest.Builder> describeReservedElasticsearchInstanceOfferingsRequest)
            throws ResourceNotFoundException, ValidationException, DisabledOperationException, InternalException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        return describeReservedElasticsearchInstanceOfferings(DescribeReservedElasticsearchInstanceOfferingsRequest.builder()
                .applyMutation(describeReservedElasticsearchInstanceOfferingsRequest).build());
    }

    /**
     * <p>
     * Lists available reserved Elasticsearch instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedElasticsearchInstanceOfferings(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsIterable responses = client.describeReservedElasticsearchInstanceOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsIterable responses = client
     *             .describeReservedElasticsearchInstanceOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsIterable responses = client.describeReservedElasticsearchInstanceOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedElasticsearchInstanceOfferings(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeReservedElasticsearchInstanceOfferings
     * @see #describeReservedElasticsearchInstanceOfferingsPaginator(DescribeReservedElasticsearchInstanceOfferingsRequest)
     */
    default DescribeReservedElasticsearchInstanceOfferingsIterable describeReservedElasticsearchInstanceOfferingsPaginator()
            throws ResourceNotFoundException, ValidationException, DisabledOperationException, InternalException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        return describeReservedElasticsearchInstanceOfferingsPaginator(DescribeReservedElasticsearchInstanceOfferingsRequest
                .builder().build());
    }

    /**
     * <p>
     * Lists available reserved Elasticsearch instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedElasticsearchInstanceOfferings(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsIterable responses = client.describeReservedElasticsearchInstanceOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsIterable responses = client
     *             .describeReservedElasticsearchInstanceOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsIterable responses = client.describeReservedElasticsearchInstanceOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedElasticsearchInstanceOfferings(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedElasticsearchInstanceOfferingsRequest
     *        Container for parameters to <code>DescribeReservedElasticsearchInstanceOfferings</code>
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeReservedElasticsearchInstanceOfferings
     */
    default DescribeReservedElasticsearchInstanceOfferingsIterable describeReservedElasticsearchInstanceOfferingsPaginator(
            DescribeReservedElasticsearchInstanceOfferingsRequest describeReservedElasticsearchInstanceOfferingsRequest)
            throws ResourceNotFoundException, ValidationException, DisabledOperationException, InternalException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available reserved Elasticsearch instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedElasticsearchInstanceOfferings(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsIterable responses = client.describeReservedElasticsearchInstanceOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsIterable responses = client
     *             .describeReservedElasticsearchInstanceOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsIterable responses = client.describeReservedElasticsearchInstanceOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedElasticsearchInstanceOfferings(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReservedElasticsearchInstanceOfferingsRequest.Builder} avoiding the need to create one manually
     * via {@link DescribeReservedElasticsearchInstanceOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedElasticsearchInstanceOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReservedElasticsearchInstanceOfferingsRequest.Builder} to create a request. Container for
     *        parameters to <code>DescribeReservedElasticsearchInstanceOfferings</code>
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeReservedElasticsearchInstanceOfferings
     */
    default DescribeReservedElasticsearchInstanceOfferingsIterable describeReservedElasticsearchInstanceOfferingsPaginator(
            Consumer<DescribeReservedElasticsearchInstanceOfferingsRequest.Builder> describeReservedElasticsearchInstanceOfferingsRequest)
            throws ResourceNotFoundException, ValidationException, DisabledOperationException, InternalException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        return describeReservedElasticsearchInstanceOfferingsPaginator(DescribeReservedElasticsearchInstanceOfferingsRequest
                .builder().applyMutation(describeReservedElasticsearchInstanceOfferingsRequest).build());
    }

    /**
     * <p>
     * Returns information about reserved Elasticsearch instances for this account.
     * </p>
     *
     * @return Result of the DescribeReservedElasticsearchInstances operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeReservedElasticsearchInstances
     * @see #describeReservedElasticsearchInstances(DescribeReservedElasticsearchInstancesRequest)
     */
    default DescribeReservedElasticsearchInstancesResponse describeReservedElasticsearchInstances()
            throws ResourceNotFoundException, InternalException, ValidationException, DisabledOperationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        return describeReservedElasticsearchInstances(DescribeReservedElasticsearchInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about reserved Elasticsearch instances for this account.
     * </p>
     *
     * @param describeReservedElasticsearchInstancesRequest
     *        Container for parameters to <code>DescribeReservedElasticsearchInstances</code>
     * @return Result of the DescribeReservedElasticsearchInstances operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeReservedElasticsearchInstances
     */
    default DescribeReservedElasticsearchInstancesResponse describeReservedElasticsearchInstances(
            DescribeReservedElasticsearchInstancesRequest describeReservedElasticsearchInstancesRequest)
            throws ResourceNotFoundException, InternalException, ValidationException, DisabledOperationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about reserved Elasticsearch instances for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReservedElasticsearchInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReservedElasticsearchInstancesRequest#builder()}
     * </p>
     *
     * @param describeReservedElasticsearchInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedElasticsearchInstancesRequest.Builder}
     *        to create a request. Container for parameters to <code>DescribeReservedElasticsearchInstances</code>
     * @return Result of the DescribeReservedElasticsearchInstances operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeReservedElasticsearchInstances
     */
    default DescribeReservedElasticsearchInstancesResponse describeReservedElasticsearchInstances(
            Consumer<DescribeReservedElasticsearchInstancesRequest.Builder> describeReservedElasticsearchInstancesRequest)
            throws ResourceNotFoundException, InternalException, ValidationException, DisabledOperationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        return describeReservedElasticsearchInstances(DescribeReservedElasticsearchInstancesRequest.builder()
                .applyMutation(describeReservedElasticsearchInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about reserved Elasticsearch instances for this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedElasticsearchInstances(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesIterable responses = client.describeReservedElasticsearchInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesIterable responses = client
     *             .describeReservedElasticsearchInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesIterable responses = client.describeReservedElasticsearchInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedElasticsearchInstances(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeReservedElasticsearchInstances
     * @see #describeReservedElasticsearchInstancesPaginator(DescribeReservedElasticsearchInstancesRequest)
     */
    default DescribeReservedElasticsearchInstancesIterable describeReservedElasticsearchInstancesPaginator()
            throws ResourceNotFoundException, InternalException, ValidationException, DisabledOperationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        return describeReservedElasticsearchInstancesPaginator(DescribeReservedElasticsearchInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about reserved Elasticsearch instances for this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedElasticsearchInstances(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesIterable responses = client.describeReservedElasticsearchInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesIterable responses = client
     *             .describeReservedElasticsearchInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesIterable responses = client.describeReservedElasticsearchInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedElasticsearchInstances(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedElasticsearchInstancesRequest
     *        Container for parameters to <code>DescribeReservedElasticsearchInstances</code>
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeReservedElasticsearchInstances
     */
    default DescribeReservedElasticsearchInstancesIterable describeReservedElasticsearchInstancesPaginator(
            DescribeReservedElasticsearchInstancesRequest describeReservedElasticsearchInstancesRequest)
            throws ResourceNotFoundException, InternalException, ValidationException, DisabledOperationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about reserved Elasticsearch instances for this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedElasticsearchInstances(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesIterable responses = client.describeReservedElasticsearchInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesIterable responses = client
     *             .describeReservedElasticsearchInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesIterable responses = client.describeReservedElasticsearchInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedElasticsearchInstances(software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReservedElasticsearchInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReservedElasticsearchInstancesRequest#builder()}
     * </p>
     *
     * @param describeReservedElasticsearchInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedElasticsearchInstancesRequest.Builder}
     *        to create a request. Container for parameters to <code>DescribeReservedElasticsearchInstances</code>
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeReservedElasticsearchInstances
     */
    default DescribeReservedElasticsearchInstancesIterable describeReservedElasticsearchInstancesPaginator(
            Consumer<DescribeReservedElasticsearchInstancesRequest.Builder> describeReservedElasticsearchInstancesRequest)
            throws ResourceNotFoundException, InternalException, ValidationException, DisabledOperationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        return describeReservedElasticsearchInstancesPaginator(DescribeReservedElasticsearchInstancesRequest.builder()
                .applyMutation(describeReservedElasticsearchInstancesRequest).build());
    }

    /**
     * <p>
     * Describes one or more Amazon OpenSearch Service-managed VPC endpoints.
     * </p>
     *
     * @param describeVpcEndpointsRequest
     *        Container for request parameters to the <code><a>DescribeVpcEndpoints</a></code> operation. Specifies the
     *        list of VPC endpoints to be described.
     * @return Result of the DescribeVpcEndpoints operation returned by the service.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeVpcEndpoints
     */
    default DescribeVpcEndpointsResponse describeVpcEndpoints(DescribeVpcEndpointsRequest describeVpcEndpointsRequest)
            throws ValidationException, InternalException, DisabledOperationException, BaseException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more Amazon OpenSearch Service-managed VPC endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVpcEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVpcEndpointsRequest#builder()}
     * </p>
     *
     * @param describeVpcEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeVpcEndpointsRequest.Builder} to create a
     *        request. Container for request parameters to the <code><a>DescribeVpcEndpoints</a></code> operation.
     *        Specifies the list of VPC endpoints to be described.
     * @return Result of the DescribeVpcEndpoints operation returned by the service.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DescribeVpcEndpoints
     */
    default DescribeVpcEndpointsResponse describeVpcEndpoints(
            Consumer<DescribeVpcEndpointsRequest.Builder> describeVpcEndpointsRequest) throws ValidationException,
            InternalException, DisabledOperationException, BaseException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return describeVpcEndpoints(DescribeVpcEndpointsRequest.builder().applyMutation(describeVpcEndpointsRequest).build());
    }

    /**
     * <p>
     * Dissociates a package from the Amazon ES domain.
     * </p>
     *
     * @param dissociatePackageRequest
     *        Container for request parameters to <code> <a>DissociatePackage</a> </code> operation.
     * @return Result of the DissociatePackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP
     *         status code 409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DissociatePackage
     */
    default DissociatePackageResponse dissociatePackage(DissociatePackageRequest dissociatePackageRequest) throws BaseException,
            InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Dissociates a package from the Amazon ES domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DissociatePackageRequest.Builder} avoiding the need
     * to create one manually via {@link DissociatePackageRequest#builder()}
     * </p>
     *
     * @param dissociatePackageRequest
     *        A {@link Consumer} that will call methods on {@link DissociatePackageRequest.Builder} to create a request.
     *        Container for request parameters to <code> <a>DissociatePackage</a> </code> operation.
     * @return Result of the DissociatePackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP
     *         status code 409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.DissociatePackage
     */
    default DissociatePackageResponse dissociatePackage(Consumer<DissociatePackageRequest.Builder> dissociatePackageRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            ConflictException, AwsServiceException, SdkClientException, ElasticsearchException {
        return dissociatePackage(DissociatePackageRequest.builder().applyMutation(dissociatePackageRequest).build());
    }

    /**
     * <p>
     * Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a
     * <code> <a>DomainName</a> </code> to get all upgrade compatible Elasticsearch versions for that specific domain.
     * </p>
     *
     * @return Result of the GetCompatibleElasticsearchVersions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.GetCompatibleElasticsearchVersions
     * @see #getCompatibleElasticsearchVersions(GetCompatibleElasticsearchVersionsRequest)
     */
    default GetCompatibleElasticsearchVersionsResponse getCompatibleElasticsearchVersions() throws BaseException,
            ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        return getCompatibleElasticsearchVersions(GetCompatibleElasticsearchVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a
     * <code> <a>DomainName</a> </code> to get all upgrade compatible Elasticsearch versions for that specific domain.
     * </p>
     *
     * @param getCompatibleElasticsearchVersionsRequest
     *        Container for request parameters to <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation.
     * @return Result of the GetCompatibleElasticsearchVersions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.GetCompatibleElasticsearchVersions
     */
    default GetCompatibleElasticsearchVersionsResponse getCompatibleElasticsearchVersions(
            GetCompatibleElasticsearchVersionsRequest getCompatibleElasticsearchVersionsRequest) throws BaseException,
            ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a
     * <code> <a>DomainName</a> </code> to get all upgrade compatible Elasticsearch versions for that specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCompatibleElasticsearchVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link GetCompatibleElasticsearchVersionsRequest#builder()}
     * </p>
     *
     * @param getCompatibleElasticsearchVersionsRequest
     *        A {@link Consumer} that will call methods on {@link GetCompatibleElasticsearchVersionsRequest.Builder} to
     *        create a request. Container for request parameters to
     *        <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation.
     * @return Result of the GetCompatibleElasticsearchVersions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.GetCompatibleElasticsearchVersions
     */
    default GetCompatibleElasticsearchVersionsResponse getCompatibleElasticsearchVersions(
            Consumer<GetCompatibleElasticsearchVersionsRequest.Builder> getCompatibleElasticsearchVersionsRequest)
            throws BaseException, ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        return getCompatibleElasticsearchVersions(GetCompatibleElasticsearchVersionsRequest.builder()
                .applyMutation(getCompatibleElasticsearchVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of versions of the package, along with their creation time and commit message.
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        Container for request parameters to <code> <a>GetPackageVersionHistory</a> </code> operation.
     * @return Result of the GetPackageVersionHistory operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.GetPackageVersionHistory
     */
    default GetPackageVersionHistoryResponse getPackageVersionHistory(
            GetPackageVersionHistoryRequest getPackageVersionHistoryRequest) throws BaseException, InternalException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of versions of the package, along with their creation time and commit message.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPackageVersionHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetPackageVersionHistoryRequest#builder()}
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetPackageVersionHistoryRequest.Builder} to create a
     *        request. Container for request parameters to <code> <a>GetPackageVersionHistory</a> </code> operation.
     * @return Result of the GetPackageVersionHistory operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.GetPackageVersionHistory
     */
    default GetPackageVersionHistoryResponse getPackageVersionHistory(
            Consumer<GetPackageVersionHistoryRequest.Builder> getPackageVersionHistoryRequest) throws BaseException,
            InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        return getPackageVersionHistory(GetPackageVersionHistoryRequest.builder().applyMutation(getPackageVersionHistoryRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of versions of the package, along with their creation time and commit message.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getPackageVersionHistory(software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetPackageVersionHistoryIterable responses = client.getPackageVersionHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.GetPackageVersionHistoryIterable responses = client
     *             .getPackageVersionHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetPackageVersionHistoryIterable responses = client.getPackageVersionHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPackageVersionHistory(software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        Container for request parameters to <code> <a>GetPackageVersionHistory</a> </code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.GetPackageVersionHistory
     */
    default GetPackageVersionHistoryIterable getPackageVersionHistoryPaginator(
            GetPackageVersionHistoryRequest getPackageVersionHistoryRequest) throws BaseException, InternalException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of versions of the package, along with their creation time and commit message.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getPackageVersionHistory(software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetPackageVersionHistoryIterable responses = client.getPackageVersionHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.GetPackageVersionHistoryIterable responses = client
     *             .getPackageVersionHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetPackageVersionHistoryIterable responses = client.getPackageVersionHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPackageVersionHistory(software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPackageVersionHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetPackageVersionHistoryRequest#builder()}
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetPackageVersionHistoryRequest.Builder} to create a
     *        request. Container for request parameters to <code> <a>GetPackageVersionHistory</a> </code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.GetPackageVersionHistory
     */
    default GetPackageVersionHistoryIterable getPackageVersionHistoryPaginator(
            Consumer<GetPackageVersionHistoryRequest.Builder> getPackageVersionHistoryRequest) throws BaseException,
            InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        return getPackageVersionHistoryPaginator(GetPackageVersionHistoryRequest.builder()
                .applyMutation(getPackageVersionHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        Container for request parameters to <code> <a>GetUpgradeHistory</a> </code> operation.
     * @return Result of the GetUpgradeHistory operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.GetUpgradeHistory
     */
    default GetUpgradeHistoryResponse getUpgradeHistory(GetUpgradeHistoryRequest getUpgradeHistoryRequest) throws BaseException,
            ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUpgradeHistoryRequest.Builder} avoiding the need
     * to create one manually via {@link GetUpgradeHistoryRequest#builder()}
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetUpgradeHistoryRequest.Builder} to create a request.
     *        Container for request parameters to <code> <a>GetUpgradeHistory</a> </code> operation.
     * @return Result of the GetUpgradeHistory operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.GetUpgradeHistory
     */
    default GetUpgradeHistoryResponse getUpgradeHistory(Consumer<GetUpgradeHistoryRequest.Builder> getUpgradeHistoryRequest)
            throws BaseException, ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        return getUpgradeHistory(GetUpgradeHistoryRequest.builder().applyMutation(getUpgradeHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryIterable responses = client.getUpgradeHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryIterable responses = client
     *             .getUpgradeHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryIterable responses = client.getUpgradeHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        Container for request parameters to <code> <a>GetUpgradeHistory</a> </code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.GetUpgradeHistory
     */
    default GetUpgradeHistoryIterable getUpgradeHistoryPaginator(GetUpgradeHistoryRequest getUpgradeHistoryRequest)
            throws BaseException, ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryIterable responses = client.getUpgradeHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryIterable responses = client
     *             .getUpgradeHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryIterable responses = client.getUpgradeHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUpgradeHistory(software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUpgradeHistoryRequest.Builder} avoiding the need
     * to create one manually via {@link GetUpgradeHistoryRequest#builder()}
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetUpgradeHistoryRequest.Builder} to create a request.
     *        Container for request parameters to <code> <a>GetUpgradeHistory</a> </code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.GetUpgradeHistory
     */
    default GetUpgradeHistoryIterable getUpgradeHistoryPaginator(
            Consumer<GetUpgradeHistoryRequest.Builder> getUpgradeHistoryRequest) throws BaseException, ResourceNotFoundException,
            DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return getUpgradeHistoryPaginator(GetUpgradeHistoryRequest.builder().applyMutation(getUpgradeHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.
     * </p>
     *
     * @param getUpgradeStatusRequest
     *        Container for request parameters to <code> <a>GetUpgradeStatus</a> </code> operation.
     * @return Result of the GetUpgradeStatus operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.GetUpgradeStatus
     */
    default GetUpgradeStatusResponse getUpgradeStatus(GetUpgradeStatusRequest getUpgradeStatusRequest) throws BaseException,
            ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUpgradeStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetUpgradeStatusRequest#builder()}
     * </p>
     *
     * @param getUpgradeStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetUpgradeStatusRequest.Builder} to create a request.
     *        Container for request parameters to <code> <a>GetUpgradeStatus</a> </code> operation.
     * @return Result of the GetUpgradeStatus operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.GetUpgradeStatus
     */
    default GetUpgradeStatusResponse getUpgradeStatus(Consumer<GetUpgradeStatusRequest.Builder> getUpgradeStatusRequest)
            throws BaseException, ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        return getUpgradeStatus(GetUpgradeStatusRequest.builder().applyMutation(getUpgradeStatusRequest).build());
    }

    /**
     * <p>
     * Returns the name of all Elasticsearch domains owned by the current user's account.
     * </p>
     *
     * @return Result of the ListDomainNames operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListDomainNames
     * @see #listDomainNames(ListDomainNamesRequest)
     */
    default ListDomainNamesResponse listDomainNames() throws BaseException, ValidationException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        return listDomainNames(ListDomainNamesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the name of all Elasticsearch domains owned by the current user's account.
     * </p>
     *
     * @param listDomainNamesRequest
     *        Container for the parameters to the <code><a>ListDomainNames</a></code> operation.
     * @return Result of the ListDomainNames operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListDomainNames
     */
    default ListDomainNamesResponse listDomainNames(ListDomainNamesRequest listDomainNamesRequest) throws BaseException,
            ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the name of all Elasticsearch domains owned by the current user's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainNamesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDomainNamesRequest#builder()}
     * </p>
     *
     * @param listDomainNamesRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainNamesRequest.Builder} to create a request.
     *        Container for the parameters to the <code><a>ListDomainNames</a></code> operation.
     * @return Result of the ListDomainNames operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListDomainNames
     */
    default ListDomainNamesResponse listDomainNames(Consumer<ListDomainNamesRequest.Builder> listDomainNamesRequest)
            throws BaseException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        return listDomainNames(ListDomainNamesRequest.builder().applyMutation(listDomainNamesRequest).build());
    }

    /**
     * <p>
     * Lists all Amazon ES domains associated with the package.
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        Container for request parameters to <code> <a>ListDomainsForPackage</a> </code> operation.
     * @return Result of the ListDomainsForPackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListDomainsForPackage
     */
    default ListDomainsForPackageResponse listDomainsForPackage(ListDomainsForPackageRequest listDomainsForPackageRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Amazon ES domains associated with the package.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsForPackageRequest.Builder} avoiding the
     * need to create one manually via {@link ListDomainsForPackageRequest#builder()}
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainsForPackageRequest.Builder} to create a
     *        request. Container for request parameters to <code> <a>ListDomainsForPackage</a> </code> operation.
     * @return Result of the ListDomainsForPackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListDomainsForPackage
     */
    default ListDomainsForPackageResponse listDomainsForPackage(
            Consumer<ListDomainsForPackageRequest.Builder> listDomainsForPackageRequest) throws BaseException, InternalException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return listDomainsForPackage(ListDomainsForPackageRequest.builder().applyMutation(listDomainsForPackageRequest).build());
    }

    /**
     * <p>
     * Lists all Amazon ES domains associated with the package.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDomainsForPackage(software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListDomainsForPackageIterable responses = client.listDomainsForPackagePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.ListDomainsForPackageIterable responses = client
     *             .listDomainsForPackagePaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListDomainsForPackageIterable responses = client.listDomainsForPackagePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainsForPackage(software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        Container for request parameters to <code> <a>ListDomainsForPackage</a> </code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListDomainsForPackage
     */
    default ListDomainsForPackageIterable listDomainsForPackagePaginator(ListDomainsForPackageRequest listDomainsForPackageRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Amazon ES domains associated with the package.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDomainsForPackage(software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListDomainsForPackageIterable responses = client.listDomainsForPackagePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.ListDomainsForPackageIterable responses = client
     *             .listDomainsForPackagePaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListDomainsForPackageIterable responses = client.listDomainsForPackagePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainsForPackage(software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsForPackageRequest.Builder} avoiding the
     * need to create one manually via {@link ListDomainsForPackageRequest#builder()}
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainsForPackageRequest.Builder} to create a
     *        request. Container for request parameters to <code> <a>ListDomainsForPackage</a> </code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListDomainsForPackage
     */
    default ListDomainsForPackageIterable listDomainsForPackagePaginator(
            Consumer<ListDomainsForPackageRequest.Builder> listDomainsForPackageRequest) throws BaseException, InternalException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return listDomainsForPackagePaginator(ListDomainsForPackageRequest.builder().applyMutation(listDomainsForPackageRequest)
                .build());
    }

    /**
     * <p>
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     * </p>
     *
     * @param listElasticsearchInstanceTypesRequest
     *        Container for the parameters to the <code> <a>ListElasticsearchInstanceTypes</a> </code> operation.
     * @return Result of the ListElasticsearchInstanceTypes operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListElasticsearchInstanceTypes
     */
    default ListElasticsearchInstanceTypesResponse listElasticsearchInstanceTypes(
            ListElasticsearchInstanceTypesRequest listElasticsearchInstanceTypesRequest) throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListElasticsearchInstanceTypesRequest.Builder}
     * avoiding the need to create one manually via {@link ListElasticsearchInstanceTypesRequest#builder()}
     * </p>
     *
     * @param listElasticsearchInstanceTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListElasticsearchInstanceTypesRequest.Builder} to
     *        create a request. Container for the parameters to the <code> <a>ListElasticsearchInstanceTypes</a> </code>
     *        operation.
     * @return Result of the ListElasticsearchInstanceTypes operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListElasticsearchInstanceTypes
     */
    default ListElasticsearchInstanceTypesResponse listElasticsearchInstanceTypes(
            Consumer<ListElasticsearchInstanceTypesRequest.Builder> listElasticsearchInstanceTypesRequest) throws BaseException,
            InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return listElasticsearchInstanceTypes(ListElasticsearchInstanceTypesRequest.builder()
                .applyMutation(listElasticsearchInstanceTypesRequest).build());
    }

    /**
     * <p>
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listElasticsearchInstanceTypes(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesIterable responses = client.listElasticsearchInstanceTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesIterable responses = client
     *             .listElasticsearchInstanceTypesPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesIterable responses = client.listElasticsearchInstanceTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listElasticsearchInstanceTypes(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listElasticsearchInstanceTypesRequest
     *        Container for the parameters to the <code> <a>ListElasticsearchInstanceTypes</a> </code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListElasticsearchInstanceTypes
     */
    default ListElasticsearchInstanceTypesIterable listElasticsearchInstanceTypesPaginator(
            ListElasticsearchInstanceTypesRequest listElasticsearchInstanceTypesRequest) throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listElasticsearchInstanceTypes(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesIterable responses = client.listElasticsearchInstanceTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesIterable responses = client
     *             .listElasticsearchInstanceTypesPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesIterable responses = client.listElasticsearchInstanceTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listElasticsearchInstanceTypes(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListElasticsearchInstanceTypesRequest.Builder}
     * avoiding the need to create one manually via {@link ListElasticsearchInstanceTypesRequest#builder()}
     * </p>
     *
     * @param listElasticsearchInstanceTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListElasticsearchInstanceTypesRequest.Builder} to
     *        create a request. Container for the parameters to the <code> <a>ListElasticsearchInstanceTypes</a> </code>
     *        operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListElasticsearchInstanceTypes
     */
    default ListElasticsearchInstanceTypesIterable listElasticsearchInstanceTypesPaginator(
            Consumer<ListElasticsearchInstanceTypesRequest.Builder> listElasticsearchInstanceTypesRequest) throws BaseException,
            InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return listElasticsearchInstanceTypesPaginator(ListElasticsearchInstanceTypesRequest.builder()
                .applyMutation(listElasticsearchInstanceTypesRequest).build());
    }

    /**
     * <p>
     * List all supported Elasticsearch versions
     * </p>
     *
     * @return Result of the ListElasticsearchVersions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListElasticsearchVersions
     * @see #listElasticsearchVersions(ListElasticsearchVersionsRequest)
     */
    default ListElasticsearchVersionsResponse listElasticsearchVersions() throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        return listElasticsearchVersions(ListElasticsearchVersionsRequest.builder().build());
    }

    /**
     * <p>
     * List all supported Elasticsearch versions
     * </p>
     *
     * @param listElasticsearchVersionsRequest
     *        Container for the parameters to the <code> <a>ListElasticsearchVersions</a> </code> operation.
     *        <p>
     *        Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single
     *        call.
     *        </p>
     *        <p>
     *        Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does
     *        not contain a NextToken, then there are no more results to retrieve.
     *        </p>
     * @return Result of the ListElasticsearchVersions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListElasticsearchVersions
     */
    default ListElasticsearchVersionsResponse listElasticsearchVersions(
            ListElasticsearchVersionsRequest listElasticsearchVersionsRequest) throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all supported Elasticsearch versions
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListElasticsearchVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListElasticsearchVersionsRequest#builder()}
     * </p>
     *
     * @param listElasticsearchVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListElasticsearchVersionsRequest.Builder} to create a
     *        request. Container for the parameters to the <code> <a>ListElasticsearchVersions</a> </code> operation.
     *        <p>
     *        Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single
     *        call.
     *        </p>
     *        <p>
     *        Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does
     *        not contain a NextToken, then there are no more results to retrieve.
     *        </p>
     * @return Result of the ListElasticsearchVersions operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListElasticsearchVersions
     */
    default ListElasticsearchVersionsResponse listElasticsearchVersions(
            Consumer<ListElasticsearchVersionsRequest.Builder> listElasticsearchVersionsRequest) throws BaseException,
            InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return listElasticsearchVersions(ListElasticsearchVersionsRequest.builder()
                .applyMutation(listElasticsearchVersionsRequest).build());
    }

    /**
     * <p>
     * List all supported Elasticsearch versions
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listElasticsearchVersions(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsIterable responses = client.listElasticsearchVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsIterable responses = client
     *             .listElasticsearchVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsIterable responses = client.listElasticsearchVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listElasticsearchVersions(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListElasticsearchVersions
     * @see #listElasticsearchVersionsPaginator(ListElasticsearchVersionsRequest)
     */
    default ListElasticsearchVersionsIterable listElasticsearchVersionsPaginator() throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        return listElasticsearchVersionsPaginator(ListElasticsearchVersionsRequest.builder().build());
    }

    /**
     * <p>
     * List all supported Elasticsearch versions
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listElasticsearchVersions(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsIterable responses = client.listElasticsearchVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsIterable responses = client
     *             .listElasticsearchVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsIterable responses = client.listElasticsearchVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listElasticsearchVersions(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listElasticsearchVersionsRequest
     *        Container for the parameters to the <code> <a>ListElasticsearchVersions</a> </code> operation.
     *        <p>
     *        Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single
     *        call.
     *        </p>
     *        <p>
     *        Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does
     *        not contain a NextToken, then there are no more results to retrieve.
     *        </p>
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListElasticsearchVersions
     */
    default ListElasticsearchVersionsIterable listElasticsearchVersionsPaginator(
            ListElasticsearchVersionsRequest listElasticsearchVersionsRequest) throws BaseException, InternalException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all supported Elasticsearch versions
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listElasticsearchVersions(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsIterable responses = client.listElasticsearchVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsIterable responses = client
     *             .listElasticsearchVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsIterable responses = client.listElasticsearchVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listElasticsearchVersions(software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListElasticsearchVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListElasticsearchVersionsRequest#builder()}
     * </p>
     *
     * @param listElasticsearchVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListElasticsearchVersionsRequest.Builder} to create a
     *        request. Container for the parameters to the <code> <a>ListElasticsearchVersions</a> </code> operation.
     *        <p>
     *        Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single
     *        call.
     *        </p>
     *        <p>
     *        Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does
     *        not contain a NextToken, then there are no more results to retrieve.
     *        </p>
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListElasticsearchVersions
     */
    default ListElasticsearchVersionsIterable listElasticsearchVersionsPaginator(
            Consumer<ListElasticsearchVersionsRequest.Builder> listElasticsearchVersionsRequest) throws BaseException,
            InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return listElasticsearchVersionsPaginator(ListElasticsearchVersionsRequest.builder()
                .applyMutation(listElasticsearchVersionsRequest).build());
    }

    /**
     * <p>
     * Lists all packages associated with the Amazon ES domain.
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        Container for request parameters to <code> <a>ListPackagesForDomain</a> </code> operation.
     * @return Result of the ListPackagesForDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListPackagesForDomain
     */
    default ListPackagesForDomainResponse listPackagesForDomain(ListPackagesForDomainRequest listPackagesForDomainRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all packages associated with the Amazon ES domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagesForDomainRequest.Builder} avoiding the
     * need to create one manually via {@link ListPackagesForDomainRequest#builder()}
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        A {@link Consumer} that will call methods on {@link ListPackagesForDomainRequest.Builder} to create a
     *        request. Container for request parameters to <code> <a>ListPackagesForDomain</a> </code> operation.
     * @return Result of the ListPackagesForDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListPackagesForDomain
     */
    default ListPackagesForDomainResponse listPackagesForDomain(
            Consumer<ListPackagesForDomainRequest.Builder> listPackagesForDomainRequest) throws BaseException, InternalException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return listPackagesForDomain(ListPackagesForDomainRequest.builder().applyMutation(listPackagesForDomainRequest).build());
    }

    /**
     * <p>
     * Lists all packages associated with the Amazon ES domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPackagesForDomain(software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListPackagesForDomainIterable responses = client.listPackagesForDomainPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.ListPackagesForDomainIterable responses = client
     *             .listPackagesForDomainPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListPackagesForDomainIterable responses = client.listPackagesForDomainPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackagesForDomain(software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        Container for request parameters to <code> <a>ListPackagesForDomain</a> </code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListPackagesForDomain
     */
    default ListPackagesForDomainIterable listPackagesForDomainPaginator(ListPackagesForDomainRequest listPackagesForDomainRequest)
            throws BaseException, InternalException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all packages associated with the Amazon ES domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPackagesForDomain(software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListPackagesForDomainIterable responses = client.listPackagesForDomainPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticsearch.paginators.ListPackagesForDomainIterable responses = client
     *             .listPackagesForDomainPaginator(request);
     *     for (software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticsearch.paginators.ListPackagesForDomainIterable responses = client.listPackagesForDomainPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPackagesForDomain(software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPackagesForDomainRequest.Builder} avoiding the
     * need to create one manually via {@link ListPackagesForDomainRequest#builder()}
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        A {@link Consumer} that will call methods on {@link ListPackagesForDomainRequest.Builder} to create a
     *        request. Container for request parameters to <code> <a>ListPackagesForDomain</a> </code> operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListPackagesForDomain
     */
    default ListPackagesForDomainIterable listPackagesForDomainPaginator(
            Consumer<ListPackagesForDomainRequest.Builder> listPackagesForDomainRequest) throws BaseException, InternalException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return listPackagesForDomainPaginator(ListPackagesForDomainRequest.builder().applyMutation(listPackagesForDomainRequest)
                .build());
    }

    /**
     * <p>
     * Returns all tags for the given Elasticsearch domain.
     * </p>
     *
     * @param listTagsRequest
     *        Container for the parameters to the <code><a>ListTags</a></code> operation. Specify the <code>ARN</code>
     *        for the Elasticsearch domain to which the tags are attached that you want to view are attached.
     * @return Result of the ListTags operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListTags
     */
    default ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws BaseException, ResourceNotFoundException,
            ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all tags for the given Elasticsearch domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     *        Container for the parameters to the <code><a>ListTags</a></code> operation. Specify the <code>ARN</code>
     *        for the Elasticsearch domain to which the tags are attached that you want to view are attached.
     * @return Result of the ListTags operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListTags
     */
    default ListTagsResponse listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) throws BaseException,
            ResourceNotFoundException, ValidationException, InternalException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about each principal that is allowed to access a given Amazon OpenSearch Service domain
     * through the use of an interface VPC endpoint.
     * </p>
     *
     * @param listVpcEndpointAccessRequest
     *        Retrieves information about each principal that is allowed to access a given Amazon OpenSearch Service
     *        domain through the use of an interface VPC endpoint
     * @return Result of the ListVpcEndpointAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListVpcEndpointAccess
     */
    default ListVpcEndpointAccessResponse listVpcEndpointAccess(ListVpcEndpointAccessRequest listVpcEndpointAccessRequest)
            throws ResourceNotFoundException, DisabledOperationException, InternalException, BaseException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about each principal that is allowed to access a given Amazon OpenSearch Service domain
     * through the use of an interface VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link ListVpcEndpointAccessRequest#builder()}
     * </p>
     *
     * @param listVpcEndpointAccessRequest
     *        A {@link Consumer} that will call methods on {@link ListVpcEndpointAccessRequest.Builder} to create a
     *        request. Retrieves information about each principal that is allowed to access a given Amazon OpenSearch
     *        Service domain through the use of an interface VPC endpoint
     * @return Result of the ListVpcEndpointAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListVpcEndpointAccess
     */
    default ListVpcEndpointAccessResponse listVpcEndpointAccess(
            Consumer<ListVpcEndpointAccessRequest.Builder> listVpcEndpointAccessRequest) throws ResourceNotFoundException,
            DisabledOperationException, InternalException, BaseException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return listVpcEndpointAccess(ListVpcEndpointAccessRequest.builder().applyMutation(listVpcEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current account and Region.
     * </p>
     *
     * @param listVpcEndpointsRequest
     *        Container for request parameters to the <code><a>ListVpcEndpoints</a></code> operation.
     * @return Result of the ListVpcEndpoints operation returned by the service.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListVpcEndpoints
     */
    default ListVpcEndpointsResponse listVpcEndpoints(ListVpcEndpointsRequest listVpcEndpointsRequest) throws InternalException,
            DisabledOperationException, BaseException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link ListVpcEndpointsRequest#builder()}
     * </p>
     *
     * @param listVpcEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link ListVpcEndpointsRequest.Builder} to create a request.
     *        Container for request parameters to the <code><a>ListVpcEndpoints</a></code> operation.
     * @return Result of the ListVpcEndpoints operation returned by the service.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListVpcEndpoints
     */
    default ListVpcEndpointsResponse listVpcEndpoints(Consumer<ListVpcEndpointsRequest.Builder> listVpcEndpointsRequest)
            throws InternalException, DisabledOperationException, BaseException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return listVpcEndpoints(ListVpcEndpointsRequest.builder().applyMutation(listVpcEndpointsRequest).build());
    }

    /**
     * <p>
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated with a particular domain.
     * </p>
     *
     * @param listVpcEndpointsForDomainRequest
     *        Container for request parameters to the <code><a>ListVpcEndpointsForDomain</a></code> operation. Specifies
     *        the domain whose VPC endpoints will be listed.
     * @return Result of the ListVpcEndpointsForDomain operation returned by the service.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListVpcEndpointsForDomain
     */
    default ListVpcEndpointsForDomainResponse listVpcEndpointsForDomain(
            ListVpcEndpointsForDomainRequest listVpcEndpointsForDomainRequest) throws InternalException,
            DisabledOperationException, ResourceNotFoundException, BaseException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated with a particular domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcEndpointsForDomainRequest.Builder} avoiding
     * the need to create one manually via {@link ListVpcEndpointsForDomainRequest#builder()}
     * </p>
     *
     * @param listVpcEndpointsForDomainRequest
     *        A {@link Consumer} that will call methods on {@link ListVpcEndpointsForDomainRequest.Builder} to create a
     *        request. Container for request parameters to the <code><a>ListVpcEndpointsForDomain</a></code> operation.
     *        Specifies the domain whose VPC endpoints will be listed.
     * @return Result of the ListVpcEndpointsForDomain operation returned by the service.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.ListVpcEndpointsForDomain
     */
    default ListVpcEndpointsForDomainResponse listVpcEndpointsForDomain(
            Consumer<ListVpcEndpointsForDomainRequest.Builder> listVpcEndpointsForDomainRequest) throws InternalException,
            DisabledOperationException, ResourceNotFoundException, BaseException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return listVpcEndpointsForDomain(ListVpcEndpointsForDomainRequest.builder()
                .applyMutation(listVpcEndpointsForDomainRequest).build());
    }

    /**
     * <p>
     * Allows you to purchase reserved Elasticsearch instances.
     * </p>
     *
     * @param purchaseReservedElasticsearchInstanceOfferingRequest
     *        Container for parameters to <code>PurchaseReservedElasticsearchInstanceOffering</code>
     * @return Result of the PurchaseReservedElasticsearchInstanceOffering operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ResourceAlreadyExistsException
     *         An exception for creating a resource that already exists. Gives http status code of 400.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.PurchaseReservedElasticsearchInstanceOffering
     */
    default PurchaseReservedElasticsearchInstanceOfferingResponse purchaseReservedElasticsearchInstanceOffering(
            PurchaseReservedElasticsearchInstanceOfferingRequest purchaseReservedElasticsearchInstanceOfferingRequest)
            throws ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, DisabledOperationException,
            ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to purchase reserved Elasticsearch instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PurchaseReservedElasticsearchInstanceOfferingRequest.Builder} avoiding the need to create one manually via
     * {@link PurchaseReservedElasticsearchInstanceOfferingRequest#builder()}
     * </p>
     *
     * @param purchaseReservedElasticsearchInstanceOfferingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link PurchaseReservedElasticsearchInstanceOfferingRequest.Builder} to create a request. Container for
     *        parameters to <code>PurchaseReservedElasticsearchInstanceOffering</code>
     * @return Result of the PurchaseReservedElasticsearchInstanceOffering operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ResourceAlreadyExistsException
     *         An exception for creating a resource that already exists. Gives http status code of 400.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.PurchaseReservedElasticsearchInstanceOffering
     */
    default PurchaseReservedElasticsearchInstanceOfferingResponse purchaseReservedElasticsearchInstanceOffering(
            Consumer<PurchaseReservedElasticsearchInstanceOfferingRequest.Builder> purchaseReservedElasticsearchInstanceOfferingRequest)
            throws ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, DisabledOperationException,
            ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        return purchaseReservedElasticsearchInstanceOffering(PurchaseReservedElasticsearchInstanceOfferingRequest.builder()
                .applyMutation(purchaseReservedElasticsearchInstanceOfferingRequest).build());
    }

    /**
     * <p>
     * Allows the destination domain owner to reject an inbound cross-cluster search connection request.
     * </p>
     *
     * @param rejectInboundCrossClusterSearchConnectionRequest
     *        Container for the parameters to the <code><a>RejectInboundCrossClusterSearchConnection</a></code>
     *        operation.
     * @return Result of the RejectInboundCrossClusterSearchConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.RejectInboundCrossClusterSearchConnection
     */
    default RejectInboundCrossClusterSearchConnectionResponse rejectInboundCrossClusterSearchConnection(
            RejectInboundCrossClusterSearchConnectionRequest rejectInboundCrossClusterSearchConnectionRequest)
            throws ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the destination domain owner to reject an inbound cross-cluster search connection request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link RejectInboundCrossClusterSearchConnectionRequest.Builder} avoiding the need to create one manually via
     * {@link RejectInboundCrossClusterSearchConnectionRequest#builder()}
     * </p>
     *
     * @param rejectInboundCrossClusterSearchConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link RejectInboundCrossClusterSearchConnectionRequest.Builder} to create a request. Container for the
     *        parameters to the <code><a>RejectInboundCrossClusterSearchConnection</a></code> operation.
     * @return Result of the RejectInboundCrossClusterSearchConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.RejectInboundCrossClusterSearchConnection
     */
    default RejectInboundCrossClusterSearchConnectionResponse rejectInboundCrossClusterSearchConnection(
            Consumer<RejectInboundCrossClusterSearchConnectionRequest.Builder> rejectInboundCrossClusterSearchConnectionRequest)
            throws ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        return rejectInboundCrossClusterSearchConnection(RejectInboundCrossClusterSearchConnectionRequest.builder()
                .applyMutation(rejectInboundCrossClusterSearchConnectionRequest).build());
    }

    /**
     * <p>
     * Removes the specified set of tags from the specified Elasticsearch domain.
     * </p>
     *
     * @param removeTagsRequest
     *        Container for the parameters to the <code><a>RemoveTags</a></code> operation. Specify the <code>ARN</code>
     *        for the Elasticsearch domain from which you want to remove the specified <code>TagKey</code>.
     * @return Result of the RemoveTags operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.RemoveTags
     */
    default RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws BaseException, ValidationException,
            InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified set of tags from the specified Elasticsearch domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveTagsRequest#builder()}
     * </p>
     *
     * @param removeTagsRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsRequest.Builder} to create a request.
     *        Container for the parameters to the <code><a>RemoveTags</a></code> operation. Specify the <code>ARN</code>
     *        for the Elasticsearch domain from which you want to remove the specified <code>TagKey</code>.
     * @return Result of the RemoveTags operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.RemoveTags
     */
    default RemoveTagsResponse removeTags(Consumer<RemoveTagsRequest.Builder> removeTagsRequest) throws BaseException,
            ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        return removeTags(RemoveTagsRequest.builder().applyMutation(removeTagsRequest).build());
    }

    /**
     * <p>
     * Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.
     * </p>
     *
     * @param revokeVpcEndpointAccessRequest
     *        Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.
     * @return Result of the RevokeVpcEndpointAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.RevokeVpcEndpointAccess
     */
    default RevokeVpcEndpointAccessResponse revokeVpcEndpointAccess(RevokeVpcEndpointAccessRequest revokeVpcEndpointAccessRequest)
            throws ResourceNotFoundException, ValidationException, DisabledOperationException, InternalException, BaseException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeVpcEndpointAccessRequest.Builder} avoiding
     * the need to create one manually via {@link RevokeVpcEndpointAccessRequest#builder()}
     * </p>
     *
     * @param revokeVpcEndpointAccessRequest
     *        A {@link Consumer} that will call methods on {@link RevokeVpcEndpointAccessRequest.Builder} to create a
     *        request. Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC
     *        endpoint.
     * @return Result of the RevokeVpcEndpointAccess operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.RevokeVpcEndpointAccess
     */
    default RevokeVpcEndpointAccessResponse revokeVpcEndpointAccess(
            Consumer<RevokeVpcEndpointAccessRequest.Builder> revokeVpcEndpointAccessRequest) throws ResourceNotFoundException,
            ValidationException, DisabledOperationException, InternalException, BaseException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        return revokeVpcEndpointAccess(RevokeVpcEndpointAccessRequest.builder().applyMutation(revokeVpcEndpointAccessRequest)
                .build());
    }

    /**
     * <p>
     * Schedules a service software update for an Amazon ES domain.
     * </p>
     *
     * @param startElasticsearchServiceSoftwareUpdateRequest
     *        Container for the parameters to the <code><a>StartElasticsearchServiceSoftwareUpdate</a></code> operation.
     *        Specifies the name of the Elasticsearch domain that you wish to schedule a service software update on.
     * @return Result of the StartElasticsearchServiceSoftwareUpdate operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.StartElasticsearchServiceSoftwareUpdate
     */
    default StartElasticsearchServiceSoftwareUpdateResponse startElasticsearchServiceSoftwareUpdate(
            StartElasticsearchServiceSoftwareUpdateRequest startElasticsearchServiceSoftwareUpdateRequest) throws BaseException,
            InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Schedules a service software update for an Amazon ES domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartElasticsearchServiceSoftwareUpdateRequest.Builder} avoiding the need to create one manually via
     * {@link StartElasticsearchServiceSoftwareUpdateRequest#builder()}
     * </p>
     *
     * @param startElasticsearchServiceSoftwareUpdateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link StartElasticsearchServiceSoftwareUpdateRequest.Builder} to create a request. Container for the
     *        parameters to the <code><a>StartElasticsearchServiceSoftwareUpdate</a></code> operation. Specifies the
     *        name of the Elasticsearch domain that you wish to schedule a service software update on.
     * @return Result of the StartElasticsearchServiceSoftwareUpdate operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.StartElasticsearchServiceSoftwareUpdate
     */
    default StartElasticsearchServiceSoftwareUpdateResponse startElasticsearchServiceSoftwareUpdate(
            Consumer<StartElasticsearchServiceSoftwareUpdateRequest.Builder> startElasticsearchServiceSoftwareUpdateRequest)
            throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, ElasticsearchException {
        return startElasticsearchServiceSoftwareUpdate(StartElasticsearchServiceSoftwareUpdateRequest.builder()
                .applyMutation(startElasticsearchServiceSoftwareUpdateRequest).build());
    }

    /**
     * <p>
     * Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type
     * and the number of instances.
     * </p>
     *
     * @param updateElasticsearchDomainConfigRequest
     *        Container for the parameters to the <code><a>UpdateElasticsearchDomain</a></code> operation. Specifies the
     *        type and number of instances in the domain cluster.
     * @return Result of the UpdateElasticsearchDomainConfig operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws InvalidTypeException
     *         An exception for trying to create or access sub-resource that is either invalid or not supported. Gives
     *         http status code of 409.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.UpdateElasticsearchDomainConfig
     */
    default UpdateElasticsearchDomainConfigResponse updateElasticsearchDomainConfig(
            UpdateElasticsearchDomainConfigRequest updateElasticsearchDomainConfigRequest) throws BaseException,
            InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type
     * and the number of instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateElasticsearchDomainConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateElasticsearchDomainConfigRequest#builder()}
     * </p>
     *
     * @param updateElasticsearchDomainConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateElasticsearchDomainConfigRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>UpdateElasticsearchDomain</a></code>
     *        operation. Specifies the type and number of instances in the domain cluster.
     * @return Result of the UpdateElasticsearchDomainConfig operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws InvalidTypeException
     *         An exception for trying to create or access sub-resource that is either invalid or not supported. Gives
     *         http status code of 409.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.UpdateElasticsearchDomainConfig
     */
    default UpdateElasticsearchDomainConfigResponse updateElasticsearchDomainConfig(
            Consumer<UpdateElasticsearchDomainConfigRequest.Builder> updateElasticsearchDomainConfigRequest)
            throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        return updateElasticsearchDomainConfig(UpdateElasticsearchDomainConfigRequest.builder()
                .applyMutation(updateElasticsearchDomainConfigRequest).build());
    }

    /**
     * <p>
     * Updates a package for use with Amazon ES domains.
     * </p>
     *
     * @param updatePackageRequest
     *        Container for request parameters to <code> <a>UpdatePackage</a> </code> operation.
     * @return Result of the UpdatePackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.UpdatePackage
     */
    default UpdatePackageResponse updatePackage(UpdatePackageRequest updatePackageRequest) throws BaseException,
            InternalException, LimitExceededException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a package for use with Amazon ES domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePackageRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePackageRequest#builder()}
     * </p>
     *
     * @param updatePackageRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePackageRequest.Builder} to create a request.
     *        Container for request parameters to <code> <a>UpdatePackage</a> </code> operation.
     * @return Result of the UpdatePackage operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws LimitExceededException
     *         An exception for trying to create more than allowed resources or sub-resources. Gives http status code of
     *         409.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws AccessDeniedException
     *         An error occurred because user does not have permissions to access the resource. Returns HTTP status code
     *         403.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.UpdatePackage
     */
    default UpdatePackageResponse updatePackage(Consumer<UpdatePackageRequest.Builder> updatePackageRequest)
            throws BaseException, InternalException, LimitExceededException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        return updatePackage(UpdatePackageRequest.builder().applyMutation(updatePackageRequest).build());
    }

    /**
     * <p>
     * Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
     * </p>
     *
     * @param updateVpcEndpointRequest
     *        Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
     * @return Result of the UpdateVpcEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP
     *         status code 409.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.UpdateVpcEndpoint
     */
    default UpdateVpcEndpointResponse updateVpcEndpoint(UpdateVpcEndpointRequest updateVpcEndpointRequest)
            throws ResourceNotFoundException, DisabledOperationException, InternalException, ValidationException,
            ConflictException, BaseException, AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVpcEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateVpcEndpointRequest#builder()}
     * </p>
     *
     * @param updateVpcEndpointRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVpcEndpointRequest.Builder} to create a request.
     *        Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
     * @return Result of the UpdateVpcEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws ConflictException
     *         An error occurred because the client attempts to remove a resource that is currently in use. Returns HTTP
     *         status code 409.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.UpdateVpcEndpoint
     */
    default UpdateVpcEndpointResponse updateVpcEndpoint(Consumer<UpdateVpcEndpointRequest.Builder> updateVpcEndpointRequest)
            throws ResourceNotFoundException, DisabledOperationException, InternalException, ValidationException,
            ConflictException, BaseException, AwsServiceException, SdkClientException, ElasticsearchException {
        return updateVpcEndpoint(UpdateVpcEndpointRequest.builder().applyMutation(updateVpcEndpointRequest).build());
    }

    /**
     * <p>
     * Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch
     * version.
     * </p>
     *
     * @param upgradeElasticsearchDomainRequest
     *        Container for request parameters to <code> <a>UpgradeElasticsearchDomain</a> </code> operation.
     * @return Result of the UpgradeElasticsearchDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ResourceAlreadyExistsException
     *         An exception for creating a resource that already exists. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.UpgradeElasticsearchDomain
     */
    default UpgradeElasticsearchDomainResponse upgradeElasticsearchDomain(
            UpgradeElasticsearchDomainRequest upgradeElasticsearchDomainRequest) throws BaseException, ResourceNotFoundException,
            ResourceAlreadyExistsException, DisabledOperationException, ValidationException, InternalException,
            AwsServiceException, SdkClientException, ElasticsearchException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch
     * version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpgradeElasticsearchDomainRequest.Builder} avoiding
     * the need to create one manually via {@link UpgradeElasticsearchDomainRequest#builder()}
     * </p>
     *
     * @param upgradeElasticsearchDomainRequest
     *        A {@link Consumer} that will call methods on {@link UpgradeElasticsearchDomainRequest.Builder} to create a
     *        request. Container for request parameters to <code> <a>UpgradeElasticsearchDomain</a> </code> operation.
     * @return Result of the UpgradeElasticsearchDomain operation returned by the service.
     * @throws BaseException
     *         An error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         An exception for accessing or deleting a resource that does not exist. Gives http status code of 400.
     * @throws ResourceAlreadyExistsException
     *         An exception for creating a resource that already exists. Gives http status code of 400.
     * @throws DisabledOperationException
     *         An error occured because the client wanted to access a not supported operation. Gives http status code of
     *         409.
     * @throws ValidationException
     *         An exception for missing / invalid input fields. Gives http status code of 400.
     * @throws InternalException
     *         The request processing has failed because of an unknown error, exception or failure (the failure is
     *         internal to the service) . Gives http status code of 500.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticsearchException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticsearchClient.UpgradeElasticsearchDomain
     */
    default UpgradeElasticsearchDomainResponse upgradeElasticsearchDomain(
            Consumer<UpgradeElasticsearchDomainRequest.Builder> upgradeElasticsearchDomainRequest) throws BaseException,
            ResourceNotFoundException, ResourceAlreadyExistsException, DisabledOperationException, ValidationException,
            InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        return upgradeElasticsearchDomain(UpgradeElasticsearchDomainRequest.builder()
                .applyMutation(upgradeElasticsearchDomainRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
