/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.elastictranscoder.model.CancelJobRequest;
import software.amazon.awssdk.services.elastictranscoder.model.CancelJobResponse;
import software.amazon.awssdk.services.elastictranscoder.model.CreateJobRequest;
import software.amazon.awssdk.services.elastictranscoder.model.CreateJobResponse;
import software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineResponse;
import software.amazon.awssdk.services.elastictranscoder.model.CreatePresetRequest;
import software.amazon.awssdk.services.elastictranscoder.model.CreatePresetResponse;
import software.amazon.awssdk.services.elastictranscoder.model.DeletePipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.DeletePipelineResponse;
import software.amazon.awssdk.services.elastictranscoder.model.DeletePresetRequest;
import software.amazon.awssdk.services.elastictranscoder.model.DeletePresetResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ListPresetsRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ReadJobRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ReadJobResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ReadPresetRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ReadPresetResponse;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsRequest;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsResponse;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusRequest;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusResponse;
import software.amazon.awssdk.services.elastictranscoder.paginators.ListJobsByPipelinePublisher;
import software.amazon.awssdk.services.elastictranscoder.paginators.ListJobsByStatusPublisher;
import software.amazon.awssdk.services.elastictranscoder.paginators.ListPipelinesPublisher;
import software.amazon.awssdk.services.elastictranscoder.paginators.ListPresetsPublisher;
import software.amazon.awssdk.services.elastictranscoder.waiters.ElasticTranscoderAsyncWaiter;

/**
 * Service client for accessing Amazon Elastic Transcoder asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>AWS Elastic Transcoder Service</fullname>
 * <p>
 * The AWS Elastic Transcoder Service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ElasticTranscoderAsyncClient extends AwsClient {
    String SERVICE_NAME = "elastictranscoder";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "elastictranscoder";

    /**
     * <p>
     * The CancelJob operation cancels an unfinished job.
     * </p>
     * <note>
     * <p>
     * You can only cancel a job that has a status of <code>Submitted</code>. To prevent a pipeline from starting to
     * process a job while you're getting the job identifier, use <a>UpdatePipelineStatus</a> to temporarily pause the
     * pipeline.
     * </p>
     * </note>
     *
     * @param cancelJobRequest
     *        The <code>CancelJobRequest</code> structure.
     * @return A Java Future containing the result of the CancelJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>ResourceInUseException The resource you are attempting to change is in use. For example, you are
     *         attempting to delete a pipeline that is currently in use.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.CancelJob
     */
    default CompletableFuture<CancelJobResponse> cancelJob(CancelJobRequest cancelJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The CancelJob operation cancels an unfinished job.
     * </p>
     * <note>
     * <p>
     * You can only cancel a job that has a status of <code>Submitted</code>. To prevent a pipeline from starting to
     * process a job while you're getting the job identifier, use <a>UpdatePipelineStatus</a> to temporarily pause the
     * pipeline.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelJobRequest.Builder} avoiding the need to
     * create one manually via {@link CancelJobRequest#builder()}
     * </p>
     *
     * @param cancelJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.CancelJobRequest.Builder} to create a
     *        request. The <code>CancelJobRequest</code> structure.
     * @return A Java Future containing the result of the CancelJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>ResourceInUseException The resource you are attempting to change is in use. For example, you are
     *         attempting to delete a pipeline that is currently in use.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.CancelJob
     */
    default CompletableFuture<CancelJobResponse> cancelJob(Consumer<CancelJobRequest.Builder> cancelJobRequest) {
        return cancelJob(CancelJobRequest.builder().applyMutation(cancelJobRequest).build());
    }

    /**
     * <p>
     * When you create a job, Elastic Transcoder returns JSON data that includes the values that you specified plus
     * information about the job that is created.
     * </p>
     * <p>
     * If you have specified more than one output for your jobs (for example, one output for the Kindle Fire and another
     * output for the Apple iPhone 4s), you currently must use the Elastic Transcoder API to list the jobs (as opposed
     * to the AWS Console).
     * </p>
     *
     * @param createJobRequest
     *        The <code>CreateJobRequest</code> structure.
     * @return A Java Future containing the result of the CreateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>LimitExceededException Too many operations for a given AWS account. For example, the number of
     *         pipelines exceeds the maximum allowed.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.CreateJob
     */
    default CompletableFuture<CreateJobResponse> createJob(CreateJobRequest createJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When you create a job, Elastic Transcoder returns JSON data that includes the values that you specified plus
     * information about the job that is created.
     * </p>
     * <p>
     * If you have specified more than one output for your jobs (for example, one output for the Kindle Fire and another
     * output for the Apple iPhone 4s), you currently must use the Elastic Transcoder API to list the jobs (as opposed
     * to the AWS Console).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobRequest.Builder} avoiding the need to
     * create one manually via {@link CreateJobRequest#builder()}
     * </p>
     *
     * @param createJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.CreateJobRequest.Builder} to create a
     *        request. The <code>CreateJobRequest</code> structure.
     * @return A Java Future containing the result of the CreateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>LimitExceededException Too many operations for a given AWS account. For example, the number of
     *         pipelines exceeds the maximum allowed.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.CreateJob
     */
    default CompletableFuture<CreateJobResponse> createJob(Consumer<CreateJobRequest.Builder> createJobRequest) {
        return createJob(CreateJobRequest.builder().applyMutation(createJobRequest).build());
    }

    /**
     * <p>
     * The CreatePipeline operation creates a pipeline with settings that you specify.
     * </p>
     *
     * @param createPipelineRequest
     *        The <code>CreatePipelineRequest</code> structure.
     * @return A Java Future containing the result of the CreatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>LimitExceededException Too many operations for a given AWS account. For example, the number of
     *         pipelines exceeds the maximum allowed.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.CreatePipeline
     */
    default CompletableFuture<CreatePipelineResponse> createPipeline(CreatePipelineRequest createPipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The CreatePipeline operation creates a pipeline with settings that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePipelineRequest#builder()}
     * </p>
     *
     * @param createPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineRequest.Builder} to create a
     *        request. The <code>CreatePipelineRequest</code> structure.
     * @return A Java Future containing the result of the CreatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>LimitExceededException Too many operations for a given AWS account. For example, the number of
     *         pipelines exceeds the maximum allowed.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.CreatePipeline
     */
    default CompletableFuture<CreatePipelineResponse> createPipeline(Consumer<CreatePipelineRequest.Builder> createPipelineRequest) {
        return createPipeline(CreatePipelineRequest.builder().applyMutation(createPipelineRequest).build());
    }

    /**
     * <p>
     * The CreatePreset operation creates a preset with settings that you specify.
     * </p>
     * <important>
     * <p>
     * Elastic Transcoder checks the CreatePreset settings to ensure that they meet Elastic Transcoder requirements and
     * to determine whether they comply with H.264 standards. If your settings are not valid for Elastic Transcoder,
     * Elastic Transcoder returns an HTTP 400 response (<code>ValidationException</code>) and does not create the
     * preset. If the settings are valid for Elastic Transcoder but aren't strictly compliant with the H.264 standard,
     * Elastic Transcoder creates the preset and returns a warning message in the response. This helps you determine
     * whether your settings comply with the H.264 standard while giving you greater flexibility with respect to the
     * video that Elastic Transcoder produces.
     * </p>
     * </important>
     * <p>
     * Elastic Transcoder uses the H.264 video-compression format. For more information, see the International
     * Telecommunication Union publication <i>Recommendation ITU-T H.264: Advanced video coding for generic audiovisual
     * services</i>.
     * </p>
     *
     * @param createPresetRequest
     *        The <code>CreatePresetRequest</code> structure.
     * @return A Java Future containing the result of the CreatePreset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>LimitExceededException Too many operations for a given AWS account. For example, the number of
     *         pipelines exceeds the maximum allowed.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.CreatePreset
     */
    default CompletableFuture<CreatePresetResponse> createPreset(CreatePresetRequest createPresetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The CreatePreset operation creates a preset with settings that you specify.
     * </p>
     * <important>
     * <p>
     * Elastic Transcoder checks the CreatePreset settings to ensure that they meet Elastic Transcoder requirements and
     * to determine whether they comply with H.264 standards. If your settings are not valid for Elastic Transcoder,
     * Elastic Transcoder returns an HTTP 400 response (<code>ValidationException</code>) and does not create the
     * preset. If the settings are valid for Elastic Transcoder but aren't strictly compliant with the H.264 standard,
     * Elastic Transcoder creates the preset and returns a warning message in the response. This helps you determine
     * whether your settings comply with the H.264 standard while giving you greater flexibility with respect to the
     * video that Elastic Transcoder produces.
     * </p>
     * </important>
     * <p>
     * Elastic Transcoder uses the H.264 video-compression format. For more information, see the International
     * Telecommunication Union publication <i>Recommendation ITU-T H.264: Advanced video coding for generic audiovisual
     * services</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePresetRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePresetRequest#builder()}
     * </p>
     *
     * @param createPresetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.CreatePresetRequest.Builder} to create a
     *        request. The <code>CreatePresetRequest</code> structure.
     * @return A Java Future containing the result of the CreatePreset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>LimitExceededException Too many operations for a given AWS account. For example, the number of
     *         pipelines exceeds the maximum allowed.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.CreatePreset
     */
    default CompletableFuture<CreatePresetResponse> createPreset(Consumer<CreatePresetRequest.Builder> createPresetRequest) {
        return createPreset(CreatePresetRequest.builder().applyMutation(createPresetRequest).build());
    }

    /**
     * <p>
     * The DeletePipeline operation removes a pipeline.
     * </p>
     * <p>
     * You can only delete a pipeline that has never been used or that is not currently in use (doesn't contain any
     * active jobs). If the pipeline is currently in use, <code>DeletePipeline</code> returns an error.
     * </p>
     *
     * @param deletePipelineRequest
     *        The <code>DeletePipelineRequest</code> structure.
     * @return A Java Future containing the result of the DeletePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>ResourceInUseException The resource you are attempting to change is in use. For example, you are
     *         attempting to delete a pipeline that is currently in use.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.DeletePipeline
     */
    default CompletableFuture<DeletePipelineResponse> deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The DeletePipeline operation removes a pipeline.
     * </p>
     * <p>
     * You can only delete a pipeline that has never been used or that is not currently in use (doesn't contain any
     * active jobs). If the pipeline is currently in use, <code>DeletePipeline</code> returns an error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePipelineRequest#builder()}
     * </p>
     *
     * @param deletePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.DeletePipelineRequest.Builder} to create a
     *        request. The <code>DeletePipelineRequest</code> structure.
     * @return A Java Future containing the result of the DeletePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>ResourceInUseException The resource you are attempting to change is in use. For example, you are
     *         attempting to delete a pipeline that is currently in use.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.DeletePipeline
     */
    default CompletableFuture<DeletePipelineResponse> deletePipeline(Consumer<DeletePipelineRequest.Builder> deletePipelineRequest) {
        return deletePipeline(DeletePipelineRequest.builder().applyMutation(deletePipelineRequest).build());
    }

    /**
     * <p>
     * The DeletePreset operation removes a preset that you've added in an AWS region.
     * </p>
     * <note>
     * <p>
     * You can't delete the default presets that are included with Elastic Transcoder.
     * </p>
     * </note>
     *
     * @param deletePresetRequest
     *        The <code>DeletePresetRequest</code> structure.
     * @return A Java Future containing the result of the DeletePreset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.DeletePreset
     */
    default CompletableFuture<DeletePresetResponse> deletePreset(DeletePresetRequest deletePresetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The DeletePreset operation removes a preset that you've added in an AWS region.
     * </p>
     * <note>
     * <p>
     * You can't delete the default presets that are included with Elastic Transcoder.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePresetRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePresetRequest#builder()}
     * </p>
     *
     * @param deletePresetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.DeletePresetRequest.Builder} to create a
     *        request. The <code>DeletePresetRequest</code> structure.
     * @return A Java Future containing the result of the DeletePreset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.DeletePreset
     */
    default CompletableFuture<DeletePresetResponse> deletePreset(Consumer<DeletePresetRequest.Builder> deletePresetRequest) {
        return deletePreset(DeletePresetRequest.builder().applyMutation(deletePresetRequest).build());
    }

    /**
     * <p>
     * The ListJobsByPipeline operation gets a list of the jobs currently in a pipeline.
     * </p>
     * <p>
     * Elastic Transcoder returns all of the jobs currently in the specified pipeline. The response body contains one
     * element for each job that satisfies the search criteria.
     * </p>
     *
     * @param listJobsByPipelineRequest
     *        The <code>ListJobsByPipelineRequest</code> structure.
     * @return A Java Future containing the result of the ListJobsByPipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListJobsByPipeline
     */
    default CompletableFuture<ListJobsByPipelineResponse> listJobsByPipeline(ListJobsByPipelineRequest listJobsByPipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListJobsByPipeline operation gets a list of the jobs currently in a pipeline.
     * </p>
     * <p>
     * Elastic Transcoder returns all of the jobs currently in the specified pipeline. The response body contains one
     * element for each job that satisfies the search criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsByPipelineRequest.Builder} avoiding the
     * need to create one manually via {@link ListJobsByPipelineRequest#builder()}
     * </p>
     *
     * @param listJobsByPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest.Builder} to
     *        create a request. The <code>ListJobsByPipelineRequest</code> structure.
     * @return A Java Future containing the result of the ListJobsByPipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListJobsByPipeline
     */
    default CompletableFuture<ListJobsByPipelineResponse> listJobsByPipeline(
            Consumer<ListJobsByPipelineRequest.Builder> listJobsByPipelineRequest) {
        return listJobsByPipeline(ListJobsByPipelineRequest.builder().applyMutation(listJobsByPipelineRequest).build());
    }

    /**
     * <p>
     * The ListJobsByPipeline operation gets a list of the jobs currently in a pipeline.
     * </p>
     * <p>
     * Elastic Transcoder returns all of the jobs currently in the specified pipeline. The response body contains one
     * element for each job that satisfies the search criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listJobsByPipeline(software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListJobsByPipelinePublisher publisher = client.listJobsByPipelinePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListJobsByPipelinePublisher publisher = client.listJobsByPipelinePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobsByPipeline(software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest)}
     * operation.</b>
     * </p>
     *
     * @param listJobsByPipelineRequest
     *        The <code>ListJobsByPipelineRequest</code> structure.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListJobsByPipeline
     */
    default ListJobsByPipelinePublisher listJobsByPipelinePaginator(ListJobsByPipelineRequest listJobsByPipelineRequest) {
        return new ListJobsByPipelinePublisher(this, listJobsByPipelineRequest);
    }

    /**
     * <p>
     * The ListJobsByPipeline operation gets a list of the jobs currently in a pipeline.
     * </p>
     * <p>
     * Elastic Transcoder returns all of the jobs currently in the specified pipeline. The response body contains one
     * element for each job that satisfies the search criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listJobsByPipeline(software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListJobsByPipelinePublisher publisher = client.listJobsByPipelinePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListJobsByPipelinePublisher publisher = client.listJobsByPipelinePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobsByPipeline(software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsByPipelineRequest.Builder} avoiding the
     * need to create one manually via {@link ListJobsByPipelineRequest#builder()}
     * </p>
     *
     * @param listJobsByPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest.Builder} to
     *        create a request. The <code>ListJobsByPipelineRequest</code> structure.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListJobsByPipeline
     */
    default ListJobsByPipelinePublisher listJobsByPipelinePaginator(
            Consumer<ListJobsByPipelineRequest.Builder> listJobsByPipelineRequest) {
        return listJobsByPipelinePaginator(ListJobsByPipelineRequest.builder().applyMutation(listJobsByPipelineRequest).build());
    }

    /**
     * <p>
     * The ListJobsByStatus operation gets a list of jobs that have a specified status. The response body contains one
     * element for each job that satisfies the search criteria.
     * </p>
     *
     * @param listJobsByStatusRequest
     *        The <code>ListJobsByStatusRequest</code> structure.
     * @return A Java Future containing the result of the ListJobsByStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListJobsByStatus
     */
    default CompletableFuture<ListJobsByStatusResponse> listJobsByStatus(ListJobsByStatusRequest listJobsByStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListJobsByStatus operation gets a list of jobs that have a specified status. The response body contains one
     * element for each job that satisfies the search criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsByStatusRequest.Builder} avoiding the need
     * to create one manually via {@link ListJobsByStatusRequest#builder()}
     * </p>
     *
     * @param listJobsByStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest.Builder} to create
     *        a request. The <code>ListJobsByStatusRequest</code> structure.
     * @return A Java Future containing the result of the ListJobsByStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListJobsByStatus
     */
    default CompletableFuture<ListJobsByStatusResponse> listJobsByStatus(
            Consumer<ListJobsByStatusRequest.Builder> listJobsByStatusRequest) {
        return listJobsByStatus(ListJobsByStatusRequest.builder().applyMutation(listJobsByStatusRequest).build());
    }

    /**
     * <p>
     * The ListJobsByStatus operation gets a list of jobs that have a specified status. The response body contains one
     * element for each job that satisfies the search criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listJobsByStatus(software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListJobsByStatusPublisher publisher = client.listJobsByStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListJobsByStatusPublisher publisher = client.listJobsByStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobsByStatus(software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listJobsByStatusRequest
     *        The <code>ListJobsByStatusRequest</code> structure.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListJobsByStatus
     */
    default ListJobsByStatusPublisher listJobsByStatusPaginator(ListJobsByStatusRequest listJobsByStatusRequest) {
        return new ListJobsByStatusPublisher(this, listJobsByStatusRequest);
    }

    /**
     * <p>
     * The ListJobsByStatus operation gets a list of jobs that have a specified status. The response body contains one
     * element for each job that satisfies the search criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listJobsByStatus(software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListJobsByStatusPublisher publisher = client.listJobsByStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListJobsByStatusPublisher publisher = client.listJobsByStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobsByStatus(software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsByStatusRequest.Builder} avoiding the need
     * to create one manually via {@link ListJobsByStatusRequest#builder()}
     * </p>
     *
     * @param listJobsByStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest.Builder} to create
     *        a request. The <code>ListJobsByStatusRequest</code> structure.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListJobsByStatus
     */
    default ListJobsByStatusPublisher listJobsByStatusPaginator(Consumer<ListJobsByStatusRequest.Builder> listJobsByStatusRequest) {
        return listJobsByStatusPaginator(ListJobsByStatusRequest.builder().applyMutation(listJobsByStatusRequest).build());
    }

    /**
     * <p>
     * The ListPipelines operation gets a list of the pipelines associated with the current AWS account.
     * </p>
     *
     * @param listPipelinesRequest
     *        The <code>ListPipelineRequest</code> structure.
     * @return A Java Future containing the result of the ListPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListPipelines
     */
    default CompletableFuture<ListPipelinesResponse> listPipelines(ListPipelinesRequest listPipelinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListPipelines operation gets a list of the pipelines associated with the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelinesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPipelinesRequest#builder()}
     * </p>
     *
     * @param listPipelinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest.Builder} to create a
     *        request. The <code>ListPipelineRequest</code> structure.
     * @return A Java Future containing the result of the ListPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListPipelines
     */
    default CompletableFuture<ListPipelinesResponse> listPipelines(Consumer<ListPipelinesRequest.Builder> listPipelinesRequest) {
        return listPipelines(ListPipelinesRequest.builder().applyMutation(listPipelinesRequest).build());
    }

    /**
     * <p>
     * The ListPipelines operation gets a list of the pipelines associated with the current AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListPipelines
     */
    default CompletableFuture<ListPipelinesResponse> listPipelines() {
        return listPipelines(ListPipelinesRequest.builder().build());
    }

    /**
     * <p>
     * The ListPipelines operation gets a list of the pipelines associated with the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPipelines(software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelines(software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListPipelines
     */
    default ListPipelinesPublisher listPipelinesPaginator() {
        return listPipelinesPaginator(ListPipelinesRequest.builder().build());
    }

    /**
     * <p>
     * The ListPipelines operation gets a list of the pipelines associated with the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPipelines(software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelines(software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPipelinesRequest
     *        The <code>ListPipelineRequest</code> structure.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListPipelines
     */
    default ListPipelinesPublisher listPipelinesPaginator(ListPipelinesRequest listPipelinesRequest) {
        return new ListPipelinesPublisher(this, listPipelinesRequest);
    }

    /**
     * <p>
     * The ListPipelines operation gets a list of the pipelines associated with the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPipelines(software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListPipelinesPublisher publisher = client.listPipelinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPipelines(software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPipelinesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPipelinesRequest#builder()}
     * </p>
     *
     * @param listPipelinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest.Builder} to create a
     *        request. The <code>ListPipelineRequest</code> structure.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListPipelines
     */
    default ListPipelinesPublisher listPipelinesPaginator(Consumer<ListPipelinesRequest.Builder> listPipelinesRequest) {
        return listPipelinesPaginator(ListPipelinesRequest.builder().applyMutation(listPipelinesRequest).build());
    }

    /**
     * <p>
     * The ListPresets operation gets a list of the default presets included with Elastic Transcoder and the presets
     * that you've added in an AWS region.
     * </p>
     *
     * @param listPresetsRequest
     *        The <code>ListPresetsRequest</code> structure.
     * @return A Java Future containing the result of the ListPresets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListPresets
     */
    default CompletableFuture<ListPresetsResponse> listPresets(ListPresetsRequest listPresetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ListPresets operation gets a list of the default presets included with Elastic Transcoder and the presets
     * that you've added in an AWS region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPresetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPresetsRequest#builder()}
     * </p>
     *
     * @param listPresetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.ListPresetsRequest.Builder} to create a
     *        request. The <code>ListPresetsRequest</code> structure.
     * @return A Java Future containing the result of the ListPresets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListPresets
     */
    default CompletableFuture<ListPresetsResponse> listPresets(Consumer<ListPresetsRequest.Builder> listPresetsRequest) {
        return listPresets(ListPresetsRequest.builder().applyMutation(listPresetsRequest).build());
    }

    /**
     * <p>
     * The ListPresets operation gets a list of the default presets included with Elastic Transcoder and the presets
     * that you've added in an AWS region.
     * </p>
     *
     * @return A Java Future containing the result of the ListPresets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListPresets
     */
    default CompletableFuture<ListPresetsResponse> listPresets() {
        return listPresets(ListPresetsRequest.builder().build());
    }

    /**
     * <p>
     * The ListPresets operation gets a list of the default presets included with Elastic Transcoder and the presets
     * that you've added in an AWS region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPresets(software.amazon.awssdk.services.elastictranscoder.model.ListPresetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListPresetsPublisher publisher = client.listPresetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListPresetsPublisher publisher = client.listPresetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPresets(software.amazon.awssdk.services.elastictranscoder.model.ListPresetsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListPresets
     */
    default ListPresetsPublisher listPresetsPaginator() {
        return listPresetsPaginator(ListPresetsRequest.builder().build());
    }

    /**
     * <p>
     * The ListPresets operation gets a list of the default presets included with Elastic Transcoder and the presets
     * that you've added in an AWS region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPresets(software.amazon.awssdk.services.elastictranscoder.model.ListPresetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListPresetsPublisher publisher = client.listPresetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListPresetsPublisher publisher = client.listPresetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPresets(software.amazon.awssdk.services.elastictranscoder.model.ListPresetsRequest)} operation.</b>
     * </p>
     *
     * @param listPresetsRequest
     *        The <code>ListPresetsRequest</code> structure.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListPresets
     */
    default ListPresetsPublisher listPresetsPaginator(ListPresetsRequest listPresetsRequest) {
        return new ListPresetsPublisher(this, listPresetsRequest);
    }

    /**
     * <p>
     * The ListPresets operation gets a list of the default presets included with Elastic Transcoder and the presets
     * that you've added in an AWS region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPresets(software.amazon.awssdk.services.elastictranscoder.model.ListPresetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListPresetsPublisher publisher = client.listPresetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elastictranscoder.paginators.ListPresetsPublisher publisher = client.listPresetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPresets(software.amazon.awssdk.services.elastictranscoder.model.ListPresetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPresetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPresetsRequest#builder()}
     * </p>
     *
     * @param listPresetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.ListPresetsRequest.Builder} to create a
     *        request. The <code>ListPresetsRequest</code> structure.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ListPresets
     */
    default ListPresetsPublisher listPresetsPaginator(Consumer<ListPresetsRequest.Builder> listPresetsRequest) {
        return listPresetsPaginator(ListPresetsRequest.builder().applyMutation(listPresetsRequest).build());
    }

    /**
     * <p>
     * The ReadJob operation returns detailed information about a job.
     * </p>
     *
     * @param readJobRequest
     *        The <code>ReadJobRequest</code> structure.
     * @return A Java Future containing the result of the ReadJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ReadJob
     */
    default CompletableFuture<ReadJobResponse> readJob(ReadJobRequest readJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ReadJob operation returns detailed information about a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReadJobRequest.Builder} avoiding the need to create
     * one manually via {@link ReadJobRequest#builder()}
     * </p>
     *
     * @param readJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.ReadJobRequest.Builder} to create a
     *        request. The <code>ReadJobRequest</code> structure.
     * @return A Java Future containing the result of the ReadJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ReadJob
     */
    default CompletableFuture<ReadJobResponse> readJob(Consumer<ReadJobRequest.Builder> readJobRequest) {
        return readJob(ReadJobRequest.builder().applyMutation(readJobRequest).build());
    }

    /**
     * <p>
     * The ReadPipeline operation gets detailed information about a pipeline.
     * </p>
     *
     * @param readPipelineRequest
     *        The <code>ReadPipelineRequest</code> structure.
     * @return A Java Future containing the result of the ReadPipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ReadPipeline
     */
    default CompletableFuture<ReadPipelineResponse> readPipeline(ReadPipelineRequest readPipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ReadPipeline operation gets detailed information about a pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReadPipelineRequest.Builder} avoiding the need to
     * create one manually via {@link ReadPipelineRequest#builder()}
     * </p>
     *
     * @param readPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineRequest.Builder} to create a
     *        request. The <code>ReadPipelineRequest</code> structure.
     * @return A Java Future containing the result of the ReadPipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ReadPipeline
     */
    default CompletableFuture<ReadPipelineResponse> readPipeline(Consumer<ReadPipelineRequest.Builder> readPipelineRequest) {
        return readPipeline(ReadPipelineRequest.builder().applyMutation(readPipelineRequest).build());
    }

    /**
     * <p>
     * The ReadPreset operation gets detailed information about a preset.
     * </p>
     *
     * @param readPresetRequest
     *        The <code>ReadPresetRequest</code> structure.
     * @return A Java Future containing the result of the ReadPreset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ReadPreset
     */
    default CompletableFuture<ReadPresetResponse> readPreset(ReadPresetRequest readPresetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The ReadPreset operation gets detailed information about a preset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReadPresetRequest.Builder} avoiding the need to
     * create one manually via {@link ReadPresetRequest#builder()}
     * </p>
     *
     * @param readPresetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.ReadPresetRequest.Builder} to create a
     *        request. The <code>ReadPresetRequest</code> structure.
     * @return A Java Future containing the result of the ReadPreset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.ReadPreset
     */
    default CompletableFuture<ReadPresetResponse> readPreset(Consumer<ReadPresetRequest.Builder> readPresetRequest) {
        return readPreset(ReadPresetRequest.builder().applyMutation(readPresetRequest).build());
    }

    /**
     * <p>
     * Use the <code>UpdatePipeline</code> operation to update settings for a pipeline.
     * </p>
     * <important>
     * <p>
     * When you change pipeline settings, your changes take effect immediately. Jobs that you have already submitted and
     * that Elastic Transcoder has not started to process are affected in addition to jobs that you submit after you
     * change settings.
     * </p>
     * </important>
     *
     * @param updatePipelineRequest
     *        The <code>UpdatePipelineRequest</code> structure.
     * @return A Java Future containing the result of the UpdatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>ResourceInUseException The resource you are attempting to change is in use. For example, you are
     *         attempting to delete a pipeline that is currently in use.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.UpdatePipeline
     */
    default CompletableFuture<UpdatePipelineResponse> updatePipeline(UpdatePipelineRequest updatePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use the <code>UpdatePipeline</code> operation to update settings for a pipeline.
     * </p>
     * <important>
     * <p>
     * When you change pipeline settings, your changes take effect immediately. Jobs that you have already submitted and
     * that Elastic Transcoder has not started to process are affected in addition to jobs that you submit after you
     * change settings.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePipelineRequest#builder()}
     * </p>
     *
     * @param updatePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineRequest.Builder} to create a
     *        request. The <code>UpdatePipelineRequest</code> structure.
     * @return A Java Future containing the result of the UpdatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>ResourceInUseException The resource you are attempting to change is in use. For example, you are
     *         attempting to delete a pipeline that is currently in use.</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.UpdatePipeline
     */
    default CompletableFuture<UpdatePipelineResponse> updatePipeline(Consumer<UpdatePipelineRequest.Builder> updatePipelineRequest) {
        return updatePipeline(UpdatePipelineRequest.builder().applyMutation(updatePipelineRequest).build());
    }

    /**
     * <p>
     * With the UpdatePipelineNotifications operation, you can update Amazon Simple Notification Service (Amazon SNS)
     * notifications for a pipeline.
     * </p>
     * <p>
     * When you update notifications for a pipeline, Elastic Transcoder returns the values that you specified in the
     * request.
     * </p>
     *
     * @param updatePipelineNotificationsRequest
     *        The <code>UpdatePipelineNotificationsRequest</code> structure.
     * @return A Java Future containing the result of the UpdatePipelineNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>ResourceInUseException The resource you are attempting to change is in use. For example, you are
     *         attempting to delete a pipeline that is currently in use.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.UpdatePipelineNotifications
     */
    default CompletableFuture<UpdatePipelineNotificationsResponse> updatePipelineNotifications(
            UpdatePipelineNotificationsRequest updatePipelineNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * With the UpdatePipelineNotifications operation, you can update Amazon Simple Notification Service (Amazon SNS)
     * notifications for a pipeline.
     * </p>
     * <p>
     * When you update notifications for a pipeline, Elastic Transcoder returns the values that you specified in the
     * request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePipelineNotificationsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdatePipelineNotificationsRequest#builder()}
     * </p>
     *
     * @param updatePipelineNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsRequest.Builder}
     *        to create a request. The <code>UpdatePipelineNotificationsRequest</code> structure.
     * @return A Java Future containing the result of the UpdatePipelineNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>ResourceInUseException The resource you are attempting to change is in use. For example, you are
     *         attempting to delete a pipeline that is currently in use.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.UpdatePipelineNotifications
     */
    default CompletableFuture<UpdatePipelineNotificationsResponse> updatePipelineNotifications(
            Consumer<UpdatePipelineNotificationsRequest.Builder> updatePipelineNotificationsRequest) {
        return updatePipelineNotifications(UpdatePipelineNotificationsRequest.builder()
                .applyMutation(updatePipelineNotificationsRequest).build());
    }

    /**
     * <p>
     * The UpdatePipelineStatus operation pauses or reactivates a pipeline, so that the pipeline stops or restarts the
     * processing of jobs.
     * </p>
     * <p>
     * Changing the pipeline status is useful if you want to cancel one or more jobs. You can't cancel jobs after
     * Elastic Transcoder has started processing them; if you pause the pipeline to which you submitted the jobs, you
     * have more time to get the job IDs for the jobs that you want to cancel, and to send a <a>CancelJob</a> request.
     * </p>
     *
     * @param updatePipelineStatusRequest
     *        The <code>UpdatePipelineStatusRequest</code> structure.
     * @return A Java Future containing the result of the UpdatePipelineStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>ResourceInUseException The resource you are attempting to change is in use. For example, you are
     *         attempting to delete a pipeline that is currently in use.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.UpdatePipelineStatus
     */
    default CompletableFuture<UpdatePipelineStatusResponse> updatePipelineStatus(
            UpdatePipelineStatusRequest updatePipelineStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The UpdatePipelineStatus operation pauses or reactivates a pipeline, so that the pipeline stops or restarts the
     * processing of jobs.
     * </p>
     * <p>
     * Changing the pipeline status is useful if you want to cancel one or more jobs. You can't cancel jobs after
     * Elastic Transcoder has started processing them; if you pause the pipeline to which you submitted the jobs, you
     * have more time to get the job IDs for the jobs that you want to cancel, and to send a <a>CancelJob</a> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePipelineStatusRequest.Builder} avoiding the
     * need to create one manually via {@link UpdatePipelineStatusRequest#builder()}
     * </p>
     *
     * @param updatePipelineStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusRequest.Builder} to
     *        create a request. The <code>UpdatePipelineStatusRequest</code> structure.
     * @return A Java Future containing the result of the UpdatePipelineStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more required parameter values were not provided in the request.</li>
     *         <li>IncompatibleVersionException</li>
     *         <li>ResourceNotFoundException The requested resource does not exist or is not available. For example, the
     *         pipeline to which you're trying to add a job doesn't exist or is still being created.</li>
     *         <li>ResourceInUseException The resource you are attempting to change is in use. For example, you are
     *         attempting to delete a pipeline that is currently in use.</li>
     *         <li>AccessDeniedException General authentication failure. The request was not signed correctly.</li>
     *         <li>InternalServiceException Elastic Transcoder encountered an unexpected exception while trying to
     *         fulfill the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticTranscoderException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ElasticTranscoderAsyncClient.UpdatePipelineStatus
     */
    default CompletableFuture<UpdatePipelineStatusResponse> updatePipelineStatus(
            Consumer<UpdatePipelineStatusRequest.Builder> updatePipelineStatusRequest) {
        return updatePipelineStatus(UpdatePipelineStatusRequest.builder().applyMutation(updatePipelineStatusRequest).build());
    }

    /**
     * Create an instance of {@link ElasticTranscoderAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link ElasticTranscoderAsyncWaiter}
     */
    default ElasticTranscoderAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default ElasticTranscoderServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ElasticTranscoderAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ElasticTranscoderAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ElasticTranscoderAsyncClient}.
     */
    static ElasticTranscoderAsyncClientBuilder builder() {
        return new DefaultElasticTranscoderAsyncClientBuilder();
    }
}
