/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The file to be used as album art. There can be multiple artworks associated with an audio file, to a maximum of 20.
 * </p>
 * <p>
 * To remove artwork or leave the artwork empty, you can either set <code>Artwork</code> to null, or set the
 * <code>Merge Policy</code> to "Replace" and use an empty <code>Artwork</code> array.
 * </p>
 * <p>
 * To pass through existing artwork unchanged, set the <code>Merge Policy</code> to "Prepend", "Append", or "Fallback",
 * and use an empty <code>Artwork</code> array.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Artwork implements SdkPojo, Serializable, ToCopyableBuilder<Artwork.Builder, Artwork> {
    private static final SdkField<String> INPUT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputKey").getter(getter(Artwork::inputKey)).setter(setter(Builder::inputKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputKey").build()).build();

    private static final SdkField<String> MAX_WIDTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxWidth").getter(getter(Artwork::maxWidth)).setter(setter(Builder::maxWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWidth").build()).build();

    private static final SdkField<String> MAX_HEIGHT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxHeight").getter(getter(Artwork::maxHeight)).setter(setter(Builder::maxHeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxHeight").build()).build();

    private static final SdkField<String> SIZING_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SizingPolicy").getter(getter(Artwork::sizingPolicy)).setter(setter(Builder::sizingPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizingPolicy").build()).build();

    private static final SdkField<String> PADDING_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaddingPolicy").getter(getter(Artwork::paddingPolicy)).setter(setter(Builder::paddingPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaddingPolicy").build()).build();

    private static final SdkField<String> ALBUM_ART_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlbumArtFormat").getter(getter(Artwork::albumArtFormat)).setter(setter(Builder::albumArtFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlbumArtFormat").build()).build();

    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .memberName("Encryption").getter(getter(Artwork::encryption)).setter(setter(Builder::encryption))
            .constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_KEY_FIELD,
            MAX_WIDTH_FIELD, MAX_HEIGHT_FIELD, SIZING_POLICY_FIELD, PADDING_POLICY_FIELD, ALBUM_ART_FORMAT_FIELD,
            ENCRYPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputKey;

    private final String maxWidth;

    private final String maxHeight;

    private final String sizingPolicy;

    private final String paddingPolicy;

    private final String albumArtFormat;

    private final Encryption encryption;

    private Artwork(BuilderImpl builder) {
        this.inputKey = builder.inputKey;
        this.maxWidth = builder.maxWidth;
        this.maxHeight = builder.maxHeight;
        this.sizingPolicy = builder.sizingPolicy;
        this.paddingPolicy = builder.paddingPolicy;
        this.albumArtFormat = builder.albumArtFormat;
        this.encryption = builder.encryption;
    }

    /**
     * <p>
     * The name of the file to be used as album art. To determine which Amazon S3 bucket contains the specified file,
     * Elastic Transcoder checks the pipeline specified by <code>PipelineId</code>; the <code>InputBucket</code> object
     * in that pipeline identifies the bucket.
     * </p>
     * <p>
     * If the file name includes a prefix, for example, <code>cooking/pie.jpg</code>, include the prefix in the key. If
     * the file isn't in the specified bucket, Elastic Transcoder returns an error.
     * </p>
     * 
     * @return The name of the file to be used as album art. To determine which Amazon S3 bucket contains the specified
     *         file, Elastic Transcoder checks the pipeline specified by <code>PipelineId</code>; the
     *         <code>InputBucket</code> object in that pipeline identifies the bucket.</p>
     *         <p>
     *         If the file name includes a prefix, for example, <code>cooking/pie.jpg</code>, include the prefix in the
     *         key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.
     */
    public final String inputKey() {
        return inputKey;
    }

    /**
     * <p>
     * The maximum width of the output album art in pixels. If you specify <code>auto</code>, Elastic Transcoder uses
     * 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 4096, inclusive.
     * </p>
     * 
     * @return The maximum width of the output album art in pixels. If you specify <code>auto</code>, Elastic Transcoder
     *         uses 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 4096,
     *         inclusive.
     */
    public final String maxWidth() {
        return maxWidth;
    }

    /**
     * <p>
     * The maximum height of the output album art in pixels. If you specify <code>auto</code>, Elastic Transcoder uses
     * 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 3072, inclusive.
     * </p>
     * 
     * @return The maximum height of the output album art in pixels. If you specify <code>auto</code>, Elastic
     *         Transcoder uses 600 as the default value. If you specify a numeric value, enter an even integer between
     *         32 and 3072, inclusive.
     */
    public final String maxHeight() {
        return maxHeight;
    }

    /**
     * <p>
     * Specify one of the following values to control scaling of the output album art:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Fit:</code> Elastic Transcoder scales the output art so it matches the value that you specified in either
     * <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Fill:</code> Elastic Transcoder scales the output art so it matches the value that you specified in either
     * <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other value. Elastic Transcoder
     * centers the output art and then crops it in the dimension (if any) that exceeds the maximum value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stretch:</code> Elastic Transcoder stretches the output art to match the values that you specified for
     * <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the input art and the output art
     * are different, the output art will be distorted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Keep:</code> Elastic Transcoder does not scale the output art. If either dimension of the input art exceeds
     * the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>, Elastic Transcoder crops the
     * output art.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ShrinkToFit:</code> Elastic Transcoder scales the output art down so that its dimensions match the values
     * that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either
     * value. If you specify this option, Elastic Transcoder does not scale the art up.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ShrinkToFill</code> Elastic Transcoder scales the output art down so that its dimensions match the values
     * that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without dropping below
     * either value. If you specify this option, Elastic Transcoder does not scale the art up.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specify one of the following values to control scaling of the output album art:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Fit:</code> Elastic Transcoder scales the output art so it matches the value that you specified in
     *         either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Fill:</code> Elastic Transcoder scales the output art so it matches the value that you specified in
     *         either <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other value. Elastic
     *         Transcoder centers the output art and then crops it in the dimension (if any) that exceeds the maximum
     *         value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stretch:</code> Elastic Transcoder stretches the output art to match the values that you specified
     *         for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the input art and
     *         the output art are different, the output art will be distorted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Keep:</code> Elastic Transcoder does not scale the output art. If either dimension of the input art
     *         exceeds the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>, Elastic
     *         Transcoder crops the output art.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ShrinkToFit:</code> Elastic Transcoder scales the output art down so that its dimensions match the
     *         values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without
     *         exceeding either value. If you specify this option, Elastic Transcoder does not scale the art up.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ShrinkToFill</code> Elastic Transcoder scales the output art down so that its dimensions match the
     *         values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without
     *         dropping below either value. If you specify this option, Elastic Transcoder does not scale the art up.
     *         </p>
     *         </li>
     */
    public final String sizingPolicy() {
        return sizingPolicy;
    }

    /**
     * <p>
     * When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add white bars to the top and
     * bottom and/or left and right sides of the output album art to make the total size of the output art match the
     * values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.
     * </p>
     * 
     * @return When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add white bars to the
     *         top and bottom and/or left and right sides of the output album art to make the total size of the output
     *         art match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.
     */
    public final String paddingPolicy() {
        return paddingPolicy;
    }

    /**
     * <p>
     * The format of album art, if any. Valid formats are <code>.jpg</code> and <code>.png</code>.
     * </p>
     * 
     * @return The format of album art, if any. Valid formats are <code>.jpg</code> and <code>.png</code>.
     */
    public final String albumArtFormat() {
        return albumArtFormat;
    }

    /**
     * <p>
     * The encryption settings, if any, that you want Elastic Transcoder to apply to your artwork.
     * </p>
     * 
     * @return The encryption settings, if any, that you want Elastic Transcoder to apply to your artwork.
     */
    public final Encryption encryption() {
        return encryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputKey());
        hashCode = 31 * hashCode + Objects.hashCode(maxWidth());
        hashCode = 31 * hashCode + Objects.hashCode(maxHeight());
        hashCode = 31 * hashCode + Objects.hashCode(sizingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(paddingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(albumArtFormat());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Artwork)) {
            return false;
        }
        Artwork other = (Artwork) obj;
        return Objects.equals(inputKey(), other.inputKey()) && Objects.equals(maxWidth(), other.maxWidth())
                && Objects.equals(maxHeight(), other.maxHeight()) && Objects.equals(sizingPolicy(), other.sizingPolicy())
                && Objects.equals(paddingPolicy(), other.paddingPolicy())
                && Objects.equals(albumArtFormat(), other.albumArtFormat()) && Objects.equals(encryption(), other.encryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Artwork").add("InputKey", inputKey()).add("MaxWidth", maxWidth()).add("MaxHeight", maxHeight())
                .add("SizingPolicy", sizingPolicy()).add("PaddingPolicy", paddingPolicy())
                .add("AlbumArtFormat", albumArtFormat()).add("Encryption", encryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputKey":
            return Optional.ofNullable(clazz.cast(inputKey()));
        case "MaxWidth":
            return Optional.ofNullable(clazz.cast(maxWidth()));
        case "MaxHeight":
            return Optional.ofNullable(clazz.cast(maxHeight()));
        case "SizingPolicy":
            return Optional.ofNullable(clazz.cast(sizingPolicy()));
        case "PaddingPolicy":
            return Optional.ofNullable(clazz.cast(paddingPolicy()));
        case "AlbumArtFormat":
            return Optional.ofNullable(clazz.cast(albumArtFormat()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Artwork, T> g) {
        return obj -> g.apply((Artwork) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Artwork> {
        /**
         * <p>
         * The name of the file to be used as album art. To determine which Amazon S3 bucket contains the specified
         * file, Elastic Transcoder checks the pipeline specified by <code>PipelineId</code>; the
         * <code>InputBucket</code> object in that pipeline identifies the bucket.
         * </p>
         * <p>
         * If the file name includes a prefix, for example, <code>cooking/pie.jpg</code>, include the prefix in the key.
         * If the file isn't in the specified bucket, Elastic Transcoder returns an error.
         * </p>
         * 
         * @param inputKey
         *        The name of the file to be used as album art. To determine which Amazon S3 bucket contains the
         *        specified file, Elastic Transcoder checks the pipeline specified by <code>PipelineId</code>; the
         *        <code>InputBucket</code> object in that pipeline identifies the bucket.</p>
         *        <p>
         *        If the file name includes a prefix, for example, <code>cooking/pie.jpg</code>, include the prefix in
         *        the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputKey(String inputKey);

        /**
         * <p>
         * The maximum width of the output album art in pixels. If you specify <code>auto</code>, Elastic Transcoder
         * uses 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 4096,
         * inclusive.
         * </p>
         * 
         * @param maxWidth
         *        The maximum width of the output album art in pixels. If you specify <code>auto</code>, Elastic
         *        Transcoder uses 600 as the default value. If you specify a numeric value, enter an even integer
         *        between 32 and 4096, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWidth(String maxWidth);

        /**
         * <p>
         * The maximum height of the output album art in pixels. If you specify <code>auto</code>, Elastic Transcoder
         * uses 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 3072,
         * inclusive.
         * </p>
         * 
         * @param maxHeight
         *        The maximum height of the output album art in pixels. If you specify <code>auto</code>, Elastic
         *        Transcoder uses 600 as the default value. If you specify a numeric value, enter an even integer
         *        between 32 and 3072, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxHeight(String maxHeight);

        /**
         * <p>
         * Specify one of the following values to control scaling of the output album art:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Fit:</code> Elastic Transcoder scales the output art so it matches the value that you specified in
         * either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Fill:</code> Elastic Transcoder scales the output art so it matches the value that you specified in
         * either <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other value. Elastic
         * Transcoder centers the output art and then crops it in the dimension (if any) that exceeds the maximum value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stretch:</code> Elastic Transcoder stretches the output art to match the values that you specified for
         * <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the input art and the output
         * art are different, the output art will be distorted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Keep:</code> Elastic Transcoder does not scale the output art. If either dimension of the input art
         * exceeds the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>, Elastic
         * Transcoder crops the output art.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ShrinkToFit:</code> Elastic Transcoder scales the output art down so that its dimensions match the
         * values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without
         * exceeding either value. If you specify this option, Elastic Transcoder does not scale the art up.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ShrinkToFill</code> Elastic Transcoder scales the output art down so that its dimensions match the
         * values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without
         * dropping below either value. If you specify this option, Elastic Transcoder does not scale the art up.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sizingPolicy
         *        Specify one of the following values to control scaling of the output album art:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Fit:</code> Elastic Transcoder scales the output art so it matches the value that you specified
         *        in either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Fill:</code> Elastic Transcoder scales the output art so it matches the value that you specified
         *        in either <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other value.
         *        Elastic Transcoder centers the output art and then crops it in the dimension (if any) that exceeds the
         *        maximum value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stretch:</code> Elastic Transcoder stretches the output art to match the values that you
         *        specified for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the
         *        input art and the output art are different, the output art will be distorted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Keep:</code> Elastic Transcoder does not scale the output art. If either dimension of the input
         *        art exceeds the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>,
         *        Elastic Transcoder crops the output art.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ShrinkToFit:</code> Elastic Transcoder scales the output art down so that its dimensions match
         *        the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code>
         *        without exceeding either value. If you specify this option, Elastic Transcoder does not scale the art
         *        up.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ShrinkToFill</code> Elastic Transcoder scales the output art down so that its dimensions match
         *        the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code>
         *        without dropping below either value. If you specify this option, Elastic Transcoder does not scale the
         *        art up.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizingPolicy(String sizingPolicy);

        /**
         * <p>
         * When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add white bars to the top
         * and bottom and/or left and right sides of the output album art to make the total size of the output art match
         * the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.
         * </p>
         * 
         * @param paddingPolicy
         *        When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add white bars to
         *        the top and bottom and/or left and right sides of the output album art to make the total size of the
         *        output art match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paddingPolicy(String paddingPolicy);

        /**
         * <p>
         * The format of album art, if any. Valid formats are <code>.jpg</code> and <code>.png</code>.
         * </p>
         * 
         * @param albumArtFormat
         *        The format of album art, if any. Valid formats are <code>.jpg</code> and <code>.png</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder albumArtFormat(String albumArtFormat);

        /**
         * <p>
         * The encryption settings, if any, that you want Elastic Transcoder to apply to your artwork.
         * </p>
         * 
         * @param encryption
         *        The encryption settings, if any, that you want Elastic Transcoder to apply to your artwork.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(Encryption encryption);

        /**
         * <p>
         * The encryption settings, if any, that you want Elastic Transcoder to apply to your artwork.
         * </p>
         * This is a convenience method that creates an instance of the {@link Encryption.Builder} avoiding the need to
         * create one manually via {@link Encryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #encryption(Encryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(Encryption)
         */
        default Builder encryption(Consumer<Encryption.Builder> encryption) {
            return encryption(Encryption.builder().applyMutation(encryption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String inputKey;

        private String maxWidth;

        private String maxHeight;

        private String sizingPolicy;

        private String paddingPolicy;

        private String albumArtFormat;

        private Encryption encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(Artwork model) {
            inputKey(model.inputKey);
            maxWidth(model.maxWidth);
            maxHeight(model.maxHeight);
            sizingPolicy(model.sizingPolicy);
            paddingPolicy(model.paddingPolicy);
            albumArtFormat(model.albumArtFormat);
            encryption(model.encryption);
        }

        public final String getInputKey() {
            return inputKey;
        }

        public final void setInputKey(String inputKey) {
            this.inputKey = inputKey;
        }

        @Override
        public final Builder inputKey(String inputKey) {
            this.inputKey = inputKey;
            return this;
        }

        public final String getMaxWidth() {
            return maxWidth;
        }

        public final void setMaxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
        }

        @Override
        public final Builder maxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public final String getMaxHeight() {
            return maxHeight;
        }

        public final void setMaxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
        }

        @Override
        public final Builder maxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
            return this;
        }

        public final String getSizingPolicy() {
            return sizingPolicy;
        }

        public final void setSizingPolicy(String sizingPolicy) {
            this.sizingPolicy = sizingPolicy;
        }

        @Override
        public final Builder sizingPolicy(String sizingPolicy) {
            this.sizingPolicy = sizingPolicy;
            return this;
        }

        public final String getPaddingPolicy() {
            return paddingPolicy;
        }

        public final void setPaddingPolicy(String paddingPolicy) {
            this.paddingPolicy = paddingPolicy;
        }

        @Override
        public final Builder paddingPolicy(String paddingPolicy) {
            this.paddingPolicy = paddingPolicy;
            return this;
        }

        public final String getAlbumArtFormat() {
            return albumArtFormat;
        }

        public final void setAlbumArtFormat(String albumArtFormat) {
            this.albumArtFormat = albumArtFormat;
        }

        @Override
        public final Builder albumArtFormat(String albumArtFormat) {
            this.albumArtFormat = albumArtFormat;
            return this;
        }

        public final Encryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        @Override
        public Artwork build() {
            return new Artwork(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
