/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderClient;
import software.amazon.awssdk.services.elastictranscoder.internal.UserAgentUtils;
import software.amazon.awssdk.services.elastictranscoder.model.Job;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusResponse;

public class ListJobsByStatusIterable
implements SdkIterable<ListJobsByStatusResponse> {
    private final ElasticTranscoderClient client;
    private final ListJobsByStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobsByStatusIterable(ElasticTranscoderClient client, ListJobsByStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListJobsByStatusResponseFetcher();
    }

    public Iterator<ListJobsByStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Job> jobs() {
        Function<ListJobsByStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListJobsByStatusResponseFetcher
    implements SyncPageFetcher<ListJobsByStatusResponse> {
        private ListJobsByStatusResponseFetcher() {
        }

        public boolean hasNextPage(ListJobsByStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListJobsByStatusResponse nextPage(ListJobsByStatusResponse previousPage) {
            if (previousPage == null) {
                return ListJobsByStatusIterable.this.client.listJobsByStatus(ListJobsByStatusIterable.this.firstRequest);
            }
            return ListJobsByStatusIterable.this.client.listJobsByStatus((ListJobsByStatusRequest)((Object)ListJobsByStatusIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

