/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStudioRequest extends EmrRequest implements
        ToCopyableBuilder<CreateStudioRequest.Builder, CreateStudioRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateStudioRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateStudioRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> AUTH_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthMode").getter(getter(CreateStudioRequest::authModeAsString)).setter(setter(Builder::authMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthMode").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(CreateStudioRequest::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(CreateStudioRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRole").getter(getter(CreateStudioRequest::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()).build();

    private static final SdkField<String> USER_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserRole").getter(getter(CreateStudioRequest::userRole)).setter(setter(Builder::userRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRole").build()).build();

    private static final SdkField<String> WORKSPACE_SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceSecurityGroupId").getter(getter(CreateStudioRequest::workspaceSecurityGroupId))
            .setter(setter(Builder::workspaceSecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceSecurityGroupId").build())
            .build();

    private static final SdkField<String> ENGINE_SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineSecurityGroupId").getter(getter(CreateStudioRequest::engineSecurityGroupId))
            .setter(setter(Builder::engineSecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineSecurityGroupId").build())
            .build();

    private static final SdkField<String> DEFAULT_S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultS3Location").getter(getter(CreateStudioRequest::defaultS3Location))
            .setter(setter(Builder::defaultS3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultS3Location").build()).build();

    private static final SdkField<String> IDP_AUTH_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdpAuthUrl").getter(getter(CreateStudioRequest::idpAuthUrl)).setter(setter(Builder::idpAuthUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdpAuthUrl").build()).build();

    private static final SdkField<String> IDP_RELAY_STATE_PARAMETER_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdpRelayStateParameterName")
            .getter(getter(CreateStudioRequest::idpRelayStateParameterName))
            .setter(setter(Builder::idpRelayStateParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdpRelayStateParameterName").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateStudioRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            AUTH_MODE_FIELD, VPC_ID_FIELD, SUBNET_IDS_FIELD, SERVICE_ROLE_FIELD, USER_ROLE_FIELD,
            WORKSPACE_SECURITY_GROUP_ID_FIELD, ENGINE_SECURITY_GROUP_ID_FIELD, DEFAULT_S3_LOCATION_FIELD, IDP_AUTH_URL_FIELD,
            IDP_RELAY_STATE_PARAMETER_NAME_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final String authMode;

    private final String vpcId;

    private final List<String> subnetIds;

    private final String serviceRole;

    private final String userRole;

    private final String workspaceSecurityGroupId;

    private final String engineSecurityGroupId;

    private final String defaultS3Location;

    private final String idpAuthUrl;

    private final String idpRelayStateParameterName;

    private final List<Tag> tags;

    private CreateStudioRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.authMode = builder.authMode;
        this.vpcId = builder.vpcId;
        this.subnetIds = builder.subnetIds;
        this.serviceRole = builder.serviceRole;
        this.userRole = builder.userRole;
        this.workspaceSecurityGroupId = builder.workspaceSecurityGroupId;
        this.engineSecurityGroupId = builder.engineSecurityGroupId;
        this.defaultS3Location = builder.defaultS3Location;
        this.idpAuthUrl = builder.idpAuthUrl;
        this.idpRelayStateParameterName = builder.idpRelayStateParameterName;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A descriptive name for the Amazon EMR Studio.
     * </p>
     * 
     * @return A descriptive name for the Amazon EMR Studio.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A detailed description of the Amazon EMR Studio.
     * </p>
     * 
     * @return A detailed description of the Amazon EMR Studio.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMode} will
     * return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authModeAsString}.
     * </p>
     * 
     * @return Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.
     * @see AuthMode
     */
    public final AuthMode authMode() {
        return AuthMode.fromValue(authMode);
    }

    /**
     * <p>
     * Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMode} will
     * return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authModeAsString}.
     * </p>
     * 
     * @return Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.
     * @see AuthMode
     */
    public final String authModeAsString() {
        return authMode;
    }

    /**
     * <p>
     * The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
     * </p>
     * 
     * @return The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The
     * subnets must belong to the VPC specified by <code>VpcId</code>. Studio users can create a Workspace in any of the
     * specified subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets.
     *         The subnets must belong to the VPC specified by <code>VpcId</code>. Studio users can create a Workspace
     *         in any of the specified subnets.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to
     * interoperate with other Amazon Web Services services.
     * </p>
     * 
     * @return The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to
     *         interoperate with other Amazon Web Services services.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a
     * <code>UserRole</code> when you use Amazon Web Services SSO authentication. The permissions attached to the
     * <code>UserRole</code> can be scoped down for each user or group using session policies.
     * </p>
     * 
     * @return The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a
     *         <code>UserRole</code> when you use Amazon Web Services SSO authentication. The permissions attached to
     *         the <code>UserRole</code> can be scoped down for each user or group using session policies.
     */
    public final String userRole() {
        return userRole;
    }

    /**
     * <p>
     * The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network
     * traffic to resources in the Engine security group, and it must be in the same VPC specified by <code>VpcId</code>
     * .
     * </p>
     * 
     * @return The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound
     *         network traffic to resources in the Engine security group, and it must be in the same VPC specified by
     *         <code>VpcId</code>.
     */
    public final String workspaceSecurityGroupId() {
        return workspaceSecurityGroupId;
    }

    /**
     * <p>
     * The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic
     * from the Workspace security group, and it must be in the same VPC specified by <code>VpcId</code>.
     * </p>
     * 
     * @return The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network
     *         traffic from the Workspace security group, and it must be in the same VPC specified by <code>VpcId</code>
     *         .
     */
    public final String engineSecurityGroupId() {
        return engineSecurityGroupId;
    }

    /**
     * <p>
     * The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
     * </p>
     * 
     * @return The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
     */
    public final String defaultS3Location() {
        return defaultS3Location;
    }

    /**
     * <p>
     * The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication
     * and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR
     * Studio redirects users to this endpoint to enter credentials.
     * </p>
     * 
     * @return The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM
     *         authentication and want to let federated users log in to a Studio with the Studio URL and credentials
     *         from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
     */
    public final String idpAuthUrl() {
        return idpAuthUrl;
    }

    /**
     * <p>
     * The name that your identity provider (IdP) uses for its <code>RelayState</code> parameter. For example,
     * <code>RelayState</code> or <code>TargetSource</code>. Specify this value when you use IAM authentication and want
     * to let federated users log in to a Studio using the Studio URL. The <code>RelayState</code> parameter differs by
     * IdP.
     * </p>
     * 
     * @return The name that your identity provider (IdP) uses for its <code>RelayState</code> parameter. For example,
     *         <code>RelayState</code> or <code>TargetSource</code>. Specify this value when you use IAM authentication
     *         and want to let federated users log in to a Studio using the Studio URL. The <code>RelayState</code>
     *         parameter differs by IdP.
     */
    public final String idpRelayStateParameterName() {
        return idpRelayStateParameterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that consist of a
     * required key string with a maximum of 128 characters, and an optional value string with a maximum of 256
     * characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that
     *         consist of a required key string with a maximum of 128 characters, and an optional value string with a
     *         maximum of 256 characters.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(authModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(userRole());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(engineSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(defaultS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(idpAuthUrl());
        hashCode = 31 * hashCode + Objects.hashCode(idpRelayStateParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStudioRequest)) {
            return false;
        }
        CreateStudioRequest other = (CreateStudioRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(authModeAsString(), other.authModeAsString()) && Objects.equals(vpcId(), other.vpcId())
                && hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(serviceRole(), other.serviceRole()) && Objects.equals(userRole(), other.userRole())
                && Objects.equals(workspaceSecurityGroupId(), other.workspaceSecurityGroupId())
                && Objects.equals(engineSecurityGroupId(), other.engineSecurityGroupId())
                && Objects.equals(defaultS3Location(), other.defaultS3Location())
                && Objects.equals(idpAuthUrl(), other.idpAuthUrl())
                && Objects.equals(idpRelayStateParameterName(), other.idpRelayStateParameterName())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStudioRequest").add("Name", name()).add("Description", description())
                .add("AuthMode", authModeAsString()).add("VpcId", vpcId()).add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("ServiceRole", serviceRole()).add("UserRole", userRole())
                .add("WorkspaceSecurityGroupId", workspaceSecurityGroupId())
                .add("EngineSecurityGroupId", engineSecurityGroupId()).add("DefaultS3Location", defaultS3Location())
                .add("IdpAuthUrl", idpAuthUrl()).add("IdpRelayStateParameterName", idpRelayStateParameterName())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AuthMode":
            return Optional.ofNullable(clazz.cast(authModeAsString()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "UserRole":
            return Optional.ofNullable(clazz.cast(userRole()));
        case "WorkspaceSecurityGroupId":
            return Optional.ofNullable(clazz.cast(workspaceSecurityGroupId()));
        case "EngineSecurityGroupId":
            return Optional.ofNullable(clazz.cast(engineSecurityGroupId()));
        case "DefaultS3Location":
            return Optional.ofNullable(clazz.cast(defaultS3Location()));
        case "IdpAuthUrl":
            return Optional.ofNullable(clazz.cast(idpAuthUrl()));
        case "IdpRelayStateParameterName":
            return Optional.ofNullable(clazz.cast(idpRelayStateParameterName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStudioRequest, T> g) {
        return obj -> g.apply((CreateStudioRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStudioRequest> {
        /**
         * <p>
         * A descriptive name for the Amazon EMR Studio.
         * </p>
         * 
         * @param name
         *        A descriptive name for the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A detailed description of the Amazon EMR Studio.
         * </p>
         * 
         * @param description
         *        A detailed description of the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.
         * </p>
         * 
         * @param authMode
         *        Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder authMode(String authMode);

        /**
         * <p>
         * Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.
         * </p>
         * 
         * @param authMode
         *        Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder authMode(AuthMode authMode);

        /**
         * <p>
         * The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
         * </p>
         * 
         * @param vpcId
         *        The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The
         * subnets must belong to the VPC specified by <code>VpcId</code>. Studio users can create a Workspace in any of
         * the specified subnets.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5
         *        subnets. The subnets must belong to the VPC specified by <code>VpcId</code>. Studio users can create a
         *        Workspace in any of the specified subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The
         * subnets must belong to the VPC specified by <code>VpcId</code>. Studio users can create a Workspace in any of
         * the specified subnets.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5
         *        subnets. The subnets must belong to the VPC specified by <code>VpcId</code>. Studio users can create a
         *        Workspace in any of the specified subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to
         * interoperate with other Amazon Web Services services.
         * </p>
         * 
         * @param serviceRole
         *        The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio
         *        to interoperate with other Amazon Web Services services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a
         * <code>UserRole</code> when you use Amazon Web Services SSO authentication. The permissions attached to the
         * <code>UserRole</code> can be scoped down for each user or group using session policies.
         * </p>
         * 
         * @param userRole
         *        The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a
         *        <code>UserRole</code> when you use Amazon Web Services SSO authentication. The permissions attached to
         *        the <code>UserRole</code> can be scoped down for each user or group using session policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userRole(String userRole);

        /**
         * <p>
         * The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound
         * network traffic to resources in the Engine security group, and it must be in the same VPC specified by
         * <code>VpcId</code>.
         * </p>
         * 
         * @param workspaceSecurityGroupId
         *        The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound
         *        network traffic to resources in the Engine security group, and it must be in the same VPC specified by
         *        <code>VpcId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceSecurityGroupId(String workspaceSecurityGroupId);

        /**
         * <p>
         * The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network
         * traffic from the Workspace security group, and it must be in the same VPC specified by <code>VpcId</code>.
         * </p>
         * 
         * @param engineSecurityGroupId
         *        The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound
         *        network traffic from the Workspace security group, and it must be in the same VPC specified by
         *        <code>VpcId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineSecurityGroupId(String engineSecurityGroupId);

        /**
         * <p>
         * The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
         * </p>
         * 
         * @param defaultS3Location
         *        The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultS3Location(String defaultS3Location);

        /**
         * <p>
         * The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM
         * authentication and want to let federated users log in to a Studio with the Studio URL and credentials from
         * your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
         * </p>
         * 
         * @param idpAuthUrl
         *        The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM
         *        authentication and want to let federated users log in to a Studio with the Studio URL and credentials
         *        from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idpAuthUrl(String idpAuthUrl);

        /**
         * <p>
         * The name that your identity provider (IdP) uses for its <code>RelayState</code> parameter. For example,
         * <code>RelayState</code> or <code>TargetSource</code>. Specify this value when you use IAM authentication and
         * want to let federated users log in to a Studio using the Studio URL. The <code>RelayState</code> parameter
         * differs by IdP.
         * </p>
         * 
         * @param idpRelayStateParameterName
         *        The name that your identity provider (IdP) uses for its <code>RelayState</code> parameter. For
         *        example, <code>RelayState</code> or <code>TargetSource</code>. Specify this value when you use IAM
         *        authentication and want to let federated users log in to a Studio using the Studio URL. The
         *        <code>RelayState</code> parameter differs by IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idpRelayStateParameterName(String idpRelayStateParameterName);

        /**
         * <p>
         * A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that consist of
         * a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256
         * characters.
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that
         *        consist of a required key string with a maximum of 128 characters, and an optional value string with a
         *        maximum of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that consist of
         * a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256
         * characters.
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that
         *        consist of a required key string with a maximum of 128 characters, and an optional value string with a
         *        maximum of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that consist of
         * a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256
         * characters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.emr.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.emr.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.emr.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String authMode;

        private String vpcId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String serviceRole;

        private String userRole;

        private String workspaceSecurityGroupId;

        private String engineSecurityGroupId;

        private String defaultS3Location;

        private String idpAuthUrl;

        private String idpRelayStateParameterName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStudioRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            authMode(model.authMode);
            vpcId(model.vpcId);
            subnetIds(model.subnetIds);
            serviceRole(model.serviceRole);
            userRole(model.userRole);
            workspaceSecurityGroupId(model.workspaceSecurityGroupId);
            engineSecurityGroupId(model.engineSecurityGroupId);
            defaultS3Location(model.defaultS3Location);
            idpAuthUrl(model.idpAuthUrl);
            idpRelayStateParameterName(model.idpRelayStateParameterName);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAuthMode() {
            return authMode;
        }

        public final void setAuthMode(String authMode) {
            this.authMode = authMode;
        }

        @Override
        public final Builder authMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        @Override
        public final Builder authMode(AuthMode authMode) {
            this.authMode(authMode == null ? null : authMode.toString());
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final String getUserRole() {
            return userRole;
        }

        public final void setUserRole(String userRole) {
            this.userRole = userRole;
        }

        @Override
        public final Builder userRole(String userRole) {
            this.userRole = userRole;
            return this;
        }

        public final String getWorkspaceSecurityGroupId() {
            return workspaceSecurityGroupId;
        }

        public final void setWorkspaceSecurityGroupId(String workspaceSecurityGroupId) {
            this.workspaceSecurityGroupId = workspaceSecurityGroupId;
        }

        @Override
        public final Builder workspaceSecurityGroupId(String workspaceSecurityGroupId) {
            this.workspaceSecurityGroupId = workspaceSecurityGroupId;
            return this;
        }

        public final String getEngineSecurityGroupId() {
            return engineSecurityGroupId;
        }

        public final void setEngineSecurityGroupId(String engineSecurityGroupId) {
            this.engineSecurityGroupId = engineSecurityGroupId;
        }

        @Override
        public final Builder engineSecurityGroupId(String engineSecurityGroupId) {
            this.engineSecurityGroupId = engineSecurityGroupId;
            return this;
        }

        public final String getDefaultS3Location() {
            return defaultS3Location;
        }

        public final void setDefaultS3Location(String defaultS3Location) {
            this.defaultS3Location = defaultS3Location;
        }

        @Override
        public final Builder defaultS3Location(String defaultS3Location) {
            this.defaultS3Location = defaultS3Location;
            return this;
        }

        public final String getIdpAuthUrl() {
            return idpAuthUrl;
        }

        public final void setIdpAuthUrl(String idpAuthUrl) {
            this.idpAuthUrl = idpAuthUrl;
        }

        @Override
        public final Builder idpAuthUrl(String idpAuthUrl) {
            this.idpAuthUrl = idpAuthUrl;
            return this;
        }

        public final String getIdpRelayStateParameterName() {
            return idpRelayStateParameterName;
        }

        public final void setIdpRelayStateParameterName(String idpRelayStateParameterName) {
            this.idpRelayStateParameterName = idpRelayStateParameterName;
        }

        @Override
        public final Builder idpRelayStateParameterName(String idpRelayStateParameterName) {
            this.idpRelayStateParameterName = idpRelayStateParameterName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStudioRequest build() {
            return new CreateStudioRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
