/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAutoTerminationPolicyResponse extends EmrResponse implements
        ToCopyableBuilder<GetAutoTerminationPolicyResponse.Builder, GetAutoTerminationPolicyResponse> {
    private static final SdkField<AutoTerminationPolicy> AUTO_TERMINATION_POLICY_FIELD = SdkField
            .<AutoTerminationPolicy> builder(MarshallingType.SDK_POJO).memberName("AutoTerminationPolicy")
            .getter(getter(GetAutoTerminationPolicyResponse::autoTerminationPolicy))
            .setter(setter(Builder::autoTerminationPolicy)).constructor(AutoTerminationPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTerminationPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AUTO_TERMINATION_POLICY_FIELD));

    private final AutoTerminationPolicy autoTerminationPolicy;

    private GetAutoTerminationPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.autoTerminationPolicy = builder.autoTerminationPolicy;
    }

    /**
     * <p>
     * Specifies the auto-termination policy that is attached to an Amazon EMR cluster.
     * </p>
     * 
     * @return Specifies the auto-termination policy that is attached to an Amazon EMR cluster.
     */
    public final AutoTerminationPolicy autoTerminationPolicy() {
        return autoTerminationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoTerminationPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutoTerminationPolicyResponse)) {
            return false;
        }
        GetAutoTerminationPolicyResponse other = (GetAutoTerminationPolicyResponse) obj;
        return Objects.equals(autoTerminationPolicy(), other.autoTerminationPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAutoTerminationPolicyResponse").add("AutoTerminationPolicy", autoTerminationPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoTerminationPolicy":
            return Optional.ofNullable(clazz.cast(autoTerminationPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAutoTerminationPolicyResponse, T> g) {
        return obj -> g.apply((GetAutoTerminationPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAutoTerminationPolicyResponse> {
        /**
         * <p>
         * Specifies the auto-termination policy that is attached to an Amazon EMR cluster.
         * </p>
         * 
         * @param autoTerminationPolicy
         *        Specifies the auto-termination policy that is attached to an Amazon EMR cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoTerminationPolicy(AutoTerminationPolicy autoTerminationPolicy);

        /**
         * <p>
         * Specifies the auto-termination policy that is attached to an Amazon EMR cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoTerminationPolicy.Builder} avoiding
         * the need to create one manually via {@link AutoTerminationPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoTerminationPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #autoTerminationPolicy(AutoTerminationPolicy)}.
         * 
         * @param autoTerminationPolicy
         *        a consumer that will call methods on {@link AutoTerminationPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoTerminationPolicy(AutoTerminationPolicy)
         */
        default Builder autoTerminationPolicy(Consumer<AutoTerminationPolicy.Builder> autoTerminationPolicy) {
            return autoTerminationPolicy(AutoTerminationPolicy.builder().applyMutation(autoTerminationPolicy).build());
        }
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private AutoTerminationPolicy autoTerminationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutoTerminationPolicyResponse model) {
            super(model);
            autoTerminationPolicy(model.autoTerminationPolicy);
        }

        public final AutoTerminationPolicy.Builder getAutoTerminationPolicy() {
            return autoTerminationPolicy != null ? autoTerminationPolicy.toBuilder() : null;
        }

        public final void setAutoTerminationPolicy(AutoTerminationPolicy.BuilderImpl autoTerminationPolicy) {
            this.autoTerminationPolicy = autoTerminationPolicy != null ? autoTerminationPolicy.build() : null;
        }

        @Override
        public final Builder autoTerminationPolicy(AutoTerminationPolicy autoTerminationPolicy) {
            this.autoTerminationPolicy = autoTerminationPolicy;
            return this;
        }

        @Override
        public GetAutoTerminationPolicyResponse build() {
            return new GetAutoTerminationPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
