/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobTemplateRequest extends EmrContainersRequest implements
        ToCopyableBuilder<CreateJobTemplateRequest.Builder, CreateJobTemplateRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateJobTemplateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateJobTemplateRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<JobTemplateData> JOB_TEMPLATE_DATA_FIELD = SdkField
            .<JobTemplateData> builder(MarshallingType.SDK_POJO).memberName("jobTemplateData")
            .getter(getter(CreateJobTemplateRequest::jobTemplateData)).setter(setter(Builder::jobTemplateData))
            .constructor(JobTemplateData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplateData").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateJobTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(CreateJobTemplateRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CLIENT_TOKEN_FIELD, JOB_TEMPLATE_DATA_FIELD, TAGS_FIELD, KMS_KEY_ARN_FIELD));

    private final String name;

    private final String clientToken;

    private final JobTemplateData jobTemplateData;

    private final Map<String, String> tags;

    private final String kmsKeyArn;

    private CreateJobTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.clientToken = builder.clientToken;
        this.jobTemplateData = builder.jobTemplateData;
        this.tags = builder.tags;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The specified name of the job template.
     * </p>
     * 
     * @return The specified name of the job template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The client token of the job template.
     * </p>
     * 
     * @return The client token of the job template.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The job template data which holds values of StartJobRun API request.
     * </p>
     * 
     * @return The job template data which holds values of StartJobRun API request.
     */
    public final JobTemplateData jobTemplateData() {
        return jobTemplateData;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that are associated with the job template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that are associated with the job template.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The KMS key ARN used to encrypt the job template.
     * </p>
     * 
     * @return The KMS key ARN used to encrypt the job template.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(jobTemplateData());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobTemplateRequest)) {
            return false;
        }
        CreateJobTemplateRequest other = (CreateJobTemplateRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(jobTemplateData(), other.jobTemplateData()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateJobTemplateRequest").add("Name", name()).add("ClientToken", clientToken())
                .add("JobTemplateData", jobTemplateData()).add("Tags", hasTags() ? tags() : null).add("KmsKeyArn", kmsKeyArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "jobTemplateData":
            return Optional.ofNullable(clazz.cast(jobTemplateData()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobTemplateRequest, T> g) {
        return obj -> g.apply((CreateJobTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrContainersRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateJobTemplateRequest> {
        /**
         * <p>
         * The specified name of the job template.
         * </p>
         * 
         * @param name
         *        The specified name of the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The client token of the job template.
         * </p>
         * 
         * @param clientToken
         *        The client token of the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The job template data which holds values of StartJobRun API request.
         * </p>
         * 
         * @param jobTemplateData
         *        The job template data which holds values of StartJobRun API request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTemplateData(JobTemplateData jobTemplateData);

        /**
         * <p>
         * The job template data which holds values of StartJobRun API request.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobTemplateData.Builder} avoiding the
         * need to create one manually via {@link JobTemplateData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobTemplateData.Builder#build()} is called immediately and its
         * result is passed to {@link #jobTemplateData(JobTemplateData)}.
         * 
         * @param jobTemplateData
         *        a consumer that will call methods on {@link JobTemplateData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobTemplateData(JobTemplateData)
         */
        default Builder jobTemplateData(Consumer<JobTemplateData.Builder> jobTemplateData) {
            return jobTemplateData(JobTemplateData.builder().applyMutation(jobTemplateData).build());
        }

        /**
         * <p>
         * The tags that are associated with the job template.
         * </p>
         * 
         * @param tags
         *        The tags that are associated with the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The KMS key ARN used to encrypt the job template.
         * </p>
         * 
         * @param kmsKeyArn
         *        The KMS key ARN used to encrypt the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrContainersRequest.BuilderImpl implements Builder {
        private String name;

        private String clientToken;

        private JobTemplateData jobTemplateData;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobTemplateRequest model) {
            super(model);
            name(model.name);
            clientToken(model.clientToken);
            jobTemplateData(model.jobTemplateData);
            tags(model.tags);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final JobTemplateData.Builder getJobTemplateData() {
            return jobTemplateData != null ? jobTemplateData.toBuilder() : null;
        }

        public final void setJobTemplateData(JobTemplateData.BuilderImpl jobTemplateData) {
            this.jobTemplateData = jobTemplateData != null ? jobTemplateData.build() : null;
        }

        @Override
        public final Builder jobTemplateData(JobTemplateData jobTemplateData) {
            this.jobTemplateData = jobTemplateData;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobTemplateRequest build() {
            return new CreateJobTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
