/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current status of the retry policy executed on the job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetryPolicyExecution implements SdkPojo, Serializable,
        ToCopyableBuilder<RetryPolicyExecution.Builder, RetryPolicyExecution> {
    private static final SdkField<Integer> CURRENT_ATTEMPT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("currentAttemptCount").getter(getter(RetryPolicyExecution::currentAttemptCount))
            .setter(setter(Builder::currentAttemptCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentAttemptCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_ATTEMPT_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer currentAttemptCount;

    private RetryPolicyExecution(BuilderImpl builder) {
        this.currentAttemptCount = builder.currentAttemptCount;
    }

    /**
     * <p>
     * The current number of attempts made on the driver of the job.
     * </p>
     * 
     * @return The current number of attempts made on the driver of the job.
     */
    public final Integer currentAttemptCount() {
        return currentAttemptCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currentAttemptCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryPolicyExecution)) {
            return false;
        }
        RetryPolicyExecution other = (RetryPolicyExecution) obj;
        return Objects.equals(currentAttemptCount(), other.currentAttemptCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetryPolicyExecution").add("CurrentAttemptCount", currentAttemptCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "currentAttemptCount":
            return Optional.ofNullable(clazz.cast(currentAttemptCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryPolicyExecution, T> g) {
        return obj -> g.apply((RetryPolicyExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetryPolicyExecution> {
        /**
         * <p>
         * The current number of attempts made on the driver of the job.
         * </p>
         * 
         * @param currentAttemptCount
         *        The current number of attempts made on the driver of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentAttemptCount(Integer currentAttemptCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer currentAttemptCount;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryPolicyExecution model) {
            currentAttemptCount(model.currentAttemptCount);
        }

        public final Integer getCurrentAttemptCount() {
            return currentAttemptCount;
        }

        public final void setCurrentAttemptCount(Integer currentAttemptCount) {
            this.currentAttemptCount = currentAttemptCount;
        }

        @Override
        public final Builder currentAttemptCount(Integer currentAttemptCount) {
            this.currentAttemptCount = currentAttemptCount;
            return this;
        }

        @Override
        public RetryPolicyExecution build() {
            return new RetryPolicyExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
