/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMatchingWorkflowsResponse extends EntityResolutionResponse implements
        ToCopyableBuilder<ListMatchingWorkflowsResponse.Builder, ListMatchingWorkflowsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListMatchingWorkflowsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<MatchingWorkflowSummary>> WORKFLOW_SUMMARIES_FIELD = SdkField
            .<List<MatchingWorkflowSummary>> builder(MarshallingType.LIST)
            .memberName("workflowSummaries")
            .getter(getter(ListMatchingWorkflowsResponse::workflowSummaries))
            .setter(setter(Builder::workflowSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MatchingWorkflowSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MatchingWorkflowSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            WORKFLOW_SUMMARIES_FIELD));

    private final String nextToken;

    private final List<MatchingWorkflowSummary> workflowSummaries;

    private ListMatchingWorkflowsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workflowSummaries = builder.workflowSummaries;
    }

    /**
     * <p>
     * The pagination token from the previous API call.
     * </p>
     * 
     * @return The pagination token from the previous API call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkflowSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWorkflowSummaries() {
        return workflowSummaries != null && !(workflowSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>MatchingWorkflowSummary</code> objects, each of which contain the fields
     * <code>WorkflowName</code>, <code>WorkflowArn</code>, <code>CreatedAt</code>, and <code>UpdatedAt</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkflowSummaries} method.
     * </p>
     * 
     * @return A list of <code>MatchingWorkflowSummary</code> objects, each of which contain the fields
     *         <code>WorkflowName</code>, <code>WorkflowArn</code>, <code>CreatedAt</code>, and <code>UpdatedAt</code>.
     */
    public final List<MatchingWorkflowSummary> workflowSummaries() {
        return workflowSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkflowSummaries() ? workflowSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMatchingWorkflowsResponse)) {
            return false;
        }
        ListMatchingWorkflowsResponse other = (ListMatchingWorkflowsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasWorkflowSummaries() == other.hasWorkflowSummaries()
                && Objects.equals(workflowSummaries(), other.workflowSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMatchingWorkflowsResponse").add("NextToken", nextToken())
                .add("WorkflowSummaries", hasWorkflowSummaries() ? workflowSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "workflowSummaries":
            return Optional.ofNullable(clazz.cast(workflowSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMatchingWorkflowsResponse, T> g) {
        return obj -> g.apply((ListMatchingWorkflowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMatchingWorkflowsResponse> {
        /**
         * <p>
         * The pagination token from the previous API call.
         * </p>
         * 
         * @param nextToken
         *        The pagination token from the previous API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of <code>MatchingWorkflowSummary</code> objects, each of which contain the fields
         * <code>WorkflowName</code>, <code>WorkflowArn</code>, <code>CreatedAt</code>, and <code>UpdatedAt</code>.
         * </p>
         * 
         * @param workflowSummaries
         *        A list of <code>MatchingWorkflowSummary</code> objects, each of which contain the fields
         *        <code>WorkflowName</code>, <code>WorkflowArn</code>, <code>CreatedAt</code>, and
         *        <code>UpdatedAt</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowSummaries(Collection<MatchingWorkflowSummary> workflowSummaries);

        /**
         * <p>
         * A list of <code>MatchingWorkflowSummary</code> objects, each of which contain the fields
         * <code>WorkflowName</code>, <code>WorkflowArn</code>, <code>CreatedAt</code>, and <code>UpdatedAt</code>.
         * </p>
         * 
         * @param workflowSummaries
         *        A list of <code>MatchingWorkflowSummary</code> objects, each of which contain the fields
         *        <code>WorkflowName</code>, <code>WorkflowArn</code>, <code>CreatedAt</code>, and
         *        <code>UpdatedAt</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowSummaries(MatchingWorkflowSummary... workflowSummaries);

        /**
         * <p>
         * A list of <code>MatchingWorkflowSummary</code> objects, each of which contain the fields
         * <code>WorkflowName</code>, <code>WorkflowArn</code>, <code>CreatedAt</code>, and <code>UpdatedAt</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.MatchingWorkflowSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.MatchingWorkflowSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.MatchingWorkflowSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #workflowSummaries(List<MatchingWorkflowSummary>)}.
         * 
         * @param workflowSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.MatchingWorkflowSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowSummaries(java.util.Collection<MatchingWorkflowSummary>)
         */
        Builder workflowSummaries(Consumer<MatchingWorkflowSummary.Builder>... workflowSummaries);
    }

    static final class BuilderImpl extends EntityResolutionResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<MatchingWorkflowSummary> workflowSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMatchingWorkflowsResponse model) {
            super(model);
            nextToken(model.nextToken);
            workflowSummaries(model.workflowSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MatchingWorkflowSummary.Builder> getWorkflowSummaries() {
            List<MatchingWorkflowSummary.Builder> result = MatchingWorkflowListCopier.copyToBuilder(this.workflowSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflowSummaries(Collection<MatchingWorkflowSummary.BuilderImpl> workflowSummaries) {
            this.workflowSummaries = MatchingWorkflowListCopier.copyFromBuilder(workflowSummaries);
        }

        @Override
        public final Builder workflowSummaries(Collection<MatchingWorkflowSummary> workflowSummaries) {
            this.workflowSummaries = MatchingWorkflowListCopier.copy(workflowSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowSummaries(MatchingWorkflowSummary... workflowSummaries) {
            workflowSummaries(Arrays.asList(workflowSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowSummaries(Consumer<MatchingWorkflowSummary.Builder>... workflowSummaries) {
            workflowSummaries(Stream.of(workflowSummaries).map(c -> MatchingWorkflowSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMatchingWorkflowsResponse build() {
            return new ListMatchingWorkflowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
