/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing <code>RuleName</code>, and <code>MatchingKeys</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rule implements SdkPojo, Serializable, ToCopyableBuilder<Rule.Builder, Rule> {
    private static final SdkField<List<String>> MATCHING_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("matchingKeys")
            .getter(getter(Rule::matchingKeys))
            .setter(setter(Builder::matchingKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchingKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleName").getter(getter(Rule::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCHING_KEYS_FIELD,
            RULE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> matchingKeys;

    private final String ruleName;

    private Rule(BuilderImpl builder) {
        this.matchingKeys = builder.matchingKeys;
        this.ruleName = builder.ruleName;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchingKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchingKeys() {
        return matchingKeys != null && !(matchingKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>MatchingKeys</code>. The <code>MatchingKeys</code> must have been defined in the
     * <code>SchemaMapping</code>. Two records are considered to match according to this rule if all of the
     * <code>MatchingKeys</code> match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchingKeys} method.
     * </p>
     * 
     * @return A list of <code>MatchingKeys</code>. The <code>MatchingKeys</code> must have been defined in the
     *         <code>SchemaMapping</code>. Two records are considered to match according to this rule if all of the
     *         <code>MatchingKeys</code> match.
     */
    public final List<String> matchingKeys() {
        return matchingKeys;
    }

    /**
     * <p>
     * A name for the matching rule.
     * </p>
     * 
     * @return A name for the matching rule.
     */
    public final String ruleName() {
        return ruleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchingKeys() ? matchingKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule) obj;
        return hasMatchingKeys() == other.hasMatchingKeys() && Objects.equals(matchingKeys(), other.matchingKeys())
                && Objects.equals(ruleName(), other.ruleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Rule").add("MatchingKeys", hasMatchingKeys() ? matchingKeys() : null)
                .add("RuleName", ruleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "matchingKeys":
            return Optional.ofNullable(clazz.cast(matchingKeys()));
        case "ruleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Rule> {
        /**
         * <p>
         * A list of <code>MatchingKeys</code>. The <code>MatchingKeys</code> must have been defined in the
         * <code>SchemaMapping</code>. Two records are considered to match according to this rule if all of the
         * <code>MatchingKeys</code> match.
         * </p>
         * 
         * @param matchingKeys
         *        A list of <code>MatchingKeys</code>. The <code>MatchingKeys</code> must have been defined in the
         *        <code>SchemaMapping</code>. Two records are considered to match according to this rule if all of the
         *        <code>MatchingKeys</code> match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingKeys(Collection<String> matchingKeys);

        /**
         * <p>
         * A list of <code>MatchingKeys</code>. The <code>MatchingKeys</code> must have been defined in the
         * <code>SchemaMapping</code>. Two records are considered to match according to this rule if all of the
         * <code>MatchingKeys</code> match.
         * </p>
         * 
         * @param matchingKeys
         *        A list of <code>MatchingKeys</code>. The <code>MatchingKeys</code> must have been defined in the
         *        <code>SchemaMapping</code>. Two records are considered to match according to this rule if all of the
         *        <code>MatchingKeys</code> match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingKeys(String... matchingKeys);

        /**
         * <p>
         * A name for the matching rule.
         * </p>
         * 
         * @param ruleName
         *        A name for the matching rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);
    }

    static final class BuilderImpl implements Builder {
        private List<String> matchingKeys = DefaultSdkAutoConstructList.getInstance();

        private String ruleName;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            matchingKeys(model.matchingKeys);
            ruleName(model.ruleName);
        }

        public final Collection<String> getMatchingKeys() {
            if (matchingKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return matchingKeys;
        }

        public final void setMatchingKeys(Collection<String> matchingKeys) {
            this.matchingKeys = RuleMatchingKeysListCopier.copy(matchingKeys);
        }

        @Override
        public final Builder matchingKeys(Collection<String> matchingKeys) {
            this.matchingKeys = RuleMatchingKeysListCopier.copy(matchingKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingKeys(String... matchingKeys) {
            matchingKeys(Arrays.asList(matchingKeys));
            return this;
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        @Override
        public Rule build() {
            return new Rule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
