/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing <code>FieldName</code>, <code>Type</code>, <code>GroupName</code>, and <code>MatchKey</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaInputAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<SchemaInputAttribute.Builder, SchemaInputAttribute> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldName").getter(getter(SchemaInputAttribute::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldName").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupName").getter(getter(SchemaInputAttribute::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupName").build()).build();

    private static final SdkField<String> MATCH_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("matchKey").getter(getter(SchemaInputAttribute::matchKey)).setter(setter(Builder::matchKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchKey").build()).build();

    private static final SdkField<String> SUB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subType").getter(getter(SchemaInputAttribute::subType)).setter(setter(Builder::subType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subType").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SchemaInputAttribute::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD,
            GROUP_NAME_FIELD, MATCH_KEY_FIELD, SUB_TYPE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final String groupName;

    private final String matchKey;

    private final String subType;

    private final String type;

    private SchemaInputAttribute(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.groupName = builder.groupName;
        this.matchKey = builder.matchKey;
        this.subType = builder.subType;
        this.type = builder.type;
    }

    /**
     * <p>
     * A string containing the field name.
     * </p>
     * 
     * @return A string containing the field name.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * Instruct Entity Resolution to combine several columns into a unified column with the identical attribute type.
     * For example, when working with columns such as first_name, middle_name, and last_name, assigning them a common
     * <code>GroupName</code> will prompt Entity Resolution to concatenate them into a single value.
     * </p>
     * 
     * @return Instruct Entity Resolution to combine several columns into a unified column with the identical attribute
     *         type. For example, when working with columns such as first_name, middle_name, and last_name, assigning
     *         them a common <code>GroupName</code> will prompt Entity Resolution to concatenate them into a single
     *         value.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * A key that allows grouping of multiple input attributes into a unified matching group. For example, let's
     * consider a scenario where the source table contains various addresses, such as <code>business_address</code> and
     * <code>shipping_address</code>. By assigning the <code>MatchKey</code> <i>Address</i> to both attributes, Entity
     * Resolution will match records across these fields to create a consolidated matching group. If no
     * <code>MatchKey</code> is specified for a column, it won't be utilized for matching purposes but will still be
     * included in the output table.
     * </p>
     * 
     * @return A key that allows grouping of multiple input attributes into a unified matching group. For example, let's
     *         consider a scenario where the source table contains various addresses, such as
     *         <code>business_address</code> and <code>shipping_address</code>. By assigning the <code>MatchKey</code>
     *         <i>Address</i> to both attributes, Entity Resolution will match records across these fields to create a
     *         consolidated matching group. If no <code>MatchKey</code> is specified for a column, it won't be utilized
     *         for matching purposes but will still be included in the output table.
     */
    public final String matchKey() {
        return matchKey;
    }

    /**
     * <p>
     * The subtype of the attribute, selected from a list of values.
     * </p>
     * 
     * @return The subtype of the attribute, selected from a list of values.
     */
    public final String subType() {
        return subType;
    }

    /**
     * <p>
     * The type of the attribute, selected from a list of values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchemaAttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the attribute, selected from a list of values.
     * @see SchemaAttributeType
     */
    public final SchemaAttributeType type() {
        return SchemaAttributeType.fromValue(type);
    }

    /**
     * <p>
     * The type of the attribute, selected from a list of values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchemaAttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the attribute, selected from a list of values.
     * @see SchemaAttributeType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(matchKey());
        hashCode = 31 * hashCode + Objects.hashCode(subType());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaInputAttribute)) {
            return false;
        }
        SchemaInputAttribute other = (SchemaInputAttribute) obj;
        return Objects.equals(fieldName(), other.fieldName()) && Objects.equals(groupName(), other.groupName())
                && Objects.equals(matchKey(), other.matchKey()) && Objects.equals(subType(), other.subType())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaInputAttribute").add("FieldName", fieldName()).add("GroupName", groupName())
                .add("MatchKey", matchKey()).add("SubType", subType()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "groupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "matchKey":
            return Optional.ofNullable(clazz.cast(matchKey()));
        case "subType":
            return Optional.ofNullable(clazz.cast(subType()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaInputAttribute, T> g) {
        return obj -> g.apply((SchemaInputAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaInputAttribute> {
        /**
         * <p>
         * A string containing the field name.
         * </p>
         * 
         * @param fieldName
         *        A string containing the field name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * Instruct Entity Resolution to combine several columns into a unified column with the identical attribute
         * type. For example, when working with columns such as first_name, middle_name, and last_name, assigning them a
         * common <code>GroupName</code> will prompt Entity Resolution to concatenate them into a single value.
         * </p>
         * 
         * @param groupName
         *        Instruct Entity Resolution to combine several columns into a unified column with the identical
         *        attribute type. For example, when working with columns such as first_name, middle_name, and last_name,
         *        assigning them a common <code>GroupName</code> will prompt Entity Resolution to concatenate them into
         *        a single value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * A key that allows grouping of multiple input attributes into a unified matching group. For example, let's
         * consider a scenario where the source table contains various addresses, such as <code>business_address</code>
         * and <code>shipping_address</code>. By assigning the <code>MatchKey</code> <i>Address</i> to both attributes,
         * Entity Resolution will match records across these fields to create a consolidated matching group. If no
         * <code>MatchKey</code> is specified for a column, it won't be utilized for matching purposes but will still be
         * included in the output table.
         * </p>
         * 
         * @param matchKey
         *        A key that allows grouping of multiple input attributes into a unified matching group. For example,
         *        let's consider a scenario where the source table contains various addresses, such as
         *        <code>business_address</code> and <code>shipping_address</code>. By assigning the
         *        <code>MatchKey</code> <i>Address</i> to both attributes, Entity Resolution will match records across
         *        these fields to create a consolidated matching group. If no <code>MatchKey</code> is specified for a
         *        column, it won't be utilized for matching purposes but will still be included in the output table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchKey(String matchKey);

        /**
         * <p>
         * The subtype of the attribute, selected from a list of values.
         * </p>
         * 
         * @param subType
         *        The subtype of the attribute, selected from a list of values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subType(String subType);

        /**
         * <p>
         * The type of the attribute, selected from a list of values.
         * </p>
         * 
         * @param type
         *        The type of the attribute, selected from a list of values.
         * @see SchemaAttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaAttributeType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the attribute, selected from a list of values.
         * </p>
         * 
         * @param type
         *        The type of the attribute, selected from a list of values.
         * @see SchemaAttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaAttributeType
         */
        Builder type(SchemaAttributeType type);
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private String groupName;

        private String matchKey;

        private String subType;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaInputAttribute model) {
            fieldName(model.fieldName);
            groupName(model.groupName);
            matchKey(model.matchKey);
            subType(model.subType);
            type(model.type);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getMatchKey() {
            return matchKey;
        }

        public final void setMatchKey(String matchKey) {
            this.matchKey = matchKey;
        }

        @Override
        public final Builder matchKey(String matchKey) {
            this.matchKey = matchKey;
            return this;
        }

        public final String getSubType() {
            return subType;
        }

        public final void setSubType(String subType) {
            this.subType = subType;
        }

        @Override
        public final Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SchemaAttributeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public SchemaInputAttribute build() {
            return new SchemaInputAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
