/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKxScalingGroupResponse extends FinspaceResponse implements
        ToCopyableBuilder<CreateKxScalingGroupResponse.Builder, CreateKxScalingGroupResponse> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(CreateKxScalingGroupResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scalingGroupName").getter(getter(CreateKxScalingGroupResponse::scalingGroupName))
            .setter(setter(Builder::scalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingGroupName").build()).build();

    private static final SdkField<String> HOST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostType").getter(getter(CreateKxScalingGroupResponse::hostType)).setter(setter(Builder::hostType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostType").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneId").getter(getter(CreateKxScalingGroupResponse::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateKxScalingGroupResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTimestamp").getter(getter(CreateKxScalingGroupResponse::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTimestamp").getter(getter(CreateKxScalingGroupResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            SCALING_GROUP_NAME_FIELD, HOST_TYPE_FIELD, AVAILABILITY_ZONE_ID_FIELD, STATUS_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD,
            CREATED_TIMESTAMP_FIELD));

    private final String environmentId;

    private final String scalingGroupName;

    private final String hostType;

    private final String availabilityZoneId;

    private final String status;

    private final Instant lastModifiedTimestamp;

    private final Instant createdTimestamp;

    private CreateKxScalingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.scalingGroupName = builder.scalingGroupName;
        this.hostType = builder.hostType;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.status = builder.status;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * A unique identifier for the kdb environment, where you create the scaling group.
     * </p>
     * 
     * @return A unique identifier for the kdb environment, where you create the scaling group.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * A unique identifier for the kdb scaling group.
     * </p>
     * 
     * @return A unique identifier for the kdb scaling group.
     */
    public final String scalingGroupName() {
        return scalingGroupName;
    }

    /**
     * <p>
     * The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be placed.
     * </p>
     * 
     * @return The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be
     *         placed.
     */
    public final String hostType() {
        return hostType;
    }

    /**
     * <p>
     * The identifier of the availability zones.
     * </p>
     * 
     * @return The identifier of the availability zones.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The status of scaling group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATING – The scaling group creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED – The scaling group creation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE – The scaling group is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING – The scaling group is in the process of being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATE_FAILED – The update action failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – The scaling group is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED – The system failed to delete the scaling group.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETED – The scaling group is successfully deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KxScalingGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of scaling group.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATING – The scaling group creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED – The scaling group creation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE – The scaling group is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING – The scaling group is in the process of being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATE_FAILED – The update action failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – The scaling group is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED – The system failed to delete the scaling group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETED – The scaling group is successfully deleted.
     *         </p>
     *         </li>
     * @see KxScalingGroupStatus
     */
    public final KxScalingGroupStatus status() {
        return KxScalingGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of scaling group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATING – The scaling group creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_FAILED – The scaling group creation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE – The scaling group is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING – The scaling group is in the process of being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATE_FAILED – The update action failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – The scaling group is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_FAILED – The system failed to delete the scaling group.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETED – The scaling group is successfully deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KxScalingGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of scaling group.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATING – The scaling group creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE_FAILED – The scaling group creation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE – The scaling group is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATING – The scaling group is in the process of being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UPDATE_FAILED – The update action failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – The scaling group is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_FAILED – The system failed to delete the scaling group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETED – The scaling group is successfully deleted.
     *         </p>
     *         </li>
     * @see KxScalingGroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The last time that the scaling group was updated in FinSpace. The value is determined as epoch time in
     * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The last time that the scaling group was updated in FinSpace. The value is determined as epoch time in
     *         milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    /**
     * <p>
     * The timestamp at which the scaling group was created in FinSpace. The value is determined as epoch time in
     * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The timestamp at which the scaling group was created in FinSpace. The value is determined as epoch time
     *         in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
     *         1635768000000.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(scalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hostType());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKxScalingGroupResponse)) {
            return false;
        }
        CreateKxScalingGroupResponse other = (CreateKxScalingGroupResponse) obj;
        return Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(scalingGroupName(), other.scalingGroupName()) && Objects.equals(hostType(), other.hostType())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateKxScalingGroupResponse").add("EnvironmentId", environmentId())
                .add("ScalingGroupName", scalingGroupName()).add("HostType", hostType())
                .add("AvailabilityZoneId", availabilityZoneId()).add("Status", statusAsString())
                .add("LastModifiedTimestamp", lastModifiedTimestamp()).add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "scalingGroupName":
            return Optional.ofNullable(clazz.cast(scalingGroupName()));
        case "hostType":
            return Optional.ofNullable(clazz.cast(hostType()));
        case "availabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "lastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        case "createdTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKxScalingGroupResponse, T> g) {
        return obj -> g.apply((CreateKxScalingGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateKxScalingGroupResponse> {
        /**
         * <p>
         * A unique identifier for the kdb environment, where you create the scaling group.
         * </p>
         * 
         * @param environmentId
         *        A unique identifier for the kdb environment, where you create the scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * A unique identifier for the kdb scaling group.
         * </p>
         * 
         * @param scalingGroupName
         *        A unique identifier for the kdb scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingGroupName(String scalingGroupName);

        /**
         * <p>
         * The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be
         * placed.
         * </p>
         * 
         * @param hostType
         *        The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will
         *        be placed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostType(String hostType);

        /**
         * <p>
         * The identifier of the availability zones.
         * </p>
         * 
         * @param availabilityZoneId
         *        The identifier of the availability zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The status of scaling group.
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATING – The scaling group creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED – The scaling group creation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE – The scaling group is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING – The scaling group is in the process of being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATE_FAILED – The update action failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – The scaling group is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED – The system failed to delete the scaling group.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETED – The scaling group is successfully deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of scaling group.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATING – The scaling group creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED – The scaling group creation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE – The scaling group is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING – The scaling group is in the process of being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATE_FAILED – The update action failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – The scaling group is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED – The system failed to delete the scaling group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETED – The scaling group is successfully deleted.
         *        </p>
         *        </li>
         * @see KxScalingGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxScalingGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of scaling group.
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATING – The scaling group creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE_FAILED – The scaling group creation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE – The scaling group is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATING – The scaling group is in the process of being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * UPDATE_FAILED – The update action failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – The scaling group is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_FAILED – The system failed to delete the scaling group.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETED – The scaling group is successfully deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of scaling group.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATING – The scaling group creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE_FAILED – The scaling group creation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE – The scaling group is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATING – The scaling group is in the process of being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UPDATE_FAILED – The update action failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – The scaling group is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_FAILED – The system failed to delete the scaling group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETED – The scaling group is successfully deleted.
         *        </p>
         *        </li>
         * @see KxScalingGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxScalingGroupStatus
         */
        Builder status(KxScalingGroupStatus status);

        /**
         * <p>
         * The last time that the scaling group was updated in FinSpace. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The last time that the scaling group was updated in FinSpace. The value is determined as epoch time in
         *        milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         *        1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);

        /**
         * <p>
         * The timestamp at which the scaling group was created in FinSpace. The value is determined as epoch time in
         * milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as
         * 1635768000000.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp at which the scaling group was created in FinSpace. The value is determined as epoch
         *        time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified
         *        as 1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl extends FinspaceResponse.BuilderImpl implements Builder {
        private String environmentId;

        private String scalingGroupName;

        private String hostType;

        private String availabilityZoneId;

        private String status;

        private Instant lastModifiedTimestamp;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKxScalingGroupResponse model) {
            super(model);
            environmentId(model.environmentId);
            scalingGroupName(model.scalingGroupName);
            hostType(model.hostType);
            availabilityZoneId(model.availabilityZoneId);
            status(model.status);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getScalingGroupName() {
            return scalingGroupName;
        }

        public final void setScalingGroupName(String scalingGroupName) {
            this.scalingGroupName = scalingGroupName;
        }

        @Override
        public final Builder scalingGroupName(String scalingGroupName) {
            this.scalingGroupName = scalingGroupName;
            return this;
        }

        public final String getHostType() {
            return hostType;
        }

        public final void setHostType(String hostType) {
            this.hostType = hostType;
        }

        @Override
        public final Builder hostType(String hostType) {
            this.hostType = hostType;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KxScalingGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public CreateKxScalingGroupResponse build() {
            return new CreateKxScalingGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
