/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.finspace.model.AccessDeniedException;
import software.amazon.awssdk.services.finspace.model.ConflictException;
import software.amazon.awssdk.services.finspace.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.CreateKxChangesetRequest;
import software.amazon.awssdk.services.finspace.model.CreateKxChangesetResponse;
import software.amazon.awssdk.services.finspace.model.CreateKxClusterRequest;
import software.amazon.awssdk.services.finspace.model.CreateKxClusterResponse;
import software.amazon.awssdk.services.finspace.model.CreateKxDatabaseRequest;
import software.amazon.awssdk.services.finspace.model.CreateKxDatabaseResponse;
import software.amazon.awssdk.services.finspace.model.CreateKxDataviewRequest;
import software.amazon.awssdk.services.finspace.model.CreateKxDataviewResponse;
import software.amazon.awssdk.services.finspace.model.CreateKxEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.CreateKxEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.CreateKxScalingGroupRequest;
import software.amazon.awssdk.services.finspace.model.CreateKxScalingGroupResponse;
import software.amazon.awssdk.services.finspace.model.CreateKxUserRequest;
import software.amazon.awssdk.services.finspace.model.CreateKxUserResponse;
import software.amazon.awssdk.services.finspace.model.CreateKxVolumeRequest;
import software.amazon.awssdk.services.finspace.model.CreateKxVolumeResponse;
import software.amazon.awssdk.services.finspace.model.DeleteEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.DeleteEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.DeleteKxClusterRequest;
import software.amazon.awssdk.services.finspace.model.DeleteKxClusterResponse;
import software.amazon.awssdk.services.finspace.model.DeleteKxDatabaseRequest;
import software.amazon.awssdk.services.finspace.model.DeleteKxDatabaseResponse;
import software.amazon.awssdk.services.finspace.model.DeleteKxDataviewRequest;
import software.amazon.awssdk.services.finspace.model.DeleteKxDataviewResponse;
import software.amazon.awssdk.services.finspace.model.DeleteKxEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.DeleteKxEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.DeleteKxScalingGroupRequest;
import software.amazon.awssdk.services.finspace.model.DeleteKxScalingGroupResponse;
import software.amazon.awssdk.services.finspace.model.DeleteKxUserRequest;
import software.amazon.awssdk.services.finspace.model.DeleteKxUserResponse;
import software.amazon.awssdk.services.finspace.model.DeleteKxVolumeRequest;
import software.amazon.awssdk.services.finspace.model.DeleteKxVolumeResponse;
import software.amazon.awssdk.services.finspace.model.FinspaceException;
import software.amazon.awssdk.services.finspace.model.GetEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.GetEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.GetKxChangesetRequest;
import software.amazon.awssdk.services.finspace.model.GetKxChangesetResponse;
import software.amazon.awssdk.services.finspace.model.GetKxClusterRequest;
import software.amazon.awssdk.services.finspace.model.GetKxClusterResponse;
import software.amazon.awssdk.services.finspace.model.GetKxConnectionStringRequest;
import software.amazon.awssdk.services.finspace.model.GetKxConnectionStringResponse;
import software.amazon.awssdk.services.finspace.model.GetKxDatabaseRequest;
import software.amazon.awssdk.services.finspace.model.GetKxDatabaseResponse;
import software.amazon.awssdk.services.finspace.model.GetKxDataviewRequest;
import software.amazon.awssdk.services.finspace.model.GetKxDataviewResponse;
import software.amazon.awssdk.services.finspace.model.GetKxEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.GetKxEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.GetKxScalingGroupRequest;
import software.amazon.awssdk.services.finspace.model.GetKxScalingGroupResponse;
import software.amazon.awssdk.services.finspace.model.GetKxUserRequest;
import software.amazon.awssdk.services.finspace.model.GetKxUserResponse;
import software.amazon.awssdk.services.finspace.model.GetKxVolumeRequest;
import software.amazon.awssdk.services.finspace.model.GetKxVolumeResponse;
import software.amazon.awssdk.services.finspace.model.InternalServerException;
import software.amazon.awssdk.services.finspace.model.InvalidRequestException;
import software.amazon.awssdk.services.finspace.model.LimitExceededException;
import software.amazon.awssdk.services.finspace.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.finspace.model.ListEnvironmentsResponse;
import software.amazon.awssdk.services.finspace.model.ListKxChangesetsRequest;
import software.amazon.awssdk.services.finspace.model.ListKxChangesetsResponse;
import software.amazon.awssdk.services.finspace.model.ListKxClusterNodesRequest;
import software.amazon.awssdk.services.finspace.model.ListKxClusterNodesResponse;
import software.amazon.awssdk.services.finspace.model.ListKxClustersRequest;
import software.amazon.awssdk.services.finspace.model.ListKxClustersResponse;
import software.amazon.awssdk.services.finspace.model.ListKxDatabasesRequest;
import software.amazon.awssdk.services.finspace.model.ListKxDatabasesResponse;
import software.amazon.awssdk.services.finspace.model.ListKxDataviewsRequest;
import software.amazon.awssdk.services.finspace.model.ListKxDataviewsResponse;
import software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsRequest;
import software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsResponse;
import software.amazon.awssdk.services.finspace.model.ListKxScalingGroupsRequest;
import software.amazon.awssdk.services.finspace.model.ListKxScalingGroupsResponse;
import software.amazon.awssdk.services.finspace.model.ListKxUsersRequest;
import software.amazon.awssdk.services.finspace.model.ListKxUsersResponse;
import software.amazon.awssdk.services.finspace.model.ListKxVolumesRequest;
import software.amazon.awssdk.services.finspace.model.ListKxVolumesResponse;
import software.amazon.awssdk.services.finspace.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.finspace.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.finspace.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.finspace.model.ResourceNotFoundException;
import software.amazon.awssdk.services.finspace.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.finspace.model.TagResourceRequest;
import software.amazon.awssdk.services.finspace.model.TagResourceResponse;
import software.amazon.awssdk.services.finspace.model.ThrottlingException;
import software.amazon.awssdk.services.finspace.model.UntagResourceRequest;
import software.amazon.awssdk.services.finspace.model.UntagResourceResponse;
import software.amazon.awssdk.services.finspace.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.UpdateKxClusterCodeConfigurationRequest;
import software.amazon.awssdk.services.finspace.model.UpdateKxClusterCodeConfigurationResponse;
import software.amazon.awssdk.services.finspace.model.UpdateKxClusterDatabasesRequest;
import software.amazon.awssdk.services.finspace.model.UpdateKxClusterDatabasesResponse;
import software.amazon.awssdk.services.finspace.model.UpdateKxDatabaseRequest;
import software.amazon.awssdk.services.finspace.model.UpdateKxDatabaseResponse;
import software.amazon.awssdk.services.finspace.model.UpdateKxDataviewRequest;
import software.amazon.awssdk.services.finspace.model.UpdateKxDataviewResponse;
import software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentNetworkRequest;
import software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentNetworkResponse;
import software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentRequest;
import software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentResponse;
import software.amazon.awssdk.services.finspace.model.UpdateKxUserRequest;
import software.amazon.awssdk.services.finspace.model.UpdateKxUserResponse;
import software.amazon.awssdk.services.finspace.model.UpdateKxVolumeRequest;
import software.amazon.awssdk.services.finspace.model.UpdateKxVolumeResponse;
import software.amazon.awssdk.services.finspace.model.ValidationException;
import software.amazon.awssdk.services.finspace.paginators.ListKxChangesetsIterable;
import software.amazon.awssdk.services.finspace.paginators.ListKxClusterNodesIterable;
import software.amazon.awssdk.services.finspace.paginators.ListKxDatabasesIterable;
import software.amazon.awssdk.services.finspace.paginators.ListKxDataviewsIterable;
import software.amazon.awssdk.services.finspace.paginators.ListKxEnvironmentsIterable;
import software.amazon.awssdk.services.finspace.paginators.ListKxScalingGroupsIterable;

/**
 * Service client for accessing finspace. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The FinSpace management service provides the APIs for managing FinSpace environments.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface FinspaceClient extends AwsClient {
    String SERVICE_NAME = "finspace";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "finspace";

    /**
     * <p>
     * Create a new FinSpace environment.
     * </p>
     *
     * @param createEnvironmentRequest
     * @return Result of the CreateEnvironment operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateEnvironment" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This method will be discontinued.
     */
    @Deprecated
    default CreateEnvironmentResponse createEnvironment(CreateEnvironmentRequest createEnvironmentRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, LimitExceededException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new FinSpace environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEnvironmentRequest#builder()}
     * </p>
     *
     * @param createEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.CreateEnvironmentRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEnvironment operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateEnvironment" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This method will be discontinued.
     */
    @Deprecated
    default CreateEnvironmentResponse createEnvironment(Consumer<CreateEnvironmentRequest.Builder> createEnvironmentRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, LimitExceededException, AwsServiceException, SdkClientException, FinspaceException {
        return createEnvironment(CreateEnvironmentRequest.builder().applyMutation(createEnvironmentRequest).build());
    }

    /**
     * <p>
     * Creates a changeset for a kdb database. A changeset allows you to add and delete existing files by using an
     * ordered list of change requests.
     * </p>
     *
     * @param createKxChangesetRequest
     * @return Result of the CreateKxChangeset operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxChangeset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxChangeset" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateKxChangesetResponse createKxChangeset(CreateKxChangesetRequest createKxChangesetRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, LimitExceededException, AwsServiceException, SdkClientException,
            FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a changeset for a kdb database. A changeset allows you to add and delete existing files by using an
     * ordered list of change requests.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKxChangesetRequest.Builder} avoiding the need
     * to create one manually via {@link CreateKxChangesetRequest#builder()}
     * </p>
     *
     * @param createKxChangesetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.CreateKxChangesetRequest.Builder} to create a
     *        request.
     * @return Result of the CreateKxChangeset operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxChangeset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxChangeset" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateKxChangesetResponse createKxChangeset(Consumer<CreateKxChangesetRequest.Builder> createKxChangesetRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, LimitExceededException, AwsServiceException, SdkClientException,
            FinspaceException {
        return createKxChangeset(CreateKxChangesetRequest.builder().applyMutation(createKxChangesetRequest).build());
    }

    /**
     * <p>
     * Creates a new kdb cluster.
     * </p>
     *
     * @param createKxClusterRequest
     * @return Result of the CreateKxCluster operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKxClusterResponse createKxCluster(CreateKxClusterRequest createKxClusterRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new kdb cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKxClusterRequest.Builder} avoiding the need
     * to create one manually via {@link CreateKxClusterRequest#builder()}
     * </p>
     *
     * @param createKxClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.CreateKxClusterRequest.Builder} to create a request.
     * @return Result of the CreateKxCluster operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKxClusterResponse createKxCluster(Consumer<CreateKxClusterRequest.Builder> createKxClusterRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        return createKxCluster(CreateKxClusterRequest.builder().applyMutation(createKxClusterRequest).build());
    }

    /**
     * <p>
     * Creates a new kdb database in the environment.
     * </p>
     *
     * @param createKxDatabaseRequest
     * @return Result of the CreateKxDatabase operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceAlreadyExistsException
     *         The specified resource group already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKxDatabaseResponse createKxDatabase(CreateKxDatabaseRequest createKxDatabaseRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException,
            ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new kdb database in the environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKxDatabaseRequest.Builder} avoiding the need
     * to create one manually via {@link CreateKxDatabaseRequest#builder()}
     * </p>
     *
     * @param createKxDatabaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.CreateKxDatabaseRequest.Builder} to create a
     *        request.
     * @return Result of the CreateKxDatabase operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceAlreadyExistsException
     *         The specified resource group already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKxDatabaseResponse createKxDatabase(Consumer<CreateKxDatabaseRequest.Builder> createKxDatabaseRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, ConflictException,
            ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, FinspaceException {
        return createKxDatabase(CreateKxDatabaseRequest.builder().applyMutation(createKxDatabaseRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of kdb database with tiered storage capabilities and a pre-warmed cache, ready for mounting on
     * kdb clusters. Dataviews are only available for clusters running on a scaling group. They are not supported on
     * dedicated clusters.
     * </p>
     *
     * @param createKxDataviewRequest
     * @return Result of the CreateKxDataview operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource group already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxDataview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxDataview" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKxDataviewResponse createKxDataview(CreateKxDataviewRequest createKxDataviewRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, LimitExceededException, ResourceAlreadyExistsException,
            AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of kdb database with tiered storage capabilities and a pre-warmed cache, ready for mounting on
     * kdb clusters. Dataviews are only available for clusters running on a scaling group. They are not supported on
     * dedicated clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKxDataviewRequest.Builder} avoiding the need
     * to create one manually via {@link CreateKxDataviewRequest#builder()}
     * </p>
     *
     * @param createKxDataviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.CreateKxDataviewRequest.Builder} to create a
     *        request.
     * @return Result of the CreateKxDataview operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource group already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxDataview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxDataview" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKxDataviewResponse createKxDataview(Consumer<CreateKxDataviewRequest.Builder> createKxDataviewRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, LimitExceededException, ResourceAlreadyExistsException,
            AwsServiceException, SdkClientException, FinspaceException {
        return createKxDataview(CreateKxDataviewRequest.builder().applyMutation(createKxDataviewRequest).build());
    }

    /**
     * <p>
     * Creates a managed kdb environment for the account.
     * </p>
     *
     * @param createKxEnvironmentRequest
     * @return Result of the CreateKxEnvironment operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateKxEnvironmentResponse createKxEnvironment(CreateKxEnvironmentRequest createKxEnvironmentRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, LimitExceededException, ConflictException, AwsServiceException, SdkClientException,
            FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a managed kdb environment for the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKxEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link CreateKxEnvironmentRequest#builder()}
     * </p>
     *
     * @param createKxEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.CreateKxEnvironmentRequest.Builder} to create a
     *        request.
     * @return Result of the CreateKxEnvironment operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateKxEnvironmentResponse createKxEnvironment(
            Consumer<CreateKxEnvironmentRequest.Builder> createKxEnvironmentRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            LimitExceededException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        return createKxEnvironment(CreateKxEnvironmentRequest.builder().applyMutation(createKxEnvironmentRequest).build());
    }

    /**
     * <p>
     * Creates a new scaling group.
     * </p>
     *
     * @param createKxScalingGroupRequest
     * @return Result of the CreateKxScalingGroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxScalingGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateKxScalingGroupResponse createKxScalingGroup(CreateKxScalingGroupRequest createKxScalingGroupRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new scaling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKxScalingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateKxScalingGroupRequest#builder()}
     * </p>
     *
     * @param createKxScalingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.CreateKxScalingGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateKxScalingGroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxScalingGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateKxScalingGroupResponse createKxScalingGroup(
            Consumer<CreateKxScalingGroupRequest.Builder> createKxScalingGroupRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return createKxScalingGroup(CreateKxScalingGroupRequest.builder().applyMutation(createKxScalingGroupRequest).build());
    }

    /**
     * <p>
     * Creates a user in FinSpace kdb environment with an associated IAM role.
     * </p>
     *
     * @param createKxUserRequest
     * @return Result of the CreateKxUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource group already exists.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKxUserResponse createKxUser(CreateKxUserRequest createKxUserRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            ResourceAlreadyExistsException, LimitExceededException, ConflictException, AwsServiceException, SdkClientException,
            FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user in FinSpace kdb environment with an associated IAM role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKxUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateKxUserRequest#builder()}
     * </p>
     *
     * @param createKxUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.CreateKxUserRequest.Builder} to create a request.
     * @return Result of the CreateKxUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource group already exists.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKxUserResponse createKxUser(Consumer<CreateKxUserRequest.Builder> createKxUserRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException,
            ValidationException, ResourceAlreadyExistsException, LimitExceededException, ConflictException, AwsServiceException,
            SdkClientException, FinspaceException {
        return createKxUser(CreateKxUserRequest.builder().applyMutation(createKxUserRequest).build());
    }

    /**
     * <p>
     * Creates a new volume with a specific amount of throughput and storage capacity.
     * </p>
     *
     * @param createKxVolumeRequest
     * @return Result of the CreateKxVolume operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ResourceAlreadyExistsException
     *         The specified resource group already exists.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKxVolumeResponse createKxVolume(CreateKxVolumeRequest createKxVolumeRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException,
            ResourceNotFoundException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new volume with a specific amount of throughput and storage capacity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKxVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateKxVolumeRequest#builder()}
     * </p>
     *
     * @param createKxVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.CreateKxVolumeRequest.Builder} to create a request.
     * @return Result of the CreateKxVolume operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ResourceAlreadyExistsException
     *         The specified resource group already exists.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.CreateKxVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/CreateKxVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKxVolumeResponse createKxVolume(Consumer<CreateKxVolumeRequest.Builder> createKxVolumeRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, ResourceAlreadyExistsException,
            AwsServiceException, SdkClientException, FinspaceException {
        return createKxVolume(CreateKxVolumeRequest.builder().applyMutation(createKxVolumeRequest).build());
    }

    /**
     * <p>
     * Delete an FinSpace environment.
     * </p>
     *
     * @param deleteEnvironmentRequest
     * @return Result of the DeleteEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteEnvironment" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This method will be discontinued.
     */
    @Deprecated
    default DeleteEnvironmentResponse deleteEnvironment(DeleteEnvironmentRequest deleteEnvironmentRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an FinSpace environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEnvironmentRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.DeleteEnvironmentRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteEnvironment" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This method will be discontinued.
     */
    @Deprecated
    default DeleteEnvironmentResponse deleteEnvironment(Consumer<DeleteEnvironmentRequest.Builder> deleteEnvironmentRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        return deleteEnvironment(DeleteEnvironmentRequest.builder().applyMutation(deleteEnvironmentRequest).build());
    }

    /**
     * <p>
     * Deletes a kdb cluster.
     * </p>
     *
     * @param deleteKxClusterRequest
     * @return Result of the DeleteKxCluster operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteKxCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKxClusterResponse deleteKxCluster(DeleteKxClusterRequest deleteKxClusterRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a kdb cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKxClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteKxClusterRequest#builder()}
     * </p>
     *
     * @param deleteKxClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.DeleteKxClusterRequest.Builder} to create a request.
     * @return Result of the DeleteKxCluster operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteKxCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKxClusterResponse deleteKxCluster(Consumer<DeleteKxClusterRequest.Builder> deleteKxClusterRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        return deleteKxCluster(DeleteKxClusterRequest.builder().applyMutation(deleteKxClusterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified database and all of its associated data. This action is irreversible. You must copy any
     * data out of the database before deleting it if the data is to be retained.
     * </p>
     *
     * @param deleteKxDatabaseRequest
     * @return Result of the DeleteKxDatabase operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteKxDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKxDatabaseResponse deleteKxDatabase(DeleteKxDatabaseRequest deleteKxDatabaseRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified database and all of its associated data. This action is irreversible. You must copy any
     * data out of the database before deleting it if the data is to be retained.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKxDatabaseRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteKxDatabaseRequest#builder()}
     * </p>
     *
     * @param deleteKxDatabaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.DeleteKxDatabaseRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteKxDatabase operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteKxDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKxDatabaseResponse deleteKxDatabase(Consumer<DeleteKxDatabaseRequest.Builder> deleteKxDatabaseRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        return deleteKxDatabase(DeleteKxDatabaseRequest.builder().applyMutation(deleteKxDatabaseRequest).build());
    }

    /**
     * <p>
     * Deletes the specified dataview. Before deleting a dataview, make sure that it is not in use by any cluster.
     * </p>
     *
     * @param deleteKxDataviewRequest
     * @return Result of the DeleteKxDataview operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteKxDataview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxDataview" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKxDataviewResponse deleteKxDataview(DeleteKxDataviewRequest deleteKxDataviewRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified dataview. Before deleting a dataview, make sure that it is not in use by any cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKxDataviewRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteKxDataviewRequest#builder()}
     * </p>
     *
     * @param deleteKxDataviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.DeleteKxDataviewRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteKxDataview operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteKxDataview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxDataview" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKxDataviewResponse deleteKxDataview(Consumer<DeleteKxDataviewRequest.Builder> deleteKxDataviewRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        return deleteKxDataview(DeleteKxDataviewRequest.builder().applyMutation(deleteKxDataviewRequest).build());
    }

    /**
     * <p>
     * Deletes the kdb environment. This action is irreversible. Deleting a kdb environment will remove all the
     * associated data and any services running in it.
     * </p>
     *
     * @param deleteKxEnvironmentRequest
     * @return Result of the DeleteKxEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteKxEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteKxEnvironmentResponse deleteKxEnvironment(DeleteKxEnvironmentRequest deleteKxEnvironmentRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the kdb environment. This action is irreversible. Deleting a kdb environment will remove all the
     * associated data and any services running in it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKxEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteKxEnvironmentRequest#builder()}
     * </p>
     *
     * @param deleteKxEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.DeleteKxEnvironmentRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteKxEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteKxEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteKxEnvironmentResponse deleteKxEnvironment(
            Consumer<DeleteKxEnvironmentRequest.Builder> deleteKxEnvironmentRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, FinspaceException {
        return deleteKxEnvironment(DeleteKxEnvironmentRequest.builder().applyMutation(deleteKxEnvironmentRequest).build());
    }

    /**
     * <p>
     * Deletes the specified scaling group. This action is irreversible. You cannot delete a scaling group until all the
     * clusters running on it have been deleted.
     * </p>
     *
     * @param deleteKxScalingGroupRequest
     * @return Result of the DeleteKxScalingGroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteKxScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxScalingGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteKxScalingGroupResponse deleteKxScalingGroup(DeleteKxScalingGroupRequest deleteKxScalingGroupRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified scaling group. This action is irreversible. You cannot delete a scaling group until all the
     * clusters running on it have been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKxScalingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteKxScalingGroupRequest#builder()}
     * </p>
     *
     * @param deleteKxScalingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.DeleteKxScalingGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteKxScalingGroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteKxScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxScalingGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteKxScalingGroupResponse deleteKxScalingGroup(
            Consumer<DeleteKxScalingGroupRequest.Builder> deleteKxScalingGroupRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return deleteKxScalingGroup(DeleteKxScalingGroupRequest.builder().applyMutation(deleteKxScalingGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a user in the specified kdb environment.
     * </p>
     *
     * @param deleteKxUserRequest
     * @return Result of the DeleteKxUser operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteKxUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKxUserResponse deleteKxUser(DeleteKxUserRequest deleteKxUserRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user in the specified kdb environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKxUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteKxUserRequest#builder()}
     * </p>
     *
     * @param deleteKxUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.DeleteKxUserRequest.Builder} to create a request.
     * @return Result of the DeleteKxUser operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteKxUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKxUserResponse deleteKxUser(Consumer<DeleteKxUserRequest.Builder> deleteKxUserRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        return deleteKxUser(DeleteKxUserRequest.builder().applyMutation(deleteKxUserRequest).build());
    }

    /**
     * <p>
     * Deletes a volume. You can only delete a volume if it's not attached to a cluster or a dataview. When a volume is
     * deleted, any data on the volume is lost. This action is irreversible.
     * </p>
     *
     * @param deleteKxVolumeRequest
     * @return Result of the DeleteKxVolume operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteKxVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKxVolumeResponse deleteKxVolume(DeleteKxVolumeRequest deleteKxVolumeRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a volume. You can only delete a volume if it's not attached to a cluster or a dataview. When a volume is
     * deleted, any data on the volume is lost. This action is irreversible.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKxVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteKxVolumeRequest#builder()}
     * </p>
     *
     * @param deleteKxVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.DeleteKxVolumeRequest.Builder} to create a request.
     * @return Result of the DeleteKxVolume operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.DeleteKxVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/DeleteKxVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKxVolumeResponse deleteKxVolume(Consumer<DeleteKxVolumeRequest.Builder> deleteKxVolumeRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        return deleteKxVolume(DeleteKxVolumeRequest.builder().applyMutation(deleteKxVolumeRequest).build());
    }

    /**
     * <p>
     * Returns the FinSpace environment object.
     * </p>
     *
     * @param getEnvironmentRequest
     * @return Result of the GetEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated This method will be discontinued.
     */
    @Deprecated
    default GetEnvironmentResponse getEnvironment(GetEnvironmentRequest getEnvironmentRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the FinSpace environment object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentRequest.Builder} avoiding the need to
     * create one manually via {@link GetEnvironmentRequest#builder()}
     * </p>
     *
     * @param getEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.GetEnvironmentRequest.Builder} to create a request.
     * @return Result of the GetEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated This method will be discontinued.
     */
    @Deprecated
    default GetEnvironmentResponse getEnvironment(Consumer<GetEnvironmentRequest.Builder> getEnvironmentRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, FinspaceException {
        return getEnvironment(GetEnvironmentRequest.builder().applyMutation(getEnvironmentRequest).build());
    }

    /**
     * <p>
     * Returns information about a kdb changeset.
     * </p>
     *
     * @param getKxChangesetRequest
     * @return Result of the GetKxChangeset operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxChangeset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxChangeset" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKxChangesetResponse getKxChangeset(GetKxChangesetRequest getKxChangesetRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a kdb changeset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKxChangesetRequest.Builder} avoiding the need to
     * create one manually via {@link GetKxChangesetRequest#builder()}
     * </p>
     *
     * @param getKxChangesetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.GetKxChangesetRequest.Builder} to create a request.
     * @return Result of the GetKxChangeset operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxChangeset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxChangeset" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKxChangesetResponse getKxChangeset(Consumer<GetKxChangesetRequest.Builder> getKxChangesetRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return getKxChangeset(GetKxChangesetRequest.builder().applyMutation(getKxChangesetRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a kdb cluster.
     * </p>
     *
     * @param getKxClusterRequest
     * @return Result of the GetKxCluster operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKxClusterResponse getKxCluster(GetKxClusterRequest getKxClusterRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a kdb cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKxClusterRequest.Builder} avoiding the need to
     * create one manually via {@link GetKxClusterRequest#builder()}
     * </p>
     *
     * @param getKxClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.GetKxClusterRequest.Builder} to create a request.
     * @return Result of the GetKxCluster operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKxClusterResponse getKxCluster(Consumer<GetKxClusterRequest.Builder> getKxClusterRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        return getKxCluster(GetKxClusterRequest.builder().applyMutation(getKxClusterRequest).build());
    }

    /**
     * <p>
     * Retrieves a connection string for a user to connect to a kdb cluster. You must call this API using the same role
     * that you have defined while creating a user.
     * </p>
     *
     * @param getKxConnectionStringRequest
     * @return Result of the GetKxConnectionString operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxConnectionString
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxConnectionString"
     *      target="_top">AWS API Documentation</a>
     */
    default GetKxConnectionStringResponse getKxConnectionString(GetKxConnectionStringRequest getKxConnectionStringRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a connection string for a user to connect to a kdb cluster. You must call this API using the same role
     * that you have defined while creating a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKxConnectionStringRequest.Builder} avoiding the
     * need to create one manually via {@link GetKxConnectionStringRequest#builder()}
     * </p>
     *
     * @param getKxConnectionStringRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.GetKxConnectionStringRequest.Builder} to create a
     *        request.
     * @return Result of the GetKxConnectionString operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxConnectionString
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxConnectionString"
     *      target="_top">AWS API Documentation</a>
     */
    default GetKxConnectionStringResponse getKxConnectionString(
            Consumer<GetKxConnectionStringRequest.Builder> getKxConnectionStringRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, FinspaceException {
        return getKxConnectionString(GetKxConnectionStringRequest.builder().applyMutation(getKxConnectionStringRequest).build());
    }

    /**
     * <p>
     * Returns database information for the specified environment ID.
     * </p>
     *
     * @param getKxDatabaseRequest
     * @return Result of the GetKxDatabase operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKxDatabaseResponse getKxDatabase(GetKxDatabaseRequest getKxDatabaseRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns database information for the specified environment ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKxDatabaseRequest.Builder} avoiding the need to
     * create one manually via {@link GetKxDatabaseRequest#builder()}
     * </p>
     *
     * @param getKxDatabaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.GetKxDatabaseRequest.Builder} to create a request.
     * @return Result of the GetKxDatabase operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKxDatabaseResponse getKxDatabase(Consumer<GetKxDatabaseRequest.Builder> getKxDatabaseRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return getKxDatabase(GetKxDatabaseRequest.builder().applyMutation(getKxDatabaseRequest).build());
    }

    /**
     * <p>
     * Retrieves details of the dataview.
     * </p>
     *
     * @param getKxDataviewRequest
     * @return Result of the GetKxDataview operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxDataview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxDataview" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKxDataviewResponse getKxDataview(GetKxDataviewRequest getKxDataviewRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of the dataview.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKxDataviewRequest.Builder} avoiding the need to
     * create one manually via {@link GetKxDataviewRequest#builder()}
     * </p>
     *
     * @param getKxDataviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.GetKxDataviewRequest.Builder} to create a request.
     * @return Result of the GetKxDataview operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxDataview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxDataview" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKxDataviewResponse getKxDataview(Consumer<GetKxDataviewRequest.Builder> getKxDataviewRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return getKxDataview(GetKxDataviewRequest.builder().applyMutation(getKxDataviewRequest).build());
    }

    /**
     * <p>
     * Retrieves all the information for the specified kdb environment.
     * </p>
     *
     * @param getKxEnvironmentRequest
     * @return Result of the GetKxEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKxEnvironmentResponse getKxEnvironment(GetKxEnvironmentRequest getKxEnvironmentRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, AccessDeniedException,
            ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all the information for the specified kdb environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKxEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link GetKxEnvironmentRequest#builder()}
     * </p>
     *
     * @param getKxEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.GetKxEnvironmentRequest.Builder} to create a
     *        request.
     * @return Result of the GetKxEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKxEnvironmentResponse getKxEnvironment(Consumer<GetKxEnvironmentRequest.Builder> getKxEnvironmentRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, AccessDeniedException,
            ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        return getKxEnvironment(GetKxEnvironmentRequest.builder().applyMutation(getKxEnvironmentRequest).build());
    }

    /**
     * <p>
     * Retrieves details of a scaling group.
     * </p>
     *
     * @param getKxScalingGroupRequest
     * @return Result of the GetKxScalingGroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxScalingGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default GetKxScalingGroupResponse getKxScalingGroup(GetKxScalingGroupRequest getKxScalingGroupRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of a scaling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKxScalingGroupRequest.Builder} avoiding the need
     * to create one manually via {@link GetKxScalingGroupRequest#builder()}
     * </p>
     *
     * @param getKxScalingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.GetKxScalingGroupRequest.Builder} to create a
     *        request.
     * @return Result of the GetKxScalingGroup operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxScalingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxScalingGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default GetKxScalingGroupResponse getKxScalingGroup(Consumer<GetKxScalingGroupRequest.Builder> getKxScalingGroupRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        return getKxScalingGroup(GetKxScalingGroupRequest.builder().applyMutation(getKxScalingGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified kdb user.
     * </p>
     *
     * @param getKxUserRequest
     * @return Result of the GetKxUser operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxUser" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKxUserResponse getKxUser(GetKxUserRequest getKxUserRequest) throws InternalServerException, ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified kdb user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKxUserRequest.Builder} avoiding the need to
     * create one manually via {@link GetKxUserRequest#builder()}
     * </p>
     *
     * @param getKxUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.GetKxUserRequest.Builder} to create a request.
     * @return Result of the GetKxUser operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxUser" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKxUserResponse getKxUser(Consumer<GetKxUserRequest.Builder> getKxUserRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, FinspaceException {
        return getKxUser(GetKxUserRequest.builder().applyMutation(getKxUserRequest).build());
    }

    /**
     * <p>
     * Retrieves the information about the volume.
     * </p>
     *
     * @param getKxVolumeRequest
     * @return Result of the GetKxVolume operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKxVolumeResponse getKxVolume(GetKxVolumeRequest getKxVolumeRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the information about the volume.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKxVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link GetKxVolumeRequest#builder()}
     * </p>
     *
     * @param getKxVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.GetKxVolumeRequest.Builder} to create a request.
     * @return Result of the GetKxVolume operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.GetKxVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/GetKxVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default GetKxVolumeResponse getKxVolume(Consumer<GetKxVolumeRequest.Builder> getKxVolumeRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        return getKxVolume(GetKxVolumeRequest.builder().applyMutation(getKxVolumeRequest).build());
    }

    /**
     * <p>
     * A list of all of your FinSpace environments.
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return Result of the ListEnvironments operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated This method will be discontinued.
     */
    @Deprecated
    default ListEnvironmentsResponse listEnvironments(ListEnvironmentsRequest listEnvironmentsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of all of your FinSpace environments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListEnvironmentsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEnvironments operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated This method will be discontinued.
     */
    @Deprecated
    default ListEnvironmentsResponse listEnvironments(Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            FinspaceException {
        return listEnvironments(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the changesets for a database.
     * </p>
     *
     * @param listKxChangesetsRequest
     * @return Result of the ListKxChangesets operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxChangesets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxChangesets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxChangesetsResponse listKxChangesets(ListKxChangesetsRequest listKxChangesetsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the changesets for a database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKxChangesetsRequest.Builder} avoiding the need
     * to create one manually via {@link ListKxChangesetsRequest#builder()}
     * </p>
     *
     * @param listKxChangesetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListKxChangesetsRequest.Builder} to create a
     *        request.
     * @return Result of the ListKxChangesets operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxChangesets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxChangesets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxChangesetsResponse listKxChangesets(Consumer<ListKxChangesetsRequest.Builder> listKxChangesetsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return listKxChangesets(ListKxChangesetsRequest.builder().applyMutation(listKxChangesetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the changesets for a database.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKxChangesets(software.amazon.awssdk.services.finspace.model.ListKxChangesetsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxChangesetsIterable responses = client.listKxChangesetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.finspace.paginators.ListKxChangesetsIterable responses = client
     *             .listKxChangesetsPaginator(request);
     *     for (software.amazon.awssdk.services.finspace.model.ListKxChangesetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxChangesetsIterable responses = client.listKxChangesetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKxChangesets(software.amazon.awssdk.services.finspace.model.ListKxChangesetsRequest)} operation.</b>
     * </p>
     *
     * @param listKxChangesetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxChangesets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxChangesets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxChangesetsIterable listKxChangesetsPaginator(ListKxChangesetsRequest listKxChangesetsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return new ListKxChangesetsIterable(this, listKxChangesetsRequest);
    }

    /**
     * <p>
     * Returns a list of all the changesets for a database.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKxChangesets(software.amazon.awssdk.services.finspace.model.ListKxChangesetsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxChangesetsIterable responses = client.listKxChangesetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.finspace.paginators.ListKxChangesetsIterable responses = client
     *             .listKxChangesetsPaginator(request);
     *     for (software.amazon.awssdk.services.finspace.model.ListKxChangesetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxChangesetsIterable responses = client.listKxChangesetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKxChangesets(software.amazon.awssdk.services.finspace.model.ListKxChangesetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKxChangesetsRequest.Builder} avoiding the need
     * to create one manually via {@link ListKxChangesetsRequest#builder()}
     * </p>
     *
     * @param listKxChangesetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListKxChangesetsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxChangesets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxChangesets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxChangesetsIterable listKxChangesetsPaginator(Consumer<ListKxChangesetsRequest.Builder> listKxChangesetsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return listKxChangesetsPaginator(ListKxChangesetsRequest.builder().applyMutation(listKxChangesetsRequest).build());
    }

    /**
     * <p>
     * Lists all the nodes in a kdb cluster.
     * </p>
     *
     * @param listKxClusterNodesRequest
     * @return Result of the ListKxClusterNodes operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxClusterNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxClusterNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKxClusterNodesResponse listKxClusterNodes(ListKxClusterNodesRequest listKxClusterNodesRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, LimitExceededException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the nodes in a kdb cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKxClusterNodesRequest.Builder} avoiding the
     * need to create one manually via {@link ListKxClusterNodesRequest#builder()}
     * </p>
     *
     * @param listKxClusterNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListKxClusterNodesRequest.Builder} to create a
     *        request.
     * @return Result of the ListKxClusterNodes operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxClusterNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxClusterNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKxClusterNodesResponse listKxClusterNodes(Consumer<ListKxClusterNodesRequest.Builder> listKxClusterNodesRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, LimitExceededException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return listKxClusterNodes(ListKxClusterNodesRequest.builder().applyMutation(listKxClusterNodesRequest).build());
    }

    /**
     * <p>
     * Lists all the nodes in a kdb cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKxClusterNodes(software.amazon.awssdk.services.finspace.model.ListKxClusterNodesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxClusterNodesIterable responses = client.listKxClusterNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.finspace.paginators.ListKxClusterNodesIterable responses = client
     *             .listKxClusterNodesPaginator(request);
     *     for (software.amazon.awssdk.services.finspace.model.ListKxClusterNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxClusterNodesIterable responses = client.listKxClusterNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKxClusterNodes(software.amazon.awssdk.services.finspace.model.ListKxClusterNodesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listKxClusterNodesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxClusterNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxClusterNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKxClusterNodesIterable listKxClusterNodesPaginator(ListKxClusterNodesRequest listKxClusterNodesRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, LimitExceededException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return new ListKxClusterNodesIterable(this, listKxClusterNodesRequest);
    }

    /**
     * <p>
     * Lists all the nodes in a kdb cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKxClusterNodes(software.amazon.awssdk.services.finspace.model.ListKxClusterNodesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxClusterNodesIterable responses = client.listKxClusterNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.finspace.paginators.ListKxClusterNodesIterable responses = client
     *             .listKxClusterNodesPaginator(request);
     *     for (software.amazon.awssdk.services.finspace.model.ListKxClusterNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxClusterNodesIterable responses = client.listKxClusterNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKxClusterNodes(software.amazon.awssdk.services.finspace.model.ListKxClusterNodesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKxClusterNodesRequest.Builder} avoiding the
     * need to create one manually via {@link ListKxClusterNodesRequest#builder()}
     * </p>
     *
     * @param listKxClusterNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListKxClusterNodesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxClusterNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxClusterNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKxClusterNodesIterable listKxClusterNodesPaginator(
            Consumer<ListKxClusterNodesRequest.Builder> listKxClusterNodesRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, LimitExceededException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, FinspaceException {
        return listKxClusterNodesPaginator(ListKxClusterNodesRequest.builder().applyMutation(listKxClusterNodesRequest).build());
    }

    /**
     * <p>
     * Returns a list of clusters.
     * </p>
     *
     * @param listKxClustersRequest
     * @return Result of the ListKxClusters operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxClustersResponse listKxClusters(ListKxClustersRequest listKxClustersRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKxClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListKxClustersRequest#builder()}
     * </p>
     *
     * @param listKxClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListKxClustersRequest.Builder} to create a request.
     * @return Result of the ListKxClusters operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxClustersResponse listKxClusters(Consumer<ListKxClustersRequest.Builder> listKxClustersRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        return listKxClusters(ListKxClustersRequest.builder().applyMutation(listKxClustersRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the databases in the kdb environment.
     * </p>
     *
     * @param listKxDatabasesRequest
     * @return Result of the ListKxDatabases operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxDatabasesResponse listKxDatabases(ListKxDatabasesRequest listKxDatabasesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the databases in the kdb environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKxDatabasesRequest.Builder} avoiding the need
     * to create one manually via {@link ListKxDatabasesRequest#builder()}
     * </p>
     *
     * @param listKxDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListKxDatabasesRequest.Builder} to create a request.
     * @return Result of the ListKxDatabases operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxDatabasesResponse listKxDatabases(Consumer<ListKxDatabasesRequest.Builder> listKxDatabasesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return listKxDatabases(ListKxDatabasesRequest.builder().applyMutation(listKxDatabasesRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the databases in the kdb environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKxDatabases(software.amazon.awssdk.services.finspace.model.ListKxDatabasesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxDatabasesIterable responses = client.listKxDatabasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.finspace.paginators.ListKxDatabasesIterable responses = client
     *             .listKxDatabasesPaginator(request);
     *     for (software.amazon.awssdk.services.finspace.model.ListKxDatabasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxDatabasesIterable responses = client.listKxDatabasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKxDatabases(software.amazon.awssdk.services.finspace.model.ListKxDatabasesRequest)} operation.</b>
     * </p>
     *
     * @param listKxDatabasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxDatabasesIterable listKxDatabasesPaginator(ListKxDatabasesRequest listKxDatabasesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return new ListKxDatabasesIterable(this, listKxDatabasesRequest);
    }

    /**
     * <p>
     * Returns a list of all the databases in the kdb environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKxDatabases(software.amazon.awssdk.services.finspace.model.ListKxDatabasesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxDatabasesIterable responses = client.listKxDatabasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.finspace.paginators.ListKxDatabasesIterable responses = client
     *             .listKxDatabasesPaginator(request);
     *     for (software.amazon.awssdk.services.finspace.model.ListKxDatabasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxDatabasesIterable responses = client.listKxDatabasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKxDatabases(software.amazon.awssdk.services.finspace.model.ListKxDatabasesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKxDatabasesRequest.Builder} avoiding the need
     * to create one manually via {@link ListKxDatabasesRequest#builder()}
     * </p>
     *
     * @param listKxDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListKxDatabasesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxDatabasesIterable listKxDatabasesPaginator(Consumer<ListKxDatabasesRequest.Builder> listKxDatabasesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return listKxDatabasesPaginator(ListKxDatabasesRequest.builder().applyMutation(listKxDatabasesRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the dataviews in the database.
     * </p>
     *
     * @param listKxDataviewsRequest
     * @return Result of the ListKxDataviews operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxDataviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxDataviews" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxDataviewsResponse listKxDataviews(ListKxDataviewsRequest listKxDataviewsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the dataviews in the database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKxDataviewsRequest.Builder} avoiding the need
     * to create one manually via {@link ListKxDataviewsRequest#builder()}
     * </p>
     *
     * @param listKxDataviewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListKxDataviewsRequest.Builder} to create a request.
     * @return Result of the ListKxDataviews operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxDataviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxDataviews" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxDataviewsResponse listKxDataviews(Consumer<ListKxDataviewsRequest.Builder> listKxDataviewsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return listKxDataviews(ListKxDataviewsRequest.builder().applyMutation(listKxDataviewsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the dataviews in the database.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKxDataviews(software.amazon.awssdk.services.finspace.model.ListKxDataviewsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxDataviewsIterable responses = client.listKxDataviewsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.finspace.paginators.ListKxDataviewsIterable responses = client
     *             .listKxDataviewsPaginator(request);
     *     for (software.amazon.awssdk.services.finspace.model.ListKxDataviewsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxDataviewsIterable responses = client.listKxDataviewsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKxDataviews(software.amazon.awssdk.services.finspace.model.ListKxDataviewsRequest)} operation.</b>
     * </p>
     *
     * @param listKxDataviewsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxDataviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxDataviews" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxDataviewsIterable listKxDataviewsPaginator(ListKxDataviewsRequest listKxDataviewsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return new ListKxDataviewsIterable(this, listKxDataviewsRequest);
    }

    /**
     * <p>
     * Returns a list of all the dataviews in the database.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKxDataviews(software.amazon.awssdk.services.finspace.model.ListKxDataviewsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxDataviewsIterable responses = client.listKxDataviewsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.finspace.paginators.ListKxDataviewsIterable responses = client
     *             .listKxDataviewsPaginator(request);
     *     for (software.amazon.awssdk.services.finspace.model.ListKxDataviewsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxDataviewsIterable responses = client.listKxDataviewsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKxDataviews(software.amazon.awssdk.services.finspace.model.ListKxDataviewsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKxDataviewsRequest.Builder} avoiding the need
     * to create one manually via {@link ListKxDataviewsRequest#builder()}
     * </p>
     *
     * @param listKxDataviewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListKxDataviewsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxDataviews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxDataviews" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxDataviewsIterable listKxDataviewsPaginator(Consumer<ListKxDataviewsRequest.Builder> listKxDataviewsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return listKxDataviewsPaginator(ListKxDataviewsRequest.builder().applyMutation(listKxDataviewsRequest).build());
    }

    /**
     * <p>
     * Returns a list of kdb environments created in an account.
     * </p>
     *
     * @param listKxEnvironmentsRequest
     * @return Result of the ListKxEnvironments operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxEnvironments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKxEnvironmentsResponse listKxEnvironments(ListKxEnvironmentsRequest listKxEnvironmentsRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of kdb environments created in an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKxEnvironmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListKxEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listKxEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsRequest.Builder} to create a
     *        request.
     * @return Result of the ListKxEnvironments operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxEnvironments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKxEnvironmentsResponse listKxEnvironments(Consumer<ListKxEnvironmentsRequest.Builder> listKxEnvironmentsRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            FinspaceException {
        return listKxEnvironments(ListKxEnvironmentsRequest.builder().applyMutation(listKxEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Returns a list of kdb environments created in an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKxEnvironments(software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxEnvironmentsIterable responses = client.listKxEnvironmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.finspace.paginators.ListKxEnvironmentsIterable responses = client
     *             .listKxEnvironmentsPaginator(request);
     *     for (software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxEnvironmentsIterable responses = client.listKxEnvironmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKxEnvironments(software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listKxEnvironmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxEnvironments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKxEnvironmentsIterable listKxEnvironmentsPaginator(ListKxEnvironmentsRequest listKxEnvironmentsRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            FinspaceException {
        return new ListKxEnvironmentsIterable(this, listKxEnvironmentsRequest);
    }

    /**
     * <p>
     * Returns a list of kdb environments created in an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKxEnvironments(software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxEnvironmentsIterable responses = client.listKxEnvironmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.finspace.paginators.ListKxEnvironmentsIterable responses = client
     *             .listKxEnvironmentsPaginator(request);
     *     for (software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxEnvironmentsIterable responses = client.listKxEnvironmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKxEnvironments(software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKxEnvironmentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListKxEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listKxEnvironmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListKxEnvironmentsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxEnvironments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKxEnvironmentsIterable listKxEnvironmentsPaginator(
            Consumer<ListKxEnvironmentsRequest.Builder> listKxEnvironmentsRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        return listKxEnvironmentsPaginator(ListKxEnvironmentsRequest.builder().applyMutation(listKxEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Returns a list of scaling groups in a kdb environment.
     * </p>
     *
     * @param listKxScalingGroupsRequest
     * @return Result of the ListKxScalingGroups operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxScalingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxScalingGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKxScalingGroupsResponse listKxScalingGroups(ListKxScalingGroupsRequest listKxScalingGroupsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of scaling groups in a kdb environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKxScalingGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListKxScalingGroupsRequest#builder()}
     * </p>
     *
     * @param listKxScalingGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListKxScalingGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the ListKxScalingGroups operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxScalingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxScalingGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKxScalingGroupsResponse listKxScalingGroups(
            Consumer<ListKxScalingGroupsRequest.Builder> listKxScalingGroupsRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return listKxScalingGroups(ListKxScalingGroupsRequest.builder().applyMutation(listKxScalingGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of scaling groups in a kdb environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKxScalingGroups(software.amazon.awssdk.services.finspace.model.ListKxScalingGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxScalingGroupsIterable responses = client.listKxScalingGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.finspace.paginators.ListKxScalingGroupsIterable responses = client
     *             .listKxScalingGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.finspace.model.ListKxScalingGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxScalingGroupsIterable responses = client.listKxScalingGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKxScalingGroups(software.amazon.awssdk.services.finspace.model.ListKxScalingGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listKxScalingGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxScalingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxScalingGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKxScalingGroupsIterable listKxScalingGroupsPaginator(ListKxScalingGroupsRequest listKxScalingGroupsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        return new ListKxScalingGroupsIterable(this, listKxScalingGroupsRequest);
    }

    /**
     * <p>
     * Returns a list of scaling groups in a kdb environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKxScalingGroups(software.amazon.awssdk.services.finspace.model.ListKxScalingGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxScalingGroupsIterable responses = client.listKxScalingGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.finspace.paginators.ListKxScalingGroupsIterable responses = client
     *             .listKxScalingGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.finspace.model.ListKxScalingGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.finspace.paginators.ListKxScalingGroupsIterable responses = client.listKxScalingGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKxScalingGroups(software.amazon.awssdk.services.finspace.model.ListKxScalingGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKxScalingGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListKxScalingGroupsRequest#builder()}
     * </p>
     *
     * @param listKxScalingGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListKxScalingGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxScalingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxScalingGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListKxScalingGroupsIterable listKxScalingGroupsPaginator(
            Consumer<ListKxScalingGroupsRequest.Builder> listKxScalingGroupsRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return listKxScalingGroupsPaginator(ListKxScalingGroupsRequest.builder().applyMutation(listKxScalingGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the users in a kdb environment.
     * </p>
     *
     * @param listKxUsersRequest
     * @return Result of the ListKxUsers operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxUsersResponse listKxUsers(ListKxUsersRequest listKxUsersRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the users in a kdb environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKxUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListKxUsersRequest#builder()}
     * </p>
     *
     * @param listKxUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListKxUsersRequest.Builder} to create a request.
     * @return Result of the ListKxUsers operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxUsersResponse listKxUsers(Consumer<ListKxUsersRequest.Builder> listKxUsersRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        return listKxUsers(ListKxUsersRequest.builder().applyMutation(listKxUsersRequest).build());
    }

    /**
     * <p>
     * Lists all the volumes in a kdb environment.
     * </p>
     *
     * @param listKxVolumesRequest
     * @return Result of the ListKxVolumes operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxVolumes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxVolumes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxVolumesResponse listKxVolumes(ListKxVolumesRequest listKxVolumesRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, LimitExceededException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the volumes in a kdb environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKxVolumesRequest.Builder} avoiding the need to
     * create one manually via {@link ListKxVolumesRequest#builder()}
     * </p>
     *
     * @param listKxVolumesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListKxVolumesRequest.Builder} to create a request.
     * @return Result of the ListKxVolumes operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListKxVolumes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListKxVolumes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKxVolumesResponse listKxVolumes(Consumer<ListKxVolumesRequest.Builder> listKxVolumesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            LimitExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        return listKxVolumes(ListKxVolumesRequest.builder().applyMutation(listKxVolumesRequest).build());
    }

    /**
     * <p>
     * A list of all tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The request is invalid. Something is wrong with the input to the request.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of all tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The request is invalid. Something is wrong with the input to the request.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to a FinSpace resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The request is invalid. Something is wrong with the input to the request.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to a FinSpace resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The request is invalid. Something is wrong with the input to the request.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, FinspaceException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from a FinSpace resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The request is invalid. Something is wrong with the input to the request.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from a FinSpace resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws InvalidRequestException
     *         The request is invalid. Something is wrong with the input to the request.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, FinspaceException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update your FinSpace environment.
     * </p>
     *
     * @param updateEnvironmentRequest
     * @return Result of the UpdateEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateEnvironment" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This method will be discontinued.
     */
    @Deprecated
    default UpdateEnvironmentResponse updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update your FinSpace environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEnvironmentRequest#builder()}
     * </p>
     *
     * @param updateEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.UpdateEnvironmentRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateEnvironment" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This method will be discontinued.
     */
    @Deprecated
    default UpdateEnvironmentResponse updateEnvironment(Consumer<UpdateEnvironmentRequest.Builder> updateEnvironmentRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, FinspaceException {
        return updateEnvironment(UpdateEnvironmentRequest.builder().applyMutation(updateEnvironmentRequest).build());
    }

    /**
     * <p>
     * Allows you to update code configuration on a running cluster. By using this API you can update the code, the
     * initialization script path, and the command line arguments for a specific cluster. The configuration that you
     * want to update will override any existing configurations on the cluster.
     * </p>
     *
     * @param updateKxClusterCodeConfigurationRequest
     * @return Result of the UpdateKxClusterCodeConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxClusterCodeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxClusterCodeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateKxClusterCodeConfigurationResponse updateKxClusterCodeConfiguration(
            UpdateKxClusterCodeConfigurationRequest updateKxClusterCodeConfigurationRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, LimitExceededException, ValidationException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to update code configuration on a running cluster. By using this API you can update the code, the
     * initialization script path, and the command line arguments for a specific cluster. The configuration that you
     * want to update will override any existing configurations on the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKxClusterCodeConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateKxClusterCodeConfigurationRequest#builder()}
     * </p>
     *
     * @param updateKxClusterCodeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.UpdateKxClusterCodeConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateKxClusterCodeConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxClusterCodeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxClusterCodeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateKxClusterCodeConfigurationResponse updateKxClusterCodeConfiguration(
            Consumer<UpdateKxClusterCodeConfigurationRequest.Builder> updateKxClusterCodeConfigurationRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, LimitExceededException,
            ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        return updateKxClusterCodeConfiguration(UpdateKxClusterCodeConfigurationRequest.builder()
                .applyMutation(updateKxClusterCodeConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the databases mounted on a kdb cluster, which includes the <code>changesetId</code> and all the dbPaths
     * to be cached. This API does not allow you to change a database name or add a database if you created a cluster
     * without one.
     * </p>
     * <p>
     * Using this API you can point a cluster to a different changeset and modify a list of partitions being cached.
     * </p>
     *
     * @param updateKxClusterDatabasesRequest
     * @return Result of the UpdateKxClusterDatabases operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxClusterDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxClusterDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateKxClusterDatabasesResponse updateKxClusterDatabases(
            UpdateKxClusterDatabasesRequest updateKxClusterDatabasesRequest) throws InternalServerException, ThrottlingException,
            AccessDeniedException, LimitExceededException, ValidationException, ConflictException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the databases mounted on a kdb cluster, which includes the <code>changesetId</code> and all the dbPaths
     * to be cached. This API does not allow you to change a database name or add a database if you created a cluster
     * without one.
     * </p>
     * <p>
     * Using this API you can point a cluster to a different changeset and modify a list of partitions being cached.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKxClusterDatabasesRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateKxClusterDatabasesRequest#builder()}
     * </p>
     *
     * @param updateKxClusterDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.UpdateKxClusterDatabasesRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateKxClusterDatabases operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxClusterDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxClusterDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateKxClusterDatabasesResponse updateKxClusterDatabases(
            Consumer<UpdateKxClusterDatabasesRequest.Builder> updateKxClusterDatabasesRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, LimitExceededException, ValidationException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        return updateKxClusterDatabases(UpdateKxClusterDatabasesRequest.builder().applyMutation(updateKxClusterDatabasesRequest)
                .build());
    }

    /**
     * <p>
     * Updates information for the given kdb database.
     * </p>
     *
     * @param updateKxDatabaseRequest
     * @return Result of the UpdateKxDatabase operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateKxDatabaseResponse updateKxDatabase(UpdateKxDatabaseRequest updateKxDatabaseRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information for the given kdb database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKxDatabaseRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateKxDatabaseRequest#builder()}
     * </p>
     *
     * @param updateKxDatabaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.UpdateKxDatabaseRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateKxDatabase operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateKxDatabaseResponse updateKxDatabase(Consumer<UpdateKxDatabaseRequest.Builder> updateKxDatabaseRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        return updateKxDatabase(UpdateKxDatabaseRequest.builder().applyMutation(updateKxDatabaseRequest).build());
    }

    /**
     * <p>
     * Updates the specified dataview. The dataviews get automatically updated when any new changesets are ingested.
     * Each update of the dataview creates a new version, including changeset details and cache configurations
     * </p>
     *
     * @param updateKxDataviewRequest
     * @return Result of the UpdateKxDataview operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceAlreadyExistsException
     *         The specified resource group already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxDataview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxDataview" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateKxDataviewResponse updateKxDataview(UpdateKxDataviewRequest updateKxDataviewRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, ResourceAlreadyExistsException, AwsServiceException,
            SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified dataview. The dataviews get automatically updated when any new changesets are ingested.
     * Each update of the dataview creates a new version, including changeset details and cache configurations
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKxDataviewRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateKxDataviewRequest#builder()}
     * </p>
     *
     * @param updateKxDataviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.UpdateKxDataviewRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateKxDataview operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceAlreadyExistsException
     *         The specified resource group already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxDataview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxDataview" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateKxDataviewResponse updateKxDataview(Consumer<UpdateKxDataviewRequest.Builder> updateKxDataviewRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ConflictException, ResourceAlreadyExistsException, AwsServiceException,
            SdkClientException, FinspaceException {
        return updateKxDataview(UpdateKxDataviewRequest.builder().applyMutation(updateKxDataviewRequest).build());
    }

    /**
     * <p>
     * Updates information for the given kdb environment.
     * </p>
     *
     * @param updateKxEnvironmentRequest
     * @return Result of the UpdateKxEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateKxEnvironmentResponse updateKxEnvironment(UpdateKxEnvironmentRequest updateKxEnvironmentRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information for the given kdb environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKxEnvironmentRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateKxEnvironmentRequest#builder()}
     * </p>
     *
     * @param updateKxEnvironmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateKxEnvironment operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxEnvironment" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateKxEnvironmentResponse updateKxEnvironment(
            Consumer<UpdateKxEnvironmentRequest.Builder> updateKxEnvironmentRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, FinspaceException {
        return updateKxEnvironment(UpdateKxEnvironmentRequest.builder().applyMutation(updateKxEnvironmentRequest).build());
    }

    /**
     * <p>
     * Updates environment network to connect to your internal network by using a transit gateway. This API supports
     * request to create a transit gateway attachment from FinSpace VPC to your transit gateway ID and create a custom
     * Route-53 outbound resolvers.
     * </p>
     * <p>
     * Once you send a request to update a network, you cannot change it again. Network update might require termination
     * of any clusters that are running in the existing network.
     * </p>
     *
     * @param updateKxEnvironmentNetworkRequest
     * @return Result of the UpdateKxEnvironmentNetwork operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxEnvironmentNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxEnvironmentNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateKxEnvironmentNetworkResponse updateKxEnvironmentNetwork(
            UpdateKxEnvironmentNetworkRequest updateKxEnvironmentNetworkRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates environment network to connect to your internal network by using a transit gateway. This API supports
     * request to create a transit gateway attachment from FinSpace VPC to your transit gateway ID and create a custom
     * Route-53 outbound resolvers.
     * </p>
     * <p>
     * Once you send a request to update a network, you cannot change it again. Network update might require termination
     * of any clusters that are running in the existing network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKxEnvironmentNetworkRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateKxEnvironmentNetworkRequest#builder()}
     * </p>
     *
     * @param updateKxEnvironmentNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.UpdateKxEnvironmentNetworkRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateKxEnvironmentNetwork operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxEnvironmentNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxEnvironmentNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateKxEnvironmentNetworkResponse updateKxEnvironmentNetwork(
            Consumer<UpdateKxEnvironmentNetworkRequest.Builder> updateKxEnvironmentNetworkRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        return updateKxEnvironmentNetwork(UpdateKxEnvironmentNetworkRequest.builder()
                .applyMutation(updateKxEnvironmentNetworkRequest).build());
    }

    /**
     * <p>
     * Updates the user details. You can only update the IAM role associated with a user.
     * </p>
     *
     * @param updateKxUserRequest
     * @return Result of the UpdateKxUser operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateKxUserResponse updateKxUser(UpdateKxUserRequest updateKxUserRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, LimitExceededException,
            ConflictException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the user details. You can only update the IAM role associated with a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKxUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateKxUserRequest#builder()}
     * </p>
     *
     * @param updateKxUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.UpdateKxUserRequest.Builder} to create a request.
     * @return Result of the UpdateKxUser operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateKxUserResponse updateKxUser(Consumer<UpdateKxUserRequest.Builder> updateKxUserRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, LimitExceededException, ConflictException, AwsServiceException, SdkClientException,
            FinspaceException {
        return updateKxUser(UpdateKxUserRequest.builder().applyMutation(updateKxUserRequest).build());
    }

    /**
     * <p>
     * Updates the throughput or capacity of a volume. During the update process, the filesystem might be unavailable
     * for a few minutes. You can retry any operations after the update is complete.
     * </p>
     *
     * @param updateKxVolumeRequest
     * @return Result of the UpdateKxVolume operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateKxVolumeResponse updateKxVolume(UpdateKxVolumeRequest updateKxVolumeRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, LimitExceededException, ValidationException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, FinspaceException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the throughput or capacity of a volume. During the update process, the filesystem might be unavailable
     * for a few minutes. You can retry any operations after the update is complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKxVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateKxVolumeRequest#builder()}
     * </p>
     *
     * @param updateKxVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.finspace.model.UpdateKxVolumeRequest.Builder} to create a request.
     * @return Result of the UpdateKxVolume operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws LimitExceededException
     *         A service limit or quota is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         There was a conflict with this action, and it could not be completed.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FinspaceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FinspaceClient.UpdateKxVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/UpdateKxVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateKxVolumeResponse updateKxVolume(Consumer<UpdateKxVolumeRequest.Builder> updateKxVolumeRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, LimitExceededException,
            ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FinspaceException {
        return updateKxVolume(UpdateKxVolumeRequest.builder().applyMutation(updateKxVolumeRequest).build());
    }

    /**
     * Create a {@link FinspaceClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static FinspaceClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link FinspaceClient}.
     */
    static FinspaceClientBuilder builder() {
        return new DefaultFinspaceClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default FinspaceServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
