/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of data that is available for querying from this database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KxDatabaseConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KxDatabaseConfiguration.Builder, KxDatabaseConfiguration> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(KxDatabaseConfiguration::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<List<KxDatabaseCacheConfiguration>> CACHE_CONFIGURATIONS_FIELD = SdkField
            .<List<KxDatabaseCacheConfiguration>> builder(MarshallingType.LIST)
            .memberName("cacheConfigurations")
            .getter(getter(KxDatabaseConfiguration::cacheConfigurations))
            .setter(setter(Builder::cacheConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KxDatabaseCacheConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(KxDatabaseCacheConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changesetId").getter(getter(KxDatabaseConfiguration::changesetId)).setter(setter(Builder::changesetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()).build();

    private static final SdkField<String> DATAVIEW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataviewName").getter(getter(KxDatabaseConfiguration::dataviewName))
            .setter(setter(Builder::dataviewName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataviewName").build()).build();

    private static final SdkField<KxDataviewConfiguration> DATAVIEW_CONFIGURATION_FIELD = SdkField
            .<KxDataviewConfiguration> builder(MarshallingType.SDK_POJO).memberName("dataviewConfiguration")
            .getter(getter(KxDatabaseConfiguration::dataviewConfiguration)).setter(setter(Builder::dataviewConfiguration))
            .constructor(KxDataviewConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataviewConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            CACHE_CONFIGURATIONS_FIELD, CHANGESET_ID_FIELD, DATAVIEW_NAME_FIELD, DATAVIEW_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String databaseName;

    private final List<KxDatabaseCacheConfiguration> cacheConfigurations;

    private final String changesetId;

    private final String dataviewName;

    private final KxDataviewConfiguration dataviewConfiguration;

    private KxDatabaseConfiguration(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.cacheConfigurations = builder.cacheConfigurations;
        this.changesetId = builder.changesetId;
        this.dataviewName = builder.dataviewName;
        this.dataviewConfiguration = builder.dataviewConfiguration;
    }

    /**
     * <p>
     * The name of the kdb database. When this parameter is specified in the structure, S3 with the whole database is
     * included by default.
     * </p>
     * 
     * @return The name of the kdb database. When this parameter is specified in the structure, S3 with the whole
     *         database is included by default.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCacheConfigurations() {
        return cacheConfigurations != null && !(cacheConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration details for the disk cache used to increase performance reading from a kdb database mounted to the
     * cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheConfigurations} method.
     * </p>
     * 
     * @return Configuration details for the disk cache used to increase performance reading from a kdb database mounted
     *         to the cluster.
     */
    public final List<KxDatabaseCacheConfiguration> cacheConfigurations() {
        return cacheConfigurations;
    }

    /**
     * <p>
     * A unique identifier of the changeset that is associated with the cluster.
     * </p>
     * 
     * @return A unique identifier of the changeset that is associated with the cluster.
     */
    public final String changesetId() {
        return changesetId;
    }

    /**
     * <p>
     * The name of the dataview to be used for caching historical data on disk.
     * </p>
     * 
     * @return The name of the dataview to be used for caching historical data on disk.
     */
    public final String dataviewName() {
        return dataviewName;
    }

    /**
     * <p>
     * The configuration of the dataview to be used with specified cluster.
     * </p>
     * 
     * @return The configuration of the dataview to be used with specified cluster.
     */
    public final KxDataviewConfiguration dataviewConfiguration() {
        return dataviewConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheConfigurations() ? cacheConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(dataviewName());
        hashCode = 31 * hashCode + Objects.hashCode(dataviewConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxDatabaseConfiguration)) {
            return false;
        }
        KxDatabaseConfiguration other = (KxDatabaseConfiguration) obj;
        return Objects.equals(databaseName(), other.databaseName()) && hasCacheConfigurations() == other.hasCacheConfigurations()
                && Objects.equals(cacheConfigurations(), other.cacheConfigurations())
                && Objects.equals(changesetId(), other.changesetId()) && Objects.equals(dataviewName(), other.dataviewName())
                && Objects.equals(dataviewConfiguration(), other.dataviewConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KxDatabaseConfiguration").add("DatabaseName", databaseName())
                .add("CacheConfigurations", hasCacheConfigurations() ? cacheConfigurations() : null)
                .add("ChangesetId", changesetId()).add("DataviewName", dataviewName())
                .add("DataviewConfiguration", dataviewConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "cacheConfigurations":
            return Optional.ofNullable(clazz.cast(cacheConfigurations()));
        case "changesetId":
            return Optional.ofNullable(clazz.cast(changesetId()));
        case "dataviewName":
            return Optional.ofNullable(clazz.cast(dataviewName()));
        case "dataviewConfiguration":
            return Optional.ofNullable(clazz.cast(dataviewConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KxDatabaseConfiguration, T> g) {
        return obj -> g.apply((KxDatabaseConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KxDatabaseConfiguration> {
        /**
         * <p>
         * The name of the kdb database. When this parameter is specified in the structure, S3 with the whole database
         * is included by default.
         * </p>
         * 
         * @param databaseName
         *        The name of the kdb database. When this parameter is specified in the structure, S3 with the whole
         *        database is included by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * Configuration details for the disk cache used to increase performance reading from a kdb database mounted to
         * the cluster.
         * </p>
         * 
         * @param cacheConfigurations
         *        Configuration details for the disk cache used to increase performance reading from a kdb database
         *        mounted to the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheConfigurations(Collection<KxDatabaseCacheConfiguration> cacheConfigurations);

        /**
         * <p>
         * Configuration details for the disk cache used to increase performance reading from a kdb database mounted to
         * the cluster.
         * </p>
         * 
         * @param cacheConfigurations
         *        Configuration details for the disk cache used to increase performance reading from a kdb database
         *        mounted to the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheConfigurations(KxDatabaseCacheConfiguration... cacheConfigurations);

        /**
         * <p>
         * Configuration details for the disk cache used to increase performance reading from a kdb database mounted to
         * the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.KxDatabaseCacheConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.finspace.model.KxDatabaseCacheConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.KxDatabaseCacheConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #cacheConfigurations(List<KxDatabaseCacheConfiguration>)}.
         * 
         * @param cacheConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.KxDatabaseCacheConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheConfigurations(java.util.Collection<KxDatabaseCacheConfiguration>)
         */
        Builder cacheConfigurations(Consumer<KxDatabaseCacheConfiguration.Builder>... cacheConfigurations);

        /**
         * <p>
         * A unique identifier of the changeset that is associated with the cluster.
         * </p>
         * 
         * @param changesetId
         *        A unique identifier of the changeset that is associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changesetId(String changesetId);

        /**
         * <p>
         * The name of the dataview to be used for caching historical data on disk.
         * </p>
         * 
         * @param dataviewName
         *        The name of the dataview to be used for caching historical data on disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataviewName(String dataviewName);

        /**
         * <p>
         * The configuration of the dataview to be used with specified cluster.
         * </p>
         * 
         * @param dataviewConfiguration
         *        The configuration of the dataview to be used with specified cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataviewConfiguration(KxDataviewConfiguration dataviewConfiguration);

        /**
         * <p>
         * The configuration of the dataview to be used with specified cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link KxDataviewConfiguration.Builder} avoiding
         * the need to create one manually via {@link KxDataviewConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KxDataviewConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #dataviewConfiguration(KxDataviewConfiguration)}.
         * 
         * @param dataviewConfiguration
         *        a consumer that will call methods on {@link KxDataviewConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataviewConfiguration(KxDataviewConfiguration)
         */
        default Builder dataviewConfiguration(Consumer<KxDataviewConfiguration.Builder> dataviewConfiguration) {
            return dataviewConfiguration(KxDataviewConfiguration.builder().applyMutation(dataviewConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String databaseName;

        private List<KxDatabaseCacheConfiguration> cacheConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String changesetId;

        private String dataviewName;

        private KxDataviewConfiguration dataviewConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(KxDatabaseConfiguration model) {
            databaseName(model.databaseName);
            cacheConfigurations(model.cacheConfigurations);
            changesetId(model.changesetId);
            dataviewName(model.dataviewName);
            dataviewConfiguration(model.dataviewConfiguration);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final List<KxDatabaseCacheConfiguration.Builder> getCacheConfigurations() {
            List<KxDatabaseCacheConfiguration.Builder> result = KxDatabaseCacheConfigurationsCopier
                    .copyToBuilder(this.cacheConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheConfigurations(Collection<KxDatabaseCacheConfiguration.BuilderImpl> cacheConfigurations) {
            this.cacheConfigurations = KxDatabaseCacheConfigurationsCopier.copyFromBuilder(cacheConfigurations);
        }

        @Override
        public final Builder cacheConfigurations(Collection<KxDatabaseCacheConfiguration> cacheConfigurations) {
            this.cacheConfigurations = KxDatabaseCacheConfigurationsCopier.copy(cacheConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheConfigurations(KxDatabaseCacheConfiguration... cacheConfigurations) {
            cacheConfigurations(Arrays.asList(cacheConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheConfigurations(Consumer<KxDatabaseCacheConfiguration.Builder>... cacheConfigurations) {
            cacheConfigurations(Stream.of(cacheConfigurations)
                    .map(c -> KxDatabaseCacheConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChangesetId() {
            return changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final String getDataviewName() {
            return dataviewName;
        }

        public final void setDataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
        }

        @Override
        public final Builder dataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
            return this;
        }

        public final KxDataviewConfiguration.Builder getDataviewConfiguration() {
            return dataviewConfiguration != null ? dataviewConfiguration.toBuilder() : null;
        }

        public final void setDataviewConfiguration(KxDataviewConfiguration.BuilderImpl dataviewConfiguration) {
            this.dataviewConfiguration = dataviewConfiguration != null ? dataviewConfiguration.build() : null;
        }

        @Override
        public final Builder dataviewConfiguration(KxDataviewConfiguration dataviewConfiguration) {
            this.dataviewConfiguration = dataviewConfiguration;
            return this;
        }

        @Override
        public KxDatabaseConfiguration build() {
            return new KxDatabaseConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
