/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeliveryStreamRequest extends FirehoseRequest implements
        ToCopyableBuilder<CreateDeliveryStreamRequest.Builder, CreateDeliveryStreamRequest> {
    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryStreamName").getter(getter(CreateDeliveryStreamRequest::deliveryStreamName))
            .setter(setter(Builder::deliveryStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamName").build())
            .build();

    private static final SdkField<String> DELIVERY_STREAM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryStreamType").getter(getter(CreateDeliveryStreamRequest::deliveryStreamTypeAsString))
            .setter(setter(Builder::deliveryStreamType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamType").build())
            .build();

    private static final SdkField<KinesisStreamSourceConfiguration> KINESIS_STREAM_SOURCE_CONFIGURATION_FIELD = SdkField
            .<KinesisStreamSourceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisStreamSourceConfiguration")
            .getter(getter(CreateDeliveryStreamRequest::kinesisStreamSourceConfiguration))
            .setter(setter(Builder::kinesisStreamSourceConfiguration))
            .constructor(KinesisStreamSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamSourceConfiguration")
                    .build()).build();

    private static final SdkField<DeliveryStreamEncryptionConfigurationInput> DELIVERY_STREAM_ENCRYPTION_CONFIGURATION_INPUT_FIELD = SdkField
            .<DeliveryStreamEncryptionConfigurationInput> builder(MarshallingType.SDK_POJO)
            .memberName("DeliveryStreamEncryptionConfigurationInput")
            .getter(getter(CreateDeliveryStreamRequest::deliveryStreamEncryptionConfigurationInput))
            .setter(setter(Builder::deliveryStreamEncryptionConfigurationInput))
            .constructor(DeliveryStreamEncryptionConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DeliveryStreamEncryptionConfigurationInput").build()).build();

    private static final SdkField<S3DestinationConfiguration> S3_DESTINATION_CONFIGURATION_FIELD = SdkField
            .<S3DestinationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("S3DestinationConfiguration")
            .getter(getter(CreateDeliveryStreamRequest::s3DestinationConfiguration))
            .setter(setter(Builder::s3DestinationConfiguration))
            .constructor(S3DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DestinationConfiguration").build())
            .build();

    private static final SdkField<ExtendedS3DestinationConfiguration> EXTENDED_S3_DESTINATION_CONFIGURATION_FIELD = SdkField
            .<ExtendedS3DestinationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ExtendedS3DestinationConfiguration")
            .getter(getter(CreateDeliveryStreamRequest::extendedS3DestinationConfiguration))
            .setter(setter(Builder::extendedS3DestinationConfiguration))
            .constructor(ExtendedS3DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedS3DestinationConfiguration")
                    .build()).build();

    private static final SdkField<RedshiftDestinationConfiguration> REDSHIFT_DESTINATION_CONFIGURATION_FIELD = SdkField
            .<RedshiftDestinationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("RedshiftDestinationConfiguration")
            .getter(getter(CreateDeliveryStreamRequest::redshiftDestinationConfiguration))
            .setter(setter(Builder::redshiftDestinationConfiguration))
            .constructor(RedshiftDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDestinationConfiguration")
                    .build()).build();

    private static final SdkField<ElasticsearchDestinationConfiguration> ELASTICSEARCH_DESTINATION_CONFIGURATION_FIELD = SdkField
            .<ElasticsearchDestinationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ElasticsearchDestinationConfiguration")
            .getter(getter(CreateDeliveryStreamRequest::elasticsearchDestinationConfiguration))
            .setter(setter(Builder::elasticsearchDestinationConfiguration))
            .constructor(ElasticsearchDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ElasticsearchDestinationConfiguration").build()).build();

    private static final SdkField<AmazonopensearchserviceDestinationConfiguration> AMAZONOPENSEARCHSERVICE_DESTINATION_CONFIGURATION_FIELD = SdkField
            .<AmazonopensearchserviceDestinationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("AmazonopensearchserviceDestinationConfiguration")
            .getter(getter(CreateDeliveryStreamRequest::amazonopensearchserviceDestinationConfiguration))
            .setter(setter(Builder::amazonopensearchserviceDestinationConfiguration))
            .constructor(AmazonopensearchserviceDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AmazonopensearchserviceDestinationConfiguration").build()).build();

    private static final SdkField<SplunkDestinationConfiguration> SPLUNK_DESTINATION_CONFIGURATION_FIELD = SdkField
            .<SplunkDestinationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SplunkDestinationConfiguration")
            .getter(getter(CreateDeliveryStreamRequest::splunkDestinationConfiguration))
            .setter(setter(Builder::splunkDestinationConfiguration))
            .constructor(SplunkDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplunkDestinationConfiguration")
                    .build()).build();

    private static final SdkField<HttpEndpointDestinationConfiguration> HTTP_ENDPOINT_DESTINATION_CONFIGURATION_FIELD = SdkField
            .<HttpEndpointDestinationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("HttpEndpointDestinationConfiguration")
            .getter(getter(CreateDeliveryStreamRequest::httpEndpointDestinationConfiguration))
            .setter(setter(Builder::httpEndpointDestinationConfiguration))
            .constructor(HttpEndpointDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("HttpEndpointDestinationConfiguration").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDeliveryStreamRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAME_FIELD,
            DELIVERY_STREAM_TYPE_FIELD, KINESIS_STREAM_SOURCE_CONFIGURATION_FIELD,
            DELIVERY_STREAM_ENCRYPTION_CONFIGURATION_INPUT_FIELD, S3_DESTINATION_CONFIGURATION_FIELD,
            EXTENDED_S3_DESTINATION_CONFIGURATION_FIELD, REDSHIFT_DESTINATION_CONFIGURATION_FIELD,
            ELASTICSEARCH_DESTINATION_CONFIGURATION_FIELD, AMAZONOPENSEARCHSERVICE_DESTINATION_CONFIGURATION_FIELD,
            SPLUNK_DESTINATION_CONFIGURATION_FIELD, HTTP_ENDPOINT_DESTINATION_CONFIGURATION_FIELD, TAGS_FIELD));

    private final String deliveryStreamName;

    private final String deliveryStreamType;

    private final KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration;

    private final DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput;

    private final S3DestinationConfiguration s3DestinationConfiguration;

    private final ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration;

    private final RedshiftDestinationConfiguration redshiftDestinationConfiguration;

    private final ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration;

    private final AmazonopensearchserviceDestinationConfiguration amazonopensearchserviceDestinationConfiguration;

    private final SplunkDestinationConfiguration splunkDestinationConfiguration;

    private final HttpEndpointDestinationConfiguration httpEndpointDestinationConfiguration;

    private final List<Tag> tags;

    private CreateDeliveryStreamRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.deliveryStreamType = builder.deliveryStreamType;
        this.kinesisStreamSourceConfiguration = builder.kinesisStreamSourceConfiguration;
        this.deliveryStreamEncryptionConfigurationInput = builder.deliveryStreamEncryptionConfigurationInput;
        this.s3DestinationConfiguration = builder.s3DestinationConfiguration;
        this.extendedS3DestinationConfiguration = builder.extendedS3DestinationConfiguration;
        this.redshiftDestinationConfiguration = builder.redshiftDestinationConfiguration;
        this.elasticsearchDestinationConfiguration = builder.elasticsearchDestinationConfiguration;
        this.amazonopensearchserviceDestinationConfiguration = builder.amazonopensearchserviceDestinationConfiguration;
        this.splunkDestinationConfiguration = builder.splunkDestinationConfiguration;
        this.httpEndpointDestinationConfiguration = builder.httpEndpointDestinationConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the delivery stream. This name must be unique per AWS account in the same AWS Region. If the delivery
     * streams are in different accounts or different Regions, you can have multiple delivery streams with the same
     * name.
     * </p>
     * 
     * @return The name of the delivery stream. This name must be unique per AWS account in the same AWS Region. If the
     *         delivery streams are in different accounts or different Regions, you can have multiple delivery streams
     *         with the same name.
     */
    public final String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * The delivery stream type. This parameter can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DirectPut</code>: Provider applications access the delivery stream directly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryStreamType} will return {@link DeliveryStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deliveryStreamTypeAsString}.
     * </p>
     * 
     * @return The delivery stream type. This parameter can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DirectPut</code>: Provider applications access the delivery stream directly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
     *         </p>
     *         </li>
     * @see DeliveryStreamType
     */
    public final DeliveryStreamType deliveryStreamType() {
        return DeliveryStreamType.fromValue(deliveryStreamType);
    }

    /**
     * <p>
     * The delivery stream type. This parameter can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DirectPut</code>: Provider applications access the delivery stream directly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryStreamType} will return {@link DeliveryStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #deliveryStreamTypeAsString}.
     * </p>
     * 
     * @return The delivery stream type. This parameter can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DirectPut</code>: Provider applications access the delivery stream directly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
     *         </p>
     *         </li>
     * @see DeliveryStreamType
     */
    public final String deliveryStreamTypeAsString() {
        return deliveryStreamType;
    }

    /**
     * <p>
     * When a Kinesis data stream is used as the source for the delivery stream, a
     * <a>KinesisStreamSourceConfiguration</a> containing the Kinesis data stream Amazon Resource Name (ARN) and the
     * role ARN for the source stream.
     * </p>
     * 
     * @return When a Kinesis data stream is used as the source for the delivery stream, a
     *         <a>KinesisStreamSourceConfiguration</a> containing the Kinesis data stream Amazon Resource Name (ARN) and
     *         the role ARN for the source stream.
     */
    public final KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration() {
        return kinesisStreamSourceConfiguration;
    }

    /**
     * <p>
     * Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption (SSE).
     * </p>
     * 
     * @return Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption
     *         (SSE).
     */
    public final DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput() {
        return deliveryStreamEncryptionConfigurationInput;
    }

    /**
     * <p>
     * [Deprecated] The destination in Amazon S3. You can specify only one destination.
     * </p>
     * 
     * @return [Deprecated] The destination in Amazon S3. You can specify only one destination.
     * @deprecated
     */
    @Deprecated
    public final S3DestinationConfiguration s3DestinationConfiguration() {
        return s3DestinationConfiguration;
    }

    /**
     * <p>
     * The destination in Amazon S3. You can specify only one destination.
     * </p>
     * 
     * @return The destination in Amazon S3. You can specify only one destination.
     */
    public final ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration() {
        return extendedS3DestinationConfiguration;
    }

    /**
     * <p>
     * The destination in Amazon Redshift. You can specify only one destination.
     * </p>
     * 
     * @return The destination in Amazon Redshift. You can specify only one destination.
     */
    public final RedshiftDestinationConfiguration redshiftDestinationConfiguration() {
        return redshiftDestinationConfiguration;
    }

    /**
     * <p>
     * The destination in Amazon ES. You can specify only one destination.
     * </p>
     * 
     * @return The destination in Amazon ES. You can specify only one destination.
     */
    public final ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration() {
        return elasticsearchDestinationConfiguration;
    }

    /**
     * Returns the value of the AmazonopensearchserviceDestinationConfiguration property for this object.
     * 
     * @return The value of the AmazonopensearchserviceDestinationConfiguration property for this object.
     */
    public final AmazonopensearchserviceDestinationConfiguration amazonopensearchserviceDestinationConfiguration() {
        return amazonopensearchserviceDestinationConfiguration;
    }

    /**
     * <p>
     * The destination in Splunk. You can specify only one destination.
     * </p>
     * 
     * @return The destination in Splunk. You can specify only one destination.
     */
    public final SplunkDestinationConfiguration splunkDestinationConfiguration() {
        return splunkDestinationConfiguration;
    }

    /**
     * <p>
     * Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. You can specify only one
     * destination.
     * </p>
     * 
     * @return Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. You can specify
     *         only one destination.
     */
    public final HttpEndpointDestinationConfiguration httpEndpointDestinationConfiguration() {
        return httpEndpointDestinationConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and assign to AWS
     * resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of
     * information that can help you distinguish the delivery stream. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the AWS Billing and Cost Management User Guide.
     * </p>
     * <p>
     * You can specify up to 50 tags when creating a delivery stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and assign
     *         to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other
     *         types of information that can help you distinguish the delivery stream. For more information about tags,
     *         see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using
     *         Cost Allocation Tags</a> in the AWS Billing and Cost Management User Guide.</p>
     *         <p>
     *         You can specify up to 50 tags when creating a delivery stream.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamEncryptionConfigurationInput());
        hashCode = 31 * hashCode + Objects.hashCode(s3DestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(extendedS3DestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(amazonopensearchserviceDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(splunkDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(httpEndpointDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeliveryStreamRequest)) {
            return false;
        }
        CreateDeliveryStreamRequest other = (CreateDeliveryStreamRequest) obj;
        return Objects.equals(deliveryStreamName(), other.deliveryStreamName())
                && Objects.equals(deliveryStreamTypeAsString(), other.deliveryStreamTypeAsString())
                && Objects.equals(kinesisStreamSourceConfiguration(), other.kinesisStreamSourceConfiguration())
                && Objects.equals(deliveryStreamEncryptionConfigurationInput(),
                        other.deliveryStreamEncryptionConfigurationInput())
                && Objects.equals(s3DestinationConfiguration(), other.s3DestinationConfiguration())
                && Objects.equals(extendedS3DestinationConfiguration(), other.extendedS3DestinationConfiguration())
                && Objects.equals(redshiftDestinationConfiguration(), other.redshiftDestinationConfiguration())
                && Objects.equals(elasticsearchDestinationConfiguration(), other.elasticsearchDestinationConfiguration())
                && Objects.equals(amazonopensearchserviceDestinationConfiguration(),
                        other.amazonopensearchserviceDestinationConfiguration())
                && Objects.equals(splunkDestinationConfiguration(), other.splunkDestinationConfiguration())
                && Objects.equals(httpEndpointDestinationConfiguration(), other.httpEndpointDestinationConfiguration())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDeliveryStreamRequest").add("DeliveryStreamName", deliveryStreamName())
                .add("DeliveryStreamType", deliveryStreamTypeAsString())
                .add("KinesisStreamSourceConfiguration", kinesisStreamSourceConfiguration())
                .add("DeliveryStreamEncryptionConfigurationInput", deliveryStreamEncryptionConfigurationInput())
                .add("S3DestinationConfiguration", s3DestinationConfiguration())
                .add("ExtendedS3DestinationConfiguration", extendedS3DestinationConfiguration())
                .add("RedshiftDestinationConfiguration", redshiftDestinationConfiguration())
                .add("ElasticsearchDestinationConfiguration", elasticsearchDestinationConfiguration())
                .add("AmazonopensearchserviceDestinationConfiguration", amazonopensearchserviceDestinationConfiguration())
                .add("SplunkDestinationConfiguration", splunkDestinationConfiguration())
                .add("HttpEndpointDestinationConfiguration", httpEndpointDestinationConfiguration())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamName":
            return Optional.ofNullable(clazz.cast(deliveryStreamName()));
        case "DeliveryStreamType":
            return Optional.ofNullable(clazz.cast(deliveryStreamTypeAsString()));
        case "KinesisStreamSourceConfiguration":
            return Optional.ofNullable(clazz.cast(kinesisStreamSourceConfiguration()));
        case "DeliveryStreamEncryptionConfigurationInput":
            return Optional.ofNullable(clazz.cast(deliveryStreamEncryptionConfigurationInput()));
        case "S3DestinationConfiguration":
            return Optional.ofNullable(clazz.cast(s3DestinationConfiguration()));
        case "ExtendedS3DestinationConfiguration":
            return Optional.ofNullable(clazz.cast(extendedS3DestinationConfiguration()));
        case "RedshiftDestinationConfiguration":
            return Optional.ofNullable(clazz.cast(redshiftDestinationConfiguration()));
        case "ElasticsearchDestinationConfiguration":
            return Optional.ofNullable(clazz.cast(elasticsearchDestinationConfiguration()));
        case "AmazonopensearchserviceDestinationConfiguration":
            return Optional.ofNullable(clazz.cast(amazonopensearchserviceDestinationConfiguration()));
        case "SplunkDestinationConfiguration":
            return Optional.ofNullable(clazz.cast(splunkDestinationConfiguration()));
        case "HttpEndpointDestinationConfiguration":
            return Optional.ofNullable(clazz.cast(httpEndpointDestinationConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeliveryStreamRequest, T> g) {
        return obj -> g.apply((CreateDeliveryStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FirehoseRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeliveryStreamRequest> {
        /**
         * <p>
         * The name of the delivery stream. This name must be unique per AWS account in the same AWS Region. If the
         * delivery streams are in different accounts or different Regions, you can have multiple delivery streams with
         * the same name.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream. This name must be unique per AWS account in the same AWS Region. If
         *        the delivery streams are in different accounts or different Regions, you can have multiple delivery
         *        streams with the same name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * The delivery stream type. This parameter can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DirectPut</code>: Provider applications access the delivery stream directly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deliveryStreamType
         *        The delivery stream type. This parameter can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DirectPut</code>: Provider applications access the delivery stream directly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
         *        </p>
         *        </li>
         * @see DeliveryStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStreamType
         */
        Builder deliveryStreamType(String deliveryStreamType);

        /**
         * <p>
         * The delivery stream type. This parameter can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DirectPut</code>: Provider applications access the delivery stream directly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deliveryStreamType
         *        The delivery stream type. This parameter can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DirectPut</code>: Provider applications access the delivery stream directly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.
         *        </p>
         *        </li>
         * @see DeliveryStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStreamType
         */
        Builder deliveryStreamType(DeliveryStreamType deliveryStreamType);

        /**
         * <p>
         * When a Kinesis data stream is used as the source for the delivery stream, a
         * <a>KinesisStreamSourceConfiguration</a> containing the Kinesis data stream Amazon Resource Name (ARN) and the
         * role ARN for the source stream.
         * </p>
         * 
         * @param kinesisStreamSourceConfiguration
         *        When a Kinesis data stream is used as the source for the delivery stream, a
         *        <a>KinesisStreamSourceConfiguration</a> containing the Kinesis data stream Amazon Resource Name (ARN)
         *        and the role ARN for the source stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration);

        /**
         * <p>
         * When a Kinesis data stream is used as the source for the delivery stream, a
         * <a>KinesisStreamSourceConfiguration</a> containing the Kinesis data stream Amazon Resource Name (ARN) and the
         * role ARN for the source stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link KinesisStreamSourceConfiguration.Builder}
         * avoiding the need to create one manually via {@link KinesisStreamSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisStreamSourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration)}.
         * 
         * @param kinesisStreamSourceConfiguration
         *        a consumer that will call methods on {@link KinesisStreamSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration)
         */
        default Builder kinesisStreamSourceConfiguration(
                Consumer<KinesisStreamSourceConfiguration.Builder> kinesisStreamSourceConfiguration) {
            return kinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration.builder()
                    .applyMutation(kinesisStreamSourceConfiguration).build());
        }

        /**
         * <p>
         * Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption
         * (SSE).
         * </p>
         * 
         * @param deliveryStreamEncryptionConfigurationInput
         *        Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side
         *        Encryption (SSE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamEncryptionConfigurationInput(
                DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput);

        /**
         * <p>
         * Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption
         * (SSE).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DeliveryStreamEncryptionConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link DeliveryStreamEncryptionConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeliveryStreamEncryptionConfigurationInput.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #deliveryStreamEncryptionConfigurationInput(DeliveryStreamEncryptionConfigurationInput)}.
         * 
         * @param deliveryStreamEncryptionConfigurationInput
         *        a consumer that will call methods on {@link DeliveryStreamEncryptionConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deliveryStreamEncryptionConfigurationInput(DeliveryStreamEncryptionConfigurationInput)
         */
        default Builder deliveryStreamEncryptionConfigurationInput(
                Consumer<DeliveryStreamEncryptionConfigurationInput.Builder> deliveryStreamEncryptionConfigurationInput) {
            return deliveryStreamEncryptionConfigurationInput(DeliveryStreamEncryptionConfigurationInput.builder()
                    .applyMutation(deliveryStreamEncryptionConfigurationInput).build());
        }

        /**
         * <p>
         * [Deprecated] The destination in Amazon S3. You can specify only one destination.
         * </p>
         * 
         * @param s3DestinationConfiguration
         *        [Deprecated] The destination in Amazon S3. You can specify only one destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder s3DestinationConfiguration(S3DestinationConfiguration s3DestinationConfiguration);

        /**
         * <p>
         * [Deprecated] The destination in Amazon S3. You can specify only one destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3DestinationConfiguration(S3DestinationConfiguration)}.
         * 
         * @param s3DestinationConfiguration
         *        a consumer that will call methods on {@link S3DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DestinationConfiguration(S3DestinationConfiguration)
         * @deprecated
         */
        @Deprecated
        default Builder s3DestinationConfiguration(Consumer<S3DestinationConfiguration.Builder> s3DestinationConfiguration) {
            return s3DestinationConfiguration(S3DestinationConfiguration.builder().applyMutation(s3DestinationConfiguration)
                    .build());
        }

        /**
         * <p>
         * The destination in Amazon S3. You can specify only one destination.
         * </p>
         * 
         * @param extendedS3DestinationConfiguration
         *        The destination in Amazon S3. You can specify only one destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration);

        /**
         * <p>
         * The destination in Amazon S3. You can specify only one destination.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExtendedS3DestinationConfiguration.Builder} avoiding the need to create one manually via
         * {@link ExtendedS3DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExtendedS3DestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #extendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration)}.
         * 
         * @param extendedS3DestinationConfiguration
         *        a consumer that will call methods on {@link ExtendedS3DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration)
         */
        default Builder extendedS3DestinationConfiguration(
                Consumer<ExtendedS3DestinationConfiguration.Builder> extendedS3DestinationConfiguration) {
            return extendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration.builder()
                    .applyMutation(extendedS3DestinationConfiguration).build());
        }

        /**
         * <p>
         * The destination in Amazon Redshift. You can specify only one destination.
         * </p>
         * 
         * @param redshiftDestinationConfiguration
         *        The destination in Amazon Redshift. You can specify only one destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDestinationConfiguration(RedshiftDestinationConfiguration redshiftDestinationConfiguration);

        /**
         * <p>
         * The destination in Amazon Redshift. You can specify only one destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftDestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link RedshiftDestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #redshiftDestinationConfiguration(RedshiftDestinationConfiguration)}.
         * 
         * @param redshiftDestinationConfiguration
         *        a consumer that will call methods on {@link RedshiftDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftDestinationConfiguration(RedshiftDestinationConfiguration)
         */
        default Builder redshiftDestinationConfiguration(
                Consumer<RedshiftDestinationConfiguration.Builder> redshiftDestinationConfiguration) {
            return redshiftDestinationConfiguration(RedshiftDestinationConfiguration.builder()
                    .applyMutation(redshiftDestinationConfiguration).build());
        }

        /**
         * <p>
         * The destination in Amazon ES. You can specify only one destination.
         * </p>
         * 
         * @param elasticsearchDestinationConfiguration
         *        The destination in Amazon ES. You can specify only one destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration);

        /**
         * <p>
         * The destination in Amazon ES. You can specify only one destination.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ElasticsearchDestinationConfiguration.Builder} avoiding the need to create one manually via
         * {@link ElasticsearchDestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ElasticsearchDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #elasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration)}.
         * 
         * @param elasticsearchDestinationConfiguration
         *        a consumer that will call methods on {@link ElasticsearchDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration)
         */
        default Builder elasticsearchDestinationConfiguration(
                Consumer<ElasticsearchDestinationConfiguration.Builder> elasticsearchDestinationConfiguration) {
            return elasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration.builder()
                    .applyMutation(elasticsearchDestinationConfiguration).build());
        }

        /**
         * Sets the value of the AmazonopensearchserviceDestinationConfiguration property for this object.
         *
         * @param amazonopensearchserviceDestinationConfiguration
         *        The new value for the AmazonopensearchserviceDestinationConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonopensearchserviceDestinationConfiguration(
                AmazonopensearchserviceDestinationConfiguration amazonopensearchserviceDestinationConfiguration);

        /**
         * Sets the value of the AmazonopensearchserviceDestinationConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link AmazonopensearchserviceDestinationConfiguration.Builder} avoiding the need to create one manually via
         * {@link AmazonopensearchserviceDestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonopensearchserviceDestinationConfiguration.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #amazonopensearchserviceDestinationConfiguration(AmazonopensearchserviceDestinationConfiguration)}.
         * 
         * @param amazonopensearchserviceDestinationConfiguration
         *        a consumer that will call methods on {@link AmazonopensearchserviceDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonopensearchserviceDestinationConfiguration(AmazonopensearchserviceDestinationConfiguration)
         */
        default Builder amazonopensearchserviceDestinationConfiguration(
                Consumer<AmazonopensearchserviceDestinationConfiguration.Builder> amazonopensearchserviceDestinationConfiguration) {
            return amazonopensearchserviceDestinationConfiguration(AmazonopensearchserviceDestinationConfiguration.builder()
                    .applyMutation(amazonopensearchserviceDestinationConfiguration).build());
        }

        /**
         * <p>
         * The destination in Splunk. You can specify only one destination.
         * </p>
         * 
         * @param splunkDestinationConfiguration
         *        The destination in Splunk. You can specify only one destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splunkDestinationConfiguration(SplunkDestinationConfiguration splunkDestinationConfiguration);

        /**
         * <p>
         * The destination in Splunk. You can specify only one destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link SplunkDestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link SplunkDestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SplunkDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #splunkDestinationConfiguration(SplunkDestinationConfiguration)}.
         * 
         * @param splunkDestinationConfiguration
         *        a consumer that will call methods on {@link SplunkDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #splunkDestinationConfiguration(SplunkDestinationConfiguration)
         */
        default Builder splunkDestinationConfiguration(
                Consumer<SplunkDestinationConfiguration.Builder> splunkDestinationConfiguration) {
            return splunkDestinationConfiguration(SplunkDestinationConfiguration.builder()
                    .applyMutation(splunkDestinationConfiguration).build());
        }

        /**
         * <p>
         * Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. You can specify only
         * one destination.
         * </p>
         * 
         * @param httpEndpointDestinationConfiguration
         *        Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. You can specify
         *        only one destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpEndpointDestinationConfiguration(HttpEndpointDestinationConfiguration httpEndpointDestinationConfiguration);

        /**
         * <p>
         * Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. You can specify only
         * one destination.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link HttpEndpointDestinationConfiguration.Builder} avoiding the need to create one manually via
         * {@link HttpEndpointDestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HttpEndpointDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #httpEndpointDestinationConfiguration(HttpEndpointDestinationConfiguration)}.
         * 
         * @param httpEndpointDestinationConfiguration
         *        a consumer that will call methods on {@link HttpEndpointDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpEndpointDestinationConfiguration(HttpEndpointDestinationConfiguration)
         */
        default Builder httpEndpointDestinationConfiguration(
                Consumer<HttpEndpointDestinationConfiguration.Builder> httpEndpointDestinationConfiguration) {
            return httpEndpointDestinationConfiguration(HttpEndpointDestinationConfiguration.builder()
                    .applyMutation(httpEndpointDestinationConfiguration).build());
        }

        /**
         * <p>
         * A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and assign to
         * AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of
         * information that can help you distinguish the delivery stream. For more information about tags, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost
         * Allocation Tags</a> in the AWS Billing and Cost Management User Guide.
         * </p>
         * <p>
         * You can specify up to 50 tags when creating a delivery stream.
         * </p>
         * 
         * @param tags
         *        A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and
         *        assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions
         *        or other types of information that can help you distinguish the delivery stream. For more information
         *        about tags, see <a
         *        href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost
         *        Allocation Tags</a> in the AWS Billing and Cost Management User Guide.</p>
         *        <p>
         *        You can specify up to 50 tags when creating a delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and assign to
         * AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of
         * information that can help you distinguish the delivery stream. For more information about tags, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost
         * Allocation Tags</a> in the AWS Billing and Cost Management User Guide.
         * </p>
         * <p>
         * You can specify up to 50 tags when creating a delivery stream.
         * </p>
         * 
         * @param tags
         *        A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and
         *        assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions
         *        or other types of information that can help you distinguish the delivery stream. For more information
         *        about tags, see <a
         *        href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost
         *        Allocation Tags</a> in the AWS Billing and Cost Management User Guide.</p>
         *        <p>
         *        You can specify up to 50 tags when creating a delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and assign to
         * AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of
         * information that can help you distinguish the delivery stream. For more information about tags, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost
         * Allocation Tags</a> in the AWS Billing and Cost Management User Guide.
         * </p>
         * <p>
         * You can specify up to 50 tags when creating a delivery stream.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.firehose.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.firehose.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.firehose.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.firehose.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FirehoseRequest.BuilderImpl implements Builder {
        private String deliveryStreamName;

        private String deliveryStreamType;

        private KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration;

        private DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput;

        private S3DestinationConfiguration s3DestinationConfiguration;

        private ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration;

        private RedshiftDestinationConfiguration redshiftDestinationConfiguration;

        private ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration;

        private AmazonopensearchserviceDestinationConfiguration amazonopensearchserviceDestinationConfiguration;

        private SplunkDestinationConfiguration splunkDestinationConfiguration;

        private HttpEndpointDestinationConfiguration httpEndpointDestinationConfiguration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeliveryStreamRequest model) {
            super(model);
            deliveryStreamName(model.deliveryStreamName);
            deliveryStreamType(model.deliveryStreamType);
            kinesisStreamSourceConfiguration(model.kinesisStreamSourceConfiguration);
            deliveryStreamEncryptionConfigurationInput(model.deliveryStreamEncryptionConfigurationInput);
            s3DestinationConfiguration(model.s3DestinationConfiguration);
            extendedS3DestinationConfiguration(model.extendedS3DestinationConfiguration);
            redshiftDestinationConfiguration(model.redshiftDestinationConfiguration);
            elasticsearchDestinationConfiguration(model.elasticsearchDestinationConfiguration);
            amazonopensearchserviceDestinationConfiguration(model.amazonopensearchserviceDestinationConfiguration);
            splunkDestinationConfiguration(model.splunkDestinationConfiguration);
            httpEndpointDestinationConfiguration(model.httpEndpointDestinationConfiguration);
            tags(model.tags);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final String getDeliveryStreamType() {
            return deliveryStreamType;
        }

        public final void setDeliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
        }

        @Override
        public final Builder deliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
            return this;
        }

        @Override
        public final Builder deliveryStreamType(DeliveryStreamType deliveryStreamType) {
            this.deliveryStreamType(deliveryStreamType == null ? null : deliveryStreamType.toString());
            return this;
        }

        public final KinesisStreamSourceConfiguration.Builder getKinesisStreamSourceConfiguration() {
            return kinesisStreamSourceConfiguration != null ? kinesisStreamSourceConfiguration.toBuilder() : null;
        }

        public final void setKinesisStreamSourceConfiguration(
                KinesisStreamSourceConfiguration.BuilderImpl kinesisStreamSourceConfiguration) {
            this.kinesisStreamSourceConfiguration = kinesisStreamSourceConfiguration != null ? kinesisStreamSourceConfiguration
                    .build() : null;
        }

        @Override
        public final Builder kinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration) {
            this.kinesisStreamSourceConfiguration = kinesisStreamSourceConfiguration;
            return this;
        }

        public final DeliveryStreamEncryptionConfigurationInput.Builder getDeliveryStreamEncryptionConfigurationInput() {
            return deliveryStreamEncryptionConfigurationInput != null ? deliveryStreamEncryptionConfigurationInput.toBuilder()
                    : null;
        }

        public final void setDeliveryStreamEncryptionConfigurationInput(
                DeliveryStreamEncryptionConfigurationInput.BuilderImpl deliveryStreamEncryptionConfigurationInput) {
            this.deliveryStreamEncryptionConfigurationInput = deliveryStreamEncryptionConfigurationInput != null ? deliveryStreamEncryptionConfigurationInput
                    .build() : null;
        }

        @Override
        public final Builder deliveryStreamEncryptionConfigurationInput(
                DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput) {
            this.deliveryStreamEncryptionConfigurationInput = deliveryStreamEncryptionConfigurationInput;
            return this;
        }

        @Deprecated
        public final S3DestinationConfiguration.Builder getS3DestinationConfiguration() {
            return s3DestinationConfiguration != null ? s3DestinationConfiguration.toBuilder() : null;
        }

        @Deprecated
        public final void setS3DestinationConfiguration(S3DestinationConfiguration.BuilderImpl s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration != null ? s3DestinationConfiguration.build() : null;
        }

        @Override
        @Deprecated
        public final Builder s3DestinationConfiguration(S3DestinationConfiguration s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration;
            return this;
        }

        public final ExtendedS3DestinationConfiguration.Builder getExtendedS3DestinationConfiguration() {
            return extendedS3DestinationConfiguration != null ? extendedS3DestinationConfiguration.toBuilder() : null;
        }

        public final void setExtendedS3DestinationConfiguration(
                ExtendedS3DestinationConfiguration.BuilderImpl extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration != null ? extendedS3DestinationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder extendedS3DestinationConfiguration(
                ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration;
            return this;
        }

        public final RedshiftDestinationConfiguration.Builder getRedshiftDestinationConfiguration() {
            return redshiftDestinationConfiguration != null ? redshiftDestinationConfiguration.toBuilder() : null;
        }

        public final void setRedshiftDestinationConfiguration(
                RedshiftDestinationConfiguration.BuilderImpl redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration != null ? redshiftDestinationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder redshiftDestinationConfiguration(RedshiftDestinationConfiguration redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration;
            return this;
        }

        public final ElasticsearchDestinationConfiguration.Builder getElasticsearchDestinationConfiguration() {
            return elasticsearchDestinationConfiguration != null ? elasticsearchDestinationConfiguration.toBuilder() : null;
        }

        public final void setElasticsearchDestinationConfiguration(
                ElasticsearchDestinationConfiguration.BuilderImpl elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration != null ? elasticsearchDestinationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder elasticsearchDestinationConfiguration(
                ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration;
            return this;
        }

        public final AmazonopensearchserviceDestinationConfiguration.Builder getAmazonopensearchserviceDestinationConfiguration() {
            return amazonopensearchserviceDestinationConfiguration != null ? amazonopensearchserviceDestinationConfiguration
                    .toBuilder() : null;
        }

        public final void setAmazonopensearchserviceDestinationConfiguration(
                AmazonopensearchserviceDestinationConfiguration.BuilderImpl amazonopensearchserviceDestinationConfiguration) {
            this.amazonopensearchserviceDestinationConfiguration = amazonopensearchserviceDestinationConfiguration != null ? amazonopensearchserviceDestinationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder amazonopensearchserviceDestinationConfiguration(
                AmazonopensearchserviceDestinationConfiguration amazonopensearchserviceDestinationConfiguration) {
            this.amazonopensearchserviceDestinationConfiguration = amazonopensearchserviceDestinationConfiguration;
            return this;
        }

        public final SplunkDestinationConfiguration.Builder getSplunkDestinationConfiguration() {
            return splunkDestinationConfiguration != null ? splunkDestinationConfiguration.toBuilder() : null;
        }

        public final void setSplunkDestinationConfiguration(
                SplunkDestinationConfiguration.BuilderImpl splunkDestinationConfiguration) {
            this.splunkDestinationConfiguration = splunkDestinationConfiguration != null ? splunkDestinationConfiguration.build()
                    : null;
        }

        @Override
        public final Builder splunkDestinationConfiguration(SplunkDestinationConfiguration splunkDestinationConfiguration) {
            this.splunkDestinationConfiguration = splunkDestinationConfiguration;
            return this;
        }

        public final HttpEndpointDestinationConfiguration.Builder getHttpEndpointDestinationConfiguration() {
            return httpEndpointDestinationConfiguration != null ? httpEndpointDestinationConfiguration.toBuilder() : null;
        }

        public final void setHttpEndpointDestinationConfiguration(
                HttpEndpointDestinationConfiguration.BuilderImpl httpEndpointDestinationConfiguration) {
            this.httpEndpointDestinationConfiguration = httpEndpointDestinationConfiguration != null ? httpEndpointDestinationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder httpEndpointDestinationConfiguration(
                HttpEndpointDestinationConfiguration httpEndpointDestinationConfiguration) {
            this.httpEndpointDestinationConfiguration = httpEndpointDestinationConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagDeliveryStreamInputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagDeliveryStreamInputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagDeliveryStreamInputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeliveryStreamRequest build() {
            return new CreateDeliveryStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
