/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExperimentResolvedTargetsRequest extends FisRequest implements
        ToCopyableBuilder<ListExperimentResolvedTargetsRequest.Builder, ListExperimentResolvedTargetsRequest> {
    private static final SdkField<String> EXPERIMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("experimentId").getter(getter(ListExperimentResolvedTargetsRequest::experimentId))
            .setter(setter(Builder::experimentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListExperimentResolvedTargetsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListExperimentResolvedTargetsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetName").getter(getter(ListExperimentResolvedTargetsRequest::targetName))
            .setter(setter(Builder::targetName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, TARGET_NAME_FIELD));

    private final String experimentId;

    private final Integer maxResults;

    private final String nextToken;

    private final String targetName;

    private ListExperimentResolvedTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.experimentId = builder.experimentId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.targetName = builder.targetName;
    }

    /**
     * <p>
     * The ID of the experiment.
     * </p>
     * 
     * @return The ID of the experiment.
     */
    public final String experimentId() {
        return experimentId;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned nextToken value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned nextToken value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The name of the target.
     * </p>
     * 
     * @return The name of the target.
     */
    public final String targetName() {
        return targetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(experimentId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(targetName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExperimentResolvedTargetsRequest)) {
            return false;
        }
        ListExperimentResolvedTargetsRequest other = (ListExperimentResolvedTargetsRequest) obj;
        return Objects.equals(experimentId(), other.experimentId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(targetName(), other.targetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListExperimentResolvedTargetsRequest").add("ExperimentId", experimentId())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("TargetName", targetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "experimentId":
            return Optional.ofNullable(clazz.cast(experimentId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "targetName":
            return Optional.ofNullable(clazz.cast(targetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExperimentResolvedTargetsRequest, T> g) {
        return obj -> g.apply((ListExperimentResolvedTargetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FisRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListExperimentResolvedTargetsRequest> {
        /**
         * <p>
         * The ID of the experiment.
         * </p>
         * 
         * @param experimentId
         *        The ID of the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentId(String experimentId);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned nextToken value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned nextToken value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The name of the target.
         * </p>
         * 
         * @param targetName
         *        The name of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetName(String targetName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FisRequest.BuilderImpl implements Builder {
        private String experimentId;

        private Integer maxResults;

        private String nextToken;

        private String targetName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExperimentResolvedTargetsRequest model) {
            super(model);
            experimentId(model.experimentId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            targetName(model.targetName);
        }

        public final String getExperimentId() {
            return experimentId;
        }

        public final void setExperimentId(String experimentId) {
            this.experimentId = experimentId;
        }

        @Override
        public final Builder experimentId(String experimentId) {
            this.experimentId = experimentId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getTargetName() {
            return targetName;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListExperimentResolvedTargetsRequest build() {
            return new ListExperimentResolvedTargetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
