/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetThirdPartyFirewallAssociationStatusRequest extends FmsRequest implements
        ToCopyableBuilder<GetThirdPartyFirewallAssociationStatusRequest.Builder, GetThirdPartyFirewallAssociationStatusRequest> {
    private static final SdkField<String> THIRD_PARTY_FIREWALL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThirdPartyFirewall")
            .getter(getter(GetThirdPartyFirewallAssociationStatusRequest::thirdPartyFirewallAsString))
            .setter(setter(Builder::thirdPartyFirewall))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThirdPartyFirewall").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THIRD_PARTY_FIREWALL_FIELD));

    private final String thirdPartyFirewall;

    private GetThirdPartyFirewallAssociationStatusRequest(BuilderImpl builder) {
        super(builder);
        this.thirdPartyFirewall = builder.thirdPartyFirewall;
    }

    /**
     * <p>
     * The name of the third-party firewall vendor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thirdPartyFirewall} will return {@link ThirdPartyFirewall#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #thirdPartyFirewallAsString}.
     * </p>
     * 
     * @return The name of the third-party firewall vendor.
     * @see ThirdPartyFirewall
     */
    public final ThirdPartyFirewall thirdPartyFirewall() {
        return ThirdPartyFirewall.fromValue(thirdPartyFirewall);
    }

    /**
     * <p>
     * The name of the third-party firewall vendor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thirdPartyFirewall} will return {@link ThirdPartyFirewall#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #thirdPartyFirewallAsString}.
     * </p>
     * 
     * @return The name of the third-party firewall vendor.
     * @see ThirdPartyFirewall
     */
    public final String thirdPartyFirewallAsString() {
        return thirdPartyFirewall;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thirdPartyFirewallAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetThirdPartyFirewallAssociationStatusRequest)) {
            return false;
        }
        GetThirdPartyFirewallAssociationStatusRequest other = (GetThirdPartyFirewallAssociationStatusRequest) obj;
        return Objects.equals(thirdPartyFirewallAsString(), other.thirdPartyFirewallAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetThirdPartyFirewallAssociationStatusRequest")
                .add("ThirdPartyFirewall", thirdPartyFirewallAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ThirdPartyFirewall":
            return Optional.ofNullable(clazz.cast(thirdPartyFirewallAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetThirdPartyFirewallAssociationStatusRequest, T> g) {
        return obj -> g.apply((GetThirdPartyFirewallAssociationStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetThirdPartyFirewallAssociationStatusRequest> {
        /**
         * <p>
         * The name of the third-party firewall vendor.
         * </p>
         * 
         * @param thirdPartyFirewall
         *        The name of the third-party firewall vendor.
         * @see ThirdPartyFirewall
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyFirewall
         */
        Builder thirdPartyFirewall(String thirdPartyFirewall);

        /**
         * <p>
         * The name of the third-party firewall vendor.
         * </p>
         * 
         * @param thirdPartyFirewall
         *        The name of the third-party firewall vendor.
         * @see ThirdPartyFirewall
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyFirewall
         */
        Builder thirdPartyFirewall(ThirdPartyFirewall thirdPartyFirewall);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FmsRequest.BuilderImpl implements Builder {
        private String thirdPartyFirewall;

        private BuilderImpl() {
        }

        private BuilderImpl(GetThirdPartyFirewallAssociationStatusRequest model) {
            super(model);
            thirdPartyFirewall(model.thirdPartyFirewall);
        }

        public final String getThirdPartyFirewall() {
            return thirdPartyFirewall;
        }

        public final void setThirdPartyFirewall(String thirdPartyFirewall) {
            this.thirdPartyFirewall = thirdPartyFirewall;
        }

        @Override
        public final Builder thirdPartyFirewall(String thirdPartyFirewall) {
            this.thirdPartyFirewall = thirdPartyFirewall;
            return this;
        }

        @Override
        public final Builder thirdPartyFirewall(ThirdPartyFirewall thirdPartyFirewall) {
            this.thirdPartyFirewall(thirdPartyFirewall == null ? null : thirdPartyFirewall.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetThirdPartyFirewallAssociationStatusRequest build() {
            return new GetThirdPartyFirewallAssociationStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
