/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The training metrics details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingMetricsV2 implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainingMetricsV2.Builder, TrainingMetricsV2> {
    private static final SdkField<OFITrainingMetricsValue> OFI_FIELD = SdkField
            .<OFITrainingMetricsValue> builder(MarshallingType.SDK_POJO).memberName("ofi").getter(getter(TrainingMetricsV2::ofi))
            .setter(setter(Builder::ofi)).constructor(OFITrainingMetricsValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ofi").build()).build();

    private static final SdkField<TFITrainingMetricsValue> TFI_FIELD = SdkField
            .<TFITrainingMetricsValue> builder(MarshallingType.SDK_POJO).memberName("tfi").getter(getter(TrainingMetricsV2::tfi))
            .setter(setter(Builder::tfi)).constructor(TFITrainingMetricsValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tfi").build()).build();

    private static final SdkField<ATITrainingMetricsValue> ATI_FIELD = SdkField
            .<ATITrainingMetricsValue> builder(MarshallingType.SDK_POJO).memberName("ati").getter(getter(TrainingMetricsV2::ati))
            .setter(setter(Builder::ati)).constructor(ATITrainingMetricsValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ati").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFI_FIELD, TFI_FIELD,
            ATI_FIELD));

    private static final long serialVersionUID = 1L;

    private final OFITrainingMetricsValue ofi;

    private final TFITrainingMetricsValue tfi;

    private final ATITrainingMetricsValue ati;

    private TrainingMetricsV2(BuilderImpl builder) {
        this.ofi = builder.ofi;
        this.tfi = builder.tfi;
        this.ati = builder.ati;
    }

    /**
     * <p>
     * The Online Fraud Insights (OFI) model training metric details.
     * </p>
     * 
     * @return The Online Fraud Insights (OFI) model training metric details.
     */
    public final OFITrainingMetricsValue ofi() {
        return ofi;
    }

    /**
     * <p>
     * The Transaction Fraud Insights (TFI) model training metric details.
     * </p>
     * 
     * @return The Transaction Fraud Insights (TFI) model training metric details.
     */
    public final TFITrainingMetricsValue tfi() {
        return tfi;
    }

    /**
     * <p>
     * The Account Takeover Insights (ATI) model training metric details.
     * </p>
     * 
     * @return The Account Takeover Insights (ATI) model training metric details.
     */
    public final ATITrainingMetricsValue ati() {
        return ati;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ofi());
        hashCode = 31 * hashCode + Objects.hashCode(tfi());
        hashCode = 31 * hashCode + Objects.hashCode(ati());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingMetricsV2)) {
            return false;
        }
        TrainingMetricsV2 other = (TrainingMetricsV2) obj;
        return Objects.equals(ofi(), other.ofi()) && Objects.equals(tfi(), other.tfi()) && Objects.equals(ati(), other.ati());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainingMetricsV2").add("Ofi", ofi()).add("Tfi", tfi()).add("Ati", ati()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ofi":
            return Optional.ofNullable(clazz.cast(ofi()));
        case "tfi":
            return Optional.ofNullable(clazz.cast(tfi()));
        case "ati":
            return Optional.ofNullable(clazz.cast(ati()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingMetricsV2, T> g) {
        return obj -> g.apply((TrainingMetricsV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingMetricsV2> {
        /**
         * <p>
         * The Online Fraud Insights (OFI) model training metric details.
         * </p>
         * 
         * @param ofi
         *        The Online Fraud Insights (OFI) model training metric details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ofi(OFITrainingMetricsValue ofi);

        /**
         * <p>
         * The Online Fraud Insights (OFI) model training metric details.
         * </p>
         * This is a convenience method that creates an instance of the {@link OFITrainingMetricsValue.Builder} avoiding
         * the need to create one manually via {@link OFITrainingMetricsValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OFITrainingMetricsValue.Builder#build()} is called immediately
         * and its result is passed to {@link #ofi(OFITrainingMetricsValue)}.
         * 
         * @param ofi
         *        a consumer that will call methods on {@link OFITrainingMetricsValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ofi(OFITrainingMetricsValue)
         */
        default Builder ofi(Consumer<OFITrainingMetricsValue.Builder> ofi) {
            return ofi(OFITrainingMetricsValue.builder().applyMutation(ofi).build());
        }

        /**
         * <p>
         * The Transaction Fraud Insights (TFI) model training metric details.
         * </p>
         * 
         * @param tfi
         *        The Transaction Fraud Insights (TFI) model training metric details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tfi(TFITrainingMetricsValue tfi);

        /**
         * <p>
         * The Transaction Fraud Insights (TFI) model training metric details.
         * </p>
         * This is a convenience method that creates an instance of the {@link TFITrainingMetricsValue.Builder} avoiding
         * the need to create one manually via {@link TFITrainingMetricsValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TFITrainingMetricsValue.Builder#build()} is called immediately
         * and its result is passed to {@link #tfi(TFITrainingMetricsValue)}.
         * 
         * @param tfi
         *        a consumer that will call methods on {@link TFITrainingMetricsValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tfi(TFITrainingMetricsValue)
         */
        default Builder tfi(Consumer<TFITrainingMetricsValue.Builder> tfi) {
            return tfi(TFITrainingMetricsValue.builder().applyMutation(tfi).build());
        }

        /**
         * <p>
         * The Account Takeover Insights (ATI) model training metric details.
         * </p>
         * 
         * @param ati
         *        The Account Takeover Insights (ATI) model training metric details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ati(ATITrainingMetricsValue ati);

        /**
         * <p>
         * The Account Takeover Insights (ATI) model training metric details.
         * </p>
         * This is a convenience method that creates an instance of the {@link ATITrainingMetricsValue.Builder} avoiding
         * the need to create one manually via {@link ATITrainingMetricsValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ATITrainingMetricsValue.Builder#build()} is called immediately
         * and its result is passed to {@link #ati(ATITrainingMetricsValue)}.
         * 
         * @param ati
         *        a consumer that will call methods on {@link ATITrainingMetricsValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ati(ATITrainingMetricsValue)
         */
        default Builder ati(Consumer<ATITrainingMetricsValue.Builder> ati) {
            return ati(ATITrainingMetricsValue.builder().applyMutation(ati).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OFITrainingMetricsValue ofi;

        private TFITrainingMetricsValue tfi;

        private ATITrainingMetricsValue ati;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingMetricsV2 model) {
            ofi(model.ofi);
            tfi(model.tfi);
            ati(model.ati);
        }

        public final OFITrainingMetricsValue.Builder getOfi() {
            return ofi != null ? ofi.toBuilder() : null;
        }

        public final void setOfi(OFITrainingMetricsValue.BuilderImpl ofi) {
            this.ofi = ofi != null ? ofi.build() : null;
        }

        @Override
        public final Builder ofi(OFITrainingMetricsValue ofi) {
            this.ofi = ofi;
            return this;
        }

        public final TFITrainingMetricsValue.Builder getTfi() {
            return tfi != null ? tfi.toBuilder() : null;
        }

        public final void setTfi(TFITrainingMetricsValue.BuilderImpl tfi) {
            this.tfi = tfi != null ? tfi.build() : null;
        }

        @Override
        public final Builder tfi(TFITrainingMetricsValue tfi) {
            this.tfi = tfi;
            return this;
        }

        public final ATITrainingMetricsValue.Builder getAti() {
            return ati != null ? ati.toBuilder() : null;
        }

        public final void setAti(ATITrainingMetricsValue.BuilderImpl ati) {
            this.ati = ati != null ? ati.build() : null;
        }

        @Override
        public final Builder ati(ATITrainingMetricsValue ati) {
            this.ati = ati;
            return this;
        }

        @Override
        public TrainingMetricsV2 build() {
            return new TrainingMetricsV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
