/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration updates for an Amazon FSx for NetApp ONTAP file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFileSystemOntapConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateFileSystemOntapConfiguration.Builder, UpdateFileSystemOntapConfiguration> {
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutomaticBackupRetentionDays")
            .getter(getter(UpdateFileSystemOntapConfiguration::automaticBackupRetentionDays))
            .setter(setter(Builder::automaticBackupRetentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays")
                    .build()).build();

    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DailyAutomaticBackupStartTime")
            .getter(getter(UpdateFileSystemOntapConfiguration::dailyAutomaticBackupStartTime))
            .setter(setter(Builder::dailyAutomaticBackupStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime")
                    .build()).build();

    private static final SdkField<String> FSX_ADMIN_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FsxAdminPassword").getter(getter(UpdateFileSystemOntapConfiguration::fsxAdminPassword))
            .setter(setter(Builder::fsxAdminPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FsxAdminPassword").build()).build();

    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceStartTime")
            .getter(getter(UpdateFileSystemOntapConfiguration::weeklyMaintenanceStartTime))
            .setter(setter(Builder::weeklyMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build())
            .build();

    private static final SdkField<DiskIopsConfiguration> DISK_IOPS_CONFIGURATION_FIELD = SdkField
            .<DiskIopsConfiguration> builder(MarshallingType.SDK_POJO).memberName("DiskIopsConfiguration")
            .getter(getter(UpdateFileSystemOntapConfiguration::diskIopsConfiguration))
            .setter(setter(Builder::diskIopsConfiguration)).constructor(DiskIopsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIopsConfiguration").build())
            .build();

    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThroughputCapacity").getter(getter(UpdateFileSystemOntapConfiguration::throughputCapacity))
            .setter(setter(Builder::throughputCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build())
            .build();

    private static final SdkField<List<String>> ADD_ROUTE_TABLE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddRouteTableIds")
            .getter(getter(UpdateFileSystemOntapConfiguration::addRouteTableIds))
            .setter(setter(Builder::addRouteTableIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddRouteTableIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOVE_ROUTE_TABLE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveRouteTableIds")
            .getter(getter(UpdateFileSystemOntapConfiguration::removeRouteTableIds))
            .setter(setter(Builder::removeRouteTableIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveRouteTableIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> THROUGHPUT_CAPACITY_PER_HA_PAIR_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThroughputCapacityPerHAPair")
            .getter(getter(UpdateFileSystemOntapConfiguration::throughputCapacityPerHAPair))
            .setter(setter(Builder::throughputCapacityPerHAPair))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacityPerHAPair")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, FSX_ADMIN_PASSWORD_FIELD,
            WEEKLY_MAINTENANCE_START_TIME_FIELD, DISK_IOPS_CONFIGURATION_FIELD, THROUGHPUT_CAPACITY_FIELD,
            ADD_ROUTE_TABLE_IDS_FIELD, REMOVE_ROUTE_TABLE_IDS_FIELD, THROUGHPUT_CAPACITY_PER_HA_PAIR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer automaticBackupRetentionDays;

    private final String dailyAutomaticBackupStartTime;

    private final String fsxAdminPassword;

    private final String weeklyMaintenanceStartTime;

    private final DiskIopsConfiguration diskIopsConfiguration;

    private final Integer throughputCapacity;

    private final List<String> addRouteTableIds;

    private final List<String> removeRouteTableIds;

    private final Integer throughputCapacityPerHAPair;

    private UpdateFileSystemOntapConfiguration(BuilderImpl builder) {
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.fsxAdminPassword = builder.fsxAdminPassword;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.diskIopsConfiguration = builder.diskIopsConfiguration;
        this.throughputCapacity = builder.throughputCapacity;
        this.addRouteTableIds = builder.addRouteTableIds;
        this.removeRouteTableIds = builder.removeRouteTableIds;
        this.throughputCapacityPerHAPair = builder.throughputCapacityPerHAPair;
    }

    /**
     * Returns the value of the AutomaticBackupRetentionDays property for this object.
     * 
     * @return The value of the AutomaticBackupRetentionDays property for this object.
     */
    public final Integer automaticBackupRetentionDays() {
        return automaticBackupRetentionDays;
    }

    /**
     * Returns the value of the DailyAutomaticBackupStartTime property for this object.
     * 
     * @return The value of the DailyAutomaticBackupStartTime property for this object.
     */
    public final String dailyAutomaticBackupStartTime() {
        return dailyAutomaticBackupStartTime;
    }

    /**
     * <p>
     * Update the password for the <code>fsxadmin</code> user by entering a new password. You use the
     * <code>fsxadmin</code> user to access the NetApp ONTAP CLI and REST API to manage your file system resources. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-resources-ontap-apps.html">Managing resources
     * using NetApp Applicaton</a>.
     * </p>
     * 
     * @return Update the password for the <code>fsxadmin</code> user by entering a new password. You use the
     *         <code>fsxadmin</code> user to access the NetApp ONTAP CLI and REST API to manage your file system
     *         resources. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-resources-ontap-apps.html">Managing
     *         resources using NetApp Applicaton</a>.
     */
    public final String fsxAdminPassword() {
        return fsxAdminPassword;
    }

    /**
     * Returns the value of the WeeklyMaintenanceStartTime property for this object.
     * 
     * @return The value of the WeeklyMaintenanceStartTime property for this object.
     */
    public final String weeklyMaintenanceStartTime() {
        return weeklyMaintenanceStartTime;
    }

    /**
     * <p>
     * The SSD IOPS (input output operations per second) configuration for an Amazon FSx for NetApp ONTAP file system.
     * The default is 3 IOPS per GB of storage capacity, but you can provision additional IOPS per GB of storage. The
     * configuration consists of an IOPS mode (<code>AUTOMATIC</code> or <code>USER_PROVISIONED</code>), and in the case
     * of <code>USER_PROVISIONED</code> IOPS, the total number of SSD IOPS provisioned. For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/increase-primary-storage.html">Updating SSD storage
     * capacity and IOPS</a>.
     * </p>
     * 
     * @return The SSD IOPS (input output operations per second) configuration for an Amazon FSx for NetApp ONTAP file
     *         system. The default is 3 IOPS per GB of storage capacity, but you can provision additional IOPS per GB of
     *         storage. The configuration consists of an IOPS mode (<code>AUTOMATIC</code> or
     *         <code>USER_PROVISIONED</code>), and in the case of <code>USER_PROVISIONED</code> IOPS, the total number
     *         of SSD IOPS provisioned. For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/increase-primary-storage.html">Updating SSD
     *         storage capacity and IOPS</a>.
     */
    public final DiskIopsConfiguration diskIopsConfiguration() {
        return diskIopsConfiguration;
    }

    /**
     * <p>
     * Enter a new value to change the amount of throughput capacity for the file system in megabytes per second (MBps).
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-throughput-capacity.html">Managing throughput
     * capacity</a> in the FSx for ONTAP User Guide.
     * </p>
     * <p>
     * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The value of <code>ThroughputCapacity</code> and <code>ThroughputCapacityPerHAPair</code> are not the same value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The value of <code>ThroughputCapacity</code> when divided by the value of <code>HAPairs</code> is outside of the
     * valid range for <code>ThroughputCapacity</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Enter a new value to change the amount of throughput capacity for the file system in megabytes per second
     *         (MBps). For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-throughput-capacity.html">Managing
     *         throughput capacity</a> in the FSx for ONTAP User Guide.</p>
     *         <p>
     *         Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The value of <code>ThroughputCapacity</code> and <code>ThroughputCapacityPerHAPair</code> are not the
     *         same value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The value of <code>ThroughputCapacity</code> when divided by the value of <code>HAPairs</code> is outside
     *         of the valid range for <code>ThroughputCapacity</code>.
     *         </p>
     *         </li>
     */
    public final Integer throughputCapacity() {
        return throughputCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddRouteTableIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddRouteTableIds() {
        return addRouteTableIds != null && !(addRouteTableIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables to associate (add) with your Amazon
     * FSx for NetApp ONTAP file system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddRouteTableIds} method.
     * </p>
     * 
     * @return (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables to associate (add) with
     *         your Amazon FSx for NetApp ONTAP file system.
     */
    public final List<String> addRouteTableIds() {
        return addRouteTableIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveRouteTableIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveRouteTableIds() {
        return removeRouteTableIds != null && !(removeRouteTableIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route tables to disassociate (remove) from
     * your Amazon FSx for NetApp ONTAP file system. You can use the API operation to retrieve the list of VPC route
     * table IDs for a file system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveRouteTableIds} method.
     * </p>
     * 
     * @return (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route tables to disassociate
     *         (remove) from your Amazon FSx for NetApp ONTAP file system. You can use the API operation to retrieve the
     *         list of VPC route table IDs for a file system.
     */
    public final List<String> removeRouteTableIds() {
        return removeRouteTableIds;
    }

    /**
     * <p>
     * Use to choose the throughput capacity per HA pair, rather than the total throughput for the file system.
     * </p>
     * <p>
     * This field and <code>ThroughputCapacity</code> cannot be defined in the same API call, but one is required.
     * </p>
     * <p>
     * This field and <code>ThroughputCapacity</code> are the same for file systems with one HA pair.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>SINGLE_AZ_1</code> and <code>MULTI_AZ_1</code>, valid values are 128, 256, 512, 1024, 2048, or 4096
     * MBps.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>SINGLE_AZ_2</code>, valid values are 3072 or 6144 MBps.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
     * </p>
     * <p>
     * The value of <code>ThroughputCapacity</code> and <code>ThroughputCapacityPerHAPair</code> are not the same value.
     * </p>
     * <p>
     * The value of <code>ThroughputCapacityPerHAPair</code> is not a valid value.
     * </p>
     * 
     * @return Use to choose the throughput capacity per HA pair, rather than the total throughput for the file system.
     *         </p>
     *         <p>
     *         This field and <code>ThroughputCapacity</code> cannot be defined in the same API call, but one is
     *         required.
     *         </p>
     *         <p>
     *         This field and <code>ThroughputCapacity</code> are the same for file systems with one HA pair.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>SINGLE_AZ_1</code> and <code>MULTI_AZ_1</code>, valid values are 128, 256, 512, 1024, 2048, or
     *         4096 MBps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>SINGLE_AZ_2</code>, valid values are 3072 or 6144 MBps.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
     *         </p>
     *         <p>
     *         The value of <code>ThroughputCapacity</code> and <code>ThroughputCapacityPerHAPair</code> are not the
     *         same value.
     *         </p>
     *         <p>
     *         The value of <code>ThroughputCapacityPerHAPair</code> is not a valid value.
     */
    public final Integer throughputCapacityPerHAPair() {
        return throughputCapacityPerHAPair;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(fsxAdminPassword());
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(diskIopsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddRouteTableIds() ? addRouteTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveRouteTableIds() ? removeRouteTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(throughputCapacityPerHAPair());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemOntapConfiguration)) {
            return false;
        }
        UpdateFileSystemOntapConfiguration other = (UpdateFileSystemOntapConfiguration) obj;
        return Objects.equals(automaticBackupRetentionDays(), other.automaticBackupRetentionDays())
                && Objects.equals(dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime())
                && Objects.equals(fsxAdminPassword(), other.fsxAdminPassword())
                && Objects.equals(weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime())
                && Objects.equals(diskIopsConfiguration(), other.diskIopsConfiguration())
                && Objects.equals(throughputCapacity(), other.throughputCapacity())
                && hasAddRouteTableIds() == other.hasAddRouteTableIds()
                && Objects.equals(addRouteTableIds(), other.addRouteTableIds())
                && hasRemoveRouteTableIds() == other.hasRemoveRouteTableIds()
                && Objects.equals(removeRouteTableIds(), other.removeRouteTableIds())
                && Objects.equals(throughputCapacityPerHAPair(), other.throughputCapacityPerHAPair());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFileSystemOntapConfiguration")
                .add("AutomaticBackupRetentionDays", automaticBackupRetentionDays())
                .add("DailyAutomaticBackupStartTime", dailyAutomaticBackupStartTime())
                .add("FsxAdminPassword", fsxAdminPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WeeklyMaintenanceStartTime", weeklyMaintenanceStartTime())
                .add("DiskIopsConfiguration", diskIopsConfiguration()).add("ThroughputCapacity", throughputCapacity())
                .add("AddRouteTableIds", hasAddRouteTableIds() ? addRouteTableIds() : null)
                .add("RemoveRouteTableIds", hasRemoveRouteTableIds() ? removeRouteTableIds() : null)
                .add("ThroughputCapacityPerHAPair", throughputCapacityPerHAPair()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomaticBackupRetentionDays":
            return Optional.ofNullable(clazz.cast(automaticBackupRetentionDays()));
        case "DailyAutomaticBackupStartTime":
            return Optional.ofNullable(clazz.cast(dailyAutomaticBackupStartTime()));
        case "FsxAdminPassword":
            return Optional.ofNullable(clazz.cast(fsxAdminPassword()));
        case "WeeklyMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceStartTime()));
        case "DiskIopsConfiguration":
            return Optional.ofNullable(clazz.cast(diskIopsConfiguration()));
        case "ThroughputCapacity":
            return Optional.ofNullable(clazz.cast(throughputCapacity()));
        case "AddRouteTableIds":
            return Optional.ofNullable(clazz.cast(addRouteTableIds()));
        case "RemoveRouteTableIds":
            return Optional.ofNullable(clazz.cast(removeRouteTableIds()));
        case "ThroughputCapacityPerHAPair":
            return Optional.ofNullable(clazz.cast(throughputCapacityPerHAPair()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemOntapConfiguration, T> g) {
        return obj -> g.apply((UpdateFileSystemOntapConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateFileSystemOntapConfiguration> {
        /**
         * Sets the value of the AutomaticBackupRetentionDays property for this object.
         *
         * @param automaticBackupRetentionDays
         *        The new value for the AutomaticBackupRetentionDays property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays);

        /**
         * Sets the value of the DailyAutomaticBackupStartTime property for this object.
         *
         * @param dailyAutomaticBackupStartTime
         *        The new value for the DailyAutomaticBackupStartTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime);

        /**
         * <p>
         * Update the password for the <code>fsxadmin</code> user by entering a new password. You use the
         * <code>fsxadmin</code> user to access the NetApp ONTAP CLI and REST API to manage your file system resources.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-resources-ontap-apps.html">Managing
         * resources using NetApp Applicaton</a>.
         * </p>
         * 
         * @param fsxAdminPassword
         *        Update the password for the <code>fsxadmin</code> user by entering a new password. You use the
         *        <code>fsxadmin</code> user to access the NetApp ONTAP CLI and REST API to manage your file system
         *        resources. For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-resources-ontap-apps.html">Managing
         *        resources using NetApp Applicaton</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fsxAdminPassword(String fsxAdminPassword);

        /**
         * Sets the value of the WeeklyMaintenanceStartTime property for this object.
         *
         * @param weeklyMaintenanceStartTime
         *        The new value for the WeeklyMaintenanceStartTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime);

        /**
         * <p>
         * The SSD IOPS (input output operations per second) configuration for an Amazon FSx for NetApp ONTAP file
         * system. The default is 3 IOPS per GB of storage capacity, but you can provision additional IOPS per GB of
         * storage. The configuration consists of an IOPS mode (<code>AUTOMATIC</code> or <code>USER_PROVISIONED</code>
         * ), and in the case of <code>USER_PROVISIONED</code> IOPS, the total number of SSD IOPS provisioned. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/increase-primary-storage.html">Updating SSD storage
         * capacity and IOPS</a>.
         * </p>
         * 
         * @param diskIopsConfiguration
         *        The SSD IOPS (input output operations per second) configuration for an Amazon FSx for NetApp ONTAP
         *        file system. The default is 3 IOPS per GB of storage capacity, but you can provision additional IOPS
         *        per GB of storage. The configuration consists of an IOPS mode (<code>AUTOMATIC</code> or
         *        <code>USER_PROVISIONED</code>), and in the case of <code>USER_PROVISIONED</code> IOPS, the total
         *        number of SSD IOPS provisioned. For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/increase-primary-storage.html">Updating SSD
         *        storage capacity and IOPS</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration);

        /**
         * <p>
         * The SSD IOPS (input output operations per second) configuration for an Amazon FSx for NetApp ONTAP file
         * system. The default is 3 IOPS per GB of storage capacity, but you can provision additional IOPS per GB of
         * storage. The configuration consists of an IOPS mode (<code>AUTOMATIC</code> or <code>USER_PROVISIONED</code>
         * ), and in the case of <code>USER_PROVISIONED</code> IOPS, the total number of SSD IOPS provisioned. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/increase-primary-storage.html">Updating SSD storage
         * capacity and IOPS</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DiskIopsConfiguration.Builder} avoiding
         * the need to create one manually via {@link DiskIopsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DiskIopsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #diskIopsConfiguration(DiskIopsConfiguration)}.
         * 
         * @param diskIopsConfiguration
         *        a consumer that will call methods on {@link DiskIopsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diskIopsConfiguration(DiskIopsConfiguration)
         */
        default Builder diskIopsConfiguration(Consumer<DiskIopsConfiguration.Builder> diskIopsConfiguration) {
            return diskIopsConfiguration(DiskIopsConfiguration.builder().applyMutation(diskIopsConfiguration).build());
        }

        /**
         * <p>
         * Enter a new value to change the amount of throughput capacity for the file system in megabytes per second
         * (MBps). For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-throughput-capacity.html">Managing
         * throughput capacity</a> in the FSx for ONTAP User Guide.
         * </p>
         * <p>
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The value of <code>ThroughputCapacity</code> and <code>ThroughputCapacityPerHAPair</code> are not the same
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * The value of <code>ThroughputCapacity</code> when divided by the value of <code>HAPairs</code> is outside of
         * the valid range for <code>ThroughputCapacity</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param throughputCapacity
         *        Enter a new value to change the amount of throughput capacity for the file system in megabytes per
         *        second (MBps). For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-throughput-capacity.html">Managing
         *        throughput capacity</a> in the FSx for ONTAP User Guide.</p>
         *        <p>
         *        Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The value of <code>ThroughputCapacity</code> and <code>ThroughputCapacityPerHAPair</code> are not the
         *        same value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The value of <code>ThroughputCapacity</code> when divided by the value of <code>HAPairs</code> is
         *        outside of the valid range for <code>ThroughputCapacity</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputCapacity(Integer throughputCapacity);

        /**
         * <p>
         * (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables to associate (add) with your
         * Amazon FSx for NetApp ONTAP file system.
         * </p>
         * 
         * @param addRouteTableIds
         *        (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables to associate (add) with
         *        your Amazon FSx for NetApp ONTAP file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRouteTableIds(Collection<String> addRouteTableIds);

        /**
         * <p>
         * (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables to associate (add) with your
         * Amazon FSx for NetApp ONTAP file system.
         * </p>
         * 
         * @param addRouteTableIds
         *        (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables to associate (add) with
         *        your Amazon FSx for NetApp ONTAP file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRouteTableIds(String... addRouteTableIds);

        /**
         * <p>
         * (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route tables to disassociate (remove)
         * from your Amazon FSx for NetApp ONTAP file system. You can use the API operation to retrieve the list of VPC
         * route table IDs for a file system.
         * </p>
         * 
         * @param removeRouteTableIds
         *        (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route tables to disassociate
         *        (remove) from your Amazon FSx for NetApp ONTAP file system. You can use the API operation to retrieve
         *        the list of VPC route table IDs for a file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeRouteTableIds(Collection<String> removeRouteTableIds);

        /**
         * <p>
         * (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route tables to disassociate (remove)
         * from your Amazon FSx for NetApp ONTAP file system. You can use the API operation to retrieve the list of VPC
         * route table IDs for a file system.
         * </p>
         * 
         * @param removeRouteTableIds
         *        (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route tables to disassociate
         *        (remove) from your Amazon FSx for NetApp ONTAP file system. You can use the API operation to retrieve
         *        the list of VPC route table IDs for a file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeRouteTableIds(String... removeRouteTableIds);

        /**
         * <p>
         * Use to choose the throughput capacity per HA pair, rather than the total throughput for the file system.
         * </p>
         * <p>
         * This field and <code>ThroughputCapacity</code> cannot be defined in the same API call, but one is required.
         * </p>
         * <p>
         * This field and <code>ThroughputCapacity</code> are the same for file systems with one HA pair.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>SINGLE_AZ_1</code> and <code>MULTI_AZ_1</code>, valid values are 128, 256, 512, 1024, 2048, or 4096
         * MBps.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>SINGLE_AZ_2</code>, valid values are 3072 or 6144 MBps.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * </p>
         * <p>
         * The value of <code>ThroughputCapacity</code> and <code>ThroughputCapacityPerHAPair</code> are not the same
         * value.
         * </p>
         * <p>
         * The value of <code>ThroughputCapacityPerHAPair</code> is not a valid value.
         * </p>
         * 
         * @param throughputCapacityPerHAPair
         *        Use to choose the throughput capacity per HA pair, rather than the total throughput for the file
         *        system. </p>
         *        <p>
         *        This field and <code>ThroughputCapacity</code> cannot be defined in the same API call, but one is
         *        required.
         *        </p>
         *        <p>
         *        This field and <code>ThroughputCapacity</code> are the same for file systems with one HA pair.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>SINGLE_AZ_1</code> and <code>MULTI_AZ_1</code>, valid values are 128, 256, 512, 1024, 2048,
         *        or 4096 MBps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>SINGLE_AZ_2</code>, valid values are 3072 or 6144 MBps.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         *        </p>
         *        <p>
         *        The value of <code>ThroughputCapacity</code> and <code>ThroughputCapacityPerHAPair</code> are not the
         *        same value.
         *        </p>
         *        <p>
         *        The value of <code>ThroughputCapacityPerHAPair</code> is not a valid value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputCapacityPerHAPair(Integer throughputCapacityPerHAPair);
    }

    static final class BuilderImpl implements Builder {
        private Integer automaticBackupRetentionDays;

        private String dailyAutomaticBackupStartTime;

        private String fsxAdminPassword;

        private String weeklyMaintenanceStartTime;

        private DiskIopsConfiguration diskIopsConfiguration;

        private Integer throughputCapacity;

        private List<String> addRouteTableIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeRouteTableIds = DefaultSdkAutoConstructList.getInstance();

        private Integer throughputCapacityPerHAPair;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemOntapConfiguration model) {
            automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            fsxAdminPassword(model.fsxAdminPassword);
            weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            diskIopsConfiguration(model.diskIopsConfiguration);
            throughputCapacity(model.throughputCapacity);
            addRouteTableIds(model.addRouteTableIds);
            removeRouteTableIds(model.removeRouteTableIds);
            throughputCapacityPerHAPair(model.throughputCapacityPerHAPair);
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final String getFsxAdminPassword() {
            return fsxAdminPassword;
        }

        public final void setFsxAdminPassword(String fsxAdminPassword) {
            this.fsxAdminPassword = fsxAdminPassword;
        }

        @Override
        public final Builder fsxAdminPassword(String fsxAdminPassword) {
            this.fsxAdminPassword = fsxAdminPassword;
            return this;
        }

        public final String getWeeklyMaintenanceStartTime() {
            return weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final DiskIopsConfiguration.Builder getDiskIopsConfiguration() {
            return diskIopsConfiguration != null ? diskIopsConfiguration.toBuilder() : null;
        }

        public final void setDiskIopsConfiguration(DiskIopsConfiguration.BuilderImpl diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration != null ? diskIopsConfiguration.build() : null;
        }

        @Override
        public final Builder diskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration;
            return this;
        }

        public final Integer getThroughputCapacity() {
            return throughputCapacity;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        @Override
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final Collection<String> getAddRouteTableIds() {
            if (addRouteTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return addRouteTableIds;
        }

        public final void setAddRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = RouteTableIdsCopier.copy(addRouteTableIds);
        }

        @Override
        public final Builder addRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = RouteTableIdsCopier.copy(addRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addRouteTableIds(String... addRouteTableIds) {
            addRouteTableIds(Arrays.asList(addRouteTableIds));
            return this;
        }

        public final Collection<String> getRemoveRouteTableIds() {
            if (removeRouteTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return removeRouteTableIds;
        }

        public final void setRemoveRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = RouteTableIdsCopier.copy(removeRouteTableIds);
        }

        @Override
        public final Builder removeRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = RouteTableIdsCopier.copy(removeRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeRouteTableIds(String... removeRouteTableIds) {
            removeRouteTableIds(Arrays.asList(removeRouteTableIds));
            return this;
        }

        public final Integer getThroughputCapacityPerHAPair() {
            return throughputCapacityPerHAPair;
        }

        public final void setThroughputCapacityPerHAPair(Integer throughputCapacityPerHAPair) {
            this.throughputCapacityPerHAPair = throughputCapacityPerHAPair;
        }

        @Override
        public final Builder throughputCapacityPerHAPair(Integer throughputCapacityPerHAPair) {
            this.throughputCapacityPerHAPair = throughputCapacityPerHAPair;
            return this;
        }

        @Override
        public UpdateFileSystemOntapConfiguration build() {
            return new UpdateFileSystemOntapConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
