/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopySnapshotAndUpdateVolumeResponse extends FSxResponse implements
        ToCopyableBuilder<CopySnapshotAndUpdateVolumeResponse.Builder, CopySnapshotAndUpdateVolumeResponse> {
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(CopySnapshotAndUpdateVolumeResponse::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Lifecycle").getter(getter(CopySnapshotAndUpdateVolumeResponse::lifecycleAsString))
            .setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<List<AdministrativeAction>> ADMINISTRATIVE_ACTIONS_FIELD = SdkField
            .<List<AdministrativeAction>> builder(MarshallingType.LIST)
            .memberName("AdministrativeActions")
            .getter(getter(CopySnapshotAndUpdateVolumeResponse::administrativeActions))
            .setter(setter(Builder::administrativeActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrativeActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdministrativeAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdministrativeAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ID_FIELD,
            LIFECYCLE_FIELD, ADMINISTRATIVE_ACTIONS_FIELD));

    private final String volumeId;

    private final String lifecycle;

    private final List<AdministrativeAction> administrativeActions;

    private CopySnapshotAndUpdateVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.volumeId = builder.volumeId;
        this.lifecycle = builder.lifecycle;
        this.administrativeActions = builder.administrativeActions;
    }

    /**
     * <p>
     * The ID of the volume that you copied the snapshot to.
     * </p>
     * 
     * @return The ID of the volume that you copied the snapshot to.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The lifecycle state of the destination volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link VolumeLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle state of the destination volume.
     * @see VolumeLifecycle
     */
    public final VolumeLifecycle lifecycle() {
        return VolumeLifecycle.fromValue(lifecycle);
    }

    /**
     * <p>
     * The lifecycle state of the destination volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link VolumeLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle state of the destination volume.
     * @see VolumeLifecycle
     */
    public final String lifecycleAsString() {
        return lifecycle;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdministrativeActions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdministrativeActions() {
        return administrativeActions != null && !(administrativeActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of administrative actions for the file system that are in process or waiting to be processed.
     * Administrative actions describe changes to the Amazon FSx system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdministrativeActions} method.
     * </p>
     * 
     * @return A list of administrative actions for the file system that are in process or waiting to be processed.
     *         Administrative actions describe changes to the Amazon FSx system.
     */
    public final List<AdministrativeAction> administrativeActions() {
        return administrativeActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdministrativeActions() ? administrativeActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotAndUpdateVolumeResponse)) {
            return false;
        }
        CopySnapshotAndUpdateVolumeResponse other = (CopySnapshotAndUpdateVolumeResponse) obj;
        return Objects.equals(volumeId(), other.volumeId()) && Objects.equals(lifecycleAsString(), other.lifecycleAsString())
                && hasAdministrativeActions() == other.hasAdministrativeActions()
                && Objects.equals(administrativeActions(), other.administrativeActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopySnapshotAndUpdateVolumeResponse").add("VolumeId", volumeId())
                .add("Lifecycle", lifecycleAsString())
                .add("AdministrativeActions", hasAdministrativeActions() ? administrativeActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        case "AdministrativeActions":
            return Optional.ofNullable(clazz.cast(administrativeActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopySnapshotAndUpdateVolumeResponse, T> g) {
        return obj -> g.apply((CopySnapshotAndUpdateVolumeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, CopySnapshotAndUpdateVolumeResponse> {
        /**
         * <p>
         * The ID of the volume that you copied the snapshot to.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume that you copied the snapshot to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The lifecycle state of the destination volume.
         * </p>
         * 
         * @param lifecycle
         *        The lifecycle state of the destination volume.
         * @see VolumeLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeLifecycle
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * The lifecycle state of the destination volume.
         * </p>
         * 
         * @param lifecycle
         *        The lifecycle state of the destination volume.
         * @see VolumeLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeLifecycle
         */
        Builder lifecycle(VolumeLifecycle lifecycle);

        /**
         * <p>
         * A list of administrative actions for the file system that are in process or waiting to be processed.
         * Administrative actions describe changes to the Amazon FSx system.
         * </p>
         * 
         * @param administrativeActions
         *        A list of administrative actions for the file system that are in process or waiting to be processed.
         *        Administrative actions describe changes to the Amazon FSx system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administrativeActions(Collection<AdministrativeAction> administrativeActions);

        /**
         * <p>
         * A list of administrative actions for the file system that are in process or waiting to be processed.
         * Administrative actions describe changes to the Amazon FSx system.
         * </p>
         * 
         * @param administrativeActions
         *        A list of administrative actions for the file system that are in process or waiting to be processed.
         *        Administrative actions describe changes to the Amazon FSx system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administrativeActions(AdministrativeAction... administrativeActions);

        /**
         * <p>
         * A list of administrative actions for the file system that are in process or waiting to be processed.
         * Administrative actions describe changes to the Amazon FSx system.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.AdministrativeAction.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.fsx.model.AdministrativeAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fsx.model.AdministrativeAction.Builder#build()} is called immediately
         * and its result is passed to {@link #administrativeActions(List<AdministrativeAction>)}.
         * 
         * @param administrativeActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fsx.model.AdministrativeAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #administrativeActions(java.util.Collection<AdministrativeAction>)
         */
        Builder administrativeActions(Consumer<AdministrativeAction.Builder>... administrativeActions);
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private String volumeId;

        private String lifecycle;

        private List<AdministrativeAction> administrativeActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopySnapshotAndUpdateVolumeResponse model) {
            super(model);
            volumeId(model.volumeId);
            lifecycle(model.lifecycle);
            administrativeActions(model.administrativeActions);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getLifecycle() {
            return lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(VolumeLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final List<AdministrativeAction.Builder> getAdministrativeActions() {
            List<AdministrativeAction.Builder> result = AdministrativeActionsCopier.copyToBuilder(this.administrativeActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdministrativeActions(Collection<AdministrativeAction.BuilderImpl> administrativeActions) {
            this.administrativeActions = AdministrativeActionsCopier.copyFromBuilder(administrativeActions);
        }

        @Override
        public final Builder administrativeActions(Collection<AdministrativeAction> administrativeActions) {
            this.administrativeActions = AdministrativeActionsCopier.copy(administrativeActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrativeActions(AdministrativeAction... administrativeActions) {
            administrativeActions(Arrays.asList(administrativeActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrativeActions(Consumer<AdministrativeAction.Builder>... administrativeActions) {
            administrativeActions(Stream.of(administrativeActions)
                    .map(c -> AdministrativeAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CopySnapshotAndUpdateVolumeResponse build() {
            return new CopySnapshotAndUpdateVolumeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
