/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for NetApp ONTAP, Amazon FSx for
 * Windows File Server, or FSx for OpenZFS file system. By default, Amazon FSx automatically provisions 3 IOPS per GB of
 * storage capacity. You can provision additional IOPS per GB of storage. The configuration consists of the total number
 * of provisioned SSD IOPS and how it is was provisioned, or the mode (by the customer or by Amazon FSx).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiskIopsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DiskIopsConfiguration.Builder, DiskIopsConfiguration> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(DiskIopsConfiguration::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<Long> IOPS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Iops")
            .getter(getter(DiskIopsConfiguration::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, IOPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final Long iops;

    private DiskIopsConfiguration(BuilderImpl builder) {
        this.mode = builder.mode;
        this.iops = builder.iops;
    }

    /**
     * <p>
     * Specifies whether the file system is using the <code>AUTOMATIC</code> setting of SSD IOPS of 3 IOPS per GB of
     * storage capacity, , or if it using a <code>USER_PROVISIONED</code> value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link DiskIopsConfigurationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Specifies whether the file system is using the <code>AUTOMATIC</code> setting of SSD IOPS of 3 IOPS per
     *         GB of storage capacity, , or if it using a <code>USER_PROVISIONED</code> value.
     * @see DiskIopsConfigurationMode
     */
    public final DiskIopsConfigurationMode mode() {
        return DiskIopsConfigurationMode.fromValue(mode);
    }

    /**
     * <p>
     * Specifies whether the file system is using the <code>AUTOMATIC</code> setting of SSD IOPS of 3 IOPS per GB of
     * storage capacity, , or if it using a <code>USER_PROVISIONED</code> value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link DiskIopsConfigurationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Specifies whether the file system is using the <code>AUTOMATIC</code> setting of SSD IOPS of 3 IOPS per
     *         GB of storage capacity, , or if it using a <code>USER_PROVISIONED</code> value.
     * @see DiskIopsConfigurationMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The total number of SSD IOPS provisioned for the file system.
     * </p>
     * <p>
     * The minimum and maximum values for this property depend on the value of <code>HAPairs</code> and
     * <code>StorageCapacity</code>. The minimum value is calculated as <code>StorageCapacity</code> * 3 *
     * <code>HAPairs</code> (3 IOPS per GB of <code>StorageCapacity</code>). The maximum value is calculated as 200,000
     * * <code>HAPairs</code>.
     * </p>
     * <p>
     * Amazon FSx responds with an HTTP status code 400 (Bad Request) if the value of <code>Iops</code> is outside of
     * the minimum or maximum values.
     * </p>
     * 
     * @return The total number of SSD IOPS provisioned for the file system.</p>
     *         <p>
     *         The minimum and maximum values for this property depend on the value of <code>HAPairs</code> and
     *         <code>StorageCapacity</code>. The minimum value is calculated as <code>StorageCapacity</code> * 3 *
     *         <code>HAPairs</code> (3 IOPS per GB of <code>StorageCapacity</code>). The maximum value is calculated as
     *         200,000 * <code>HAPairs</code>.
     *         </p>
     *         <p>
     *         Amazon FSx responds with an HTTP status code 400 (Bad Request) if the value of <code>Iops</code> is
     *         outside of the minimum or maximum values.
     */
    public final Long iops() {
        return iops;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskIopsConfiguration)) {
            return false;
        }
        DiskIopsConfiguration other = (DiskIopsConfiguration) obj;
        return Objects.equals(modeAsString(), other.modeAsString()) && Objects.equals(iops(), other.iops());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiskIopsConfiguration").add("Mode", modeAsString()).add("Iops", iops()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiskIopsConfiguration, T> g) {
        return obj -> g.apply((DiskIopsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DiskIopsConfiguration> {
        /**
         * <p>
         * Specifies whether the file system is using the <code>AUTOMATIC</code> setting of SSD IOPS of 3 IOPS per GB of
         * storage capacity, , or if it using a <code>USER_PROVISIONED</code> value.
         * </p>
         * 
         * @param mode
         *        Specifies whether the file system is using the <code>AUTOMATIC</code> setting of SSD IOPS of 3 IOPS
         *        per GB of storage capacity, , or if it using a <code>USER_PROVISIONED</code> value.
         * @see DiskIopsConfigurationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskIopsConfigurationMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * Specifies whether the file system is using the <code>AUTOMATIC</code> setting of SSD IOPS of 3 IOPS per GB of
         * storage capacity, , or if it using a <code>USER_PROVISIONED</code> value.
         * </p>
         * 
         * @param mode
         *        Specifies whether the file system is using the <code>AUTOMATIC</code> setting of SSD IOPS of 3 IOPS
         *        per GB of storage capacity, , or if it using a <code>USER_PROVISIONED</code> value.
         * @see DiskIopsConfigurationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskIopsConfigurationMode
         */
        Builder mode(DiskIopsConfigurationMode mode);

        /**
         * <p>
         * The total number of SSD IOPS provisioned for the file system.
         * </p>
         * <p>
         * The minimum and maximum values for this property depend on the value of <code>HAPairs</code> and
         * <code>StorageCapacity</code>. The minimum value is calculated as <code>StorageCapacity</code> * 3 *
         * <code>HAPairs</code> (3 IOPS per GB of <code>StorageCapacity</code>). The maximum value is calculated as
         * 200,000 * <code>HAPairs</code>.
         * </p>
         * <p>
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) if the value of <code>Iops</code> is outside
         * of the minimum or maximum values.
         * </p>
         * 
         * @param iops
         *        The total number of SSD IOPS provisioned for the file system.</p>
         *        <p>
         *        The minimum and maximum values for this property depend on the value of <code>HAPairs</code> and
         *        <code>StorageCapacity</code>. The minimum value is calculated as <code>StorageCapacity</code> * 3 *
         *        <code>HAPairs</code> (3 IOPS per GB of <code>StorageCapacity</code>). The maximum value is calculated
         *        as 200,000 * <code>HAPairs</code>.
         *        </p>
         *        <p>
         *        Amazon FSx responds with an HTTP status code 400 (Bad Request) if the value of <code>Iops</code> is
         *        outside of the minimum or maximum values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Long iops);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private Long iops;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskIopsConfiguration model) {
            mode(model.mode);
            iops(model.iops);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(DiskIopsConfigurationMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Long getIops() {
            return iops;
        }

        public final void setIops(Long iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Long iops) {
            this.iops = iops;
            return this;
        }

        @Override
        public DiskIopsConfiguration build() {
            return new DiskIopsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
