/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAliasesRequest extends GameLiftRequest implements
        ToCopyableBuilder<ListAliasesRequest.Builder, ListAliasesRequest> {
    private static final SdkField<String> ROUTING_STRATEGY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingStrategyType").getter(getter(ListAliasesRequest::routingStrategyTypeAsString))
            .setter(setter(Builder::routingStrategyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingStrategyType").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ListAliasesRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListAliasesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAliasesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_STRATEGY_TYPE_FIELD,
            NAME_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final String routingStrategyType;

    private final String name;

    private final Integer limit;

    private final String nextToken;

    private ListAliasesRequest(BuilderImpl builder) {
        super(builder);
        this.routingStrategyType = builder.routingStrategyType;
        this.name = builder.name;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The routing type to filter results on. Use this parameter to retrieve only aliases with a certain routing type.
     * To retrieve all aliases, leave this parameter empty.
     * </p>
     * <p>
     * Possible routing types include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SIMPLE</b> -- The alias resolves to one specific fleet. Use this type when routing to active fleets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TERMINAL</b> -- The alias does not resolve to a fleet but instead can be used to display a message to the
     * user. A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a> message
     * embedded.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #routingStrategyType} will return {@link RoutingStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #routingStrategyTypeAsString}.
     * </p>
     * 
     * @return The routing type to filter results on. Use this parameter to retrieve only aliases with a certain routing
     *         type. To retrieve all aliases, leave this parameter empty.</p>
     *         <p>
     *         Possible routing types include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>SIMPLE</b> -- The alias resolves to one specific fleet. Use this type when routing to active fleets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TERMINAL</b> -- The alias does not resolve to a fleet but instead can be used to display a message to
     *         the user. A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a>
     *         message embedded.
     *         </p>
     *         </li>
     * @see RoutingStrategyType
     */
    public final RoutingStrategyType routingStrategyType() {
        return RoutingStrategyType.fromValue(routingStrategyType);
    }

    /**
     * <p>
     * The routing type to filter results on. Use this parameter to retrieve only aliases with a certain routing type.
     * To retrieve all aliases, leave this parameter empty.
     * </p>
     * <p>
     * Possible routing types include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SIMPLE</b> -- The alias resolves to one specific fleet. Use this type when routing to active fleets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TERMINAL</b> -- The alias does not resolve to a fleet but instead can be used to display a message to the
     * user. A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a> message
     * embedded.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #routingStrategyType} will return {@link RoutingStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #routingStrategyTypeAsString}.
     * </p>
     * 
     * @return The routing type to filter results on. Use this parameter to retrieve only aliases with a certain routing
     *         type. To retrieve all aliases, leave this parameter empty.</p>
     *         <p>
     *         Possible routing types include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>SIMPLE</b> -- The alias resolves to one specific fleet. Use this type when routing to active fleets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TERMINAL</b> -- The alias does not resolve to a fleet but instead can be used to display a message to
     *         the user. A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a>
     *         message embedded.
     *         </p>
     *         </li>
     * @see RoutingStrategyType
     */
    public final String routingStrategyTypeAsString() {
        return routingStrategyType;
    }

    /**
     * <p>
     * A descriptive label that is associated with an alias. Alias names do not need to be unique.
     * </p>
     * 
     * @return A descriptive label that is associated with an alias. Alias names do not need to be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set
     * of sequential pages.
     * </p>
     * 
     * @return The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as
     *         a set of sequential pages.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a
     * previous call to this operation. To start at the beginning of the result set, do not specify a value.
     * </p>
     * 
     * @return A token that indicates the start of the next sequential page of results. Use the token that is returned
     *         with a previous call to this operation. To start at the beginning of the result set, do not specify a
     *         value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routingStrategyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAliasesRequest)) {
            return false;
        }
        ListAliasesRequest other = (ListAliasesRequest) obj;
        return Objects.equals(routingStrategyTypeAsString(), other.routingStrategyTypeAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAliasesRequest").add("RoutingStrategyType", routingStrategyTypeAsString())
                .add("Name", name()).add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoutingStrategyType":
            return Optional.ofNullable(clazz.cast(routingStrategyTypeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAliasesRequest, T> g) {
        return obj -> g.apply((ListAliasesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAliasesRequest> {
        /**
         * <p>
         * The routing type to filter results on. Use this parameter to retrieve only aliases with a certain routing
         * type. To retrieve all aliases, leave this parameter empty.
         * </p>
         * <p>
         * Possible routing types include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>SIMPLE</b> -- The alias resolves to one specific fleet. Use this type when routing to active fleets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TERMINAL</b> -- The alias does not resolve to a fleet but instead can be used to display a message to the
         * user. A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a> message
         * embedded.
         * </p>
         * </li>
         * </ul>
         * 
         * @param routingStrategyType
         *        The routing type to filter results on. Use this parameter to retrieve only aliases with a certain
         *        routing type. To retrieve all aliases, leave this parameter empty.</p>
         *        <p>
         *        Possible routing types include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>SIMPLE</b> -- The alias resolves to one specific fleet. Use this type when routing to active
         *        fleets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TERMINAL</b> -- The alias does not resolve to a fleet but instead can be used to display a message
         *        to the user. A terminal alias throws a TerminalRoutingStrategyException with the
         *        <a>RoutingStrategy</a> message embedded.
         *        </p>
         *        </li>
         * @see RoutingStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingStrategyType
         */
        Builder routingStrategyType(String routingStrategyType);

        /**
         * <p>
         * The routing type to filter results on. Use this parameter to retrieve only aliases with a certain routing
         * type. To retrieve all aliases, leave this parameter empty.
         * </p>
         * <p>
         * Possible routing types include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>SIMPLE</b> -- The alias resolves to one specific fleet. Use this type when routing to active fleets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TERMINAL</b> -- The alias does not resolve to a fleet but instead can be used to display a message to the
         * user. A terminal alias throws a TerminalRoutingStrategyException with the <a>RoutingStrategy</a> message
         * embedded.
         * </p>
         * </li>
         * </ul>
         * 
         * @param routingStrategyType
         *        The routing type to filter results on. Use this parameter to retrieve only aliases with a certain
         *        routing type. To retrieve all aliases, leave this parameter empty.</p>
         *        <p>
         *        Possible routing types include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>SIMPLE</b> -- The alias resolves to one specific fleet. Use this type when routing to active
         *        fleets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TERMINAL</b> -- The alias does not resolve to a fleet but instead can be used to display a message
         *        to the user. A terminal alias throws a TerminalRoutingStrategyException with the
         *        <a>RoutingStrategy</a> message embedded.
         *        </p>
         *        </li>
         * @see RoutingStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingStrategyType
         */
        Builder routingStrategyType(RoutingStrategyType routingStrategyType);

        /**
         * <p>
         * A descriptive label that is associated with an alias. Alias names do not need to be unique.
         * </p>
         * 
         * @param name
         *        A descriptive label that is associated with an alias. Alias names do not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a
         * set of sequential pages.
         * </p>
         * 
         * @param limit
         *        The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results
         *        as a set of sequential pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with
         * a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the start of the next sequential page of results. Use the token that is
         *        returned with a previous call to this operation. To start at the beginning of the result set, do not
         *        specify a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String routingStrategyType;

        private String name;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAliasesRequest model) {
            super(model);
            routingStrategyType(model.routingStrategyType);
            name(model.name);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getRoutingStrategyType() {
            return routingStrategyType;
        }

        public final void setRoutingStrategyType(String routingStrategyType) {
            this.routingStrategyType = routingStrategyType;
        }

        @Override
        public final Builder routingStrategyType(String routingStrategyType) {
            this.routingStrategyType = routingStrategyType;
            return this;
        }

        @Override
        public final Builder routingStrategyType(RoutingStrategyType routingStrategyType) {
            this.routingStrategyType(routingStrategyType == null ? null : routingStrategyType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAliasesRequest build() {
            return new ListAliasesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
