/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeListenerResponse extends GlobalAcceleratorResponse implements
        ToCopyableBuilder<DescribeListenerResponse.Builder, DescribeListenerResponse> {
    private static final SdkField<Listener> LISTENER_FIELD = SdkField.<Listener> builder(MarshallingType.SDK_POJO)
            .memberName("Listener").getter(getter(DescribeListenerResponse::listener)).setter(setter(Builder::listener))
            .constructor(Listener::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Listener").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_FIELD));

    private final Listener listener;

    private DescribeListenerResponse(BuilderImpl builder) {
        super(builder);
        this.listener = builder.listener;
    }

    /**
     * <p>
     * The description of a listener.
     * </p>
     * 
     * @return The description of a listener.
     */
    public final Listener listener() {
        return listener;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listener());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeListenerResponse)) {
            return false;
        }
        DescribeListenerResponse other = (DescribeListenerResponse) obj;
        return Objects.equals(listener(), other.listener());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeListenerResponse").add("Listener", listener()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Listener":
            return Optional.ofNullable(clazz.cast(listener()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeListenerResponse, T> g) {
        return obj -> g.apply((DescribeListenerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeListenerResponse> {
        /**
         * <p>
         * The description of a listener.
         * </p>
         * 
         * @param listener
         *        The description of a listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listener(Listener listener);

        /**
         * <p>
         * The description of a listener.
         * </p>
         * This is a convenience method that creates an instance of the {@link Listener.Builder} avoiding the need to
         * create one manually via {@link Listener#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Listener.Builder#build()} is called immediately and its result is
         * passed to {@link #listener(Listener)}.
         * 
         * @param listener
         *        a consumer that will call methods on {@link Listener.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listener(Listener)
         */
        default Builder listener(Consumer<Listener.Builder> listener) {
            return listener(Listener.builder().applyMutation(listener).build());
        }
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private Listener listener;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeListenerResponse model) {
            super(model);
            listener(model.listener);
        }

        public final Listener.Builder getListener() {
            return listener != null ? listener.toBuilder() : null;
        }

        public final void setListener(Listener.BuilderImpl listener) {
            this.listener = listener != null ? listener.build() : null;
        }

        @Override
        public final Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        @Override
        public DescribeListenerResponse build() {
            return new DescribeListenerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
