/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a data target that writes to Amazon S3 in Apache Parquet columnar storage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JDBCConnectorTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<JDBCConnectorTarget.Builder, JDBCConnectorTarget> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(JDBCConnectorTarget::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(JDBCConnectorTarget::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionName").getter(getter(JDBCConnectorTarget::connectionName))
            .setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<String> CONNECTION_TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionTable").getter(getter(JDBCConnectorTarget::connectionTable))
            .setter(setter(Builder::connectionTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTable").build()).build();

    private static final SdkField<String> CONNECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorName").getter(getter(JDBCConnectorTarget::connectorName))
            .setter(setter(Builder::connectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorName").build()).build();

    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionType").getter(getter(JDBCConnectorTarget::connectionType))
            .setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()).build();

    private static final SdkField<Map<String, String>> ADDITIONAL_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdditionalOptions")
            .getter(getter(JDBCConnectorTarget::additionalOptions))
            .setter(setter(Builder::additionalOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOptions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<GlueSchema>> OUTPUT_SCHEMAS_FIELD = SdkField
            .<List<GlueSchema>> builder(MarshallingType.LIST)
            .memberName("OutputSchemas")
            .getter(getter(JDBCConnectorTarget::outputSchemas))
            .setter(setter(Builder::outputSchemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSchemas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlueSchema> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlueSchema::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            CONNECTION_NAME_FIELD, CONNECTION_TABLE_FIELD, CONNECTOR_NAME_FIELD, CONNECTION_TYPE_FIELD, ADDITIONAL_OPTIONS_FIELD,
            OUTPUT_SCHEMAS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final String connectionName;

    private final String connectionTable;

    private final String connectorName;

    private final String connectionType;

    private final Map<String, String> additionalOptions;

    private final List<GlueSchema> outputSchemas;

    private JDBCConnectorTarget(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.connectionName = builder.connectionName;
        this.connectionTable = builder.connectionTable;
        this.connectorName = builder.connectorName;
        this.connectionType = builder.connectionType;
        this.additionalOptions = builder.additionalOptions;
        this.outputSchemas = builder.outputSchemas;
    }

    /**
     * <p>
     * The name of the data target.
     * </p>
     * 
     * @return The name of the data target.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The nodes that are inputs to the data target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The nodes that are inputs to the data target.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * <p>
     * The name of the connection that is associated with the connector.
     * </p>
     * 
     * @return The name of the connection that is associated with the connector.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * <p>
     * The name of the table in the data target.
     * </p>
     * 
     * @return The name of the table in the data target.
     */
    public final String connectionTable() {
        return connectionTable;
    }

    /**
     * <p>
     * The name of a connector that will be used.
     * </p>
     * 
     * @return The name of a connector that will be used.
     */
    public final String connectorName() {
        return connectorName;
    }

    /**
     * <p>
     * The type of connection, such as marketplace.jdbc or custom.jdbc, designating a connection to a JDBC data target.
     * </p>
     * 
     * @return The type of connection, such as marketplace.jdbc or custom.jdbc, designating a connection to a JDBC data
     *         target.
     */
    public final String connectionType() {
        return connectionType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalOptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalOptions() {
        return additionalOptions != null && !(additionalOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Additional connection options for the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalOptions} method.
     * </p>
     * 
     * @return Additional connection options for the connector.
     */
    public final Map<String, String> additionalOptions() {
        return additionalOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputSchemas property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputSchemas() {
        return outputSchemas != null && !(outputSchemas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the data schema for the JDBC target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputSchemas} method.
     * </p>
     * 
     * @return Specifies the data schema for the JDBC target.
     */
    public final List<GlueSchema> outputSchemas() {
        return outputSchemas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTable());
        hashCode = 31 * hashCode + Objects.hashCode(connectorName());
        hashCode = 31 * hashCode + Objects.hashCode(connectionType());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalOptions() ? additionalOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputSchemas() ? outputSchemas() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JDBCConnectorTarget)) {
            return false;
        }
        JDBCConnectorTarget other = (JDBCConnectorTarget) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(connectionName(), other.connectionName())
                && Objects.equals(connectionTable(), other.connectionTable())
                && Objects.equals(connectorName(), other.connectorName())
                && Objects.equals(connectionType(), other.connectionType())
                && hasAdditionalOptions() == other.hasAdditionalOptions()
                && Objects.equals(additionalOptions(), other.additionalOptions())
                && hasOutputSchemas() == other.hasOutputSchemas() && Objects.equals(outputSchemas(), other.outputSchemas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JDBCConnectorTarget").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("ConnectionName", connectionName()).add("ConnectionTable", connectionTable())
                .add("ConnectorName", connectorName()).add("ConnectionType", connectionType())
                .add("AdditionalOptions", hasAdditionalOptions() ? additionalOptions() : null)
                .add("OutputSchemas", hasOutputSchemas() ? outputSchemas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "ConnectionTable":
            return Optional.ofNullable(clazz.cast(connectionTable()));
        case "ConnectorName":
            return Optional.ofNullable(clazz.cast(connectorName()));
        case "ConnectionType":
            return Optional.ofNullable(clazz.cast(connectionType()));
        case "AdditionalOptions":
            return Optional.ofNullable(clazz.cast(additionalOptions()));
        case "OutputSchemas":
            return Optional.ofNullable(clazz.cast(outputSchemas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JDBCConnectorTarget, T> g) {
        return obj -> g.apply((JDBCConnectorTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JDBCConnectorTarget> {
        /**
         * <p>
         * The name of the data target.
         * </p>
         * 
         * @param name
         *        The name of the data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The nodes that are inputs to the data target.
         * </p>
         * 
         * @param inputs
         *        The nodes that are inputs to the data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The nodes that are inputs to the data target.
         * </p>
         * 
         * @param inputs
         *        The nodes that are inputs to the data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * The name of the connection that is associated with the connector.
         * </p>
         * 
         * @param connectionName
         *        The name of the connection that is associated with the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * The name of the table in the data target.
         * </p>
         * 
         * @param connectionTable
         *        The name of the table in the data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionTable(String connectionTable);

        /**
         * <p>
         * The name of a connector that will be used.
         * </p>
         * 
         * @param connectorName
         *        The name of a connector that will be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorName(String connectorName);

        /**
         * <p>
         * The type of connection, such as marketplace.jdbc or custom.jdbc, designating a connection to a JDBC data
         * target.
         * </p>
         * 
         * @param connectionType
         *        The type of connection, such as marketplace.jdbc or custom.jdbc, designating a connection to a JDBC
         *        data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * Additional connection options for the connector.
         * </p>
         * 
         * @param additionalOptions
         *        Additional connection options for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalOptions(Map<String, String> additionalOptions);

        /**
         * <p>
         * Specifies the data schema for the JDBC target.
         * </p>
         * 
         * @param outputSchemas
         *        Specifies the data schema for the JDBC target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSchemas(Collection<GlueSchema> outputSchemas);

        /**
         * <p>
         * Specifies the data schema for the JDBC target.
         * </p>
         * 
         * @param outputSchemas
         *        Specifies the data schema for the JDBC target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSchemas(GlueSchema... outputSchemas);

        /**
         * <p>
         * Specifies the data schema for the JDBC target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.GlueSchema.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.GlueSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.GlueSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #outputSchemas(List<GlueSchema>)}.
         * 
         * @param outputSchemas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.GlueSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSchemas(java.util.Collection<GlueSchema>)
         */
        Builder outputSchemas(Consumer<GlueSchema.Builder>... outputSchemas);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private String connectionName;

        private String connectionTable;

        private String connectorName;

        private String connectionType;

        private Map<String, String> additionalOptions = DefaultSdkAutoConstructMap.getInstance();

        private List<GlueSchema> outputSchemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JDBCConnectorTarget model) {
            name(model.name);
            inputs(model.inputs);
            connectionName(model.connectionName);
            connectionTable(model.connectionTable);
            connectorName(model.connectorName);
            connectionType(model.connectionType);
            additionalOptions(model.additionalOptions);
            outputSchemas(model.outputSchemas);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getConnectionTable() {
            return connectionTable;
        }

        public final void setConnectionTable(String connectionTable) {
            this.connectionTable = connectionTable;
        }

        @Override
        public final Builder connectionTable(String connectionTable) {
            this.connectionTable = connectionTable;
            return this;
        }

        public final String getConnectorName() {
            return connectorName;
        }

        public final void setConnectorName(String connectorName) {
            this.connectorName = connectorName;
        }

        @Override
        public final Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            return this;
        }

        public final String getConnectionType() {
            return connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public final Map<String, String> getAdditionalOptions() {
            if (additionalOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalOptions;
        }

        public final void setAdditionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = AdditionalOptionsCopier.copy(additionalOptions);
        }

        @Override
        public final Builder additionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = AdditionalOptionsCopier.copy(additionalOptions);
            return this;
        }

        public final List<GlueSchema.Builder> getOutputSchemas() {
            List<GlueSchema.Builder> result = GlueSchemasCopier.copyToBuilder(this.outputSchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSchemas(Collection<GlueSchema.BuilderImpl> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copyFromBuilder(outputSchemas);
        }

        @Override
        public final Builder outputSchemas(Collection<GlueSchema> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copy(outputSchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(GlueSchema... outputSchemas) {
            outputSchemas(Arrays.asList(outputSchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(Consumer<GlueSchema.Builder>... outputSchemas) {
            outputSchemas(Stream.of(outputSchemas).map(c -> GlueSchema.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public JDBCConnectorTarget build() {
            return new JDBCConnectorTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
