/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkspaceApiKeyRequest extends GrafanaRequest implements
        ToCopyableBuilder<CreateWorkspaceApiKeyRequest.Builder, CreateWorkspaceApiKeyRequest> {
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyName").getter(getter(CreateWorkspaceApiKeyRequest::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyName").build()).build();

    private static final SdkField<String> KEY_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyRole").getter(getter(CreateWorkspaceApiKeyRequest::keyRole)).setter(setter(Builder::keyRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyRole").build()).build();

    private static final SdkField<Integer> SECONDS_TO_LIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("secondsToLive").getter(getter(CreateWorkspaceApiKeyRequest::secondsToLive))
            .setter(setter(Builder::secondsToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondsToLive").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(CreateWorkspaceApiKeyRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_NAME_FIELD,
            KEY_ROLE_FIELD, SECONDS_TO_LIVE_FIELD, WORKSPACE_ID_FIELD));

    private final String keyName;

    private final String keyRole;

    private final Integer secondsToLive;

    private final String workspaceId;

    private CreateWorkspaceApiKeyRequest(BuilderImpl builder) {
        super(builder);
        this.keyName = builder.keyName;
        this.keyRole = builder.keyRole;
        this.secondsToLive = builder.secondsToLive;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * Specifies the name of the key to create. Key names must be unique to the workspace.
     * </p>
     * 
     * @return Specifies the name of the key to create. Key names must be unique to the workspace.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * Specifies the permission level of the key.
     * </p>
     * <p>
     * Valid Values: <code>VIEWER</code> | <code>EDITOR</code> | <code>ADMIN</code>
     * </p>
     * 
     * @return Specifies the permission level of the key.</p>
     *         <p>
     *         Valid Values: <code>VIEWER</code> | <code>EDITOR</code> | <code>ADMIN</code>
     */
    public final String keyRole() {
        return keyRole;
    }

    /**
     * <p>
     * Specifies the time in seconds until the key expires. Keys can be valid for up to 30 days.
     * </p>
     * 
     * @return Specifies the time in seconds until the key expires. Keys can be valid for up to 30 days.
     */
    public final Integer secondsToLive() {
        return secondsToLive;
    }

    /**
     * <p>
     * The ID of the workspace in which to create an API key.
     * </p>
     * 
     * @return The ID of the workspace in which to create an API key.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(keyRole());
        hashCode = 31 * hashCode + Objects.hashCode(secondsToLive());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceApiKeyRequest)) {
            return false;
        }
        CreateWorkspaceApiKeyRequest other = (CreateWorkspaceApiKeyRequest) obj;
        return Objects.equals(keyName(), other.keyName()) && Objects.equals(keyRole(), other.keyRole())
                && Objects.equals(secondsToLive(), other.secondsToLive()) && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkspaceApiKeyRequest").add("KeyName", keyName()).add("KeyRole", keyRole())
                .add("SecondsToLive", secondsToLive()).add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "keyRole":
            return Optional.ofNullable(clazz.cast(keyRole()));
        case "secondsToLive":
            return Optional.ofNullable(clazz.cast(secondsToLive()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceApiKeyRequest, T> g) {
        return obj -> g.apply((CreateWorkspaceApiKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkspaceApiKeyRequest> {
        /**
         * <p>
         * Specifies the name of the key to create. Key names must be unique to the workspace.
         * </p>
         * 
         * @param keyName
         *        Specifies the name of the key to create. Key names must be unique to the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * Specifies the permission level of the key.
         * </p>
         * <p>
         * Valid Values: <code>VIEWER</code> | <code>EDITOR</code> | <code>ADMIN</code>
         * </p>
         * 
         * @param keyRole
         *        Specifies the permission level of the key.</p>
         *        <p>
         *        Valid Values: <code>VIEWER</code> | <code>EDITOR</code> | <code>ADMIN</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyRole(String keyRole);

        /**
         * <p>
         * Specifies the time in seconds until the key expires. Keys can be valid for up to 30 days.
         * </p>
         * 
         * @param secondsToLive
         *        Specifies the time in seconds until the key expires. Keys can be valid for up to 30 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondsToLive(Integer secondsToLive);

        /**
         * <p>
         * The ID of the workspace in which to create an API key.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace in which to create an API key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GrafanaRequest.BuilderImpl implements Builder {
        private String keyName;

        private String keyRole;

        private Integer secondsToLive;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceApiKeyRequest model) {
            super(model);
            keyName(model.keyName);
            keyRole(model.keyRole);
            secondsToLive(model.secondsToLive);
            workspaceId(model.workspaceId);
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getKeyRole() {
            return keyRole;
        }

        public final void setKeyRole(String keyRole) {
            this.keyRole = keyRole;
        }

        @Override
        public final Builder keyRole(String keyRole) {
            this.keyRole = keyRole;
            return this;
        }

        public final Integer getSecondsToLive() {
            return secondsToLive;
        }

        public final void setSecondsToLive(Integer secondsToLive) {
            this.secondsToLive = secondsToLive;
        }

        @Override
        public final Builder secondsToLive(Integer secondsToLive) {
            this.secondsToLive = secondsToLive;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkspaceApiKeyRequest build() {
            return new CreateWorkspaceApiKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
