/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.grafana.model.AccountAccessType;
import software.amazon.awssdk.services.grafana.model.DataSourceType;
import software.amazon.awssdk.services.grafana.model.DataSourceTypesListCopier;
import software.amazon.awssdk.services.grafana.model.GrafanaRequest;
import software.amazon.awssdk.services.grafana.model.NotificationDestinationType;
import software.amazon.awssdk.services.grafana.model.NotificationDestinationsListCopier;
import software.amazon.awssdk.services.grafana.model.OrganizationalUnitListCopier;
import software.amazon.awssdk.services.grafana.model.PermissionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkspaceRequest
extends GrafanaRequest
implements ToCopyableBuilder<Builder, UpdateWorkspaceRequest> {
    private static final SdkField<String> ACCOUNT_ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountAccessType").getter(UpdateWorkspaceRequest.getter(UpdateWorkspaceRequest::accountAccessTypeAsString)).setter(UpdateWorkspaceRequest.setter(Builder::accountAccessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountAccessType").build()}).build();
    private static final SdkField<String> ORGANIZATION_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("organizationRoleName").getter(UpdateWorkspaceRequest.getter(UpdateWorkspaceRequest::organizationRoleName)).setter(UpdateWorkspaceRequest.setter(Builder::organizationRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationRoleName").build()}).build();
    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permissionType").getter(UpdateWorkspaceRequest.getter(UpdateWorkspaceRequest::permissionTypeAsString)).setter(UpdateWorkspaceRequest.setter(Builder::permissionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionType").build()}).build();
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stackSetName").getter(UpdateWorkspaceRequest.getter(UpdateWorkspaceRequest::stackSetName)).setter(UpdateWorkspaceRequest.setter(Builder::stackSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackSetName").build()}).build();
    private static final SdkField<List<String>> WORKSPACE_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workspaceDataSources").getter(UpdateWorkspaceRequest.getter(UpdateWorkspaceRequest::workspaceDataSourcesAsStrings)).setter(UpdateWorkspaceRequest.setter(Builder::workspaceDataSourcesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceDataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKSPACE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceDescription").getter(UpdateWorkspaceRequest.getter(UpdateWorkspaceRequest::workspaceDescription)).setter(UpdateWorkspaceRequest.setter(Builder::workspaceDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceDescription").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(UpdateWorkspaceRequest.getter(UpdateWorkspaceRequest::workspaceId)).setter(UpdateWorkspaceRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final SdkField<String> WORKSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceName").getter(UpdateWorkspaceRequest.getter(UpdateWorkspaceRequest::workspaceName)).setter(UpdateWorkspaceRequest.setter(Builder::workspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceName").build()}).build();
    private static final SdkField<List<String>> WORKSPACE_NOTIFICATION_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workspaceNotificationDestinations").getter(UpdateWorkspaceRequest.getter(UpdateWorkspaceRequest::workspaceNotificationDestinationsAsStrings)).setter(UpdateWorkspaceRequest.setter(Builder::workspaceNotificationDestinationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceNotificationDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> WORKSPACE_ORGANIZATIONAL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workspaceOrganizationalUnits").getter(UpdateWorkspaceRequest.getter(UpdateWorkspaceRequest::workspaceOrganizationalUnits)).setter(UpdateWorkspaceRequest.setter(Builder::workspaceOrganizationalUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceOrganizationalUnits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKSPACE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceRoleArn").getter(UpdateWorkspaceRequest.getter(UpdateWorkspaceRequest::workspaceRoleArn)).setter(UpdateWorkspaceRequest.setter(Builder::workspaceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ACCESS_TYPE_FIELD, ORGANIZATION_ROLE_NAME_FIELD, PERMISSION_TYPE_FIELD, STACK_SET_NAME_FIELD, WORKSPACE_DATA_SOURCES_FIELD, WORKSPACE_DESCRIPTION_FIELD, WORKSPACE_ID_FIELD, WORKSPACE_NAME_FIELD, WORKSPACE_NOTIFICATION_DESTINATIONS_FIELD, WORKSPACE_ORGANIZATIONAL_UNITS_FIELD, WORKSPACE_ROLE_ARN_FIELD));
    private final String accountAccessType;
    private final String organizationRoleName;
    private final String permissionType;
    private final String stackSetName;
    private final List<String> workspaceDataSources;
    private final String workspaceDescription;
    private final String workspaceId;
    private final String workspaceName;
    private final List<String> workspaceNotificationDestinations;
    private final List<String> workspaceOrganizationalUnits;
    private final String workspaceRoleArn;

    private UpdateWorkspaceRequest(BuilderImpl builder) {
        super(builder);
        this.accountAccessType = builder.accountAccessType;
        this.organizationRoleName = builder.organizationRoleName;
        this.permissionType = builder.permissionType;
        this.stackSetName = builder.stackSetName;
        this.workspaceDataSources = builder.workspaceDataSources;
        this.workspaceDescription = builder.workspaceDescription;
        this.workspaceId = builder.workspaceId;
        this.workspaceName = builder.workspaceName;
        this.workspaceNotificationDestinations = builder.workspaceNotificationDestinations;
        this.workspaceOrganizationalUnits = builder.workspaceOrganizationalUnits;
        this.workspaceRoleArn = builder.workspaceRoleArn;
    }

    public final AccountAccessType accountAccessType() {
        return AccountAccessType.fromValue(this.accountAccessType);
    }

    public final String accountAccessTypeAsString() {
        return this.accountAccessType;
    }

    public final String organizationRoleName() {
        return this.organizationRoleName;
    }

    public final PermissionType permissionType() {
        return PermissionType.fromValue(this.permissionType);
    }

    public final String permissionTypeAsString() {
        return this.permissionType;
    }

    public final String stackSetName() {
        return this.stackSetName;
    }

    public final List<DataSourceType> workspaceDataSources() {
        return DataSourceTypesListCopier.copyStringToEnum(this.workspaceDataSources);
    }

    public final boolean hasWorkspaceDataSources() {
        return this.workspaceDataSources != null && !(this.workspaceDataSources instanceof SdkAutoConstructList);
    }

    public final List<String> workspaceDataSourcesAsStrings() {
        return this.workspaceDataSources;
    }

    public final String workspaceDescription() {
        return this.workspaceDescription;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final String workspaceName() {
        return this.workspaceName;
    }

    public final List<NotificationDestinationType> workspaceNotificationDestinations() {
        return NotificationDestinationsListCopier.copyStringToEnum(this.workspaceNotificationDestinations);
    }

    public final boolean hasWorkspaceNotificationDestinations() {
        return this.workspaceNotificationDestinations != null && !(this.workspaceNotificationDestinations instanceof SdkAutoConstructList);
    }

    public final List<String> workspaceNotificationDestinationsAsStrings() {
        return this.workspaceNotificationDestinations;
    }

    public final boolean hasWorkspaceOrganizationalUnits() {
        return this.workspaceOrganizationalUnits != null && !(this.workspaceOrganizationalUnits instanceof SdkAutoConstructList);
    }

    public final List<String> workspaceOrganizationalUnits() {
        return this.workspaceOrganizationalUnits;
    }

    public final String workspaceRoleArn() {
        return this.workspaceRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAccessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspaceDataSources() ? this.workspaceDataSourcesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspaceNotificationDestinations() ? this.workspaceNotificationDestinationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspaceOrganizationalUnits() ? this.workspaceOrganizationalUnits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceRequest)) {
            return false;
        }
        UpdateWorkspaceRequest other = (UpdateWorkspaceRequest)((Object)obj);
        return Objects.equals(this.accountAccessTypeAsString(), other.accountAccessTypeAsString()) && Objects.equals(this.organizationRoleName(), other.organizationRoleName()) && Objects.equals(this.permissionTypeAsString(), other.permissionTypeAsString()) && Objects.equals(this.stackSetName(), other.stackSetName()) && this.hasWorkspaceDataSources() == other.hasWorkspaceDataSources() && Objects.equals(this.workspaceDataSourcesAsStrings(), other.workspaceDataSourcesAsStrings()) && Objects.equals(this.workspaceDescription(), other.workspaceDescription()) && Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.workspaceName(), other.workspaceName()) && this.hasWorkspaceNotificationDestinations() == other.hasWorkspaceNotificationDestinations() && Objects.equals(this.workspaceNotificationDestinationsAsStrings(), other.workspaceNotificationDestinationsAsStrings()) && this.hasWorkspaceOrganizationalUnits() == other.hasWorkspaceOrganizationalUnits() && Objects.equals(this.workspaceOrganizationalUnits(), other.workspaceOrganizationalUnits()) && Objects.equals(this.workspaceRoleArn(), other.workspaceRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkspaceRequest").add("AccountAccessType", (Object)this.accountAccessTypeAsString()).add("OrganizationRoleName", (Object)(this.organizationRoleName() == null ? null : "*** Sensitive Data Redacted ***")).add("PermissionType", (Object)this.permissionTypeAsString()).add("StackSetName", (Object)this.stackSetName()).add("WorkspaceDataSources", this.hasWorkspaceDataSources() ? this.workspaceDataSourcesAsStrings() : null).add("WorkspaceDescription", (Object)(this.workspaceDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("WorkspaceId", (Object)this.workspaceId()).add("WorkspaceName", (Object)(this.workspaceName() == null ? null : "*** Sensitive Data Redacted ***")).add("WorkspaceNotificationDestinations", this.hasWorkspaceNotificationDestinations() ? this.workspaceNotificationDestinationsAsStrings() : null).add("WorkspaceOrganizationalUnits", (Object)(this.workspaceOrganizationalUnits() == null ? null : "*** Sensitive Data Redacted ***")).add("WorkspaceRoleArn", (Object)(this.workspaceRoleArn() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountAccessType": {
                return Optional.ofNullable(clazz.cast(this.accountAccessTypeAsString()));
            }
            case "organizationRoleName": {
                return Optional.ofNullable(clazz.cast(this.organizationRoleName()));
            }
            case "permissionType": {
                return Optional.ofNullable(clazz.cast(this.permissionTypeAsString()));
            }
            case "stackSetName": {
                return Optional.ofNullable(clazz.cast(this.stackSetName()));
            }
            case "workspaceDataSources": {
                return Optional.ofNullable(clazz.cast(this.workspaceDataSourcesAsStrings()));
            }
            case "workspaceDescription": {
                return Optional.ofNullable(clazz.cast(this.workspaceDescription()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "workspaceName": {
                return Optional.ofNullable(clazz.cast(this.workspaceName()));
            }
            case "workspaceNotificationDestinations": {
                return Optional.ofNullable(clazz.cast(this.workspaceNotificationDestinationsAsStrings()));
            }
            case "workspaceOrganizationalUnits": {
                return Optional.ofNullable(clazz.cast(this.workspaceOrganizationalUnits()));
            }
            case "workspaceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.workspaceRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspaceRequest, T> g) {
        return obj -> g.apply((UpdateWorkspaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaRequest.BuilderImpl
    implements Builder {
        private String accountAccessType;
        private String organizationRoleName;
        private String permissionType;
        private String stackSetName;
        private List<String> workspaceDataSources = DefaultSdkAutoConstructList.getInstance();
        private String workspaceDescription;
        private String workspaceId;
        private String workspaceName;
        private List<String> workspaceNotificationDestinations = DefaultSdkAutoConstructList.getInstance();
        private List<String> workspaceOrganizationalUnits = DefaultSdkAutoConstructList.getInstance();
        private String workspaceRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspaceRequest model) {
            super(model);
            this.accountAccessType(model.accountAccessType);
            this.organizationRoleName(model.organizationRoleName);
            this.permissionType(model.permissionType);
            this.stackSetName(model.stackSetName);
            this.workspaceDataSourcesWithStrings(model.workspaceDataSources);
            this.workspaceDescription(model.workspaceDescription);
            this.workspaceId(model.workspaceId);
            this.workspaceName(model.workspaceName);
            this.workspaceNotificationDestinationsWithStrings(model.workspaceNotificationDestinations);
            this.workspaceOrganizationalUnits(model.workspaceOrganizationalUnits);
            this.workspaceRoleArn(model.workspaceRoleArn);
        }

        public final String getAccountAccessType() {
            return this.accountAccessType;
        }

        public final void setAccountAccessType(String accountAccessType) {
            this.accountAccessType = accountAccessType;
        }

        @Override
        public final Builder accountAccessType(String accountAccessType) {
            this.accountAccessType = accountAccessType;
            return this;
        }

        @Override
        public final Builder accountAccessType(AccountAccessType accountAccessType) {
            this.accountAccessType(accountAccessType == null ? null : accountAccessType.toString());
            return this;
        }

        public final String getOrganizationRoleName() {
            return this.organizationRoleName;
        }

        public final void setOrganizationRoleName(String organizationRoleName) {
            this.organizationRoleName = organizationRoleName;
        }

        @Override
        public final Builder organizationRoleName(String organizationRoleName) {
            this.organizationRoleName = organizationRoleName;
            return this;
        }

        public final String getPermissionType() {
            return this.permissionType;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(PermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final Collection<String> getWorkspaceDataSources() {
            if (this.workspaceDataSources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.workspaceDataSources;
        }

        public final void setWorkspaceDataSources(Collection<String> workspaceDataSources) {
            this.workspaceDataSources = DataSourceTypesListCopier.copy(workspaceDataSources);
        }

        @Override
        public final Builder workspaceDataSourcesWithStrings(Collection<String> workspaceDataSources) {
            this.workspaceDataSources = DataSourceTypesListCopier.copy(workspaceDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceDataSourcesWithStrings(String ... workspaceDataSources) {
            this.workspaceDataSourcesWithStrings(Arrays.asList(workspaceDataSources));
            return this;
        }

        @Override
        public final Builder workspaceDataSources(Collection<DataSourceType> workspaceDataSources) {
            this.workspaceDataSources = DataSourceTypesListCopier.copyEnumToString(workspaceDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceDataSources(DataSourceType ... workspaceDataSources) {
            this.workspaceDataSources(Arrays.asList(workspaceDataSources));
            return this;
        }

        public final String getWorkspaceDescription() {
            return this.workspaceDescription;
        }

        public final void setWorkspaceDescription(String workspaceDescription) {
            this.workspaceDescription = workspaceDescription;
        }

        @Override
        public final Builder workspaceDescription(String workspaceDescription) {
            this.workspaceDescription = workspaceDescription;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getWorkspaceName() {
            return this.workspaceName;
        }

        public final void setWorkspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
        }

        @Override
        public final Builder workspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
            return this;
        }

        public final Collection<String> getWorkspaceNotificationDestinations() {
            if (this.workspaceNotificationDestinations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.workspaceNotificationDestinations;
        }

        public final void setWorkspaceNotificationDestinations(Collection<String> workspaceNotificationDestinations) {
            this.workspaceNotificationDestinations = NotificationDestinationsListCopier.copy(workspaceNotificationDestinations);
        }

        @Override
        public final Builder workspaceNotificationDestinationsWithStrings(Collection<String> workspaceNotificationDestinations) {
            this.workspaceNotificationDestinations = NotificationDestinationsListCopier.copy(workspaceNotificationDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceNotificationDestinationsWithStrings(String ... workspaceNotificationDestinations) {
            this.workspaceNotificationDestinationsWithStrings(Arrays.asList(workspaceNotificationDestinations));
            return this;
        }

        @Override
        public final Builder workspaceNotificationDestinations(Collection<NotificationDestinationType> workspaceNotificationDestinations) {
            this.workspaceNotificationDestinations = NotificationDestinationsListCopier.copyEnumToString(workspaceNotificationDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceNotificationDestinations(NotificationDestinationType ... workspaceNotificationDestinations) {
            this.workspaceNotificationDestinations(Arrays.asList(workspaceNotificationDestinations));
            return this;
        }

        public final Collection<String> getWorkspaceOrganizationalUnits() {
            if (this.workspaceOrganizationalUnits instanceof SdkAutoConstructList) {
                return null;
            }
            return this.workspaceOrganizationalUnits;
        }

        public final void setWorkspaceOrganizationalUnits(Collection<String> workspaceOrganizationalUnits) {
            this.workspaceOrganizationalUnits = OrganizationalUnitListCopier.copy(workspaceOrganizationalUnits);
        }

        @Override
        public final Builder workspaceOrganizationalUnits(Collection<String> workspaceOrganizationalUnits) {
            this.workspaceOrganizationalUnits = OrganizationalUnitListCopier.copy(workspaceOrganizationalUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaceOrganizationalUnits(String ... workspaceOrganizationalUnits) {
            this.workspaceOrganizationalUnits(Arrays.asList(workspaceOrganizationalUnits));
            return this;
        }

        public final String getWorkspaceRoleArn() {
            return this.workspaceRoleArn;
        }

        public final void setWorkspaceRoleArn(String workspaceRoleArn) {
            this.workspaceRoleArn = workspaceRoleArn;
        }

        @Override
        public final Builder workspaceRoleArn(String workspaceRoleArn) {
            this.workspaceRoleArn = workspaceRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspaceRequest build() {
            return new UpdateWorkspaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GrafanaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkspaceRequest> {
        public Builder accountAccessType(String var1);

        public Builder accountAccessType(AccountAccessType var1);

        public Builder organizationRoleName(String var1);

        public Builder permissionType(String var1);

        public Builder permissionType(PermissionType var1);

        public Builder stackSetName(String var1);

        public Builder workspaceDataSourcesWithStrings(Collection<String> var1);

        public Builder workspaceDataSourcesWithStrings(String ... var1);

        public Builder workspaceDataSources(Collection<DataSourceType> var1);

        public Builder workspaceDataSources(DataSourceType ... var1);

        public Builder workspaceDescription(String var1);

        public Builder workspaceId(String var1);

        public Builder workspaceName(String var1);

        public Builder workspaceNotificationDestinationsWithStrings(Collection<String> var1);

        public Builder workspaceNotificationDestinationsWithStrings(String ... var1);

        public Builder workspaceNotificationDestinations(Collection<NotificationDestinationType> var1);

        public Builder workspaceNotificationDestinations(NotificationDestinationType ... var1);

        public Builder workspaceOrganizationalUnits(Collection<String> var1);

        public Builder workspaceOrganizationalUnits(String ... var1);

        public Builder workspaceRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

