/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateClientDeviceWithCoreDeviceResponse extends GreengrassV2Response
        implements
        ToCopyableBuilder<BatchAssociateClientDeviceWithCoreDeviceResponse.Builder, BatchAssociateClientDeviceWithCoreDeviceResponse> {
    private static final SdkField<List<AssociateClientDeviceWithCoreDeviceErrorEntry>> ERROR_ENTRIES_FIELD = SdkField
            .<List<AssociateClientDeviceWithCoreDeviceErrorEntry>> builder(MarshallingType.LIST)
            .memberName("errorEntries")
            .getter(getter(BatchAssociateClientDeviceWithCoreDeviceResponse::errorEntries))
            .setter(setter(Builder::errorEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociateClientDeviceWithCoreDeviceErrorEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociateClientDeviceWithCoreDeviceErrorEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_ENTRIES_FIELD));

    private final List<AssociateClientDeviceWithCoreDeviceErrorEntry> errorEntries;

    private BatchAssociateClientDeviceWithCoreDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.errorEntries = builder.errorEntries;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorEntries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasErrorEntries() {
        return errorEntries != null && !(errorEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of any errors for the entries in the request. Each error entry contains the name of the IoT thing that
     * failed to associate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorEntries} method.
     * </p>
     * 
     * @return The list of any errors for the entries in the request. Each error entry contains the name of the IoT
     *         thing that failed to associate.
     */
    public final List<AssociateClientDeviceWithCoreDeviceErrorEntry> errorEntries() {
        return errorEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorEntries() ? errorEntries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateClientDeviceWithCoreDeviceResponse)) {
            return false;
        }
        BatchAssociateClientDeviceWithCoreDeviceResponse other = (BatchAssociateClientDeviceWithCoreDeviceResponse) obj;
        return hasErrorEntries() == other.hasErrorEntries() && Objects.equals(errorEntries(), other.errorEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAssociateClientDeviceWithCoreDeviceResponse")
                .add("ErrorEntries", hasErrorEntries() ? errorEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorEntries":
            return Optional.ofNullable(clazz.cast(errorEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateClientDeviceWithCoreDeviceResponse, T> g) {
        return obj -> g.apply((BatchAssociateClientDeviceWithCoreDeviceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchAssociateClientDeviceWithCoreDeviceResponse> {
        /**
         * <p>
         * The list of any errors for the entries in the request. Each error entry contains the name of the IoT thing
         * that failed to associate.
         * </p>
         * 
         * @param errorEntries
         *        The list of any errors for the entries in the request. Each error entry contains the name of the IoT
         *        thing that failed to associate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorEntries(Collection<AssociateClientDeviceWithCoreDeviceErrorEntry> errorEntries);

        /**
         * <p>
         * The list of any errors for the entries in the request. Each error entry contains the name of the IoT thing
         * that failed to associate.
         * </p>
         * 
         * @param errorEntries
         *        The list of any errors for the entries in the request. Each error entry contains the name of the IoT
         *        thing that failed to associate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorEntries(AssociateClientDeviceWithCoreDeviceErrorEntry... errorEntries);

        /**
         * <p>
         * The list of any errors for the entries in the request. Each error entry contains the name of the IoT thing
         * that failed to associate.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.greengrassv2.model.AssociateClientDeviceWithCoreDeviceErrorEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.greengrassv2.model.AssociateClientDeviceWithCoreDeviceErrorEntry#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.greengrassv2.model.AssociateClientDeviceWithCoreDeviceErrorEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #errorEntries(List<AssociateClientDeviceWithCoreDeviceErrorEntry>)}.
         * 
         * @param errorEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.greengrassv2.model.AssociateClientDeviceWithCoreDeviceErrorEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorEntries(java.util.Collection<AssociateClientDeviceWithCoreDeviceErrorEntry>)
         */
        Builder errorEntries(Consumer<AssociateClientDeviceWithCoreDeviceErrorEntry.Builder>... errorEntries);
    }

    static final class BuilderImpl extends GreengrassV2Response.BuilderImpl implements Builder {
        private List<AssociateClientDeviceWithCoreDeviceErrorEntry> errorEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateClientDeviceWithCoreDeviceResponse model) {
            super(model);
            errorEntries(model.errorEntries);
        }

        public final List<AssociateClientDeviceWithCoreDeviceErrorEntry.Builder> getErrorEntries() {
            List<AssociateClientDeviceWithCoreDeviceErrorEntry.Builder> result = AssociateClientDeviceWithCoreDeviceErrorListCopier
                    .copyToBuilder(this.errorEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorEntries(Collection<AssociateClientDeviceWithCoreDeviceErrorEntry.BuilderImpl> errorEntries) {
            this.errorEntries = AssociateClientDeviceWithCoreDeviceErrorListCopier.copyFromBuilder(errorEntries);
        }

        @Override
        public final Builder errorEntries(Collection<AssociateClientDeviceWithCoreDeviceErrorEntry> errorEntries) {
            this.errorEntries = AssociateClientDeviceWithCoreDeviceErrorListCopier.copy(errorEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(AssociateClientDeviceWithCoreDeviceErrorEntry... errorEntries) {
            errorEntries(Arrays.asList(errorEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(Consumer<AssociateClientDeviceWithCoreDeviceErrorEntry.Builder>... errorEntries) {
            errorEntries(Stream.of(errorEntries)
                    .map(c -> AssociateClientDeviceWithCoreDeviceErrorEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchAssociateClientDeviceWithCoreDeviceResponse build() {
            return new BatchAssociateClientDeviceWithCoreDeviceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
