/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.greengrassv2.model.AssociateServiceRoleToAccountRequest;
import software.amazon.awssdk.services.greengrassv2.model.AssociateServiceRoleToAccountResponse;
import software.amazon.awssdk.services.greengrassv2.model.BatchAssociateClientDeviceWithCoreDeviceRequest;
import software.amazon.awssdk.services.greengrassv2.model.BatchAssociateClientDeviceWithCoreDeviceResponse;
import software.amazon.awssdk.services.greengrassv2.model.BatchDisassociateClientDeviceFromCoreDeviceRequest;
import software.amazon.awssdk.services.greengrassv2.model.BatchDisassociateClientDeviceFromCoreDeviceResponse;
import software.amazon.awssdk.services.greengrassv2.model.CancelDeploymentRequest;
import software.amazon.awssdk.services.greengrassv2.model.CancelDeploymentResponse;
import software.amazon.awssdk.services.greengrassv2.model.CreateComponentVersionRequest;
import software.amazon.awssdk.services.greengrassv2.model.CreateComponentVersionResponse;
import software.amazon.awssdk.services.greengrassv2.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.greengrassv2.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.greengrassv2.model.DeleteComponentRequest;
import software.amazon.awssdk.services.greengrassv2.model.DeleteComponentResponse;
import software.amazon.awssdk.services.greengrassv2.model.DeleteCoreDeviceRequest;
import software.amazon.awssdk.services.greengrassv2.model.DeleteCoreDeviceResponse;
import software.amazon.awssdk.services.greengrassv2.model.DeleteDeploymentRequest;
import software.amazon.awssdk.services.greengrassv2.model.DeleteDeploymentResponse;
import software.amazon.awssdk.services.greengrassv2.model.DescribeComponentRequest;
import software.amazon.awssdk.services.greengrassv2.model.DescribeComponentResponse;
import software.amazon.awssdk.services.greengrassv2.model.DisassociateServiceRoleFromAccountRequest;
import software.amazon.awssdk.services.greengrassv2.model.DisassociateServiceRoleFromAccountResponse;
import software.amazon.awssdk.services.greengrassv2.model.GetComponentRequest;
import software.amazon.awssdk.services.greengrassv2.model.GetComponentResponse;
import software.amazon.awssdk.services.greengrassv2.model.GetComponentVersionArtifactRequest;
import software.amazon.awssdk.services.greengrassv2.model.GetComponentVersionArtifactResponse;
import software.amazon.awssdk.services.greengrassv2.model.GetConnectivityInfoRequest;
import software.amazon.awssdk.services.greengrassv2.model.GetConnectivityInfoResponse;
import software.amazon.awssdk.services.greengrassv2.model.GetCoreDeviceRequest;
import software.amazon.awssdk.services.greengrassv2.model.GetCoreDeviceResponse;
import software.amazon.awssdk.services.greengrassv2.model.GetDeploymentRequest;
import software.amazon.awssdk.services.greengrassv2.model.GetDeploymentResponse;
import software.amazon.awssdk.services.greengrassv2.model.GetServiceRoleForAccountRequest;
import software.amazon.awssdk.services.greengrassv2.model.GetServiceRoleForAccountResponse;
import software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceResponse;
import software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsResponse;
import software.amazon.awssdk.services.greengrassv2.model.ListComponentsRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListComponentsResponse;
import software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesResponse;
import software.amazon.awssdk.services.greengrassv2.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsResponse;
import software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsResponse;
import software.amazon.awssdk.services.greengrassv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.greengrassv2.model.ResolveComponentCandidatesRequest;
import software.amazon.awssdk.services.greengrassv2.model.ResolveComponentCandidatesResponse;
import software.amazon.awssdk.services.greengrassv2.model.TagResourceRequest;
import software.amazon.awssdk.services.greengrassv2.model.TagResourceResponse;
import software.amazon.awssdk.services.greengrassv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.greengrassv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.greengrassv2.model.UpdateConnectivityInfoRequest;
import software.amazon.awssdk.services.greengrassv2.model.UpdateConnectivityInfoResponse;
import software.amazon.awssdk.services.greengrassv2.paginators.ListClientDevicesAssociatedWithCoreDevicePublisher;
import software.amazon.awssdk.services.greengrassv2.paginators.ListComponentVersionsPublisher;
import software.amazon.awssdk.services.greengrassv2.paginators.ListComponentsPublisher;
import software.amazon.awssdk.services.greengrassv2.paginators.ListCoreDevicesPublisher;
import software.amazon.awssdk.services.greengrassv2.paginators.ListDeploymentsPublisher;
import software.amazon.awssdk.services.greengrassv2.paginators.ListEffectiveDeploymentsPublisher;
import software.amazon.awssdk.services.greengrassv2.paginators.ListInstalledComponentsPublisher;

/**
 * Service client for accessing AWS GreengrassV2 asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * IoT Greengrass brings local compute, messaging, data management, sync, and ML inference capabilities to edge devices.
 * This enables devices to collect and analyze data closer to the source of information, react autonomously to local
 * events, and communicate securely with each other on local networks. Local devices can also communicate securely with
 * Amazon Web Services IoT Core and export IoT data to the Amazon Web Services Cloud. IoT Greengrass developers can use
 * Lambda functions and components to create and deploy applications to fleets of edge devices for local operation.
 * </p>
 * <p>
 * IoT Greengrass Version 2 provides a new major version of the IoT Greengrass Core software, new APIs, and a new
 * console. Use this API reference to learn how to use the IoT Greengrass V2 API operations to manage components, manage
 * deployments, and core devices.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/what-is-iot-greengrass.html">What is IoT
 * Greengrass?</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GreengrassV2AsyncClient extends AwsClient {
    String SERVICE_NAME = "greengrass";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "greengrass";

    /**
     * <p>
     * Associates a Greengrass service role with IoT Greengrass for your Amazon Web Services account in this Amazon Web
     * Services Region. IoT Greengrass uses this role to verify the identity of client devices and manage core device
     * connectivity information. The role must include the <a href=
     * "https://console.aws.amazon.com/iam/home#/policies/arn:awsiam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy"
     * >AWSGreengrassResourceAccessRolePolicy</a> managed policy or a custom policy that defines equivalent permissions
     * for the IoT Greengrass features that you use. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html">Greengrass service
     * role</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.
     * </p>
     *
     * @param associateServiceRoleToAccountRequest
     * @return A Java Future containing the result of the AssociateServiceRoleToAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.AssociateServiceRoleToAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/AssociateServiceRoleToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateServiceRoleToAccountResponse> associateServiceRoleToAccount(
            AssociateServiceRoleToAccountRequest associateServiceRoleToAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a Greengrass service role with IoT Greengrass for your Amazon Web Services account in this Amazon Web
     * Services Region. IoT Greengrass uses this role to verify the identity of client devices and manage core device
     * connectivity information. The role must include the <a href=
     * "https://console.aws.amazon.com/iam/home#/policies/arn:awsiam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy"
     * >AWSGreengrassResourceAccessRolePolicy</a> managed policy or a custom policy that defines equivalent permissions
     * for the IoT Greengrass features that you use. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html">Greengrass service
     * role</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateServiceRoleToAccountRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateServiceRoleToAccountRequest#builder()}
     * </p>
     *
     * @param associateServiceRoleToAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.AssociateServiceRoleToAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateServiceRoleToAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.AssociateServiceRoleToAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/AssociateServiceRoleToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateServiceRoleToAccountResponse> associateServiceRoleToAccount(
            Consumer<AssociateServiceRoleToAccountRequest.Builder> associateServiceRoleToAccountRequest) {
        return associateServiceRoleToAccount(AssociateServiceRoleToAccountRequest.builder()
                .applyMutation(associateServiceRoleToAccountRequest).build());
    }

    /**
     * <p>
     * Associates a list of client devices with a core device. Use this API operation to specify which client devices
     * can discover a core device through cloud discovery. With cloud discovery, client devices connect to IoT
     * Greengrass to retrieve associated core devices' connectivity information and certificates. For more information,
     * see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-cloud-discovery.html">Configure
     * cloud discovery</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * Client devices are local IoT devices that connect to and communicate with an IoT Greengrass core device over
     * MQTT. You can connect client devices to a core device to sync MQTT messages and data to Amazon Web Services IoT
     * Core and interact with client devices in Greengrass components. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interact-with-local-iot-devices.html">Interact
     * with local IoT devices</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * </note>
     *
     * @param batchAssociateClientDeviceWithCoreDeviceRequest
     * @return A Java Future containing the result of the BatchAssociateClientDeviceWithCoreDevice operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.BatchAssociateClientDeviceWithCoreDevice
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/BatchAssociateClientDeviceWithCoreDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateClientDeviceWithCoreDeviceResponse> batchAssociateClientDeviceWithCoreDevice(
            BatchAssociateClientDeviceWithCoreDeviceRequest batchAssociateClientDeviceWithCoreDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a list of client devices with a core device. Use this API operation to specify which client devices
     * can discover a core device through cloud discovery. With cloud discovery, client devices connect to IoT
     * Greengrass to retrieve associated core devices' connectivity information and certificates. For more information,
     * see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-cloud-discovery.html">Configure
     * cloud discovery</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * Client devices are local IoT devices that connect to and communicate with an IoT Greengrass core device over
     * MQTT. You can connect client devices to a core device to sync MQTT messages and data to Amazon Web Services IoT
     * Core and interact with client devices in Greengrass components. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interact-with-local-iot-devices.html">Interact
     * with local IoT devices</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchAssociateClientDeviceWithCoreDeviceRequest.Builder} avoiding the need to create one manually via
     * {@link BatchAssociateClientDeviceWithCoreDeviceRequest#builder()}
     * </p>
     *
     * @param batchAssociateClientDeviceWithCoreDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.BatchAssociateClientDeviceWithCoreDeviceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchAssociateClientDeviceWithCoreDevice operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.BatchAssociateClientDeviceWithCoreDevice
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/BatchAssociateClientDeviceWithCoreDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateClientDeviceWithCoreDeviceResponse> batchAssociateClientDeviceWithCoreDevice(
            Consumer<BatchAssociateClientDeviceWithCoreDeviceRequest.Builder> batchAssociateClientDeviceWithCoreDeviceRequest) {
        return batchAssociateClientDeviceWithCoreDevice(BatchAssociateClientDeviceWithCoreDeviceRequest.builder()
                .applyMutation(batchAssociateClientDeviceWithCoreDeviceRequest).build());
    }

    /**
     * <p>
     * Disassociates a list of client devices from a core device. After you disassociate a client device from a core
     * device, the client device won't be able to use cloud discovery to retrieve the core device's connectivity
     * information and certificates.
     * </p>
     *
     * @param batchDisassociateClientDeviceFromCoreDeviceRequest
     * @return A Java Future containing the result of the BatchDisassociateClientDeviceFromCoreDevice operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.BatchDisassociateClientDeviceFromCoreDevice
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/BatchDisassociateClientDeviceFromCoreDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateClientDeviceFromCoreDeviceResponse> batchDisassociateClientDeviceFromCoreDevice(
            BatchDisassociateClientDeviceFromCoreDeviceRequest batchDisassociateClientDeviceFromCoreDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a list of client devices from a core device. After you disassociate a client device from a core
     * device, the client device won't be able to use cloud discovery to retrieve the core device's connectivity
     * information and certificates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchDisassociateClientDeviceFromCoreDeviceRequest.Builder} avoiding the need to create one manually via
     * {@link BatchDisassociateClientDeviceFromCoreDeviceRequest#builder()}
     * </p>
     *
     * @param batchDisassociateClientDeviceFromCoreDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.BatchDisassociateClientDeviceFromCoreDeviceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchDisassociateClientDeviceFromCoreDevice operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.BatchDisassociateClientDeviceFromCoreDevice
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/BatchDisassociateClientDeviceFromCoreDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateClientDeviceFromCoreDeviceResponse> batchDisassociateClientDeviceFromCoreDevice(
            Consumer<BatchDisassociateClientDeviceFromCoreDeviceRequest.Builder> batchDisassociateClientDeviceFromCoreDeviceRequest) {
        return batchDisassociateClientDeviceFromCoreDevice(BatchDisassociateClientDeviceFromCoreDeviceRequest.builder()
                .applyMutation(batchDisassociateClientDeviceFromCoreDeviceRequest).build());
    }

    /**
     * <p>
     * Cancels a deployment. This operation cancels the deployment for devices that haven't yet received it. If a device
     * already received the deployment, this operation doesn't change anything for that device.
     * </p>
     *
     * @param cancelDeploymentRequest
     * @return A Java Future containing the result of the CancelDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.CancelDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/CancelDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelDeploymentResponse> cancelDeployment(CancelDeploymentRequest cancelDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a deployment. This operation cancels the deployment for devices that haven't yet received it. If a device
     * already received the deployment, this operation doesn't change anything for that device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link CancelDeploymentRequest#builder()}
     * </p>
     *
     * @param cancelDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.CancelDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.CancelDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/CancelDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelDeploymentResponse> cancelDeployment(
            Consumer<CancelDeploymentRequest.Builder> cancelDeploymentRequest) {
        return cancelDeployment(CancelDeploymentRequest.builder().applyMutation(cancelDeploymentRequest).build());
    }

    /**
     * <p>
     * Creates a component. Components are software that run on Greengrass core devices. After you develop and test a
     * component on your core device, you can use this operation to upload your component to IoT Greengrass. Then, you
     * can deploy the component to other core devices.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Create components from recipes</b>
     * </p>
     * <p>
     * Create a component from a recipe, which is a file that defines the component's metadata, parameters,
     * dependencies, lifecycle, artifacts, and platform capability. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/component-recipe-reference.html">IoT Greengrass
     * component recipe reference</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * <p>
     * To create a component from a recipe, specify <code>inlineRecipe</code> when you call this operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Create components from Lambda functions</b>
     * </p>
     * <p>
     * Create a component from an Lambda function that runs on IoT Greengrass. This creates a recipe and artifacts from
     * the Lambda function's deployment package. You can use this operation to migrate Lambda functions from IoT
     * Greengrass V1 to IoT Greengrass V2.
     * </p>
     * <p>
     * This function only accepts Lambda functions that use the following runtimes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Python 2.7 – <code>python2.7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Python 3.7 – <code>python3.7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Python 3.8 – <code>python3.8</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Python 3.9 – <code>python3.9</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Java 8 – <code>java8</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Java 11 – <code>java11</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Node.js 10 – <code>nodejs10.x</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Node.js 12 – <code>nodejs12.x</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Node.js 14 – <code>nodejs14.x</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To create a component from a Lambda function, specify <code>lambdaFunction</code> when you call this operation.
     * </p>
     * <note>
     * <p>
     * IoT Greengrass currently supports Lambda functions on only Linux core devices.
     * </p>
     * </note></li>
     * </ul>
     *
     * @param createComponentVersionRequest
     * @return A Java Future containing the result of the CreateComponentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota. For example, you might have the
     *         maximum number of components that you can create.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>RequestAlreadyInProgressException The request is already in progress. This exception occurs when you
     *         use a client token for multiple requests while IoT Greengrass is still processing an earlier request that
     *         uses the same client token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.CreateComponentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/CreateComponentVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateComponentVersionResponse> createComponentVersion(
            CreateComponentVersionRequest createComponentVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a component. Components are software that run on Greengrass core devices. After you develop and test a
     * component on your core device, you can use this operation to upload your component to IoT Greengrass. Then, you
     * can deploy the component to other core devices.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Create components from recipes</b>
     * </p>
     * <p>
     * Create a component from a recipe, which is a file that defines the component's metadata, parameters,
     * dependencies, lifecycle, artifacts, and platform capability. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/component-recipe-reference.html">IoT Greengrass
     * component recipe reference</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * <p>
     * To create a component from a recipe, specify <code>inlineRecipe</code> when you call this operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Create components from Lambda functions</b>
     * </p>
     * <p>
     * Create a component from an Lambda function that runs on IoT Greengrass. This creates a recipe and artifacts from
     * the Lambda function's deployment package. You can use this operation to migrate Lambda functions from IoT
     * Greengrass V1 to IoT Greengrass V2.
     * </p>
     * <p>
     * This function only accepts Lambda functions that use the following runtimes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Python 2.7 – <code>python2.7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Python 3.7 – <code>python3.7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Python 3.8 – <code>python3.8</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Python 3.9 – <code>python3.9</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Java 8 – <code>java8</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Java 11 – <code>java11</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Node.js 10 – <code>nodejs10.x</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Node.js 12 – <code>nodejs12.x</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Node.js 14 – <code>nodejs14.x</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To create a component from a Lambda function, specify <code>lambdaFunction</code> when you call this operation.
     * </p>
     * <note>
     * <p>
     * IoT Greengrass currently supports Lambda functions on only Linux core devices.
     * </p>
     * </note></li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateComponentVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateComponentVersionRequest#builder()}
     * </p>
     *
     * @param createComponentVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.CreateComponentVersionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateComponentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota. For example, you might have the
     *         maximum number of components that you can create.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>RequestAlreadyInProgressException The request is already in progress. This exception occurs when you
     *         use a client token for multiple requests while IoT Greengrass is still processing an earlier request that
     *         uses the same client token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.CreateComponentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/CreateComponentVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateComponentVersionResponse> createComponentVersion(
            Consumer<CreateComponentVersionRequest.Builder> createComponentVersionRequest) {
        return createComponentVersion(CreateComponentVersionRequest.builder().applyMutation(createComponentVersionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a continuous deployment for a target, which is a Greengrass core device or group of core devices. When
     * you add a new core device to a group of core devices that has a deployment, IoT Greengrass deploys that group's
     * deployment to the new device.
     * </p>
     * <p>
     * You can define one deployment for each target. When you create a new deployment for a target that has an existing
     * deployment, you replace the previous deployment. IoT Greengrass applies the new deployment to the target devices.
     * </p>
     * <p>
     * Every deployment has a revision number that indicates how many deployment revisions you define for a target. Use
     * this operation to create a new revision of an existing deployment.
     * </p>
     * <p>
     * For more information, see the <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments</a> in
     * the <i>IoT Greengrass V2 Developer Guide</i>.
     * </p>
     *
     * @param createDeploymentRequest
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>RequestAlreadyInProgressException The request is already in progress. This exception occurs when you
     *         use a client token for multiple requests while IoT Greengrass is still processing an earlier request that
     *         uses the same client token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a continuous deployment for a target, which is a Greengrass core device or group of core devices. When
     * you add a new core device to a group of core devices that has a deployment, IoT Greengrass deploys that group's
     * deployment to the new device.
     * </p>
     * <p>
     * You can define one deployment for each target. When you create a new deployment for a target that has an existing
     * deployment, you replace the previous deployment. IoT Greengrass applies the new deployment to the target devices.
     * </p>
     * <p>
     * Every deployment has a revision number that indicates how many deployment revisions you define for a target. Use
     * this operation to create a new revision of an existing deployment.
     * </p>
     * <p>
     * For more information, see the <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments</a> in
     * the <i>IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDeploymentRequest#builder()}
     * </p>
     *
     * @param createDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.CreateDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>RequestAlreadyInProgressException The request is already in progress. This exception occurs when you
     *         use a client token for multiple requests while IoT Greengrass is still processing an earlier request that
     *         uses the same client token.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDeploymentResponse> createDeployment(
            Consumer<CreateDeploymentRequest.Builder> createDeploymentRequest) {
        return createDeployment(CreateDeploymentRequest.builder().applyMutation(createDeploymentRequest).build());
    }

    /**
     * <p>
     * Deletes a version of a component from IoT Greengrass.
     * </p>
     * <note>
     * <p>
     * This operation deletes the component's recipe and artifacts. As a result, deployments that refer to this
     * component version will fail. If you have deployments that use this component version, you can remove the
     * component from the deployment or update the deployment to use a valid version.
     * </p>
     * </note>
     *
     * @param deleteComponentRequest
     * @return A Java Future containing the result of the DeleteComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DeleteComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteComponentResponse> deleteComponent(DeleteComponentRequest deleteComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a version of a component from IoT Greengrass.
     * </p>
     * <note>
     * <p>
     * This operation deletes the component's recipe and artifacts. As a result, deployments that refer to this
     * component version will fail. If you have deployments that use this component version, you can remove the
     * component from the deployment or update the deployment to use a valid version.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteComponentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteComponentRequest#builder()}
     * </p>
     *
     * @param deleteComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.DeleteComponentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DeleteComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteComponentResponse> deleteComponent(
            Consumer<DeleteComponentRequest.Builder> deleteComponentRequest) {
        return deleteComponent(DeleteComponentRequest.builder().applyMutation(deleteComponentRequest).build());
    }

    /**
     * <p>
     * Deletes a Greengrass core device, which is an IoT thing. This operation removes the core device from the list of
     * core devices. This operation doesn't delete the IoT thing. For more information about how to delete the IoT
     * thing, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteThing.html">DeleteThing</a> in
     * the <i>IoT API Reference</i>.
     * </p>
     *
     * @param deleteCoreDeviceRequest
     * @return A Java Future containing the result of the DeleteCoreDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.DeleteCoreDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DeleteCoreDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCoreDeviceResponse> deleteCoreDevice(DeleteCoreDeviceRequest deleteCoreDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Greengrass core device, which is an IoT thing. This operation removes the core device from the list of
     * core devices. This operation doesn't delete the IoT thing. For more information about how to delete the IoT
     * thing, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteThing.html">DeleteThing</a> in
     * the <i>IoT API Reference</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCoreDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCoreDeviceRequest#builder()}
     * </p>
     *
     * @param deleteCoreDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.DeleteCoreDeviceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCoreDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.DeleteCoreDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DeleteCoreDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCoreDeviceResponse> deleteCoreDevice(
            Consumer<DeleteCoreDeviceRequest.Builder> deleteCoreDeviceRequest) {
        return deleteCoreDevice(DeleteCoreDeviceRequest.builder().applyMutation(deleteCoreDeviceRequest).build());
    }

    /**
     * <p>
     * Deletes a deployment. To delete an active deployment, you must first cancel it. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/apireference/API_CancelDeployment.html">CancelDeployment</a>.
     * </p>
     * <p>
     * Deleting a deployment doesn't affect core devices that run that deployment, because core devices store the
     * deployment's configuration on the device. Additionally, core devices can roll back to a previous deployment that
     * has been deleted.
     * </p>
     *
     * @param deleteDeploymentRequest
     * @return A Java Future containing the result of the DeleteDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.DeleteDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DeleteDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDeploymentResponse> deleteDeployment(DeleteDeploymentRequest deleteDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a deployment. To delete an active deployment, you must first cancel it. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/apireference/API_CancelDeployment.html">CancelDeployment</a>.
     * </p>
     * <p>
     * Deleting a deployment doesn't affect core devices that run that deployment, because core devices store the
     * deployment's configuration on the device. Additionally, core devices can roll back to a previous deployment that
     * has been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDeploymentRequest#builder()}
     * </p>
     *
     * @param deleteDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.DeleteDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.DeleteDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DeleteDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDeploymentResponse> deleteDeployment(
            Consumer<DeleteDeploymentRequest.Builder> deleteDeploymentRequest) {
        return deleteDeployment(DeleteDeploymentRequest.builder().applyMutation(deleteDeploymentRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata for a version of a component.
     * </p>
     *
     * @param describeComponentRequest
     * @return A Java Future containing the result of the DescribeComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.DescribeComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DescribeComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComponentResponse> describeComponent(DescribeComponentRequest describeComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata for a version of a component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComponentRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeComponentRequest#builder()}
     * </p>
     *
     * @param describeComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.DescribeComponentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.DescribeComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DescribeComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComponentResponse> describeComponent(
            Consumer<DescribeComponentRequest.Builder> describeComponentRequest) {
        return describeComponent(DescribeComponentRequest.builder().applyMutation(describeComponentRequest).build());
    }

    /**
     * <p>
     * Disassociates the Greengrass service role from IoT Greengrass for your Amazon Web Services account in this Amazon
     * Web Services Region. Without a service role, IoT Greengrass can't verify the identity of client devices or manage
     * core device connectivity information. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html">Greengrass service
     * role</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.
     * </p>
     *
     * @param disassociateServiceRoleFromAccountRequest
     * @return A Java Future containing the result of the DisassociateServiceRoleFromAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.DisassociateServiceRoleFromAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DisassociateServiceRoleFromAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateServiceRoleFromAccountResponse> disassociateServiceRoleFromAccount(
            DisassociateServiceRoleFromAccountRequest disassociateServiceRoleFromAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the Greengrass service role from IoT Greengrass for your Amazon Web Services account in this Amazon
     * Web Services Region. Without a service role, IoT Greengrass can't verify the identity of client devices or manage
     * core device connectivity information. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html">Greengrass service
     * role</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateServiceRoleFromAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateServiceRoleFromAccountRequest#builder()}
     * </p>
     *
     * @param disassociateServiceRoleFromAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.DisassociateServiceRoleFromAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateServiceRoleFromAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.DisassociateServiceRoleFromAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/DisassociateServiceRoleFromAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateServiceRoleFromAccountResponse> disassociateServiceRoleFromAccount(
            Consumer<DisassociateServiceRoleFromAccountRequest.Builder> disassociateServiceRoleFromAccountRequest) {
        return disassociateServiceRoleFromAccount(DisassociateServiceRoleFromAccountRequest.builder()
                .applyMutation(disassociateServiceRoleFromAccountRequest).build());
    }

    /**
     * <p>
     * Gets the recipe for a version of a component.
     * </p>
     *
     * @param getComponentRequest
     * @return A Java Future containing the result of the GetComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetComponentResponse> getComponent(GetComponentRequest getComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the recipe for a version of a component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComponentRequest.Builder} avoiding the need to
     * create one manually via {@link GetComponentRequest#builder()}
     * </p>
     *
     * @param getComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.GetComponentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetComponent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetComponentResponse> getComponent(Consumer<GetComponentRequest.Builder> getComponentRequest) {
        return getComponent(GetComponentRequest.builder().applyMutation(getComponentRequest).build());
    }

    /**
     * <p>
     * Gets the pre-signed URL to download a public or a Lambda component artifact. Core devices call this operation to
     * identify the URL that they can use to download an artifact to install.
     * </p>
     *
     * @param getComponentVersionArtifactRequest
     * @return A Java Future containing the result of the GetComponentVersionArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.GetComponentVersionArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetComponentVersionArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComponentVersionArtifactResponse> getComponentVersionArtifact(
            GetComponentVersionArtifactRequest getComponentVersionArtifactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the pre-signed URL to download a public or a Lambda component artifact. Core devices call this operation to
     * identify the URL that they can use to download an artifact to install.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComponentVersionArtifactRequest.Builder}
     * avoiding the need to create one manually via {@link GetComponentVersionArtifactRequest#builder()}
     * </p>
     *
     * @param getComponentVersionArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.GetComponentVersionArtifactRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetComponentVersionArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.GetComponentVersionArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetComponentVersionArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetComponentVersionArtifactResponse> getComponentVersionArtifact(
            Consumer<GetComponentVersionArtifactRequest.Builder> getComponentVersionArtifactRequest) {
        return getComponentVersionArtifact(GetComponentVersionArtifactRequest.builder()
                .applyMutation(getComponentVersionArtifactRequest).build());
    }

    /**
     * <p>
     * Retrieves connectivity information for a Greengrass core device.
     * </p>
     * <p>
     * Connectivity information includes endpoints and ports where client devices can connect to an MQTT broker on the
     * core device. When a client device calls the <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-discover-api.html">IoT Greengrass
     * discovery API</a>, IoT Greengrass returns connectivity information for all of the core devices where the client
     * device can connect. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/connect-client-devices.html">Connect client
     * devices to core devices</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.
     * </p>
     *
     * @param getConnectivityInfoRequest
     * @return A Java Future containing the result of the GetConnectivityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.GetConnectivityInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetConnectivityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectivityInfoResponse> getConnectivityInfo(
            GetConnectivityInfoRequest getConnectivityInfoRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves connectivity information for a Greengrass core device.
     * </p>
     * <p>
     * Connectivity information includes endpoints and ports where client devices can connect to an MQTT broker on the
     * core device. When a client device calls the <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-discover-api.html">IoT Greengrass
     * discovery API</a>, IoT Greengrass returns connectivity information for all of the core devices where the client
     * device can connect. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/connect-client-devices.html">Connect client
     * devices to core devices</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectivityInfoRequest.Builder} avoiding the
     * need to create one manually via {@link GetConnectivityInfoRequest#builder()}
     * </p>
     *
     * @param getConnectivityInfoRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.GetConnectivityInfoRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetConnectivityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.GetConnectivityInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetConnectivityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConnectivityInfoResponse> getConnectivityInfo(
            Consumer<GetConnectivityInfoRequest.Builder> getConnectivityInfoRequest) {
        return getConnectivityInfo(GetConnectivityInfoRequest.builder().applyMutation(getConnectivityInfoRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata for a Greengrass core device.
     * </p>
     * <note>
     * <p>
     * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT
     * Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services
     * Cloud, then the reported status of that device might not reflect its current status. The status timestamp
     * indicates when the device status was last updated.
     * </p>
     * <p>
     * Core devices send status updates at the following times:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When the IoT Greengrass Core software starts
     * </p>
     * </li>
     * <li>
     * <p>
     * When the core device receives a deployment from the Amazon Web Services Cloud
     * </p>
     * </li>
     * <li>
     * <p>
     * When the status of any component on the core device becomes <code>BROKEN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * At a <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss"
     * >regular interval that you can configure</a>, which defaults to 24 hours
     * </p>
     * </li>
     * <li>
     * <p>
     * For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param getCoreDeviceRequest
     * @return A Java Future containing the result of the GetCoreDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.GetCoreDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetCoreDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCoreDeviceResponse> getCoreDevice(GetCoreDeviceRequest getCoreDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata for a Greengrass core device.
     * </p>
     * <note>
     * <p>
     * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT
     * Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services
     * Cloud, then the reported status of that device might not reflect its current status. The status timestamp
     * indicates when the device status was last updated.
     * </p>
     * <p>
     * Core devices send status updates at the following times:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When the IoT Greengrass Core software starts
     * </p>
     * </li>
     * <li>
     * <p>
     * When the core device receives a deployment from the Amazon Web Services Cloud
     * </p>
     * </li>
     * <li>
     * <p>
     * When the status of any component on the core device becomes <code>BROKEN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * At a <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss"
     * >regular interval that you can configure</a>, which defaults to 24 hours
     * </p>
     * </li>
     * <li>
     * <p>
     * For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCoreDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link GetCoreDeviceRequest#builder()}
     * </p>
     *
     * @param getCoreDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.GetCoreDeviceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCoreDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.GetCoreDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetCoreDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCoreDeviceResponse> getCoreDevice(Consumer<GetCoreDeviceRequest.Builder> getCoreDeviceRequest) {
        return getCoreDevice(GetCoreDeviceRequest.builder().applyMutation(getCoreDeviceRequest).build());
    }

    /**
     * <p>
     * Gets a deployment. Deployments define the components that run on Greengrass core devices.
     * </p>
     *
     * @param getDeploymentRequest
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeploymentResponse> getDeployment(GetDeploymentRequest getDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a deployment. Deployments define the components that run on Greengrass core devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentRequest#builder()}
     * </p>
     *
     * @param getDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.GetDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDeploymentResponse> getDeployment(Consumer<GetDeploymentRequest.Builder> getDeploymentRequest) {
        return getDeployment(GetDeploymentRequest.builder().applyMutation(getDeploymentRequest).build());
    }

    /**
     * <p>
     * Gets the service role associated with IoT Greengrass for your Amazon Web Services account in this Amazon Web
     * Services Region. IoT Greengrass uses this role to verify the identity of client devices and manage core device
     * connectivity information. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html">Greengrass service
     * role</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.
     * </p>
     *
     * @param getServiceRoleForAccountRequest
     * @return A Java Future containing the result of the GetServiceRoleForAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.GetServiceRoleForAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetServiceRoleForAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceRoleForAccountResponse> getServiceRoleForAccount(
            GetServiceRoleForAccountRequest getServiceRoleForAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the service role associated with IoT Greengrass for your Amazon Web Services account in this Amazon Web
     * Services Region. IoT Greengrass uses this role to verify the identity of client devices and manage core device
     * connectivity information. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html">Greengrass service
     * role</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceRoleForAccountRequest.Builder} avoiding
     * the need to create one manually via {@link GetServiceRoleForAccountRequest#builder()}
     * </p>
     *
     * @param getServiceRoleForAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.GetServiceRoleForAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetServiceRoleForAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.GetServiceRoleForAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/GetServiceRoleForAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceRoleForAccountResponse> getServiceRoleForAccount(
            Consumer<GetServiceRoleForAccountRequest.Builder> getServiceRoleForAccountRequest) {
        return getServiceRoleForAccount(GetServiceRoleForAccountRequest.builder().applyMutation(getServiceRoleForAccountRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a paginated list of client devices that are associated with a core device.
     * </p>
     *
     * @param listClientDevicesAssociatedWithCoreDeviceRequest
     * @return A Java Future containing the result of the ListClientDevicesAssociatedWithCoreDevice operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListClientDevicesAssociatedWithCoreDevice
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListClientDevicesAssociatedWithCoreDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListClientDevicesAssociatedWithCoreDeviceResponse> listClientDevicesAssociatedWithCoreDevice(
            ListClientDevicesAssociatedWithCoreDeviceRequest listClientDevicesAssociatedWithCoreDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of client devices that are associated with a core device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListClientDevicesAssociatedWithCoreDeviceRequest.Builder} avoiding the need to create one manually via
     * {@link ListClientDevicesAssociatedWithCoreDeviceRequest#builder()}
     * </p>
     *
     * @param listClientDevicesAssociatedWithCoreDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListClientDevicesAssociatedWithCoreDevice operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListClientDevicesAssociatedWithCoreDevice
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListClientDevicesAssociatedWithCoreDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListClientDevicesAssociatedWithCoreDeviceResponse> listClientDevicesAssociatedWithCoreDevice(
            Consumer<ListClientDevicesAssociatedWithCoreDeviceRequest.Builder> listClientDevicesAssociatedWithCoreDeviceRequest) {
        return listClientDevicesAssociatedWithCoreDevice(ListClientDevicesAssociatedWithCoreDeviceRequest.builder()
                .applyMutation(listClientDevicesAssociatedWithCoreDeviceRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of client devices that are associated with a core device.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listClientDevicesAssociatedWithCoreDevice(software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListClientDevicesAssociatedWithCoreDevicePublisher publisher = client.listClientDevicesAssociatedWithCoreDevicePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListClientDevicesAssociatedWithCoreDevicePublisher publisher = client.listClientDevicesAssociatedWithCoreDevicePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClientDevicesAssociatedWithCoreDevice(software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listClientDevicesAssociatedWithCoreDeviceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListClientDevicesAssociatedWithCoreDevice
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListClientDevicesAssociatedWithCoreDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClientDevicesAssociatedWithCoreDevicePublisher listClientDevicesAssociatedWithCoreDevicePaginator(
            ListClientDevicesAssociatedWithCoreDeviceRequest listClientDevicesAssociatedWithCoreDeviceRequest) {
        return new ListClientDevicesAssociatedWithCoreDevicePublisher(this, listClientDevicesAssociatedWithCoreDeviceRequest);
    }

    /**
     * <p>
     * Retrieves a paginated list of client devices that are associated with a core device.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listClientDevicesAssociatedWithCoreDevice(software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListClientDevicesAssociatedWithCoreDevicePublisher publisher = client.listClientDevicesAssociatedWithCoreDevicePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListClientDevicesAssociatedWithCoreDevicePublisher publisher = client.listClientDevicesAssociatedWithCoreDevicePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClientDevicesAssociatedWithCoreDevice(software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListClientDevicesAssociatedWithCoreDeviceRequest.Builder} avoiding the need to create one manually via
     * {@link ListClientDevicesAssociatedWithCoreDeviceRequest#builder()}
     * </p>
     *
     * @param listClientDevicesAssociatedWithCoreDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListClientDevicesAssociatedWithCoreDevice
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListClientDevicesAssociatedWithCoreDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClientDevicesAssociatedWithCoreDevicePublisher listClientDevicesAssociatedWithCoreDevicePaginator(
            Consumer<ListClientDevicesAssociatedWithCoreDeviceRequest.Builder> listClientDevicesAssociatedWithCoreDeviceRequest) {
        return listClientDevicesAssociatedWithCoreDevicePaginator(ListClientDevicesAssociatedWithCoreDeviceRequest.builder()
                .applyMutation(listClientDevicesAssociatedWithCoreDeviceRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of all versions for a component. Greater versions are listed first.
     * </p>
     *
     * @param listComponentVersionsRequest
     * @return A Java Future containing the result of the ListComponentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListComponentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListComponentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListComponentVersionsResponse> listComponentVersions(
            ListComponentVersionsRequest listComponentVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of all versions for a component. Greater versions are listed first.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListComponentVersionsRequest#builder()}
     * </p>
     *
     * @param listComponentVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListComponentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListComponentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListComponentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListComponentVersionsResponse> listComponentVersions(
            Consumer<ListComponentVersionsRequest.Builder> listComponentVersionsRequest) {
        return listComponentVersions(ListComponentVersionsRequest.builder().applyMutation(listComponentVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of all versions for a component. Greater versions are listed first.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponentVersions(software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListComponentVersionsPublisher publisher = client.listComponentVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListComponentVersionsPublisher publisher = client.listComponentVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentVersions(software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComponentVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListComponentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListComponentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentVersionsPublisher listComponentVersionsPaginator(
            ListComponentVersionsRequest listComponentVersionsRequest) {
        return new ListComponentVersionsPublisher(this, listComponentVersionsRequest);
    }

    /**
     * <p>
     * Retrieves a paginated list of all versions for a component. Greater versions are listed first.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponentVersions(software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListComponentVersionsPublisher publisher = client.listComponentVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListComponentVersionsPublisher publisher = client.listComponentVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponentVersions(software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListComponentVersionsRequest#builder()}
     * </p>
     *
     * @param listComponentVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListComponentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListComponentVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentVersionsPublisher listComponentVersionsPaginator(
            Consumer<ListComponentVersionsRequest.Builder> listComponentVersionsRequest) {
        return listComponentVersionsPaginator(ListComponentVersionsRequest.builder().applyMutation(listComponentVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a paginated list of component summaries. This list includes components that you have permission to
     * view.
     * </p>
     *
     * @param listComponentsRequest
     * @return A Java Future containing the result of the ListComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListComponentsResponse> listComponents(ListComponentsRequest listComponentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of component summaries. This list includes components that you have permission to
     * view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ListComponentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListComponentsResponse> listComponents(Consumer<ListComponentsRequest.Builder> listComponentsRequest) {
        return listComponents(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of component summaries. This list includes components that you have permission to
     * view.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.greengrassv2.model.ListComponentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.greengrassv2.model.ListComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.greengrassv2.model.ListComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.greengrassv2.model.ListComponentsRequest)} operation.</b>
     * </p>
     *
     * @param listComponentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComponentsPublisher listComponentsPaginator(ListComponentsRequest listComponentsRequest) {
        return new ListComponentsPublisher(this, listComponentsRequest);
    }

    /**
     * <p>
     * Retrieves a paginated list of component summaries. This list includes components that you have permission to
     * view.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.greengrassv2.model.ListComponentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListComponentsPublisher publisher = client.listComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.greengrassv2.model.ListComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.greengrassv2.model.ListComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.greengrassv2.model.ListComponentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ListComponentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComponentsPublisher listComponentsPaginator(Consumer<ListComponentsRequest.Builder> listComponentsRequest) {
        return listComponentsPaginator(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of Greengrass core devices.
     * </p>
     * <note>
     * <p>
     * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT
     * Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services
     * Cloud, then the reported status of that device might not reflect its current status. The status timestamp
     * indicates when the device status was last updated.
     * </p>
     * <p>
     * Core devices send status updates at the following times:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When the IoT Greengrass Core software starts
     * </p>
     * </li>
     * <li>
     * <p>
     * When the core device receives a deployment from the Amazon Web Services Cloud
     * </p>
     * </li>
     * <li>
     * <p>
     * When the status of any component on the core device becomes <code>BROKEN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * At a <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss"
     * >regular interval that you can configure</a>, which defaults to 24 hours
     * </p>
     * </li>
     * <li>
     * <p>
     * For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listCoreDevicesRequest
     * @return A Java Future containing the result of the ListCoreDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListCoreDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListCoreDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCoreDevicesResponse> listCoreDevices(ListCoreDevicesRequest listCoreDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of Greengrass core devices.
     * </p>
     * <note>
     * <p>
     * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT
     * Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services
     * Cloud, then the reported status of that device might not reflect its current status. The status timestamp
     * indicates when the device status was last updated.
     * </p>
     * <p>
     * Core devices send status updates at the following times:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When the IoT Greengrass Core software starts
     * </p>
     * </li>
     * <li>
     * <p>
     * When the core device receives a deployment from the Amazon Web Services Cloud
     * </p>
     * </li>
     * <li>
     * <p>
     * When the status of any component on the core device becomes <code>BROKEN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * At a <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss"
     * >regular interval that you can configure</a>, which defaults to 24 hours
     * </p>
     * </li>
     * <li>
     * <p>
     * For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoreDevicesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCoreDevicesRequest#builder()}
     * </p>
     *
     * @param listCoreDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCoreDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListCoreDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListCoreDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCoreDevicesResponse> listCoreDevices(
            Consumer<ListCoreDevicesRequest.Builder> listCoreDevicesRequest) {
        return listCoreDevices(ListCoreDevicesRequest.builder().applyMutation(listCoreDevicesRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of Greengrass core devices.
     * </p>
     * <note>
     * <p>
     * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT
     * Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services
     * Cloud, then the reported status of that device might not reflect its current status. The status timestamp
     * indicates when the device status was last updated.
     * </p>
     * <p>
     * Core devices send status updates at the following times:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When the IoT Greengrass Core software starts
     * </p>
     * </li>
     * <li>
     * <p>
     * When the core device receives a deployment from the Amazon Web Services Cloud
     * </p>
     * </li>
     * <li>
     * <p>
     * When the status of any component on the core device becomes <code>BROKEN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * At a <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss"
     * >regular interval that you can configure</a>, which defaults to 24 hours
     * </p>
     * </li>
     * <li>
     * <p>
     * For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listCoreDevices(software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListCoreDevicesPublisher publisher = client.listCoreDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListCoreDevicesPublisher publisher = client.listCoreDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoreDevices(software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCoreDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListCoreDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListCoreDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCoreDevicesPublisher listCoreDevicesPaginator(ListCoreDevicesRequest listCoreDevicesRequest) {
        return new ListCoreDevicesPublisher(this, listCoreDevicesRequest);
    }

    /**
     * <p>
     * Retrieves a paginated list of Greengrass core devices.
     * </p>
     * <note>
     * <p>
     * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT
     * Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services
     * Cloud, then the reported status of that device might not reflect its current status. The status timestamp
     * indicates when the device status was last updated.
     * </p>
     * <p>
     * Core devices send status updates at the following times:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When the IoT Greengrass Core software starts
     * </p>
     * </li>
     * <li>
     * <p>
     * When the core device receives a deployment from the Amazon Web Services Cloud
     * </p>
     * </li>
     * <li>
     * <p>
     * When the status of any component on the core device becomes <code>BROKEN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * At a <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss"
     * >regular interval that you can configure</a>, which defaults to 24 hours
     * </p>
     * </li>
     * <li>
     * <p>
     * For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listCoreDevices(software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListCoreDevicesPublisher publisher = client.listCoreDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListCoreDevicesPublisher publisher = client.listCoreDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCoreDevices(software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCoreDevicesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCoreDevicesRequest#builder()}
     * </p>
     *
     * @param listCoreDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListCoreDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListCoreDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCoreDevicesPublisher listCoreDevicesPaginator(Consumer<ListCoreDevicesRequest.Builder> listCoreDevicesRequest) {
        return listCoreDevicesPaginator(ListCoreDevicesRequest.builder().applyMutation(listCoreDevicesRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of deployments.
     * </p>
     *
     * @param listDeploymentsRequest
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest listDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of deployments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ListDeploymentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDeploymentsResponse> listDeployments(
            Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest) {
        return listDeployments(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of deployments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeployments(software.amazon.awssdk.services.greengrassv2.model.ListDeploymentsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.greengrassv2.model.ListDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.greengrassv2.model.ListDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.greengrassv2.model.ListDeploymentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeploymentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsPublisher listDeploymentsPaginator(ListDeploymentsRequest listDeploymentsRequest) {
        return new ListDeploymentsPublisher(this, listDeploymentsRequest);
    }

    /**
     * <p>
     * Retrieves a paginated list of deployments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeployments(software.amazon.awssdk.services.greengrassv2.model.ListDeploymentsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.greengrassv2.model.ListDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.greengrassv2.model.ListDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.greengrassv2.model.ListDeploymentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ListDeploymentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsPublisher listDeploymentsPaginator(Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest) {
        return listDeploymentsPaginator(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of deployment jobs that IoT Greengrass sends to Greengrass core devices.
     * </p>
     *
     * @param listEffectiveDeploymentsRequest
     * @return A Java Future containing the result of the ListEffectiveDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListEffectiveDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListEffectiveDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEffectiveDeploymentsResponse> listEffectiveDeployments(
            ListEffectiveDeploymentsRequest listEffectiveDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of deployment jobs that IoT Greengrass sends to Greengrass core devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEffectiveDeploymentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEffectiveDeploymentsRequest#builder()}
     * </p>
     *
     * @param listEffectiveDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListEffectiveDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListEffectiveDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListEffectiveDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEffectiveDeploymentsResponse> listEffectiveDeployments(
            Consumer<ListEffectiveDeploymentsRequest.Builder> listEffectiveDeploymentsRequest) {
        return listEffectiveDeployments(ListEffectiveDeploymentsRequest.builder().applyMutation(listEffectiveDeploymentsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a paginated list of deployment jobs that IoT Greengrass sends to Greengrass core devices.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEffectiveDeployments(software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListEffectiveDeploymentsPublisher publisher = client.listEffectiveDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListEffectiveDeploymentsPublisher publisher = client.listEffectiveDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEffectiveDeployments(software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEffectiveDeploymentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListEffectiveDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListEffectiveDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEffectiveDeploymentsPublisher listEffectiveDeploymentsPaginator(
            ListEffectiveDeploymentsRequest listEffectiveDeploymentsRequest) {
        return new ListEffectiveDeploymentsPublisher(this, listEffectiveDeploymentsRequest);
    }

    /**
     * <p>
     * Retrieves a paginated list of deployment jobs that IoT Greengrass sends to Greengrass core devices.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEffectiveDeployments(software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListEffectiveDeploymentsPublisher publisher = client.listEffectiveDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListEffectiveDeploymentsPublisher publisher = client.listEffectiveDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEffectiveDeployments(software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEffectiveDeploymentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEffectiveDeploymentsRequest#builder()}
     * </p>
     *
     * @param listEffectiveDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListEffectiveDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListEffectiveDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEffectiveDeploymentsPublisher listEffectiveDeploymentsPaginator(
            Consumer<ListEffectiveDeploymentsRequest.Builder> listEffectiveDeploymentsRequest) {
        return listEffectiveDeploymentsPaginator(ListEffectiveDeploymentsRequest.builder()
                .applyMutation(listEffectiveDeploymentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a paginated list of the components that a Greengrass core device runs. By default, this list doesn't
     * include components that are deployed as dependencies of other components. To include dependencies in the
     * response, set the <code>topologyFilter</code> parameter to <code>ALL</code>.
     * </p>
     * <note>
     * <p>
     * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT
     * Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services
     * Cloud, then the reported status of that device might not reflect its current status. The status timestamp
     * indicates when the device status was last updated.
     * </p>
     * <p>
     * Core devices send status updates at the following times:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When the IoT Greengrass Core software starts
     * </p>
     * </li>
     * <li>
     * <p>
     * When the core device receives a deployment from the Amazon Web Services Cloud
     * </p>
     * </li>
     * <li>
     * <p>
     * When the status of any component on the core device becomes <code>BROKEN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * At a <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss"
     * >regular interval that you can configure</a>, which defaults to 24 hours
     * </p>
     * </li>
     * <li>
     * <p>
     * For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listInstalledComponentsRequest
     * @return A Java Future containing the result of the ListInstalledComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListInstalledComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListInstalledComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstalledComponentsResponse> listInstalledComponents(
            ListInstalledComponentsRequest listInstalledComponentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a paginated list of the components that a Greengrass core device runs. By default, this list doesn't
     * include components that are deployed as dependencies of other components. To include dependencies in the
     * response, set the <code>topologyFilter</code> parameter to <code>ALL</code>.
     * </p>
     * <note>
     * <p>
     * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT
     * Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services
     * Cloud, then the reported status of that device might not reflect its current status. The status timestamp
     * indicates when the device status was last updated.
     * </p>
     * <p>
     * Core devices send status updates at the following times:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When the IoT Greengrass Core software starts
     * </p>
     * </li>
     * <li>
     * <p>
     * When the core device receives a deployment from the Amazon Web Services Cloud
     * </p>
     * </li>
     * <li>
     * <p>
     * When the status of any component on the core device becomes <code>BROKEN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * At a <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss"
     * >regular interval that you can configure</a>, which defaults to 24 hours
     * </p>
     * </li>
     * <li>
     * <p>
     * For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstalledComponentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInstalledComponentsRequest#builder()}
     * </p>
     *
     * @param listInstalledComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListInstalledComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListInstalledComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListInstalledComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstalledComponentsResponse> listInstalledComponents(
            Consumer<ListInstalledComponentsRequest.Builder> listInstalledComponentsRequest) {
        return listInstalledComponents(ListInstalledComponentsRequest.builder().applyMutation(listInstalledComponentsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a paginated list of the components that a Greengrass core device runs. By default, this list doesn't
     * include components that are deployed as dependencies of other components. To include dependencies in the
     * response, set the <code>topologyFilter</code> parameter to <code>ALL</code>.
     * </p>
     * <note>
     * <p>
     * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT
     * Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services
     * Cloud, then the reported status of that device might not reflect its current status. The status timestamp
     * indicates when the device status was last updated.
     * </p>
     * <p>
     * Core devices send status updates at the following times:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When the IoT Greengrass Core software starts
     * </p>
     * </li>
     * <li>
     * <p>
     * When the core device receives a deployment from the Amazon Web Services Cloud
     * </p>
     * </li>
     * <li>
     * <p>
     * When the status of any component on the core device becomes <code>BROKEN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * At a <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss"
     * >regular interval that you can configure</a>, which defaults to 24 hours
     * </p>
     * </li>
     * <li>
     * <p>
     * For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listInstalledComponents(software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListInstalledComponentsPublisher publisher = client.listInstalledComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListInstalledComponentsPublisher publisher = client.listInstalledComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstalledComponents(software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstalledComponentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListInstalledComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListInstalledComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstalledComponentsPublisher listInstalledComponentsPaginator(
            ListInstalledComponentsRequest listInstalledComponentsRequest) {
        return new ListInstalledComponentsPublisher(this, listInstalledComponentsRequest);
    }

    /**
     * <p>
     * Retrieves a paginated list of the components that a Greengrass core device runs. By default, this list doesn't
     * include components that are deployed as dependencies of other components. To include dependencies in the
     * response, set the <code>topologyFilter</code> parameter to <code>ALL</code>.
     * </p>
     * <note>
     * <p>
     * IoT Greengrass relies on individual devices to send status updates to the Amazon Web Services Cloud. If the IoT
     * Greengrass Core software isn't running on the device, or if device isn't connected to the Amazon Web Services
     * Cloud, then the reported status of that device might not reflect its current status. The status timestamp
     * indicates when the device status was last updated.
     * </p>
     * <p>
     * Core devices send status updates at the following times:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When the IoT Greengrass Core software starts
     * </p>
     * </li>
     * <li>
     * <p>
     * When the core device receives a deployment from the Amazon Web Services Cloud
     * </p>
     * </li>
     * <li>
     * <p>
     * When the status of any component on the core device becomes <code>BROKEN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * At a <a href=
     * "https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html#greengrass-nucleus-component-configuration-fss"
     * >regular interval that you can configure</a>, which defaults to 24 hours
     * </p>
     * </li>
     * <li>
     * <p>
     * For IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and cloud deployment
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listInstalledComponents(software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListInstalledComponentsPublisher publisher = client.listInstalledComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.greengrassv2.paginators.ListInstalledComponentsPublisher publisher = client.listInstalledComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstalledComponents(software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstalledComponentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInstalledComponentsRequest#builder()}
     * </p>
     *
     * @param listInstalledComponentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListInstalledComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListInstalledComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstalledComponentsPublisher listInstalledComponentsPaginator(
            Consumer<ListInstalledComponentsRequest.Builder> listInstalledComponentsRequest) {
        return listInstalledComponentsPaginator(ListInstalledComponentsRequest.builder()
                .applyMutation(listInstalledComponentsRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of tags for an IoT Greengrass resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of tags for an IoT Greengrass resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of components that meet the component, version, and platform requirements of a deployment.
     * Greengrass core devices call this operation when they receive a deployment to identify the components to install.
     * </p>
     * <p>
     * This operation identifies components that meet all dependency requirements for a deployment. If the requirements
     * conflict, then this operation returns an error and the deployment fails. For example, this occurs if component
     * <code>A</code> requires version <code>&gt;2.0.0</code> and component <code>B</code> requires version
     * <code>&lt;2.0.0</code> of a component dependency.
     * </p>
     * <p>
     * When you specify the component candidates to resolve, IoT Greengrass compares each component's digest from the
     * core device with the component's digest in the Amazon Web Services Cloud. If the digests don't match, then IoT
     * Greengrass specifies to use the version from the Amazon Web Services Cloud.
     * </p>
     * <important>
     * <p>
     * To use this operation, you must use the data plane API endpoint and authenticate with an IoT device certificate.
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/greengrass.html">IoT Greengrass
     * endpoints and quotas</a>.
     * </p>
     * </important>
     *
     * @param resolveComponentCandidatesRequest
     * @return A Java Future containing the result of the ResolveComponentCandidates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ResolveComponentCandidates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ResolveComponentCandidates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResolveComponentCandidatesResponse> resolveComponentCandidates(
            ResolveComponentCandidatesRequest resolveComponentCandidatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of components that meet the component, version, and platform requirements of a deployment.
     * Greengrass core devices call this operation when they receive a deployment to identify the components to install.
     * </p>
     * <p>
     * This operation identifies components that meet all dependency requirements for a deployment. If the requirements
     * conflict, then this operation returns an error and the deployment fails. For example, this occurs if component
     * <code>A</code> requires version <code>&gt;2.0.0</code> and component <code>B</code> requires version
     * <code>&lt;2.0.0</code> of a component dependency.
     * </p>
     * <p>
     * When you specify the component candidates to resolve, IoT Greengrass compares each component's digest from the
     * core device with the component's digest in the Amazon Web Services Cloud. If the digests don't match, then IoT
     * Greengrass specifies to use the version from the Amazon Web Services Cloud.
     * </p>
     * <important>
     * <p>
     * To use this operation, you must use the data plane API endpoint and authenticate with an IoT device certificate.
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/greengrass.html">IoT Greengrass
     * endpoints and quotas</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResolveComponentCandidatesRequest.Builder} avoiding
     * the need to create one manually via {@link ResolveComponentCandidatesRequest#builder()}
     * </p>
     *
     * @param resolveComponentCandidatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.ResolveComponentCandidatesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ResolveComponentCandidates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>AccessDeniedException You don't have permission to perform the action.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>ConflictException Your request has conflicting operations. This can occur if you're trying to perform
     *         more than one operation on the same resource at the same time.</li>
     *         <li>ThrottlingException Your request exceeded a request rate quota. For example, you might have exceeded
     *         the amount of times that you can retrieve device or deployment status per second.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.ResolveComponentCandidates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ResolveComponentCandidates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResolveComponentCandidatesResponse> resolveComponentCandidates(
            Consumer<ResolveComponentCandidatesRequest.Builder> resolveComponentCandidatesRequest) {
        return resolveComponentCandidates(ResolveComponentCandidatesRequest.builder()
                .applyMutation(resolveComponentCandidatesRequest).build());
    }

    /**
     * <p>
     * Adds tags to an IoT Greengrass resource. If a tag already exists for the resource, this operation updates the
     * tag's value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to an IoT Greengrass resource. If a tag already exists for the resource, this operation updates the
     * tag's value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from an IoT Greengrass resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from an IoT Greengrass resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>ResourceNotFoundException The requested resource can't be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates connectivity information for a Greengrass core device.
     * </p>
     * <p>
     * Connectivity information includes endpoints and ports where client devices can connect to an MQTT broker on the
     * core device. When a client device calls the <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-discover-api.html">IoT Greengrass
     * discovery API</a>, IoT Greengrass returns connectivity information for all of the core devices where the client
     * device can connect. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/connect-client-devices.html">Connect client
     * devices to core devices</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.
     * </p>
     *
     * @param updateConnectivityInfoRequest
     * @return A Java Future containing the result of the UpdateConnectivityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.UpdateConnectivityInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/UpdateConnectivityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectivityInfoResponse> updateConnectivityInfo(
            UpdateConnectivityInfoRequest updateConnectivityInfoRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates connectivity information for a Greengrass core device.
     * </p>
     * <p>
     * Connectivity information includes endpoints and ports where client devices can connect to an MQTT broker on the
     * core device. When a client device calls the <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-discover-api.html">IoT Greengrass
     * discovery API</a>, IoT Greengrass returns connectivity information for all of the core devices where the client
     * device can connect. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/connect-client-devices.html">Connect client
     * devices to core devices</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectivityInfoRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateConnectivityInfoRequest#builder()}
     * </p>
     *
     * @param updateConnectivityInfoRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.greengrassv2.model.UpdateConnectivityInfoRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateConnectivityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request isn't valid. This can occur if your request contains malformed JSON
     *         or unsupported characters.</li>
     *         <li>InternalServerException IoT Greengrass can't process your request right now. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassV2AsyncClient.UpdateConnectivityInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/UpdateConnectivityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConnectivityInfoResponse> updateConnectivityInfo(
            Consumer<UpdateConnectivityInfoRequest.Builder> updateConnectivityInfoRequest) {
        return updateConnectivityInfo(UpdateConnectivityInfoRequest.builder().applyMutation(updateConnectivityInfoRequest)
                .build());
    }

    @Override
    default GreengrassV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link GreengrassV2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GreengrassV2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GreengrassV2AsyncClient}.
     */
    static GreengrassV2AsyncClientBuilder builder() {
        return new DefaultGreengrassV2AsyncClientBuilder();
    }
}
