/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the endpoint details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointDetails implements SdkPojo, Serializable, ToCopyableBuilder<EndpointDetails.Builder, EndpointDetails> {
    private static final SdkField<DataflowEndpoint> ENDPOINT_FIELD = SdkField
            .<DataflowEndpoint> builder(MarshallingType.SDK_POJO).memberName("endpoint")
            .getter(getter(EndpointDetails::endpoint)).setter(setter(Builder::endpoint)).constructor(DataflowEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<SecurityDetails> SECURITY_DETAILS_FIELD = SdkField
            .<SecurityDetails> builder(MarshallingType.SDK_POJO).memberName("securityDetails")
            .getter(getter(EndpointDetails::securityDetails)).setter(setter(Builder::securityDetails))
            .constructor(SecurityDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD,
            SECURITY_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataflowEndpoint endpoint;

    private final SecurityDetails securityDetails;

    private EndpointDetails(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.securityDetails = builder.securityDetails;
    }

    /**
     * <p>
     * A dataflow endpoint.
     * </p>
     * 
     * @return A dataflow endpoint.
     */
    public final DataflowEndpoint endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * Endpoint security details including a list of subnets, a list of security groups and a role to connect streams to
     * instances.
     * </p>
     * 
     * @return Endpoint security details including a list of subnets, a list of security groups and a role to connect
     *         streams to instances.
     */
    public final SecurityDetails securityDetails() {
        return securityDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(securityDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointDetails)) {
            return false;
        }
        EndpointDetails other = (EndpointDetails) obj;
        return Objects.equals(endpoint(), other.endpoint()) && Objects.equals(securityDetails(), other.securityDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointDetails").add("Endpoint", endpoint()).add("SecurityDetails", securityDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "securityDetails":
            return Optional.ofNullable(clazz.cast(securityDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointDetails, T> g) {
        return obj -> g.apply((EndpointDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointDetails> {
        /**
         * <p>
         * A dataflow endpoint.
         * </p>
         * 
         * @param endpoint
         *        A dataflow endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(DataflowEndpoint endpoint);

        /**
         * <p>
         * A dataflow endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataflowEndpoint.Builder} avoiding the
         * need to create one manually via {@link DataflowEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataflowEndpoint.Builder#build()} is called immediately and its
         * result is passed to {@link #endpoint(DataflowEndpoint)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link DataflowEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(DataflowEndpoint)
         */
        default Builder endpoint(Consumer<DataflowEndpoint.Builder> endpoint) {
            return endpoint(DataflowEndpoint.builder().applyMutation(endpoint).build());
        }

        /**
         * <p>
         * Endpoint security details including a list of subnets, a list of security groups and a role to connect
         * streams to instances.
         * </p>
         * 
         * @param securityDetails
         *        Endpoint security details including a list of subnets, a list of security groups and a role to connect
         *        streams to instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityDetails(SecurityDetails securityDetails);

        /**
         * <p>
         * Endpoint security details including a list of subnets, a list of security groups and a role to connect
         * streams to instances.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecurityDetails.Builder} avoiding the
         * need to create one manually via {@link SecurityDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecurityDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #securityDetails(SecurityDetails)}.
         * 
         * @param securityDetails
         *        a consumer that will call methods on {@link SecurityDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityDetails(SecurityDetails)
         */
        default Builder securityDetails(Consumer<SecurityDetails.Builder> securityDetails) {
            return securityDetails(SecurityDetails.builder().applyMutation(securityDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataflowEndpoint endpoint;

        private SecurityDetails securityDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointDetails model) {
            endpoint(model.endpoint);
            securityDetails(model.securityDetails);
        }

        public final DataflowEndpoint.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        public final void setEndpoint(DataflowEndpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(DataflowEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final SecurityDetails.Builder getSecurityDetails() {
            return securityDetails != null ? securityDetails.toBuilder() : null;
        }

        public final void setSecurityDetails(SecurityDetails.BuilderImpl securityDetails) {
            this.securityDetails = securityDetails != null ? securityDetails.build() : null;
        }

        @Override
        public final Builder securityDetails(SecurityDetails securityDetails) {
            this.securityDetails = securityDetails;
            return this;
        }

        @Override
        public EndpointDetails build() {
            return new EndpointDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
