/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about AwsGroundStationAgentEndpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsGroundStationAgentEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsGroundStationAgentEndpoint.Builder, AwsGroundStationAgentEndpoint> {
    private static final SdkField<String> AGENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentStatus").getter(getter(AwsGroundStationAgentEndpoint::agentStatusAsString))
            .setter(setter(Builder::agentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentStatus").build()).build();

    private static final SdkField<String> AUDIT_RESULTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("auditResults").getter(getter(AwsGroundStationAgentEndpoint::auditResultsAsString))
            .setter(setter(Builder::auditResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditResults").build()).build();

    private static final SdkField<ConnectionDetails> EGRESS_ADDRESS_FIELD = SdkField
            .<ConnectionDetails> builder(MarshallingType.SDK_POJO).memberName("egressAddress")
            .getter(getter(AwsGroundStationAgentEndpoint::egressAddress)).setter(setter(Builder::egressAddress))
            .constructor(ConnectionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressAddress").build()).build();

    private static final SdkField<RangedConnectionDetails> INGRESS_ADDRESS_FIELD = SdkField
            .<RangedConnectionDetails> builder(MarshallingType.SDK_POJO).memberName("ingressAddress")
            .getter(getter(AwsGroundStationAgentEndpoint::ingressAddress)).setter(setter(Builder::ingressAddress))
            .constructor(RangedConnectionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressAddress").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AwsGroundStationAgentEndpoint::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_STATUS_FIELD,
            AUDIT_RESULTS_FIELD, EGRESS_ADDRESS_FIELD, INGRESS_ADDRESS_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentStatus;

    private final String auditResults;

    private final ConnectionDetails egressAddress;

    private final RangedConnectionDetails ingressAddress;

    private final String name;

    private AwsGroundStationAgentEndpoint(BuilderImpl builder) {
        this.agentStatus = builder.agentStatus;
        this.auditResults = builder.auditResults;
        this.egressAddress = builder.egressAddress;
        this.ingressAddress = builder.ingressAddress;
        this.name = builder.name;
    }

    /**
     * <p>
     * The status of AgentEndpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentStatus} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #agentStatusAsString}.
     * </p>
     * 
     * @return The status of AgentEndpoint.
     * @see AgentStatus
     */
    public final AgentStatus agentStatus() {
        return AgentStatus.fromValue(agentStatus);
    }

    /**
     * <p>
     * The status of AgentEndpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentStatus} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #agentStatusAsString}.
     * </p>
     * 
     * @return The status of AgentEndpoint.
     * @see AgentStatus
     */
    public final String agentStatusAsString() {
        return agentStatus;
    }

    /**
     * <p>
     * The results of the audit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #auditResults} will
     * return {@link AuditResults#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #auditResultsAsString}.
     * </p>
     * 
     * @return The results of the audit.
     * @see AuditResults
     */
    public final AuditResults auditResults() {
        return AuditResults.fromValue(auditResults);
    }

    /**
     * <p>
     * The results of the audit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #auditResults} will
     * return {@link AuditResults#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #auditResultsAsString}.
     * </p>
     * 
     * @return The results of the audit.
     * @see AuditResults
     */
    public final String auditResultsAsString() {
        return auditResults;
    }

    /**
     * <p>
     * The egress address of AgentEndpoint.
     * </p>
     * 
     * @return The egress address of AgentEndpoint.
     */
    public final ConnectionDetails egressAddress() {
        return egressAddress;
    }

    /**
     * <p>
     * The ingress address of AgentEndpoint.
     * </p>
     * 
     * @return The ingress address of AgentEndpoint.
     */
    public final RangedConnectionDetails ingressAddress() {
        return ingressAddress;
    }

    /**
     * <p>
     * Name string associated with AgentEndpoint. Used as a human-readable identifier for AgentEndpoint.
     * </p>
     * 
     * @return Name string associated with AgentEndpoint. Used as a human-readable identifier for AgentEndpoint.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(auditResultsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(egressAddress());
        hashCode = 31 * hashCode + Objects.hashCode(ingressAddress());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsGroundStationAgentEndpoint)) {
            return false;
        }
        AwsGroundStationAgentEndpoint other = (AwsGroundStationAgentEndpoint) obj;
        return Objects.equals(agentStatusAsString(), other.agentStatusAsString())
                && Objects.equals(auditResultsAsString(), other.auditResultsAsString())
                && Objects.equals(egressAddress(), other.egressAddress())
                && Objects.equals(ingressAddress(), other.ingressAddress()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsGroundStationAgentEndpoint").add("AgentStatus", agentStatusAsString())
                .add("AuditResults", auditResultsAsString()).add("EgressAddress", egressAddress())
                .add("IngressAddress", ingressAddress()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentStatus":
            return Optional.ofNullable(clazz.cast(agentStatusAsString()));
        case "auditResults":
            return Optional.ofNullable(clazz.cast(auditResultsAsString()));
        case "egressAddress":
            return Optional.ofNullable(clazz.cast(egressAddress()));
        case "ingressAddress":
            return Optional.ofNullable(clazz.cast(ingressAddress()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsGroundStationAgentEndpoint, T> g) {
        return obj -> g.apply((AwsGroundStationAgentEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsGroundStationAgentEndpoint> {
        /**
         * <p>
         * The status of AgentEndpoint.
         * </p>
         * 
         * @param agentStatus
         *        The status of AgentEndpoint.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder agentStatus(String agentStatus);

        /**
         * <p>
         * The status of AgentEndpoint.
         * </p>
         * 
         * @param agentStatus
         *        The status of AgentEndpoint.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder agentStatus(AgentStatus agentStatus);

        /**
         * <p>
         * The results of the audit.
         * </p>
         * 
         * @param auditResults
         *        The results of the audit.
         * @see AuditResults
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditResults
         */
        Builder auditResults(String auditResults);

        /**
         * <p>
         * The results of the audit.
         * </p>
         * 
         * @param auditResults
         *        The results of the audit.
         * @see AuditResults
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditResults
         */
        Builder auditResults(AuditResults auditResults);

        /**
         * <p>
         * The egress address of AgentEndpoint.
         * </p>
         * 
         * @param egressAddress
         *        The egress address of AgentEndpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressAddress(ConnectionDetails egressAddress);

        /**
         * <p>
         * The egress address of AgentEndpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionDetails.Builder} avoiding the
         * need to create one manually via {@link ConnectionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #egressAddress(ConnectionDetails)}.
         * 
         * @param egressAddress
         *        a consumer that will call methods on {@link ConnectionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressAddress(ConnectionDetails)
         */
        default Builder egressAddress(Consumer<ConnectionDetails.Builder> egressAddress) {
            return egressAddress(ConnectionDetails.builder().applyMutation(egressAddress).build());
        }

        /**
         * <p>
         * The ingress address of AgentEndpoint.
         * </p>
         * 
         * @param ingressAddress
         *        The ingress address of AgentEndpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressAddress(RangedConnectionDetails ingressAddress);

        /**
         * <p>
         * The ingress address of AgentEndpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link RangedConnectionDetails.Builder} avoiding
         * the need to create one manually via {@link RangedConnectionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RangedConnectionDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #ingressAddress(RangedConnectionDetails)}.
         * 
         * @param ingressAddress
         *        a consumer that will call methods on {@link RangedConnectionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressAddress(RangedConnectionDetails)
         */
        default Builder ingressAddress(Consumer<RangedConnectionDetails.Builder> ingressAddress) {
            return ingressAddress(RangedConnectionDetails.builder().applyMutation(ingressAddress).build());
        }

        /**
         * <p>
         * Name string associated with AgentEndpoint. Used as a human-readable identifier for AgentEndpoint.
         * </p>
         * 
         * @param name
         *        Name string associated with AgentEndpoint. Used as a human-readable identifier for AgentEndpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String agentStatus;

        private String auditResults;

        private ConnectionDetails egressAddress;

        private RangedConnectionDetails ingressAddress;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsGroundStationAgentEndpoint model) {
            agentStatus(model.agentStatus);
            auditResults(model.auditResults);
            egressAddress(model.egressAddress);
            ingressAddress(model.ingressAddress);
            name(model.name);
        }

        public final String getAgentStatus() {
            return agentStatus;
        }

        public final void setAgentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
        }

        @Override
        public final Builder agentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
            return this;
        }

        @Override
        public final Builder agentStatus(AgentStatus agentStatus) {
            this.agentStatus(agentStatus == null ? null : agentStatus.toString());
            return this;
        }

        public final String getAuditResults() {
            return auditResults;
        }

        public final void setAuditResults(String auditResults) {
            this.auditResults = auditResults;
        }

        @Override
        public final Builder auditResults(String auditResults) {
            this.auditResults = auditResults;
            return this;
        }

        @Override
        public final Builder auditResults(AuditResults auditResults) {
            this.auditResults(auditResults == null ? null : auditResults.toString());
            return this;
        }

        public final ConnectionDetails.Builder getEgressAddress() {
            return egressAddress != null ? egressAddress.toBuilder() : null;
        }

        public final void setEgressAddress(ConnectionDetails.BuilderImpl egressAddress) {
            this.egressAddress = egressAddress != null ? egressAddress.build() : null;
        }

        @Override
        public final Builder egressAddress(ConnectionDetails egressAddress) {
            this.egressAddress = egressAddress;
            return this;
        }

        public final RangedConnectionDetails.Builder getIngressAddress() {
            return ingressAddress != null ? ingressAddress.toBuilder() : null;
        }

        public final void setIngressAddress(RangedConnectionDetails.BuilderImpl ingressAddress) {
            this.ingressAddress = ingressAddress != null ? ingressAddress.build() : null;
        }

        @Override
        public final Builder ingressAddress(RangedConnectionDetails ingressAddress) {
            this.ingressAddress = ingressAddress;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public AwsGroundStationAgentEndpoint build() {
            return new AwsGroundStationAgentEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
