/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ErrorCode {
    ACCESS_DENIED("ACCESS_DENIED"),
    INVALID_URL_ERROR("INVALID_URL_ERROR"),
    INVALID_IMPORT_OPTIONS_ERROR("INVALID_IMPORT_OPTIONS_ERROR"),
    INVALID_TABLE_ID_ERROR("INVALID_TABLE_ID_ERROR"),
    INVALID_TABLE_COLUMN_ID_ERROR("INVALID_TABLE_COLUMN_ID_ERROR"),
    TABLE_NOT_FOUND_ERROR("TABLE_NOT_FOUND_ERROR"),
    FILE_EMPTY_ERROR("FILE_EMPTY_ERROR"),
    INVALID_FILE_TYPE_ERROR("INVALID_FILE_TYPE_ERROR"),
    FILE_PARSING_ERROR("FILE_PARSING_ERROR"),
    FILE_SIZE_LIMIT_ERROR("FILE_SIZE_LIMIT_ERROR"),
    FILE_NOT_FOUND_ERROR("FILE_NOT_FOUND_ERROR"),
    UNKNOWN_ERROR("UNKNOWN_ERROR"),
    RESOURCE_NOT_FOUND_ERROR("RESOURCE_NOT_FOUND_ERROR"),
    SYSTEM_LIMIT_ERROR("SYSTEM_LIMIT_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorCode> VALUE_MAP;
    private final String value;

    private ErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCode> knownValues() {
        EnumSet<ErrorCode> knownValues = EnumSet.allOf(ErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ErrorCode.class, ErrorCode::toString);
    }
}

