/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Resource selection criteria for the lifecycle policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicyResourceSelection implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecyclePolicyResourceSelection.Builder, LifecyclePolicyResourceSelection> {
    private static final SdkField<List<LifecyclePolicyResourceSelectionRecipe>> RECIPES_FIELD = SdkField
            .<List<LifecyclePolicyResourceSelectionRecipe>> builder(MarshallingType.LIST)
            .memberName("recipes")
            .getter(getter(LifecyclePolicyResourceSelection::recipes))
            .setter(setter(Builder::recipes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecyclePolicyResourceSelectionRecipe> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecyclePolicyResourceSelectionRecipe::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAG_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tagMap")
            .getter(getter(LifecyclePolicyResourceSelection::tagMap))
            .setter(setter(Builder::tagMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECIPES_FIELD, TAG_MAP_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<LifecyclePolicyResourceSelectionRecipe> recipes;

    private final Map<String, String> tagMap;

    private LifecyclePolicyResourceSelection(BuilderImpl builder) {
        this.recipes = builder.recipes;
        this.tagMap = builder.tagMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the Recipes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecipes() {
        return recipes != null && !(recipes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of recipes that are used as selection criteria for the output images that the lifecycle policy applies to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecipes} method.
     * </p>
     * 
     * @return A list of recipes that are used as selection criteria for the output images that the lifecycle policy
     *         applies to.
     */
    public final List<LifecyclePolicyResourceSelectionRecipe> recipes() {
        return recipes;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagMap property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagMap() {
        return tagMap != null && !(tagMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags that are used as selection criteria for the resources that the lifecycle policy applies to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagMap} method.
     * </p>
     * 
     * @return A list of tags that are used as selection criteria for the resources that the lifecycle policy applies
     *         to.
     */
    public final Map<String, String> tagMap() {
        return tagMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRecipes() ? recipes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagMap() ? tagMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyResourceSelection)) {
            return false;
        }
        LifecyclePolicyResourceSelection other = (LifecyclePolicyResourceSelection) obj;
        return hasRecipes() == other.hasRecipes() && Objects.equals(recipes(), other.recipes())
                && hasTagMap() == other.hasTagMap() && Objects.equals(tagMap(), other.tagMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecyclePolicyResourceSelection").add("Recipes", hasRecipes() ? recipes() : null)
                .add("TagMap", hasTagMap() ? tagMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recipes":
            return Optional.ofNullable(clazz.cast(recipes()));
        case "tagMap":
            return Optional.ofNullable(clazz.cast(tagMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyResourceSelection, T> g) {
        return obj -> g.apply((LifecyclePolicyResourceSelection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicyResourceSelection> {
        /**
         * <p>
         * A list of recipes that are used as selection criteria for the output images that the lifecycle policy applies
         * to.
         * </p>
         * 
         * @param recipes
         *        A list of recipes that are used as selection criteria for the output images that the lifecycle policy
         *        applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipes(Collection<LifecyclePolicyResourceSelectionRecipe> recipes);

        /**
         * <p>
         * A list of recipes that are used as selection criteria for the output images that the lifecycle policy applies
         * to.
         * </p>
         * 
         * @param recipes
         *        A list of recipes that are used as selection criteria for the output images that the lifecycle policy
         *        applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipes(LifecyclePolicyResourceSelectionRecipe... recipes);

        /**
         * <p>
         * A list of recipes that are used as selection criteria for the output images that the lifecycle policy applies
         * to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #recipes(List<LifecyclePolicyResourceSelectionRecipe>)}.
         * 
         * @param recipes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyResourceSelectionRecipe.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recipes(java.util.Collection<LifecyclePolicyResourceSelectionRecipe>)
         */
        Builder recipes(Consumer<LifecyclePolicyResourceSelectionRecipe.Builder>... recipes);

        /**
         * <p>
         * A list of tags that are used as selection criteria for the resources that the lifecycle policy applies to.
         * </p>
         * 
         * @param tagMap
         *        A list of tags that are used as selection criteria for the resources that the lifecycle policy applies
         *        to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagMap(Map<String, String> tagMap);
    }

    static final class BuilderImpl implements Builder {
        private List<LifecyclePolicyResourceSelectionRecipe> recipes = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tagMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyResourceSelection model) {
            recipes(model.recipes);
            tagMap(model.tagMap);
        }

        public final List<LifecyclePolicyResourceSelectionRecipe.Builder> getRecipes() {
            List<LifecyclePolicyResourceSelectionRecipe.Builder> result = LifecyclePolicyResourceSelectionRecipesCopier
                    .copyToBuilder(this.recipes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecipes(Collection<LifecyclePolicyResourceSelectionRecipe.BuilderImpl> recipes) {
            this.recipes = LifecyclePolicyResourceSelectionRecipesCopier.copyFromBuilder(recipes);
        }

        @Override
        public final Builder recipes(Collection<LifecyclePolicyResourceSelectionRecipe> recipes) {
            this.recipes = LifecyclePolicyResourceSelectionRecipesCopier.copy(recipes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipes(LifecyclePolicyResourceSelectionRecipe... recipes) {
            recipes(Arrays.asList(recipes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipes(Consumer<LifecyclePolicyResourceSelectionRecipe.Builder>... recipes) {
            recipes(Stream.of(recipes).map(c -> LifecyclePolicyResourceSelectionRecipe.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTagMap() {
            if (tagMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return tagMap;
        }

        public final void setTagMap(Map<String, String> tagMap) {
            this.tagMap = TagMapCopier.copy(tagMap);
        }

        @Override
        public final Builder tagMap(Map<String, String> tagMap) {
            this.tagMap = TagMapCopier.copy(tagMap);
            return this;
        }

        @Override
        public LifecyclePolicyResourceSelection build() {
            return new LifecyclePolicyResourceSelection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
