/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents which scan types are automatically enabled for new members of your Amazon Inspector organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoEnable implements SdkPojo, Serializable, ToCopyableBuilder<AutoEnable.Builder, AutoEnable> {
    private static final SdkField<Boolean> EC2_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("ec2")
            .getter(getter(AutoEnable::ec2)).setter(setter(Builder::ec2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2").build()).build();

    private static final SdkField<Boolean> ECR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("ecr")
            .getter(getter(AutoEnable::ecr)).setter(setter(Builder::ecr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_FIELD, ECR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean ec2;

    private final Boolean ecr;

    private AutoEnable(BuilderImpl builder) {
        this.ec2 = builder.ec2;
        this.ecr = builder.ecr;
    }

    /**
     * <p>
     * Represents whether Amazon EC2 scans are automatically enabled for new members of your Amazon Inspector
     * organization.
     * </p>
     * 
     * @return Represents whether Amazon EC2 scans are automatically enabled for new members of your Amazon Inspector
     *         organization.
     */
    public final Boolean ec2() {
        return ec2;
    }

    /**
     * <p>
     * Represents whether Amazon ECR scans are automatically enabled for new members of your Amazon Inspector
     * organization.
     * </p>
     * 
     * @return Represents whether Amazon ECR scans are automatically enabled for new members of your Amazon Inspector
     *         organization.
     */
    public final Boolean ecr() {
        return ecr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2());
        hashCode = 31 * hashCode + Objects.hashCode(ecr());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoEnable)) {
            return false;
        }
        AutoEnable other = (AutoEnable) obj;
        return Objects.equals(ec2(), other.ec2()) && Objects.equals(ecr(), other.ecr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoEnable").add("Ec2", ec2()).add("Ecr", ecr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ec2":
            return Optional.ofNullable(clazz.cast(ec2()));
        case "ecr":
            return Optional.ofNullable(clazz.cast(ecr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoEnable, T> g) {
        return obj -> g.apply((AutoEnable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoEnable> {
        /**
         * <p>
         * Represents whether Amazon EC2 scans are automatically enabled for new members of your Amazon Inspector
         * organization.
         * </p>
         * 
         * @param ec2
         *        Represents whether Amazon EC2 scans are automatically enabled for new members of your Amazon Inspector
         *        organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2(Boolean ec2);

        /**
         * <p>
         * Represents whether Amazon ECR scans are automatically enabled for new members of your Amazon Inspector
         * organization.
         * </p>
         * 
         * @param ecr
         *        Represents whether Amazon ECR scans are automatically enabled for new members of your Amazon Inspector
         *        organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecr(Boolean ecr);
    }

    static final class BuilderImpl implements Builder {
        private Boolean ec2;

        private Boolean ecr;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoEnable model) {
            ec2(model.ec2);
            ecr(model.ecr);
        }

        public final Boolean getEc2() {
            return ec2;
        }

        public final void setEc2(Boolean ec2) {
            this.ec2 = ec2;
        }

        @Override
        public final Builder ec2(Boolean ec2) {
            this.ec2 = ec2;
            return this;
        }

        public final Boolean getEcr() {
            return ecr;
        }

        public final void setEcr(Boolean ecr) {
            this.ecr = ecr;
        }

        @Override
        public final Builder ecr(Boolean ecr) {
            this.ecr = ecr;
            return this;
        }

        @Override
        public AutoEnable build() {
            return new AutoEnable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
