/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableDelegatedAdminAccountRequest extends Inspector2Request implements
        ToCopyableBuilder<DisableDelegatedAdminAccountRequest.Builder, DisableDelegatedAdminAccountRequest> {
    private static final SdkField<String> DELEGATED_ADMIN_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("delegatedAdminAccountId").getter(getter(DisableDelegatedAdminAccountRequest::delegatedAdminAccountId))
            .setter(setter(Builder::delegatedAdminAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegatedAdminAccountId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DELEGATED_ADMIN_ACCOUNT_ID_FIELD));

    private final String delegatedAdminAccountId;

    private DisableDelegatedAdminAccountRequest(BuilderImpl builder) {
        super(builder);
        this.delegatedAdminAccountId = builder.delegatedAdminAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the current Amazon Inspector delegated administrator.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the current Amazon Inspector delegated administrator.
     */
    public final String delegatedAdminAccountId() {
        return delegatedAdminAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(delegatedAdminAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableDelegatedAdminAccountRequest)) {
            return false;
        }
        DisableDelegatedAdminAccountRequest other = (DisableDelegatedAdminAccountRequest) obj;
        return Objects.equals(delegatedAdminAccountId(), other.delegatedAdminAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisableDelegatedAdminAccountRequest").add("DelegatedAdminAccountId", delegatedAdminAccountId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "delegatedAdminAccountId":
            return Optional.ofNullable(clazz.cast(delegatedAdminAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableDelegatedAdminAccountRequest, T> g) {
        return obj -> g.apply((DisableDelegatedAdminAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DisableDelegatedAdminAccountRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID of the current Amazon Inspector delegated administrator.
         * </p>
         * 
         * @param delegatedAdminAccountId
         *        The Amazon Web Services account ID of the current Amazon Inspector delegated administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegatedAdminAccountId(String delegatedAdminAccountId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private String delegatedAdminAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableDelegatedAdminAccountRequest model) {
            super(model);
            delegatedAdminAccountId(model.delegatedAdminAccountId);
        }

        public final String getDelegatedAdminAccountId() {
            return delegatedAdminAccountId;
        }

        public final void setDelegatedAdminAccountId(String delegatedAdminAccountId) {
            this.delegatedAdminAccountId = delegatedAdminAccountId;
        }

        @Override
        public final Builder delegatedAdminAccountId(String delegatedAdminAccountId) {
            this.delegatedAdminAccountId = delegatedAdminAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisableDelegatedAdminAccountRequest build() {
            return new DisableDelegatedAdminAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
