/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on the criteria used to define the filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterCriteria implements SdkPojo, Serializable, ToCopyableBuilder<FilterCriteria.Builder, FilterCriteria> {
    private static final SdkField<List<StringFilter>> AWS_ACCOUNT_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("awsAccountId")
            .getter(getter(FilterCriteria::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> COMPONENT_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("componentId")
            .getter(getter(FilterCriteria::componentId))
            .setter(setter(Builder::componentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> COMPONENT_TYPE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("componentType")
            .getter(getter(FilterCriteria::componentType))
            .setter(setter(Builder::componentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> EC2_INSTANCE_IMAGE_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ec2InstanceImageId")
            .getter(getter(FilterCriteria::ec2InstanceImageId))
            .setter(setter(Builder::ec2InstanceImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceImageId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> EC2_INSTANCE_SUBNET_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ec2InstanceSubnetId")
            .getter(getter(FilterCriteria::ec2InstanceSubnetId))
            .setter(setter(Builder::ec2InstanceSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceSubnetId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> EC2_INSTANCE_VPC_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ec2InstanceVpcId")
            .getter(getter(FilterCriteria::ec2InstanceVpcId))
            .setter(setter(Builder::ec2InstanceVpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceVpcId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> ECR_IMAGE_ARCHITECTURE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ecrImageArchitecture")
            .getter(getter(FilterCriteria::ecrImageArchitecture))
            .setter(setter(Builder::ecrImageArchitecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImageArchitecture").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> ECR_IMAGE_HASH_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ecrImageHash")
            .getter(getter(FilterCriteria::ecrImageHash))
            .setter(setter(Builder::ecrImageHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImageHash").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> ECR_IMAGE_PUSHED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .memberName("ecrImagePushedAt")
            .getter(getter(FilterCriteria::ecrImagePushedAt))
            .setter(setter(Builder::ecrImagePushedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImagePushedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> ECR_IMAGE_REGISTRY_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ecrImageRegistry")
            .getter(getter(FilterCriteria::ecrImageRegistry))
            .setter(setter(Builder::ecrImageRegistry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImageRegistry").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> ECR_IMAGE_REPOSITORY_NAME_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ecrImageRepositoryName")
            .getter(getter(FilterCriteria::ecrImageRepositoryName))
            .setter(setter(Builder::ecrImageRepositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImageRepositoryName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> ECR_IMAGE_TAGS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("ecrImageTags")
            .getter(getter(FilterCriteria::ecrImageTags))
            .setter(setter(Builder::ecrImageTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImageTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> FINDING_ARN_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("findingArn")
            .getter(getter(FilterCriteria::findingArn))
            .setter(setter(Builder::findingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> FINDING_STATUS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("findingStatus")
            .getter(getter(FilterCriteria::findingStatus))
            .setter(setter(Builder::findingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> FINDING_TYPE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("findingType")
            .getter(getter(FilterCriteria::findingType))
            .setter(setter(Builder::findingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> FIRST_OBSERVED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .memberName("firstObservedAt")
            .getter(getter(FilterCriteria::firstObservedAt))
            .setter(setter(Builder::firstObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstObservedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> FIX_AVAILABLE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("fixAvailable")
            .getter(getter(FilterCriteria::fixAvailable))
            .setter(setter(Builder::fixAvailable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixAvailable").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NumberFilter>> INSPECTOR_SCORE_FIELD = SdkField
            .<List<NumberFilter>> builder(MarshallingType.LIST)
            .memberName("inspectorScore")
            .getter(getter(FilterCriteria::inspectorScore))
            .setter(setter(Builder::inspectorScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectorScore").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(NumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> LAST_OBSERVED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .memberName("lastObservedAt")
            .getter(getter(FilterCriteria::lastObservedAt))
            .setter(setter(Builder::lastObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastObservedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> NETWORK_PROTOCOL_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("networkProtocol")
            .getter(getter(FilterCriteria::networkProtocol))
            .setter(setter(Builder::networkProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkProtocol").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PortRangeFilter>> PORT_RANGE_FIELD = SdkField
            .<List<PortRangeFilter>> builder(MarshallingType.LIST)
            .memberName("portRange")
            .getter(getter(FilterCriteria::portRange))
            .setter(setter(Builder::portRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portRange").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PortRangeFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortRangeFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RELATED_VULNERABILITIES_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("relatedVulnerabilities")
            .getter(getter(FilterCriteria::relatedVulnerabilities))
            .setter(setter(Builder::relatedVulnerabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedVulnerabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("resourceId")
            .getter(getter(FilterCriteria::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MapFilter>> RESOURCE_TAGS_FIELD = SdkField
            .<List<MapFilter>> builder(MarshallingType.LIST)
            .memberName("resourceTags")
            .getter(getter(FilterCriteria::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_TYPE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("resourceType")
            .getter(getter(FilterCriteria::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> SEVERITY_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("severity")
            .getter(getter(FilterCriteria::severity))
            .setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> TITLE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("title")
            .getter(getter(FilterCriteria::title))
            .setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateFilter>> UPDATED_AT_FIELD = SdkField
            .<List<DateFilter>> builder(MarshallingType.LIST)
            .memberName("updatedAt")
            .getter(getter(FilterCriteria::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> VENDOR_SEVERITY_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("vendorSeverity")
            .getter(getter(FilterCriteria::vendorSeverity))
            .setter(setter(Builder::vendorSeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorSeverity").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> VULNERABILITY_ID_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("vulnerabilityId")
            .getter(getter(FilterCriteria::vulnerabilityId))
            .setter(setter(Builder::vulnerabilityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilityId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> VULNERABILITY_SOURCE_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("vulnerabilitySource")
            .getter(getter(FilterCriteria::vulnerabilitySource))
            .setter(setter(Builder::vulnerabilitySource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilitySource").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PackageFilter>> VULNERABLE_PACKAGES_FIELD = SdkField
            .<List<PackageFilter>> builder(MarshallingType.LIST)
            .memberName("vulnerablePackages")
            .getter(getter(FilterCriteria::vulnerablePackages))
            .setter(setter(Builder::vulnerablePackages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerablePackages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PackageFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackageFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            COMPONENT_ID_FIELD, COMPONENT_TYPE_FIELD, EC2_INSTANCE_IMAGE_ID_FIELD, EC2_INSTANCE_SUBNET_ID_FIELD,
            EC2_INSTANCE_VPC_ID_FIELD, ECR_IMAGE_ARCHITECTURE_FIELD, ECR_IMAGE_HASH_FIELD, ECR_IMAGE_PUSHED_AT_FIELD,
            ECR_IMAGE_REGISTRY_FIELD, ECR_IMAGE_REPOSITORY_NAME_FIELD, ECR_IMAGE_TAGS_FIELD, FINDING_ARN_FIELD,
            FINDING_STATUS_FIELD, FINDING_TYPE_FIELD, FIRST_OBSERVED_AT_FIELD, FIX_AVAILABLE_FIELD, INSPECTOR_SCORE_FIELD,
            LAST_OBSERVED_AT_FIELD, NETWORK_PROTOCOL_FIELD, PORT_RANGE_FIELD, RELATED_VULNERABILITIES_FIELD, RESOURCE_ID_FIELD,
            RESOURCE_TAGS_FIELD, RESOURCE_TYPE_FIELD, SEVERITY_FIELD, TITLE_FIELD, UPDATED_AT_FIELD, VENDOR_SEVERITY_FIELD,
            VULNERABILITY_ID_FIELD, VULNERABILITY_SOURCE_FIELD, VULNERABLE_PACKAGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StringFilter> awsAccountId;

    private final List<StringFilter> componentId;

    private final List<StringFilter> componentType;

    private final List<StringFilter> ec2InstanceImageId;

    private final List<StringFilter> ec2InstanceSubnetId;

    private final List<StringFilter> ec2InstanceVpcId;

    private final List<StringFilter> ecrImageArchitecture;

    private final List<StringFilter> ecrImageHash;

    private final List<DateFilter> ecrImagePushedAt;

    private final List<StringFilter> ecrImageRegistry;

    private final List<StringFilter> ecrImageRepositoryName;

    private final List<StringFilter> ecrImageTags;

    private final List<StringFilter> findingArn;

    private final List<StringFilter> findingStatus;

    private final List<StringFilter> findingType;

    private final List<DateFilter> firstObservedAt;

    private final List<StringFilter> fixAvailable;

    private final List<NumberFilter> inspectorScore;

    private final List<DateFilter> lastObservedAt;

    private final List<StringFilter> networkProtocol;

    private final List<PortRangeFilter> portRange;

    private final List<StringFilter> relatedVulnerabilities;

    private final List<StringFilter> resourceId;

    private final List<MapFilter> resourceTags;

    private final List<StringFilter> resourceType;

    private final List<StringFilter> severity;

    private final List<StringFilter> title;

    private final List<DateFilter> updatedAt;

    private final List<StringFilter> vendorSeverity;

    private final List<StringFilter> vulnerabilityId;

    private final List<StringFilter> vulnerabilitySource;

    private final List<PackageFilter> vulnerablePackages;

    private FilterCriteria(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.componentId = builder.componentId;
        this.componentType = builder.componentType;
        this.ec2InstanceImageId = builder.ec2InstanceImageId;
        this.ec2InstanceSubnetId = builder.ec2InstanceSubnetId;
        this.ec2InstanceVpcId = builder.ec2InstanceVpcId;
        this.ecrImageArchitecture = builder.ecrImageArchitecture;
        this.ecrImageHash = builder.ecrImageHash;
        this.ecrImagePushedAt = builder.ecrImagePushedAt;
        this.ecrImageRegistry = builder.ecrImageRegistry;
        this.ecrImageRepositoryName = builder.ecrImageRepositoryName;
        this.ecrImageTags = builder.ecrImageTags;
        this.findingArn = builder.findingArn;
        this.findingStatus = builder.findingStatus;
        this.findingType = builder.findingType;
        this.firstObservedAt = builder.firstObservedAt;
        this.fixAvailable = builder.fixAvailable;
        this.inspectorScore = builder.inspectorScore;
        this.lastObservedAt = builder.lastObservedAt;
        this.networkProtocol = builder.networkProtocol;
        this.portRange = builder.portRange;
        this.relatedVulnerabilities = builder.relatedVulnerabilities;
        this.resourceId = builder.resourceId;
        this.resourceTags = builder.resourceTags;
        this.resourceType = builder.resourceType;
        this.severity = builder.severity;
        this.title = builder.title;
        this.updatedAt = builder.updatedAt;
        this.vendorSeverity = builder.vendorSeverity;
        this.vulnerabilityId = builder.vulnerabilityId;
        this.vulnerabilitySource = builder.vulnerabilitySource;
        this.vulnerablePackages = builder.vulnerablePackages;
    }

    /**
     * For responses, this returns true if the service returned a value for the AwsAccountId property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAwsAccountId() {
        return awsAccountId != null && !(awsAccountId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of the Amazon Web Services account IDs used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsAccountId} method.
     * </p>
     * 
     * @return Details of the Amazon Web Services account IDs used to filter findings.
     */
    public final List<StringFilter> awsAccountId() {
        return awsAccountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComponentId property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComponentId() {
        return componentId != null && !(componentId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of the component IDs used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponentId} method.
     * </p>
     * 
     * @return Details of the component IDs used to filter findings.
     */
    public final List<StringFilter> componentId() {
        return componentId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComponentType property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComponentType() {
        return componentType != null && !(componentType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of the component types used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponentType} method.
     * </p>
     * 
     * @return Details of the component types used to filter findings.
     */
    public final List<StringFilter> componentType() {
        return componentType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ec2InstanceImageId property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2InstanceImageId() {
        return ec2InstanceImageId != null && !(ec2InstanceImageId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of the Amazon EC2 instance image IDs used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2InstanceImageId} method.
     * </p>
     * 
     * @return Details of the Amazon EC2 instance image IDs used to filter findings.
     */
    public final List<StringFilter> ec2InstanceImageId() {
        return ec2InstanceImageId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ec2InstanceSubnetId property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2InstanceSubnetId() {
        return ec2InstanceSubnetId != null && !(ec2InstanceSubnetId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of the Amazon EC2 instance subnet IDs used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2InstanceSubnetId} method.
     * </p>
     * 
     * @return Details of the Amazon EC2 instance subnet IDs used to filter findings.
     */
    public final List<StringFilter> ec2InstanceSubnetId() {
        return ec2InstanceSubnetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ec2InstanceVpcId property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2InstanceVpcId() {
        return ec2InstanceVpcId != null && !(ec2InstanceVpcId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of the Amazon EC2 instance VPC IDs used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2InstanceVpcId} method.
     * </p>
     * 
     * @return Details of the Amazon EC2 instance VPC IDs used to filter findings.
     */
    public final List<StringFilter> ec2InstanceVpcId() {
        return ec2InstanceVpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EcrImageArchitecture property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEcrImageArchitecture() {
        return ecrImageArchitecture != null && !(ecrImageArchitecture instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of the Amazon ECR image architecture types used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEcrImageArchitecture} method.
     * </p>
     * 
     * @return Details of the Amazon ECR image architecture types used to filter findings.
     */
    public final List<StringFilter> ecrImageArchitecture() {
        return ecrImageArchitecture;
    }

    /**
     * For responses, this returns true if the service returned a value for the EcrImageHash property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEcrImageHash() {
        return ecrImageHash != null && !(ecrImageHash instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of the Amazon ECR image hashes used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEcrImageHash} method.
     * </p>
     * 
     * @return Details of the Amazon ECR image hashes used to filter findings.
     */
    public final List<StringFilter> ecrImageHash() {
        return ecrImageHash;
    }

    /**
     * For responses, this returns true if the service returned a value for the EcrImagePushedAt property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEcrImagePushedAt() {
        return ecrImagePushedAt != null && !(ecrImagePushedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the Amazon ECR image push date and time used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEcrImagePushedAt} method.
     * </p>
     * 
     * @return Details on the Amazon ECR image push date and time used to filter findings.
     */
    public final List<DateFilter> ecrImagePushedAt() {
        return ecrImagePushedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the EcrImageRegistry property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEcrImageRegistry() {
        return ecrImageRegistry != null && !(ecrImageRegistry instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the Amazon ECR registry used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEcrImageRegistry} method.
     * </p>
     * 
     * @return Details on the Amazon ECR registry used to filter findings.
     */
    public final List<StringFilter> ecrImageRegistry() {
        return ecrImageRegistry;
    }

    /**
     * For responses, this returns true if the service returned a value for the EcrImageRepositoryName property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEcrImageRepositoryName() {
        return ecrImageRepositoryName != null && !(ecrImageRepositoryName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the name of the Amazon ECR repository used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEcrImageRepositoryName} method.
     * </p>
     * 
     * @return Details on the name of the Amazon ECR repository used to filter findings.
     */
    public final List<StringFilter> ecrImageRepositoryName() {
        return ecrImageRepositoryName;
    }

    /**
     * For responses, this returns true if the service returned a value for the EcrImageTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEcrImageTags() {
        return ecrImageTags != null && !(ecrImageTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags attached to the Amazon ECR container image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEcrImageTags} method.
     * </p>
     * 
     * @return The tags attached to the Amazon ECR container image.
     */
    public final List<StringFilter> ecrImageTags() {
        return ecrImageTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingArn property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFindingArn() {
        return findingArn != null && !(findingArn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the finding ARNs used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingArn} method.
     * </p>
     * 
     * @return Details on the finding ARNs used to filter findings.
     */
    public final List<StringFilter> findingArn() {
        return findingArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingStatus property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFindingStatus() {
        return findingStatus != null && !(findingStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the finding status types used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingStatus} method.
     * </p>
     * 
     * @return Details on the finding status types used to filter findings.
     */
    public final List<StringFilter> findingStatus() {
        return findingStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingType property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFindingType() {
        return findingType != null && !(findingType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the finding types used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingType} method.
     * </p>
     * 
     * @return Details on the finding types used to filter findings.
     */
    public final List<StringFilter> findingType() {
        return findingType;
    }

    /**
     * For responses, this returns true if the service returned a value for the FirstObservedAt property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFirstObservedAt() {
        return firstObservedAt != null && !(firstObservedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the date and time a finding was first seen used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFirstObservedAt} method.
     * </p>
     * 
     * @return Details on the date and time a finding was first seen used to filter findings.
     */
    public final List<DateFilter> firstObservedAt() {
        return firstObservedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the FixAvailable property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFixAvailable() {
        return fixAvailable != null && !(fixAvailable instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on whether a fix is available through a version update. This value can be <code>YES</code>,
     * <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of the
     * packages identified in the finding have fixes available through updated versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFixAvailable} method.
     * </p>
     * 
     * @return Details on whether a fix is available through a version update. This value can be <code>YES</code>,
     *         <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of the
     *         packages identified in the finding have fixes available through updated versions.
     */
    public final List<StringFilter> fixAvailable() {
        return fixAvailable;
    }

    /**
     * For responses, this returns true if the service returned a value for the InspectorScore property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInspectorScore() {
        return inspectorScore != null && !(inspectorScore instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Inspector score to filter on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInspectorScore} method.
     * </p>
     * 
     * @return The Amazon Inspector score to filter on.
     */
    public final List<NumberFilter> inspectorScore() {
        return inspectorScore;
    }

    /**
     * For responses, this returns true if the service returned a value for the LastObservedAt property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLastObservedAt() {
        return lastObservedAt != null && !(lastObservedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the date and time a finding was last seen used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastObservedAt} method.
     * </p>
     * 
     * @return Details on the date and time a finding was last seen used to filter findings.
     */
    public final List<DateFilter> lastObservedAt() {
        return lastObservedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkProtocol property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkProtocol() {
        return networkProtocol != null && !(networkProtocol instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the ingress source addresses used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkProtocol} method.
     * </p>
     * 
     * @return Details on the ingress source addresses used to filter findings.
     */
    public final List<StringFilter> networkProtocol() {
        return networkProtocol;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortRange property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPortRange() {
        return portRange != null && !(portRange instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the port ranges used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortRange} method.
     * </p>
     * 
     * @return Details on the port ranges used to filter findings.
     */
    public final List<PortRangeFilter> portRange() {
        return portRange;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelatedVulnerabilities property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRelatedVulnerabilities() {
        return relatedVulnerabilities != null && !(relatedVulnerabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the related vulnerabilities used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelatedVulnerabilities} method.
     * </p>
     * 
     * @return Details on the related vulnerabilities used to filter findings.
     */
    public final List<StringFilter> relatedVulnerabilities() {
        return relatedVulnerabilities;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceId property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResourceId() {
        return resourceId != null && !(resourceId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the resource IDs used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceId} method.
     * </p>
     * 
     * @return Details on the resource IDs used to filter findings.
     */
    public final List<StringFilter> resourceId() {
        return resourceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the resource tags used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTags} method.
     * </p>
     * 
     * @return Details on the resource tags used to filter findings.
     */
    public final List<MapFilter> resourceTags() {
        return resourceTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceType property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceType() {
        return resourceType != null && !(resourceType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the resource types used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceType} method.
     * </p>
     * 
     * @return Details on the resource types used to filter findings.
     */
    public final List<StringFilter> resourceType() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Severity property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSeverity() {
        return severity != null && !(severity instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the severity used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSeverity} method.
     * </p>
     * 
     * @return Details on the severity used to filter findings.
     */
    public final List<StringFilter> severity() {
        return severity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Title property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTitle() {
        return title != null && !(title instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the finding title used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTitle} method.
     * </p>
     * 
     * @return Details on the finding title used to filter findings.
     */
    public final List<StringFilter> title() {
        return title;
    }

    /**
     * For responses, this returns true if the service returned a value for the UpdatedAt property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUpdatedAt() {
        return updatedAt != null && !(updatedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the date and time a finding was last updated at used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdatedAt} method.
     * </p>
     * 
     * @return Details on the date and time a finding was last updated at used to filter findings.
     */
    public final List<DateFilter> updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the VendorSeverity property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVendorSeverity() {
        return vendorSeverity != null && !(vendorSeverity instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the vendor severity used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVendorSeverity} method.
     * </p>
     * 
     * @return Details on the vendor severity used to filter findings.
     */
    public final List<StringFilter> vendorSeverity() {
        return vendorSeverity;
    }

    /**
     * For responses, this returns true if the service returned a value for the VulnerabilityId property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVulnerabilityId() {
        return vulnerabilityId != null && !(vulnerabilityId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the vulnerability ID used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVulnerabilityId} method.
     * </p>
     * 
     * @return Details on the vulnerability ID used to filter findings.
     */
    public final List<StringFilter> vulnerabilityId() {
        return vulnerabilityId;
    }

    /**
     * For responses, this returns true if the service returned a value for the VulnerabilitySource property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVulnerabilitySource() {
        return vulnerabilitySource != null && !(vulnerabilitySource instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the vulnerability type used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVulnerabilitySource} method.
     * </p>
     * 
     * @return Details on the vulnerability type used to filter findings.
     */
    public final List<StringFilter> vulnerabilitySource() {
        return vulnerabilitySource;
    }

    /**
     * For responses, this returns true if the service returned a value for the VulnerablePackages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVulnerablePackages() {
        return vulnerablePackages != null && !(vulnerablePackages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the vulnerable packages used to filter findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVulnerablePackages} method.
     * </p>
     * 
     * @return Details on the vulnerable packages used to filter findings.
     */
    public final List<PackageFilter> vulnerablePackages() {
        return vulnerablePackages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsAccountId() ? awsAccountId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasComponentId() ? componentId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasComponentType() ? componentType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2InstanceImageId() ? ec2InstanceImageId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2InstanceSubnetId() ? ec2InstanceSubnetId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2InstanceVpcId() ? ec2InstanceVpcId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEcrImageArchitecture() ? ecrImageArchitecture() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEcrImageHash() ? ecrImageHash() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEcrImagePushedAt() ? ecrImagePushedAt() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEcrImageRegistry() ? ecrImageRegistry() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEcrImageRepositoryName() ? ecrImageRepositoryName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEcrImageTags() ? ecrImageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingArn() ? findingArn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingStatus() ? findingStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingType() ? findingType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFirstObservedAt() ? firstObservedAt() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFixAvailable() ? fixAvailable() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInspectorScore() ? inspectorScore() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLastObservedAt() ? lastObservedAt() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkProtocol() ? networkProtocol() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPortRange() ? portRange() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRelatedVulnerabilities() ? relatedVulnerabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceId() ? resourceId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceType() ? resourceType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSeverity() ? severity() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTitle() ? title() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdatedAt() ? updatedAt() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVendorSeverity() ? vendorSeverity() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVulnerabilityId() ? vulnerabilityId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVulnerabilitySource() ? vulnerabilitySource() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVulnerablePackages() ? vulnerablePackages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterCriteria)) {
            return false;
        }
        FilterCriteria other = (FilterCriteria) obj;
        return hasAwsAccountId() == other.hasAwsAccountId() && Objects.equals(awsAccountId(), other.awsAccountId())
                && hasComponentId() == other.hasComponentId() && Objects.equals(componentId(), other.componentId())
                && hasComponentType() == other.hasComponentType() && Objects.equals(componentType(), other.componentType())
                && hasEc2InstanceImageId() == other.hasEc2InstanceImageId()
                && Objects.equals(ec2InstanceImageId(), other.ec2InstanceImageId())
                && hasEc2InstanceSubnetId() == other.hasEc2InstanceSubnetId()
                && Objects.equals(ec2InstanceSubnetId(), other.ec2InstanceSubnetId())
                && hasEc2InstanceVpcId() == other.hasEc2InstanceVpcId()
                && Objects.equals(ec2InstanceVpcId(), other.ec2InstanceVpcId())
                && hasEcrImageArchitecture() == other.hasEcrImageArchitecture()
                && Objects.equals(ecrImageArchitecture(), other.ecrImageArchitecture())
                && hasEcrImageHash() == other.hasEcrImageHash() && Objects.equals(ecrImageHash(), other.ecrImageHash())
                && hasEcrImagePushedAt() == other.hasEcrImagePushedAt()
                && Objects.equals(ecrImagePushedAt(), other.ecrImagePushedAt())
                && hasEcrImageRegistry() == other.hasEcrImageRegistry()
                && Objects.equals(ecrImageRegistry(), other.ecrImageRegistry())
                && hasEcrImageRepositoryName() == other.hasEcrImageRepositoryName()
                && Objects.equals(ecrImageRepositoryName(), other.ecrImageRepositoryName())
                && hasEcrImageTags() == other.hasEcrImageTags() && Objects.equals(ecrImageTags(), other.ecrImageTags())
                && hasFindingArn() == other.hasFindingArn() && Objects.equals(findingArn(), other.findingArn())
                && hasFindingStatus() == other.hasFindingStatus() && Objects.equals(findingStatus(), other.findingStatus())
                && hasFindingType() == other.hasFindingType() && Objects.equals(findingType(), other.findingType())
                && hasFirstObservedAt() == other.hasFirstObservedAt()
                && Objects.equals(firstObservedAt(), other.firstObservedAt()) && hasFixAvailable() == other.hasFixAvailable()
                && Objects.equals(fixAvailable(), other.fixAvailable()) && hasInspectorScore() == other.hasInspectorScore()
                && Objects.equals(inspectorScore(), other.inspectorScore()) && hasLastObservedAt() == other.hasLastObservedAt()
                && Objects.equals(lastObservedAt(), other.lastObservedAt()) && hasNetworkProtocol() == other.hasNetworkProtocol()
                && Objects.equals(networkProtocol(), other.networkProtocol()) && hasPortRange() == other.hasPortRange()
                && Objects.equals(portRange(), other.portRange())
                && hasRelatedVulnerabilities() == other.hasRelatedVulnerabilities()
                && Objects.equals(relatedVulnerabilities(), other.relatedVulnerabilities())
                && hasResourceId() == other.hasResourceId() && Objects.equals(resourceId(), other.resourceId())
                && hasResourceTags() == other.hasResourceTags() && Objects.equals(resourceTags(), other.resourceTags())
                && hasResourceType() == other.hasResourceType() && Objects.equals(resourceType(), other.resourceType())
                && hasSeverity() == other.hasSeverity() && Objects.equals(severity(), other.severity())
                && hasTitle() == other.hasTitle() && Objects.equals(title(), other.title())
                && hasUpdatedAt() == other.hasUpdatedAt() && Objects.equals(updatedAt(), other.updatedAt())
                && hasVendorSeverity() == other.hasVendorSeverity() && Objects.equals(vendorSeverity(), other.vendorSeverity())
                && hasVulnerabilityId() == other.hasVulnerabilityId()
                && Objects.equals(vulnerabilityId(), other.vulnerabilityId())
                && hasVulnerabilitySource() == other.hasVulnerabilitySource()
                && Objects.equals(vulnerabilitySource(), other.vulnerabilitySource())
                && hasVulnerablePackages() == other.hasVulnerablePackages()
                && Objects.equals(vulnerablePackages(), other.vulnerablePackages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterCriteria").add("AwsAccountId", hasAwsAccountId() ? awsAccountId() : null)
                .add("ComponentId", hasComponentId() ? componentId() : null)
                .add("ComponentType", hasComponentType() ? componentType() : null)
                .add("Ec2InstanceImageId", hasEc2InstanceImageId() ? ec2InstanceImageId() : null)
                .add("Ec2InstanceSubnetId", hasEc2InstanceSubnetId() ? ec2InstanceSubnetId() : null)
                .add("Ec2InstanceVpcId", hasEc2InstanceVpcId() ? ec2InstanceVpcId() : null)
                .add("EcrImageArchitecture", hasEcrImageArchitecture() ? ecrImageArchitecture() : null)
                .add("EcrImageHash", hasEcrImageHash() ? ecrImageHash() : null)
                .add("EcrImagePushedAt", hasEcrImagePushedAt() ? ecrImagePushedAt() : null)
                .add("EcrImageRegistry", hasEcrImageRegistry() ? ecrImageRegistry() : null)
                .add("EcrImageRepositoryName", hasEcrImageRepositoryName() ? ecrImageRepositoryName() : null)
                .add("EcrImageTags", hasEcrImageTags() ? ecrImageTags() : null)
                .add("FindingArn", hasFindingArn() ? findingArn() : null)
                .add("FindingStatus", hasFindingStatus() ? findingStatus() : null)
                .add("FindingType", hasFindingType() ? findingType() : null)
                .add("FirstObservedAt", hasFirstObservedAt() ? firstObservedAt() : null)
                .add("FixAvailable", hasFixAvailable() ? fixAvailable() : null)
                .add("InspectorScore", hasInspectorScore() ? inspectorScore() : null)
                .add("LastObservedAt", hasLastObservedAt() ? lastObservedAt() : null)
                .add("NetworkProtocol", hasNetworkProtocol() ? networkProtocol() : null)
                .add("PortRange", hasPortRange() ? portRange() : null)
                .add("RelatedVulnerabilities", hasRelatedVulnerabilities() ? relatedVulnerabilities() : null)
                .add("ResourceId", hasResourceId() ? resourceId() : null)
                .add("ResourceTags", hasResourceTags() ? resourceTags() : null)
                .add("ResourceType", hasResourceType() ? resourceType() : null)
                .add("Severity", hasSeverity() ? severity() : null).add("Title", hasTitle() ? title() : null)
                .add("UpdatedAt", hasUpdatedAt() ? updatedAt() : null)
                .add("VendorSeverity", hasVendorSeverity() ? vendorSeverity() : null)
                .add("VulnerabilityId", hasVulnerabilityId() ? vulnerabilityId() : null)
                .add("VulnerabilitySource", hasVulnerabilitySource() ? vulnerabilitySource() : null)
                .add("VulnerablePackages", hasVulnerablePackages() ? vulnerablePackages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "componentId":
            return Optional.ofNullable(clazz.cast(componentId()));
        case "componentType":
            return Optional.ofNullable(clazz.cast(componentType()));
        case "ec2InstanceImageId":
            return Optional.ofNullable(clazz.cast(ec2InstanceImageId()));
        case "ec2InstanceSubnetId":
            return Optional.ofNullable(clazz.cast(ec2InstanceSubnetId()));
        case "ec2InstanceVpcId":
            return Optional.ofNullable(clazz.cast(ec2InstanceVpcId()));
        case "ecrImageArchitecture":
            return Optional.ofNullable(clazz.cast(ecrImageArchitecture()));
        case "ecrImageHash":
            return Optional.ofNullable(clazz.cast(ecrImageHash()));
        case "ecrImagePushedAt":
            return Optional.ofNullable(clazz.cast(ecrImagePushedAt()));
        case "ecrImageRegistry":
            return Optional.ofNullable(clazz.cast(ecrImageRegistry()));
        case "ecrImageRepositoryName":
            return Optional.ofNullable(clazz.cast(ecrImageRepositoryName()));
        case "ecrImageTags":
            return Optional.ofNullable(clazz.cast(ecrImageTags()));
        case "findingArn":
            return Optional.ofNullable(clazz.cast(findingArn()));
        case "findingStatus":
            return Optional.ofNullable(clazz.cast(findingStatus()));
        case "findingType":
            return Optional.ofNullable(clazz.cast(findingType()));
        case "firstObservedAt":
            return Optional.ofNullable(clazz.cast(firstObservedAt()));
        case "fixAvailable":
            return Optional.ofNullable(clazz.cast(fixAvailable()));
        case "inspectorScore":
            return Optional.ofNullable(clazz.cast(inspectorScore()));
        case "lastObservedAt":
            return Optional.ofNullable(clazz.cast(lastObservedAt()));
        case "networkProtocol":
            return Optional.ofNullable(clazz.cast(networkProtocol()));
        case "portRange":
            return Optional.ofNullable(clazz.cast(portRange()));
        case "relatedVulnerabilities":
            return Optional.ofNullable(clazz.cast(relatedVulnerabilities()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "resourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "vendorSeverity":
            return Optional.ofNullable(clazz.cast(vendorSeverity()));
        case "vulnerabilityId":
            return Optional.ofNullable(clazz.cast(vulnerabilityId()));
        case "vulnerabilitySource":
            return Optional.ofNullable(clazz.cast(vulnerabilitySource()));
        case "vulnerablePackages":
            return Optional.ofNullable(clazz.cast(vulnerablePackages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterCriteria, T> g) {
        return obj -> g.apply((FilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterCriteria> {
        /**
         * <p>
         * Details of the Amazon Web Services account IDs used to filter findings.
         * </p>
         * 
         * @param awsAccountId
         *        Details of the Amazon Web Services account IDs used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(Collection<StringFilter> awsAccountId);

        /**
         * <p>
         * Details of the Amazon Web Services account IDs used to filter findings.
         * </p>
         * 
         * @param awsAccountId
         *        Details of the Amazon Web Services account IDs used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(StringFilter... awsAccountId);

        /**
         * <p>
         * Details of the Amazon Web Services account IDs used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #awsAccountId(List<StringFilter>)}.
         * 
         * @param awsAccountId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsAccountId(java.util.Collection<StringFilter>)
         */
        Builder awsAccountId(Consumer<StringFilter.Builder>... awsAccountId);

        /**
         * <p>
         * Details of the component IDs used to filter findings.
         * </p>
         * 
         * @param componentId
         *        Details of the component IDs used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentId(Collection<StringFilter> componentId);

        /**
         * <p>
         * Details of the component IDs used to filter findings.
         * </p>
         * 
         * @param componentId
         *        Details of the component IDs used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentId(StringFilter... componentId);

        /**
         * <p>
         * Details of the component IDs used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #componentId(List<StringFilter>)}.
         * 
         * @param componentId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #componentId(java.util.Collection<StringFilter>)
         */
        Builder componentId(Consumer<StringFilter.Builder>... componentId);

        /**
         * <p>
         * Details of the component types used to filter findings.
         * </p>
         * 
         * @param componentType
         *        Details of the component types used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentType(Collection<StringFilter> componentType);

        /**
         * <p>
         * Details of the component types used to filter findings.
         * </p>
         * 
         * @param componentType
         *        Details of the component types used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentType(StringFilter... componentType);

        /**
         * <p>
         * Details of the component types used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #componentType(List<StringFilter>)}.
         * 
         * @param componentType
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #componentType(java.util.Collection<StringFilter>)
         */
        Builder componentType(Consumer<StringFilter.Builder>... componentType);

        /**
         * <p>
         * Details of the Amazon EC2 instance image IDs used to filter findings.
         * </p>
         * 
         * @param ec2InstanceImageId
         *        Details of the Amazon EC2 instance image IDs used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceImageId(Collection<StringFilter> ec2InstanceImageId);

        /**
         * <p>
         * Details of the Amazon EC2 instance image IDs used to filter findings.
         * </p>
         * 
         * @param ec2InstanceImageId
         *        Details of the Amazon EC2 instance image IDs used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceImageId(StringFilter... ec2InstanceImageId);

        /**
         * <p>
         * Details of the Amazon EC2 instance image IDs used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #ec2InstanceImageId(List<StringFilter>)}.
         * 
         * @param ec2InstanceImageId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InstanceImageId(java.util.Collection<StringFilter>)
         */
        Builder ec2InstanceImageId(Consumer<StringFilter.Builder>... ec2InstanceImageId);

        /**
         * <p>
         * Details of the Amazon EC2 instance subnet IDs used to filter findings.
         * </p>
         * 
         * @param ec2InstanceSubnetId
         *        Details of the Amazon EC2 instance subnet IDs used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceSubnetId(Collection<StringFilter> ec2InstanceSubnetId);

        /**
         * <p>
         * Details of the Amazon EC2 instance subnet IDs used to filter findings.
         * </p>
         * 
         * @param ec2InstanceSubnetId
         *        Details of the Amazon EC2 instance subnet IDs used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceSubnetId(StringFilter... ec2InstanceSubnetId);

        /**
         * <p>
         * Details of the Amazon EC2 instance subnet IDs used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #ec2InstanceSubnetId(List<StringFilter>)}.
         * 
         * @param ec2InstanceSubnetId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InstanceSubnetId(java.util.Collection<StringFilter>)
         */
        Builder ec2InstanceSubnetId(Consumer<StringFilter.Builder>... ec2InstanceSubnetId);

        /**
         * <p>
         * Details of the Amazon EC2 instance VPC IDs used to filter findings.
         * </p>
         * 
         * @param ec2InstanceVpcId
         *        Details of the Amazon EC2 instance VPC IDs used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceVpcId(Collection<StringFilter> ec2InstanceVpcId);

        /**
         * <p>
         * Details of the Amazon EC2 instance VPC IDs used to filter findings.
         * </p>
         * 
         * @param ec2InstanceVpcId
         *        Details of the Amazon EC2 instance VPC IDs used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceVpcId(StringFilter... ec2InstanceVpcId);

        /**
         * <p>
         * Details of the Amazon EC2 instance VPC IDs used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #ec2InstanceVpcId(List<StringFilter>)}.
         * 
         * @param ec2InstanceVpcId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InstanceVpcId(java.util.Collection<StringFilter>)
         */
        Builder ec2InstanceVpcId(Consumer<StringFilter.Builder>... ec2InstanceVpcId);

        /**
         * <p>
         * Details of the Amazon ECR image architecture types used to filter findings.
         * </p>
         * 
         * @param ecrImageArchitecture
         *        Details of the Amazon ECR image architecture types used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageArchitecture(Collection<StringFilter> ecrImageArchitecture);

        /**
         * <p>
         * Details of the Amazon ECR image architecture types used to filter findings.
         * </p>
         * 
         * @param ecrImageArchitecture
         *        Details of the Amazon ECR image architecture types used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageArchitecture(StringFilter... ecrImageArchitecture);

        /**
         * <p>
         * Details of the Amazon ECR image architecture types used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #ecrImageArchitecture(List<StringFilter>)}.
         * 
         * @param ecrImageArchitecture
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrImageArchitecture(java.util.Collection<StringFilter>)
         */
        Builder ecrImageArchitecture(Consumer<StringFilter.Builder>... ecrImageArchitecture);

        /**
         * <p>
         * Details of the Amazon ECR image hashes used to filter findings.
         * </p>
         * 
         * @param ecrImageHash
         *        Details of the Amazon ECR image hashes used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageHash(Collection<StringFilter> ecrImageHash);

        /**
         * <p>
         * Details of the Amazon ECR image hashes used to filter findings.
         * </p>
         * 
         * @param ecrImageHash
         *        Details of the Amazon ECR image hashes used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageHash(StringFilter... ecrImageHash);

        /**
         * <p>
         * Details of the Amazon ECR image hashes used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #ecrImageHash(List<StringFilter>)}.
         * 
         * @param ecrImageHash
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrImageHash(java.util.Collection<StringFilter>)
         */
        Builder ecrImageHash(Consumer<StringFilter.Builder>... ecrImageHash);

        /**
         * <p>
         * Details on the Amazon ECR image push date and time used to filter findings.
         * </p>
         * 
         * @param ecrImagePushedAt
         *        Details on the Amazon ECR image push date and time used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImagePushedAt(Collection<DateFilter> ecrImagePushedAt);

        /**
         * <p>
         * Details on the Amazon ECR image push date and time used to filter findings.
         * </p>
         * 
         * @param ecrImagePushedAt
         *        Details on the Amazon ECR image push date and time used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImagePushedAt(DateFilter... ecrImagePushedAt);

        /**
         * <p>
         * Details on the Amazon ECR image push date and time used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.DateFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.DateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.DateFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #ecrImagePushedAt(List<DateFilter>)}.
         * 
         * @param ecrImagePushedAt
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.DateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrImagePushedAt(java.util.Collection<DateFilter>)
         */
        Builder ecrImagePushedAt(Consumer<DateFilter.Builder>... ecrImagePushedAt);

        /**
         * <p>
         * Details on the Amazon ECR registry used to filter findings.
         * </p>
         * 
         * @param ecrImageRegistry
         *        Details on the Amazon ECR registry used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageRegistry(Collection<StringFilter> ecrImageRegistry);

        /**
         * <p>
         * Details on the Amazon ECR registry used to filter findings.
         * </p>
         * 
         * @param ecrImageRegistry
         *        Details on the Amazon ECR registry used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageRegistry(StringFilter... ecrImageRegistry);

        /**
         * <p>
         * Details on the Amazon ECR registry used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #ecrImageRegistry(List<StringFilter>)}.
         * 
         * @param ecrImageRegistry
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrImageRegistry(java.util.Collection<StringFilter>)
         */
        Builder ecrImageRegistry(Consumer<StringFilter.Builder>... ecrImageRegistry);

        /**
         * <p>
         * Details on the name of the Amazon ECR repository used to filter findings.
         * </p>
         * 
         * @param ecrImageRepositoryName
         *        Details on the name of the Amazon ECR repository used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageRepositoryName(Collection<StringFilter> ecrImageRepositoryName);

        /**
         * <p>
         * Details on the name of the Amazon ECR repository used to filter findings.
         * </p>
         * 
         * @param ecrImageRepositoryName
         *        Details on the name of the Amazon ECR repository used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageRepositoryName(StringFilter... ecrImageRepositoryName);

        /**
         * <p>
         * Details on the name of the Amazon ECR repository used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #ecrImageRepositoryName(List<StringFilter>)}.
         * 
         * @param ecrImageRepositoryName
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrImageRepositoryName(java.util.Collection<StringFilter>)
         */
        Builder ecrImageRepositoryName(Consumer<StringFilter.Builder>... ecrImageRepositoryName);

        /**
         * <p>
         * The tags attached to the Amazon ECR container image.
         * </p>
         * 
         * @param ecrImageTags
         *        The tags attached to the Amazon ECR container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageTags(Collection<StringFilter> ecrImageTags);

        /**
         * <p>
         * The tags attached to the Amazon ECR container image.
         * </p>
         * 
         * @param ecrImageTags
         *        The tags attached to the Amazon ECR container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageTags(StringFilter... ecrImageTags);

        /**
         * <p>
         * The tags attached to the Amazon ECR container image.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #ecrImageTags(List<StringFilter>)}.
         * 
         * @param ecrImageTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrImageTags(java.util.Collection<StringFilter>)
         */
        Builder ecrImageTags(Consumer<StringFilter.Builder>... ecrImageTags);

        /**
         * <p>
         * Details on the finding ARNs used to filter findings.
         * </p>
         * 
         * @param findingArn
         *        Details on the finding ARNs used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingArn(Collection<StringFilter> findingArn);

        /**
         * <p>
         * Details on the finding ARNs used to filter findings.
         * </p>
         * 
         * @param findingArn
         *        Details on the finding ARNs used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingArn(StringFilter... findingArn);

        /**
         * <p>
         * Details on the finding ARNs used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #findingArn(List<StringFilter>)}.
         * 
         * @param findingArn
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingArn(java.util.Collection<StringFilter>)
         */
        Builder findingArn(Consumer<StringFilter.Builder>... findingArn);

        /**
         * <p>
         * Details on the finding status types used to filter findings.
         * </p>
         * 
         * @param findingStatus
         *        Details on the finding status types used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingStatus(Collection<StringFilter> findingStatus);

        /**
         * <p>
         * Details on the finding status types used to filter findings.
         * </p>
         * 
         * @param findingStatus
         *        Details on the finding status types used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingStatus(StringFilter... findingStatus);

        /**
         * <p>
         * Details on the finding status types used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #findingStatus(List<StringFilter>)}.
         * 
         * @param findingStatus
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingStatus(java.util.Collection<StringFilter>)
         */
        Builder findingStatus(Consumer<StringFilter.Builder>... findingStatus);

        /**
         * <p>
         * Details on the finding types used to filter findings.
         * </p>
         * 
         * @param findingType
         *        Details on the finding types used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingType(Collection<StringFilter> findingType);

        /**
         * <p>
         * Details on the finding types used to filter findings.
         * </p>
         * 
         * @param findingType
         *        Details on the finding types used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingType(StringFilter... findingType);

        /**
         * <p>
         * Details on the finding types used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #findingType(List<StringFilter>)}.
         * 
         * @param findingType
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingType(java.util.Collection<StringFilter>)
         */
        Builder findingType(Consumer<StringFilter.Builder>... findingType);

        /**
         * <p>
         * Details on the date and time a finding was first seen used to filter findings.
         * </p>
         * 
         * @param firstObservedAt
         *        Details on the date and time a finding was first seen used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstObservedAt(Collection<DateFilter> firstObservedAt);

        /**
         * <p>
         * Details on the date and time a finding was first seen used to filter findings.
         * </p>
         * 
         * @param firstObservedAt
         *        Details on the date and time a finding was first seen used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstObservedAt(DateFilter... firstObservedAt);

        /**
         * <p>
         * Details on the date and time a finding was first seen used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.DateFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.DateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.DateFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #firstObservedAt(List<DateFilter>)}.
         * 
         * @param firstObservedAt
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.DateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firstObservedAt(java.util.Collection<DateFilter>)
         */
        Builder firstObservedAt(Consumer<DateFilter.Builder>... firstObservedAt);

        /**
         * <p>
         * Details on whether a fix is available through a version update. This value can be <code>YES</code>,
         * <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of the
         * packages identified in the finding have fixes available through updated versions.
         * </p>
         * 
         * @param fixAvailable
         *        Details on whether a fix is available through a version update. This value can be <code>YES</code>,
         *        <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of
         *        the packages identified in the finding have fixes available through updated versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixAvailable(Collection<StringFilter> fixAvailable);

        /**
         * <p>
         * Details on whether a fix is available through a version update. This value can be <code>YES</code>,
         * <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of the
         * packages identified in the finding have fixes available through updated versions.
         * </p>
         * 
         * @param fixAvailable
         *        Details on whether a fix is available through a version update. This value can be <code>YES</code>,
         *        <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of
         *        the packages identified in the finding have fixes available through updated versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixAvailable(StringFilter... fixAvailable);

        /**
         * <p>
         * Details on whether a fix is available through a version update. This value can be <code>YES</code>,
         * <code>NO</code>, or <code>PARTIAL</code>. A <code>PARTIAL</code> fix means that some, but not all, of the
         * packages identified in the finding have fixes available through updated versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #fixAvailable(List<StringFilter>)}.
         * 
         * @param fixAvailable
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fixAvailable(java.util.Collection<StringFilter>)
         */
        Builder fixAvailable(Consumer<StringFilter.Builder>... fixAvailable);

        /**
         * <p>
         * The Amazon Inspector score to filter on.
         * </p>
         * 
         * @param inspectorScore
         *        The Amazon Inspector score to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inspectorScore(Collection<NumberFilter> inspectorScore);

        /**
         * <p>
         * The Amazon Inspector score to filter on.
         * </p>
         * 
         * @param inspectorScore
         *        The Amazon Inspector score to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inspectorScore(NumberFilter... inspectorScore);

        /**
         * <p>
         * The Amazon Inspector score to filter on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.NumberFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.NumberFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.NumberFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #inspectorScore(List<NumberFilter>)}.
         * 
         * @param inspectorScore
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.NumberFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inspectorScore(java.util.Collection<NumberFilter>)
         */
        Builder inspectorScore(Consumer<NumberFilter.Builder>... inspectorScore);

        /**
         * <p>
         * Details on the date and time a finding was last seen used to filter findings.
         * </p>
         * 
         * @param lastObservedAt
         *        Details on the date and time a finding was last seen used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastObservedAt(Collection<DateFilter> lastObservedAt);

        /**
         * <p>
         * Details on the date and time a finding was last seen used to filter findings.
         * </p>
         * 
         * @param lastObservedAt
         *        Details on the date and time a finding was last seen used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastObservedAt(DateFilter... lastObservedAt);

        /**
         * <p>
         * Details on the date and time a finding was last seen used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.DateFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.DateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.DateFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #lastObservedAt(List<DateFilter>)}.
         * 
         * @param lastObservedAt
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.DateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastObservedAt(java.util.Collection<DateFilter>)
         */
        Builder lastObservedAt(Consumer<DateFilter.Builder>... lastObservedAt);

        /**
         * <p>
         * Details on the ingress source addresses used to filter findings.
         * </p>
         * 
         * @param networkProtocol
         *        Details on the ingress source addresses used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProtocol(Collection<StringFilter> networkProtocol);

        /**
         * <p>
         * Details on the ingress source addresses used to filter findings.
         * </p>
         * 
         * @param networkProtocol
         *        Details on the ingress source addresses used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProtocol(StringFilter... networkProtocol);

        /**
         * <p>
         * Details on the ingress source addresses used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #networkProtocol(List<StringFilter>)}.
         * 
         * @param networkProtocol
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkProtocol(java.util.Collection<StringFilter>)
         */
        Builder networkProtocol(Consumer<StringFilter.Builder>... networkProtocol);

        /**
         * <p>
         * Details on the port ranges used to filter findings.
         * </p>
         * 
         * @param portRange
         *        Details on the port ranges used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRange(Collection<PortRangeFilter> portRange);

        /**
         * <p>
         * Details on the port ranges used to filter findings.
         * </p>
         * 
         * @param portRange
         *        Details on the port ranges used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRange(PortRangeFilter... portRange);

        /**
         * <p>
         * Details on the port ranges used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.PortRangeFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.PortRangeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.PortRangeFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #portRange(List<PortRangeFilter>)}.
         * 
         * @param portRange
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.PortRangeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portRange(java.util.Collection<PortRangeFilter>)
         */
        Builder portRange(Consumer<PortRangeFilter.Builder>... portRange);

        /**
         * <p>
         * Details on the related vulnerabilities used to filter findings.
         * </p>
         * 
         * @param relatedVulnerabilities
         *        Details on the related vulnerabilities used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedVulnerabilities(Collection<StringFilter> relatedVulnerabilities);

        /**
         * <p>
         * Details on the related vulnerabilities used to filter findings.
         * </p>
         * 
         * @param relatedVulnerabilities
         *        Details on the related vulnerabilities used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedVulnerabilities(StringFilter... relatedVulnerabilities);

        /**
         * <p>
         * Details on the related vulnerabilities used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #relatedVulnerabilities(List<StringFilter>)}.
         * 
         * @param relatedVulnerabilities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedVulnerabilities(java.util.Collection<StringFilter>)
         */
        Builder relatedVulnerabilities(Consumer<StringFilter.Builder>... relatedVulnerabilities);

        /**
         * <p>
         * Details on the resource IDs used to filter findings.
         * </p>
         * 
         * @param resourceId
         *        Details on the resource IDs used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(Collection<StringFilter> resourceId);

        /**
         * <p>
         * Details on the resource IDs used to filter findings.
         * </p>
         * 
         * @param resourceId
         *        Details on the resource IDs used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(StringFilter... resourceId);

        /**
         * <p>
         * Details on the resource IDs used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceId(List<StringFilter>)}.
         * 
         * @param resourceId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceId(java.util.Collection<StringFilter>)
         */
        Builder resourceId(Consumer<StringFilter.Builder>... resourceId);

        /**
         * <p>
         * Details on the resource tags used to filter findings.
         * </p>
         * 
         * @param resourceTags
         *        Details on the resource tags used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Collection<MapFilter> resourceTags);

        /**
         * <p>
         * Details on the resource tags used to filter findings.
         * </p>
         * 
         * @param resourceTags
         *        Details on the resource tags used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(MapFilter... resourceTags);

        /**
         * <p>
         * Details on the resource tags used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.MapFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.MapFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.MapFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceTags(List<MapFilter>)}.
         * 
         * @param resourceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.MapFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTags(java.util.Collection<MapFilter>)
         */
        Builder resourceTags(Consumer<MapFilter.Builder>... resourceTags);

        /**
         * <p>
         * Details on the resource types used to filter findings.
         * </p>
         * 
         * @param resourceType
         *        Details on the resource types used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(Collection<StringFilter> resourceType);

        /**
         * <p>
         * Details on the resource types used to filter findings.
         * </p>
         * 
         * @param resourceType
         *        Details on the resource types used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(StringFilter... resourceType);

        /**
         * <p>
         * Details on the resource types used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceType(List<StringFilter>)}.
         * 
         * @param resourceType
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceType(java.util.Collection<StringFilter>)
         */
        Builder resourceType(Consumer<StringFilter.Builder>... resourceType);

        /**
         * <p>
         * Details on the severity used to filter findings.
         * </p>
         * 
         * @param severity
         *        Details on the severity used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(Collection<StringFilter> severity);

        /**
         * <p>
         * Details on the severity used to filter findings.
         * </p>
         * 
         * @param severity
         *        Details on the severity used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(StringFilter... severity);

        /**
         * <p>
         * Details on the severity used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #severity(List<StringFilter>)}.
         * 
         * @param severity
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severity(java.util.Collection<StringFilter>)
         */
        Builder severity(Consumer<StringFilter.Builder>... severity);

        /**
         * <p>
         * Details on the finding title used to filter findings.
         * </p>
         * 
         * @param title
         *        Details on the finding title used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(Collection<StringFilter> title);

        /**
         * <p>
         * Details on the finding title used to filter findings.
         * </p>
         * 
         * @param title
         *        Details on the finding title used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(StringFilter... title);

        /**
         * <p>
         * Details on the finding title used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #title(List<StringFilter>)}.
         * 
         * @param title
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #title(java.util.Collection<StringFilter>)
         */
        Builder title(Consumer<StringFilter.Builder>... title);

        /**
         * <p>
         * Details on the date and time a finding was last updated at used to filter findings.
         * </p>
         * 
         * @param updatedAt
         *        Details on the date and time a finding was last updated at used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Collection<DateFilter> updatedAt);

        /**
         * <p>
         * Details on the date and time a finding was last updated at used to filter findings.
         * </p>
         * 
         * @param updatedAt
         *        Details on the date and time a finding was last updated at used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(DateFilter... updatedAt);

        /**
         * <p>
         * Details on the date and time a finding was last updated at used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.DateFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.DateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.DateFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #updatedAt(List<DateFilter>)}.
         * 
         * @param updatedAt
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.DateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updatedAt(java.util.Collection<DateFilter>)
         */
        Builder updatedAt(Consumer<DateFilter.Builder>... updatedAt);

        /**
         * <p>
         * Details on the vendor severity used to filter findings.
         * </p>
         * 
         * @param vendorSeverity
         *        Details on the vendor severity used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorSeverity(Collection<StringFilter> vendorSeverity);

        /**
         * <p>
         * Details on the vendor severity used to filter findings.
         * </p>
         * 
         * @param vendorSeverity
         *        Details on the vendor severity used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorSeverity(StringFilter... vendorSeverity);

        /**
         * <p>
         * Details on the vendor severity used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #vendorSeverity(List<StringFilter>)}.
         * 
         * @param vendorSeverity
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vendorSeverity(java.util.Collection<StringFilter>)
         */
        Builder vendorSeverity(Consumer<StringFilter.Builder>... vendorSeverity);

        /**
         * <p>
         * Details on the vulnerability ID used to filter findings.
         * </p>
         * 
         * @param vulnerabilityId
         *        Details on the vulnerability ID used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilityId(Collection<StringFilter> vulnerabilityId);

        /**
         * <p>
         * Details on the vulnerability ID used to filter findings.
         * </p>
         * 
         * @param vulnerabilityId
         *        Details on the vulnerability ID used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilityId(StringFilter... vulnerabilityId);

        /**
         * <p>
         * Details on the vulnerability ID used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #vulnerabilityId(List<StringFilter>)}.
         * 
         * @param vulnerabilityId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vulnerabilityId(java.util.Collection<StringFilter>)
         */
        Builder vulnerabilityId(Consumer<StringFilter.Builder>... vulnerabilityId);

        /**
         * <p>
         * Details on the vulnerability type used to filter findings.
         * </p>
         * 
         * @param vulnerabilitySource
         *        Details on the vulnerability type used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilitySource(Collection<StringFilter> vulnerabilitySource);

        /**
         * <p>
         * Details on the vulnerability type used to filter findings.
         * </p>
         * 
         * @param vulnerabilitySource
         *        Details on the vulnerability type used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilitySource(StringFilter... vulnerabilitySource);

        /**
         * <p>
         * Details on the vulnerability type used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #vulnerabilitySource(List<StringFilter>)}.
         * 
         * @param vulnerabilitySource
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vulnerabilitySource(java.util.Collection<StringFilter>)
         */
        Builder vulnerabilitySource(Consumer<StringFilter.Builder>... vulnerabilitySource);

        /**
         * <p>
         * Details on the vulnerable packages used to filter findings.
         * </p>
         * 
         * @param vulnerablePackages
         *        Details on the vulnerable packages used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerablePackages(Collection<PackageFilter> vulnerablePackages);

        /**
         * <p>
         * Details on the vulnerable packages used to filter findings.
         * </p>
         * 
         * @param vulnerablePackages
         *        Details on the vulnerable packages used to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerablePackages(PackageFilter... vulnerablePackages);

        /**
         * <p>
         * Details on the vulnerable packages used to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.PackageFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.PackageFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.PackageFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #vulnerablePackages(List<PackageFilter>)}.
         * 
         * @param vulnerablePackages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.PackageFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vulnerablePackages(java.util.Collection<PackageFilter>)
         */
        Builder vulnerablePackages(Consumer<PackageFilter.Builder>... vulnerablePackages);
    }

    static final class BuilderImpl implements Builder {
        private List<StringFilter> awsAccountId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> componentId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> componentType = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> ec2InstanceImageId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> ec2InstanceSubnetId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> ec2InstanceVpcId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> ecrImageArchitecture = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> ecrImageHash = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> ecrImagePushedAt = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> ecrImageRegistry = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> ecrImageRepositoryName = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> ecrImageTags = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> findingArn = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> findingStatus = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> findingType = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> firstObservedAt = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> fixAvailable = DefaultSdkAutoConstructList.getInstance();

        private List<NumberFilter> inspectorScore = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> lastObservedAt = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> networkProtocol = DefaultSdkAutoConstructList.getInstance();

        private List<PortRangeFilter> portRange = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> relatedVulnerabilities = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceId = DefaultSdkAutoConstructList.getInstance();

        private List<MapFilter> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceType = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> severity = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> title = DefaultSdkAutoConstructList.getInstance();

        private List<DateFilter> updatedAt = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> vendorSeverity = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> vulnerabilityId = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> vulnerabilitySource = DefaultSdkAutoConstructList.getInstance();

        private List<PackageFilter> vulnerablePackages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FilterCriteria model) {
            awsAccountId(model.awsAccountId);
            componentId(model.componentId);
            componentType(model.componentType);
            ec2InstanceImageId(model.ec2InstanceImageId);
            ec2InstanceSubnetId(model.ec2InstanceSubnetId);
            ec2InstanceVpcId(model.ec2InstanceVpcId);
            ecrImageArchitecture(model.ecrImageArchitecture);
            ecrImageHash(model.ecrImageHash);
            ecrImagePushedAt(model.ecrImagePushedAt);
            ecrImageRegistry(model.ecrImageRegistry);
            ecrImageRepositoryName(model.ecrImageRepositoryName);
            ecrImageTags(model.ecrImageTags);
            findingArn(model.findingArn);
            findingStatus(model.findingStatus);
            findingType(model.findingType);
            firstObservedAt(model.firstObservedAt);
            fixAvailable(model.fixAvailable);
            inspectorScore(model.inspectorScore);
            lastObservedAt(model.lastObservedAt);
            networkProtocol(model.networkProtocol);
            portRange(model.portRange);
            relatedVulnerabilities(model.relatedVulnerabilities);
            resourceId(model.resourceId);
            resourceTags(model.resourceTags);
            resourceType(model.resourceType);
            severity(model.severity);
            title(model.title);
            updatedAt(model.updatedAt);
            vendorSeverity(model.vendorSeverity);
            vulnerabilityId(model.vulnerabilityId);
            vulnerabilitySource(model.vulnerabilitySource);
            vulnerablePackages(model.vulnerablePackages);
        }

        public final List<StringFilter.Builder> getAwsAccountId() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.awsAccountId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAwsAccountId(Collection<StringFilter.BuilderImpl> awsAccountId) {
            this.awsAccountId = StringFilterListCopier.copyFromBuilder(awsAccountId);
        }

        @Override
        public final Builder awsAccountId(Collection<StringFilter> awsAccountId) {
            this.awsAccountId = StringFilterListCopier.copy(awsAccountId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountId(StringFilter... awsAccountId) {
            awsAccountId(Arrays.asList(awsAccountId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountId(Consumer<StringFilter.Builder>... awsAccountId) {
            awsAccountId(Stream.of(awsAccountId).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getComponentId() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.componentId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentId(Collection<StringFilter.BuilderImpl> componentId) {
            this.componentId = StringFilterListCopier.copyFromBuilder(componentId);
        }

        @Override
        public final Builder componentId(Collection<StringFilter> componentId) {
            this.componentId = StringFilterListCopier.copy(componentId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentId(StringFilter... componentId) {
            componentId(Arrays.asList(componentId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentId(Consumer<StringFilter.Builder>... componentId) {
            componentId(Stream.of(componentId).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getComponentType() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.componentType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentType(Collection<StringFilter.BuilderImpl> componentType) {
            this.componentType = StringFilterListCopier.copyFromBuilder(componentType);
        }

        @Override
        public final Builder componentType(Collection<StringFilter> componentType) {
            this.componentType = StringFilterListCopier.copy(componentType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentType(StringFilter... componentType) {
            componentType(Arrays.asList(componentType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentType(Consumer<StringFilter.Builder>... componentType) {
            componentType(Stream.of(componentType).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getEc2InstanceImageId() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.ec2InstanceImageId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2InstanceImageId(Collection<StringFilter.BuilderImpl> ec2InstanceImageId) {
            this.ec2InstanceImageId = StringFilterListCopier.copyFromBuilder(ec2InstanceImageId);
        }

        @Override
        public final Builder ec2InstanceImageId(Collection<StringFilter> ec2InstanceImageId) {
            this.ec2InstanceImageId = StringFilterListCopier.copy(ec2InstanceImageId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceImageId(StringFilter... ec2InstanceImageId) {
            ec2InstanceImageId(Arrays.asList(ec2InstanceImageId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceImageId(Consumer<StringFilter.Builder>... ec2InstanceImageId) {
            ec2InstanceImageId(Stream.of(ec2InstanceImageId).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getEc2InstanceSubnetId() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.ec2InstanceSubnetId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2InstanceSubnetId(Collection<StringFilter.BuilderImpl> ec2InstanceSubnetId) {
            this.ec2InstanceSubnetId = StringFilterListCopier.copyFromBuilder(ec2InstanceSubnetId);
        }

        @Override
        public final Builder ec2InstanceSubnetId(Collection<StringFilter> ec2InstanceSubnetId) {
            this.ec2InstanceSubnetId = StringFilterListCopier.copy(ec2InstanceSubnetId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceSubnetId(StringFilter... ec2InstanceSubnetId) {
            ec2InstanceSubnetId(Arrays.asList(ec2InstanceSubnetId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceSubnetId(Consumer<StringFilter.Builder>... ec2InstanceSubnetId) {
            ec2InstanceSubnetId(Stream.of(ec2InstanceSubnetId).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getEc2InstanceVpcId() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.ec2InstanceVpcId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2InstanceVpcId(Collection<StringFilter.BuilderImpl> ec2InstanceVpcId) {
            this.ec2InstanceVpcId = StringFilterListCopier.copyFromBuilder(ec2InstanceVpcId);
        }

        @Override
        public final Builder ec2InstanceVpcId(Collection<StringFilter> ec2InstanceVpcId) {
            this.ec2InstanceVpcId = StringFilterListCopier.copy(ec2InstanceVpcId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceVpcId(StringFilter... ec2InstanceVpcId) {
            ec2InstanceVpcId(Arrays.asList(ec2InstanceVpcId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceVpcId(Consumer<StringFilter.Builder>... ec2InstanceVpcId) {
            ec2InstanceVpcId(Stream.of(ec2InstanceVpcId).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getEcrImageArchitecture() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.ecrImageArchitecture);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrImageArchitecture(Collection<StringFilter.BuilderImpl> ecrImageArchitecture) {
            this.ecrImageArchitecture = StringFilterListCopier.copyFromBuilder(ecrImageArchitecture);
        }

        @Override
        public final Builder ecrImageArchitecture(Collection<StringFilter> ecrImageArchitecture) {
            this.ecrImageArchitecture = StringFilterListCopier.copy(ecrImageArchitecture);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageArchitecture(StringFilter... ecrImageArchitecture) {
            ecrImageArchitecture(Arrays.asList(ecrImageArchitecture));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageArchitecture(Consumer<StringFilter.Builder>... ecrImageArchitecture) {
            ecrImageArchitecture(Stream.of(ecrImageArchitecture).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getEcrImageHash() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.ecrImageHash);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrImageHash(Collection<StringFilter.BuilderImpl> ecrImageHash) {
            this.ecrImageHash = StringFilterListCopier.copyFromBuilder(ecrImageHash);
        }

        @Override
        public final Builder ecrImageHash(Collection<StringFilter> ecrImageHash) {
            this.ecrImageHash = StringFilterListCopier.copy(ecrImageHash);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageHash(StringFilter... ecrImageHash) {
            ecrImageHash(Arrays.asList(ecrImageHash));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageHash(Consumer<StringFilter.Builder>... ecrImageHash) {
            ecrImageHash(Stream.of(ecrImageHash).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DateFilter.Builder> getEcrImagePushedAt() {
            List<DateFilter.Builder> result = DateFilterListCopier.copyToBuilder(this.ecrImagePushedAt);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrImagePushedAt(Collection<DateFilter.BuilderImpl> ecrImagePushedAt) {
            this.ecrImagePushedAt = DateFilterListCopier.copyFromBuilder(ecrImagePushedAt);
        }

        @Override
        public final Builder ecrImagePushedAt(Collection<DateFilter> ecrImagePushedAt) {
            this.ecrImagePushedAt = DateFilterListCopier.copy(ecrImagePushedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImagePushedAt(DateFilter... ecrImagePushedAt) {
            ecrImagePushedAt(Arrays.asList(ecrImagePushedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImagePushedAt(Consumer<DateFilter.Builder>... ecrImagePushedAt) {
            ecrImagePushedAt(Stream.of(ecrImagePushedAt).map(c -> DateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getEcrImageRegistry() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.ecrImageRegistry);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrImageRegistry(Collection<StringFilter.BuilderImpl> ecrImageRegistry) {
            this.ecrImageRegistry = StringFilterListCopier.copyFromBuilder(ecrImageRegistry);
        }

        @Override
        public final Builder ecrImageRegistry(Collection<StringFilter> ecrImageRegistry) {
            this.ecrImageRegistry = StringFilterListCopier.copy(ecrImageRegistry);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageRegistry(StringFilter... ecrImageRegistry) {
            ecrImageRegistry(Arrays.asList(ecrImageRegistry));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageRegistry(Consumer<StringFilter.Builder>... ecrImageRegistry) {
            ecrImageRegistry(Stream.of(ecrImageRegistry).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getEcrImageRepositoryName() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.ecrImageRepositoryName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrImageRepositoryName(Collection<StringFilter.BuilderImpl> ecrImageRepositoryName) {
            this.ecrImageRepositoryName = StringFilterListCopier.copyFromBuilder(ecrImageRepositoryName);
        }

        @Override
        public final Builder ecrImageRepositoryName(Collection<StringFilter> ecrImageRepositoryName) {
            this.ecrImageRepositoryName = StringFilterListCopier.copy(ecrImageRepositoryName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageRepositoryName(StringFilter... ecrImageRepositoryName) {
            ecrImageRepositoryName(Arrays.asList(ecrImageRepositoryName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageRepositoryName(Consumer<StringFilter.Builder>... ecrImageRepositoryName) {
            ecrImageRepositoryName(Stream.of(ecrImageRepositoryName).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getEcrImageTags() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.ecrImageTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrImageTags(Collection<StringFilter.BuilderImpl> ecrImageTags) {
            this.ecrImageTags = StringFilterListCopier.copyFromBuilder(ecrImageTags);
        }

        @Override
        public final Builder ecrImageTags(Collection<StringFilter> ecrImageTags) {
            this.ecrImageTags = StringFilterListCopier.copy(ecrImageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageTags(StringFilter... ecrImageTags) {
            ecrImageTags(Arrays.asList(ecrImageTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageTags(Consumer<StringFilter.Builder>... ecrImageTags) {
            ecrImageTags(Stream.of(ecrImageTags).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getFindingArn() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.findingArn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingArn(Collection<StringFilter.BuilderImpl> findingArn) {
            this.findingArn = StringFilterListCopier.copyFromBuilder(findingArn);
        }

        @Override
        public final Builder findingArn(Collection<StringFilter> findingArn) {
            this.findingArn = StringFilterListCopier.copy(findingArn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingArn(StringFilter... findingArn) {
            findingArn(Arrays.asList(findingArn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingArn(Consumer<StringFilter.Builder>... findingArn) {
            findingArn(Stream.of(findingArn).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getFindingStatus() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.findingStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingStatus(Collection<StringFilter.BuilderImpl> findingStatus) {
            this.findingStatus = StringFilterListCopier.copyFromBuilder(findingStatus);
        }

        @Override
        public final Builder findingStatus(Collection<StringFilter> findingStatus) {
            this.findingStatus = StringFilterListCopier.copy(findingStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingStatus(StringFilter... findingStatus) {
            findingStatus(Arrays.asList(findingStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingStatus(Consumer<StringFilter.Builder>... findingStatus) {
            findingStatus(Stream.of(findingStatus).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getFindingType() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.findingType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingType(Collection<StringFilter.BuilderImpl> findingType) {
            this.findingType = StringFilterListCopier.copyFromBuilder(findingType);
        }

        @Override
        public final Builder findingType(Collection<StringFilter> findingType) {
            this.findingType = StringFilterListCopier.copy(findingType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingType(StringFilter... findingType) {
            findingType(Arrays.asList(findingType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingType(Consumer<StringFilter.Builder>... findingType) {
            findingType(Stream.of(findingType).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DateFilter.Builder> getFirstObservedAt() {
            List<DateFilter.Builder> result = DateFilterListCopier.copyToBuilder(this.firstObservedAt);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirstObservedAt(Collection<DateFilter.BuilderImpl> firstObservedAt) {
            this.firstObservedAt = DateFilterListCopier.copyFromBuilder(firstObservedAt);
        }

        @Override
        public final Builder firstObservedAt(Collection<DateFilter> firstObservedAt) {
            this.firstObservedAt = DateFilterListCopier.copy(firstObservedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firstObservedAt(DateFilter... firstObservedAt) {
            firstObservedAt(Arrays.asList(firstObservedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firstObservedAt(Consumer<DateFilter.Builder>... firstObservedAt) {
            firstObservedAt(Stream.of(firstObservedAt).map(c -> DateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getFixAvailable() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.fixAvailable);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFixAvailable(Collection<StringFilter.BuilderImpl> fixAvailable) {
            this.fixAvailable = StringFilterListCopier.copyFromBuilder(fixAvailable);
        }

        @Override
        public final Builder fixAvailable(Collection<StringFilter> fixAvailable) {
            this.fixAvailable = StringFilterListCopier.copy(fixAvailable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fixAvailable(StringFilter... fixAvailable) {
            fixAvailable(Arrays.asList(fixAvailable));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fixAvailable(Consumer<StringFilter.Builder>... fixAvailable) {
            fixAvailable(Stream.of(fixAvailable).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<NumberFilter.Builder> getInspectorScore() {
            List<NumberFilter.Builder> result = NumberFilterListCopier.copyToBuilder(this.inspectorScore);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInspectorScore(Collection<NumberFilter.BuilderImpl> inspectorScore) {
            this.inspectorScore = NumberFilterListCopier.copyFromBuilder(inspectorScore);
        }

        @Override
        public final Builder inspectorScore(Collection<NumberFilter> inspectorScore) {
            this.inspectorScore = NumberFilterListCopier.copy(inspectorScore);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inspectorScore(NumberFilter... inspectorScore) {
            inspectorScore(Arrays.asList(inspectorScore));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inspectorScore(Consumer<NumberFilter.Builder>... inspectorScore) {
            inspectorScore(Stream.of(inspectorScore).map(c -> NumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DateFilter.Builder> getLastObservedAt() {
            List<DateFilter.Builder> result = DateFilterListCopier.copyToBuilder(this.lastObservedAt);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLastObservedAt(Collection<DateFilter.BuilderImpl> lastObservedAt) {
            this.lastObservedAt = DateFilterListCopier.copyFromBuilder(lastObservedAt);
        }

        @Override
        public final Builder lastObservedAt(Collection<DateFilter> lastObservedAt) {
            this.lastObservedAt = DateFilterListCopier.copy(lastObservedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastObservedAt(DateFilter... lastObservedAt) {
            lastObservedAt(Arrays.asList(lastObservedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastObservedAt(Consumer<DateFilter.Builder>... lastObservedAt) {
            lastObservedAt(Stream.of(lastObservedAt).map(c -> DateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getNetworkProtocol() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.networkProtocol);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkProtocol(Collection<StringFilter.BuilderImpl> networkProtocol) {
            this.networkProtocol = StringFilterListCopier.copyFromBuilder(networkProtocol);
        }

        @Override
        public final Builder networkProtocol(Collection<StringFilter> networkProtocol) {
            this.networkProtocol = StringFilterListCopier.copy(networkProtocol);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProtocol(StringFilter... networkProtocol) {
            networkProtocol(Arrays.asList(networkProtocol));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProtocol(Consumer<StringFilter.Builder>... networkProtocol) {
            networkProtocol(Stream.of(networkProtocol).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PortRangeFilter.Builder> getPortRange() {
            List<PortRangeFilter.Builder> result = PortRangeFilterListCopier.copyToBuilder(this.portRange);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortRange(Collection<PortRangeFilter.BuilderImpl> portRange) {
            this.portRange = PortRangeFilterListCopier.copyFromBuilder(portRange);
        }

        @Override
        public final Builder portRange(Collection<PortRangeFilter> portRange) {
            this.portRange = PortRangeFilterListCopier.copy(portRange);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRange(PortRangeFilter... portRange) {
            portRange(Arrays.asList(portRange));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRange(Consumer<PortRangeFilter.Builder>... portRange) {
            portRange(Stream.of(portRange).map(c -> PortRangeFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getRelatedVulnerabilities() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.relatedVulnerabilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedVulnerabilities(Collection<StringFilter.BuilderImpl> relatedVulnerabilities) {
            this.relatedVulnerabilities = StringFilterListCopier.copyFromBuilder(relatedVulnerabilities);
        }

        @Override
        public final Builder relatedVulnerabilities(Collection<StringFilter> relatedVulnerabilities) {
            this.relatedVulnerabilities = StringFilterListCopier.copy(relatedVulnerabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedVulnerabilities(StringFilter... relatedVulnerabilities) {
            relatedVulnerabilities(Arrays.asList(relatedVulnerabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedVulnerabilities(Consumer<StringFilter.Builder>... relatedVulnerabilities) {
            relatedVulnerabilities(Stream.of(relatedVulnerabilities).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourceId() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceId(Collection<StringFilter.BuilderImpl> resourceId) {
            this.resourceId = StringFilterListCopier.copyFromBuilder(resourceId);
        }

        @Override
        public final Builder resourceId(Collection<StringFilter> resourceId) {
            this.resourceId = StringFilterListCopier.copy(resourceId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceId(StringFilter... resourceId) {
            resourceId(Arrays.asList(resourceId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceId(Consumer<StringFilter.Builder>... resourceId) {
            resourceId(Stream.of(resourceId).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MapFilter.Builder> getResourceTags() {
            List<MapFilter.Builder> result = MapFilterListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<MapFilter.BuilderImpl> resourceTags) {
            this.resourceTags = MapFilterListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<MapFilter> resourceTags) {
            this.resourceTags = MapFilterListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(MapFilter... resourceTags) {
            resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<MapFilter.Builder>... resourceTags) {
            resourceTags(Stream.of(resourceTags).map(c -> MapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourceType() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceType(Collection<StringFilter.BuilderImpl> resourceType) {
            this.resourceType = StringFilterListCopier.copyFromBuilder(resourceType);
        }

        @Override
        public final Builder resourceType(Collection<StringFilter> resourceType) {
            this.resourceType = StringFilterListCopier.copy(resourceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceType(StringFilter... resourceType) {
            resourceType(Arrays.asList(resourceType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceType(Consumer<StringFilter.Builder>... resourceType) {
            resourceType(Stream.of(resourceType).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getSeverity() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.severity);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSeverity(Collection<StringFilter.BuilderImpl> severity) {
            this.severity = StringFilterListCopier.copyFromBuilder(severity);
        }

        @Override
        public final Builder severity(Collection<StringFilter> severity) {
            this.severity = StringFilterListCopier.copy(severity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severity(StringFilter... severity) {
            severity(Arrays.asList(severity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severity(Consumer<StringFilter.Builder>... severity) {
            severity(Stream.of(severity).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getTitle() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.title);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTitle(Collection<StringFilter.BuilderImpl> title) {
            this.title = StringFilterListCopier.copyFromBuilder(title);
        }

        @Override
        public final Builder title(Collection<StringFilter> title) {
            this.title = StringFilterListCopier.copy(title);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(StringFilter... title) {
            title(Arrays.asList(title));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(Consumer<StringFilter.Builder>... title) {
            title(Stream.of(title).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DateFilter.Builder> getUpdatedAt() {
            List<DateFilter.Builder> result = DateFilterListCopier.copyToBuilder(this.updatedAt);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdatedAt(Collection<DateFilter.BuilderImpl> updatedAt) {
            this.updatedAt = DateFilterListCopier.copyFromBuilder(updatedAt);
        }

        @Override
        public final Builder updatedAt(Collection<DateFilter> updatedAt) {
            this.updatedAt = DateFilterListCopier.copy(updatedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updatedAt(DateFilter... updatedAt) {
            updatedAt(Arrays.asList(updatedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updatedAt(Consumer<DateFilter.Builder>... updatedAt) {
            updatedAt(Stream.of(updatedAt).map(c -> DateFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getVendorSeverity() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.vendorSeverity);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVendorSeverity(Collection<StringFilter.BuilderImpl> vendorSeverity) {
            this.vendorSeverity = StringFilterListCopier.copyFromBuilder(vendorSeverity);
        }

        @Override
        public final Builder vendorSeverity(Collection<StringFilter> vendorSeverity) {
            this.vendorSeverity = StringFilterListCopier.copy(vendorSeverity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vendorSeverity(StringFilter... vendorSeverity) {
            vendorSeverity(Arrays.asList(vendorSeverity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vendorSeverity(Consumer<StringFilter.Builder>... vendorSeverity) {
            vendorSeverity(Stream.of(vendorSeverity).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getVulnerabilityId() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.vulnerabilityId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVulnerabilityId(Collection<StringFilter.BuilderImpl> vulnerabilityId) {
            this.vulnerabilityId = StringFilterListCopier.copyFromBuilder(vulnerabilityId);
        }

        @Override
        public final Builder vulnerabilityId(Collection<StringFilter> vulnerabilityId) {
            this.vulnerabilityId = StringFilterListCopier.copy(vulnerabilityId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilityId(StringFilter... vulnerabilityId) {
            vulnerabilityId(Arrays.asList(vulnerabilityId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilityId(Consumer<StringFilter.Builder>... vulnerabilityId) {
            vulnerabilityId(Stream.of(vulnerabilityId).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getVulnerabilitySource() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.vulnerabilitySource);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVulnerabilitySource(Collection<StringFilter.BuilderImpl> vulnerabilitySource) {
            this.vulnerabilitySource = StringFilterListCopier.copyFromBuilder(vulnerabilitySource);
        }

        @Override
        public final Builder vulnerabilitySource(Collection<StringFilter> vulnerabilitySource) {
            this.vulnerabilitySource = StringFilterListCopier.copy(vulnerabilitySource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilitySource(StringFilter... vulnerabilitySource) {
            vulnerabilitySource(Arrays.asList(vulnerabilitySource));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerabilitySource(Consumer<StringFilter.Builder>... vulnerabilitySource) {
            vulnerabilitySource(Stream.of(vulnerabilitySource).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PackageFilter.Builder> getVulnerablePackages() {
            List<PackageFilter.Builder> result = PackageFilterListCopier.copyToBuilder(this.vulnerablePackages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVulnerablePackages(Collection<PackageFilter.BuilderImpl> vulnerablePackages) {
            this.vulnerablePackages = PackageFilterListCopier.copyFromBuilder(vulnerablePackages);
        }

        @Override
        public final Builder vulnerablePackages(Collection<PackageFilter> vulnerablePackages) {
            this.vulnerablePackages = PackageFilterListCopier.copy(vulnerablePackages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerablePackages(PackageFilter... vulnerablePackages) {
            vulnerablePackages(Arrays.asList(vulnerablePackages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerablePackages(Consumer<PackageFilter.Builder>... vulnerablePackages) {
            vulnerablePackages(Stream.of(vulnerablePackages).map(c -> PackageFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FilterCriteria build() {
            return new FilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
