/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that describes the details of a port range filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortRangeFilter implements SdkPojo, Serializable, ToCopyableBuilder<PortRangeFilter.Builder, PortRangeFilter> {
    private static final SdkField<Integer> BEGIN_INCLUSIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("beginInclusive").getter(getter(PortRangeFilter::beginInclusive)).setter(setter(Builder::beginInclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beginInclusive").build()).build();

    private static final SdkField<Integer> END_INCLUSIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("endInclusive").getter(getter(PortRangeFilter::endInclusive)).setter(setter(Builder::endInclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endInclusive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_INCLUSIVE_FIELD,
            END_INCLUSIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer beginInclusive;

    private final Integer endInclusive;

    private PortRangeFilter(BuilderImpl builder) {
        this.beginInclusive = builder.beginInclusive;
        this.endInclusive = builder.endInclusive;
    }

    /**
     * <p>
     * The port number the port range begins at.
     * </p>
     * 
     * @return The port number the port range begins at.
     */
    public final Integer beginInclusive() {
        return beginInclusive;
    }

    /**
     * <p>
     * The port number the port range ends at.
     * </p>
     * 
     * @return The port number the port range ends at.
     */
    public final Integer endInclusive() {
        return endInclusive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(beginInclusive());
        hashCode = 31 * hashCode + Objects.hashCode(endInclusive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortRangeFilter)) {
            return false;
        }
        PortRangeFilter other = (PortRangeFilter) obj;
        return Objects.equals(beginInclusive(), other.beginInclusive()) && Objects.equals(endInclusive(), other.endInclusive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PortRangeFilter").add("BeginInclusive", beginInclusive()).add("EndInclusive", endInclusive())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "beginInclusive":
            return Optional.ofNullable(clazz.cast(beginInclusive()));
        case "endInclusive":
            return Optional.ofNullable(clazz.cast(endInclusive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortRangeFilter, T> g) {
        return obj -> g.apply((PortRangeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortRangeFilter> {
        /**
         * <p>
         * The port number the port range begins at.
         * </p>
         * 
         * @param beginInclusive
         *        The port number the port range begins at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginInclusive(Integer beginInclusive);

        /**
         * <p>
         * The port number the port range ends at.
         * </p>
         * 
         * @param endInclusive
         *        The port number the port range ends at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endInclusive(Integer endInclusive);
    }

    static final class BuilderImpl implements Builder {
        private Integer beginInclusive;

        private Integer endInclusive;

        private BuilderImpl() {
        }

        private BuilderImpl(PortRangeFilter model) {
            beginInclusive(model.beginInclusive);
            endInclusive(model.endInclusive);
        }

        public final Integer getBeginInclusive() {
            return beginInclusive;
        }

        public final void setBeginInclusive(Integer beginInclusive) {
            this.beginInclusive = beginInclusive;
        }

        @Override
        public final Builder beginInclusive(Integer beginInclusive) {
            this.beginInclusive = beginInclusive;
            return this;
        }

        public final Integer getEndInclusive() {
            return endInclusive;
        }

        public final void setEndInclusive(Integer endInclusive) {
            this.endInclusive = endInclusive;
        }

        @Override
        public final Builder endInclusive(Integer endInclusive) {
            this.endInclusive = endInclusive;
            return this;
        }

        @Override
        public PortRangeFilter build() {
            return new PortRangeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
