/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details that define an aggregation based on Amazon EC2 instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2InstanceAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<Ec2InstanceAggregation.Builder, Ec2InstanceAggregation> {
    private static final SdkField<List<StringFilter>> AMIS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("amis")
            .getter(getter(Ec2InstanceAggregation::amis))
            .setter(setter(Builder::amis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amis").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> INSTANCE_IDS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("instanceIds")
            .getter(getter(Ec2InstanceAggregation::instanceIds))
            .setter(setter(Builder::instanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MapFilter>> INSTANCE_TAGS_FIELD = SdkField
            .<List<MapFilter>> builder(MarshallingType.LIST)
            .memberName("instanceTags")
            .getter(getter(Ec2InstanceAggregation::instanceTags))
            .setter(setter(Builder::instanceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> OPERATING_SYSTEMS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("operatingSystems")
            .getter(getter(Ec2InstanceAggregation::operatingSystems))
            .setter(setter(Builder::operatingSystems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(Ec2InstanceAggregation::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(Ec2InstanceAggregation::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMIS_FIELD,
            INSTANCE_IDS_FIELD, INSTANCE_TAGS_FIELD, OPERATING_SYSTEMS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StringFilter> amis;

    private final List<StringFilter> instanceIds;

    private final List<MapFilter> instanceTags;

    private final List<StringFilter> operatingSystems;

    private final String sortBy;

    private final String sortOrder;

    private Ec2InstanceAggregation(BuilderImpl builder) {
        this.amis = builder.amis;
        this.instanceIds = builder.instanceIds;
        this.instanceTags = builder.instanceTags;
        this.operatingSystems = builder.operatingSystems;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the Amis property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAmis() {
        return amis != null && !(amis instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAmis} method.
     * </p>
     * 
     * @return The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.
     */
    public final List<StringFilter> amis() {
        return amis;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceIds() {
        return instanceIds != null && !(instanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon EC2 instance IDs to aggregate findings for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceIds} method.
     * </p>
     * 
     * @return The Amazon EC2 instance IDs to aggregate findings for.
     */
    public final List<StringFilter> instanceIds() {
        return instanceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceTags() {
        return instanceTags != null && !(instanceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon EC2 instance tags to aggregate findings for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceTags} method.
     * </p>
     * 
     * @return The Amazon EC2 instance tags to aggregate findings for.
     */
    public final List<MapFilter> instanceTags() {
        return instanceTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the OperatingSystems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOperatingSystems() {
        return operatingSystems != null && !(operatingSystems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The operating system types to aggregate findings for. Valid values must be uppercase and underscore separated,
     * examples are <code>ORACLE_LINUX_7</code> and <code>ALPINE_LINUX_3_8</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperatingSystems} method.
     * </p>
     * 
     * @return The operating system types to aggregate findings for. Valid values must be uppercase and underscore
     *         separated, examples are <code>ORACLE_LINUX_7</code> and <code>ALPINE_LINUX_3_8</code>.
     */
    public final List<StringFilter> operatingSystems() {
        return operatingSystems;
    }

    /**
     * <p>
     * The value to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link Ec2InstanceSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort results by.
     * @see Ec2InstanceSortBy
     */
    public final Ec2InstanceSortBy sortBy() {
        return Ec2InstanceSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The value to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link Ec2InstanceSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort results by.
     * @see Ec2InstanceSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The order to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort results by.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort results by.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAmis() ? amis() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceIds() ? instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceTags() ? instanceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOperatingSystems() ? operatingSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2InstanceAggregation)) {
            return false;
        }
        Ec2InstanceAggregation other = (Ec2InstanceAggregation) obj;
        return hasAmis() == other.hasAmis() && Objects.equals(amis(), other.amis()) && hasInstanceIds() == other.hasInstanceIds()
                && Objects.equals(instanceIds(), other.instanceIds()) && hasInstanceTags() == other.hasInstanceTags()
                && Objects.equals(instanceTags(), other.instanceTags()) && hasOperatingSystems() == other.hasOperatingSystems()
                && Objects.equals(operatingSystems(), other.operatingSystems())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2InstanceAggregation").add("Amis", hasAmis() ? amis() : null)
                .add("InstanceIds", hasInstanceIds() ? instanceIds() : null)
                .add("InstanceTags", hasInstanceTags() ? instanceTags() : null)
                .add("OperatingSystems", hasOperatingSystems() ? operatingSystems() : null).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amis":
            return Optional.ofNullable(clazz.cast(amis()));
        case "instanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        case "instanceTags":
            return Optional.ofNullable(clazz.cast(instanceTags()));
        case "operatingSystems":
            return Optional.ofNullable(clazz.cast(operatingSystems()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ec2InstanceAggregation, T> g) {
        return obj -> g.apply((Ec2InstanceAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2InstanceAggregation> {
        /**
         * <p>
         * The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.
         * </p>
         * 
         * @param amis
         *        The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amis(Collection<StringFilter> amis);

        /**
         * <p>
         * The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.
         * </p>
         * 
         * @param amis
         *        The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amis(StringFilter... amis);

        /**
         * <p>
         * The AMI IDs associated with the Amazon EC2 instances to aggregate findings for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #amis(List<StringFilter>)}.
         * 
         * @param amis
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amis(java.util.Collection<StringFilter>)
         */
        Builder amis(Consumer<StringFilter.Builder>... amis);

        /**
         * <p>
         * The Amazon EC2 instance IDs to aggregate findings for.
         * </p>
         * 
         * @param instanceIds
         *        The Amazon EC2 instance IDs to aggregate findings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<StringFilter> instanceIds);

        /**
         * <p>
         * The Amazon EC2 instance IDs to aggregate findings for.
         * </p>
         * 
         * @param instanceIds
         *        The Amazon EC2 instance IDs to aggregate findings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(StringFilter... instanceIds);

        /**
         * <p>
         * The Amazon EC2 instance IDs to aggregate findings for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceIds(List<StringFilter>)}.
         * 
         * @param instanceIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceIds(java.util.Collection<StringFilter>)
         */
        Builder instanceIds(Consumer<StringFilter.Builder>... instanceIds);

        /**
         * <p>
         * The Amazon EC2 instance tags to aggregate findings for.
         * </p>
         * 
         * @param instanceTags
         *        The Amazon EC2 instance tags to aggregate findings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTags(Collection<MapFilter> instanceTags);

        /**
         * <p>
         * The Amazon EC2 instance tags to aggregate findings for.
         * </p>
         * 
         * @param instanceTags
         *        The Amazon EC2 instance tags to aggregate findings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTags(MapFilter... instanceTags);

        /**
         * <p>
         * The Amazon EC2 instance tags to aggregate findings for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.MapFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.MapFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.MapFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceTags(List<MapFilter>)}.
         * 
         * @param instanceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.MapFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceTags(java.util.Collection<MapFilter>)
         */
        Builder instanceTags(Consumer<MapFilter.Builder>... instanceTags);

        /**
         * <p>
         * The operating system types to aggregate findings for. Valid values must be uppercase and underscore
         * separated, examples are <code>ORACLE_LINUX_7</code> and <code>ALPINE_LINUX_3_8</code>.
         * </p>
         * 
         * @param operatingSystems
         *        The operating system types to aggregate findings for. Valid values must be uppercase and underscore
         *        separated, examples are <code>ORACLE_LINUX_7</code> and <code>ALPINE_LINUX_3_8</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystems(Collection<StringFilter> operatingSystems);

        /**
         * <p>
         * The operating system types to aggregate findings for. Valid values must be uppercase and underscore
         * separated, examples are <code>ORACLE_LINUX_7</code> and <code>ALPINE_LINUX_3_8</code>.
         * </p>
         * 
         * @param operatingSystems
         *        The operating system types to aggregate findings for. Valid values must be uppercase and underscore
         *        separated, examples are <code>ORACLE_LINUX_7</code> and <code>ALPINE_LINUX_3_8</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystems(StringFilter... operatingSystems);

        /**
         * <p>
         * The operating system types to aggregate findings for. Valid values must be uppercase and underscore
         * separated, examples are <code>ORACLE_LINUX_7</code> and <code>ALPINE_LINUX_3_8</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #operatingSystems(List<StringFilter>)}.
         * 
         * @param operatingSystems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operatingSystems(java.util.Collection<StringFilter>)
         */
        Builder operatingSystems(Consumer<StringFilter.Builder>... operatingSystems);

        /**
         * <p>
         * The value to sort results by.
         * </p>
         * 
         * @param sortBy
         *        The value to sort results by.
         * @see Ec2InstanceSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2InstanceSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The value to sort results by.
         * </p>
         * 
         * @param sortBy
         *        The value to sort results by.
         * @see Ec2InstanceSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2InstanceSortBy
         */
        Builder sortBy(Ec2InstanceSortBy sortBy);

        /**
         * <p>
         * The order to sort results by.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort results by.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order to sort results by.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort results by.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private List<StringFilter> amis = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private List<MapFilter> instanceTags = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> operatingSystems = DefaultSdkAutoConstructList.getInstance();

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2InstanceAggregation model) {
            amis(model.amis);
            instanceIds(model.instanceIds);
            instanceTags(model.instanceTags);
            operatingSystems(model.operatingSystems);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final List<StringFilter.Builder> getAmis() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.amis);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmis(Collection<StringFilter.BuilderImpl> amis) {
            this.amis = StringFilterListCopier.copyFromBuilder(amis);
        }

        @Override
        public final Builder amis(Collection<StringFilter> amis) {
            this.amis = StringFilterListCopier.copy(amis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amis(StringFilter... amis) {
            amis(Arrays.asList(amis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amis(Consumer<StringFilter.Builder>... amis) {
            amis(Stream.of(amis).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getInstanceIds() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.instanceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceIds(Collection<StringFilter.BuilderImpl> instanceIds) {
            this.instanceIds = StringFilterListCopier.copyFromBuilder(instanceIds);
        }

        @Override
        public final Builder instanceIds(Collection<StringFilter> instanceIds) {
            this.instanceIds = StringFilterListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(StringFilter... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(Consumer<StringFilter.Builder>... instanceIds) {
            instanceIds(Stream.of(instanceIds).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MapFilter.Builder> getInstanceTags() {
            List<MapFilter.Builder> result = MapFilterListCopier.copyToBuilder(this.instanceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceTags(Collection<MapFilter.BuilderImpl> instanceTags) {
            this.instanceTags = MapFilterListCopier.copyFromBuilder(instanceTags);
        }

        @Override
        public final Builder instanceTags(Collection<MapFilter> instanceTags) {
            this.instanceTags = MapFilterListCopier.copy(instanceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTags(MapFilter... instanceTags) {
            instanceTags(Arrays.asList(instanceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTags(Consumer<MapFilter.Builder>... instanceTags) {
            instanceTags(Stream.of(instanceTags).map(c -> MapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getOperatingSystems() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.operatingSystems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperatingSystems(Collection<StringFilter.BuilderImpl> operatingSystems) {
            this.operatingSystems = StringFilterListCopier.copyFromBuilder(operatingSystems);
        }

        @Override
        public final Builder operatingSystems(Collection<StringFilter> operatingSystems) {
            this.operatingSystems = StringFilterListCopier.copy(operatingSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystems(StringFilter... operatingSystems) {
            operatingSystems(Arrays.asList(operatingSystems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystems(Consumer<StringFilter.Builder>... operatingSystems) {
            operatingSystems(Stream.of(operatingSystems).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(Ec2InstanceSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Ec2InstanceAggregation build() {
            return new Ec2InstanceAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
