/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SqsAction implements SdkPojo, Serializable, ToCopyableBuilder<SqsAction.Builder, SqsAction> {
    private static final SdkField<String> QUEUE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueUrl").getter(getter(SqsAction::queueUrl)).setter(setter(Builder::queueUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueUrl").build()).build();

    private static final SdkField<Boolean> USE_BASE64_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useBase64").getter(getter(SqsAction::useBase64)).setter(setter(Builder::useBase64))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useBase64").build()).build();

    private static final SdkField<Payload> PAYLOAD_FIELD = SdkField.<Payload> builder(MarshallingType.SDK_POJO)
            .memberName("payload").getter(getter(SqsAction::payload)).setter(setter(Builder::payload))
            .constructor(Payload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_URL_FIELD,
            USE_BASE64_FIELD, PAYLOAD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String queueUrl;

    private final Boolean useBase64;

    private final Payload payload;

    private SqsAction(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.useBase64 = builder.useBase64;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The URL of the SQS queue where the data is written.
     * </p>
     * 
     * @return The URL of the SQS queue where the data is written.
     */
    public final String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set
     * this to FALSE.
     * </p>
     * 
     * @return Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise,
     *         set this to FALSE.
     */
    public final Boolean useBase64() {
        return useBase64;
    }

    /**
     * <p>
     * You can configure the action payload when you send a message to an Amazon SQS queue.
     * </p>
     * 
     * @return You can configure the action payload when you send a message to an Amazon SQS queue.
     */
    public final Payload payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(useBase64());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqsAction)) {
            return false;
        }
        SqsAction other = (SqsAction) obj;
        return Objects.equals(queueUrl(), other.queueUrl()) && Objects.equals(useBase64(), other.useBase64())
                && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SqsAction").add("QueueUrl", queueUrl()).add("UseBase64", useBase64()).add("Payload", payload())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queueUrl":
            return Optional.ofNullable(clazz.cast(queueUrl()));
        case "useBase64":
            return Optional.ofNullable(clazz.cast(useBase64()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqsAction, T> g) {
        return obj -> g.apply((SqsAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SqsAction> {
        /**
         * <p>
         * The URL of the SQS queue where the data is written.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the SQS queue where the data is written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set
         * this to FALSE.
         * </p>
         * 
         * @param useBase64
         *        Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue.
         *        Otherwise, set this to FALSE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useBase64(Boolean useBase64);

        /**
         * <p>
         * You can configure the action payload when you send a message to an Amazon SQS queue.
         * </p>
         * 
         * @param payload
         *        You can configure the action payload when you send a message to an Amazon SQS queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(Payload payload);

        /**
         * <p>
         * You can configure the action payload when you send a message to an Amazon SQS queue.
         * </p>
         * This is a convenience method that creates an instance of the {@link Payload.Builder} avoiding the need to
         * create one manually via {@link Payload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Payload.Builder#build()} is called immediately and its result is
         * passed to {@link #payload(Payload)}.
         * 
         * @param payload
         *        a consumer that will call methods on {@link Payload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #payload(Payload)
         */
        default Builder payload(Consumer<Payload.Builder> payload) {
            return payload(Payload.builder().applyMutation(payload).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String queueUrl;

        private Boolean useBase64;

        private Payload payload;

        private BuilderImpl() {
        }

        private BuilderImpl(SqsAction model) {
            queueUrl(model.queueUrl);
            useBase64(model.useBase64);
            payload(model.payload);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final Boolean getUseBase64() {
            return useBase64;
        }

        public final void setUseBase64(Boolean useBase64) {
            this.useBase64 = useBase64;
        }

        @Override
        public final Builder useBase64(Boolean useBase64) {
            this.useBase64 = useBase64;
            return this;
        }

        public final Payload.Builder getPayload() {
            return payload != null ? payload.toBuilder() : null;
        }

        public final void setPayload(Payload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(Payload payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public SqsAction build() {
            return new SqsAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
