/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sends information about the detector model instance and the event that triggered the action to a specified asset
 * property in AWS IoT SiteWise.
 * </p>
 * <p>
 * You must use expressions for all parameters in <code>IotSiteWiseAction</code>. The expressions accept literals,
 * operators, functions, references, and substitutions templates.
 * </p>
 * <p class="title">
 * <b>Examples</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * For literal values, the expressions must contain single quotes. For example, the value for the
 * <code>propertyAlias</code> parameter can be <code>'/company/windfarm/3/turbine/7/temperature'</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For references, you must specify either variables or input values. For example, the value for the
 * <code>assetId</code> parameter can be <code>$input.TurbineInput.assetId1</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution
 * template can also contain a combination of literals, operators, functions, references, and substitution templates.
 * </p>
 * <p>
 * In the following example, the value for the <code>propertyAlias</code> parameter uses a substitution template.
 * </p>
 * <p>
 * <code>'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * You must specify either <code>propertyAlias</code> or both <code>assetId</code> and <code>propertyId</code> to
 * identify the target asset property in AWS IoT SiteWise.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the
 * <i>AWS IoT Events Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IotSiteWiseAction implements SdkPojo, Serializable,
        ToCopyableBuilder<IotSiteWiseAction.Builder, IotSiteWiseAction> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entryId").getter(getter(IotSiteWiseAction::entryId)).setter(setter(Builder::entryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()).build();

    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(IotSiteWiseAction::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyId").getter(getter(IotSiteWiseAction::propertyId)).setter(setter(Builder::propertyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyId").build()).build();

    private static final SdkField<String> PROPERTY_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyAlias").getter(getter(IotSiteWiseAction::propertyAlias)).setter(setter(Builder::propertyAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyAlias").build()).build();

    private static final SdkField<AssetPropertyValue> PROPERTY_VALUE_FIELD = SdkField
            .<AssetPropertyValue> builder(MarshallingType.SDK_POJO).memberName("propertyValue")
            .getter(getter(IotSiteWiseAction::propertyValue)).setter(setter(Builder::propertyValue))
            .constructor(AssetPropertyValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD,
            ASSET_ID_FIELD, PROPERTY_ID_FIELD, PROPERTY_ALIAS_FIELD, PROPERTY_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entryId;

    private final String assetId;

    private final String propertyId;

    private final String propertyAlias;

    private final AssetPropertyValue propertyValue;

    private IotSiteWiseAction(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.propertyAlias = builder.propertyAlias;
        this.propertyValue = builder.propertyValue;
    }

    /**
     * <p>
     * A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of
     * failure. The default is a new unique identifier.
     * </p>
     * 
     * @return A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in
     *         case of failure. The default is a new unique identifier.
     */
    public final String entryId() {
        return entryId;
    }

    /**
     * <p>
     * The ID of the asset that has the specified property.
     * </p>
     * 
     * @return The ID of the asset that has the specified property.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The ID of the asset property.
     * </p>
     * 
     * @return The ID of the asset property.
     */
    public final String propertyId() {
        return propertyId;
    }

    /**
     * <p>
     * The alias of the asset property.
     * </p>
     * 
     * @return The alias of the asset property.
     */
    public final String propertyAlias() {
        return propertyAlias;
    }

    /**
     * <p>
     * The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information.
     * </p>
     * 
     * @return The value to send to the asset property. This value contains timestamp, quality, and value (TQV)
     *         information.
     */
    public final AssetPropertyValue propertyValue() {
        return propertyValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryId());
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyAlias());
        hashCode = 31 * hashCode + Objects.hashCode(propertyValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotSiteWiseAction)) {
            return false;
        }
        IotSiteWiseAction other = (IotSiteWiseAction) obj;
        return Objects.equals(entryId(), other.entryId()) && Objects.equals(assetId(), other.assetId())
                && Objects.equals(propertyId(), other.propertyId()) && Objects.equals(propertyAlias(), other.propertyAlias())
                && Objects.equals(propertyValue(), other.propertyValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IotSiteWiseAction").add("EntryId", entryId()).add("AssetId", assetId())
                .add("PropertyId", propertyId()).add("PropertyAlias", propertyAlias()).add("PropertyValue", propertyValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryId":
            return Optional.ofNullable(clazz.cast(entryId()));
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "propertyId":
            return Optional.ofNullable(clazz.cast(propertyId()));
        case "propertyAlias":
            return Optional.ofNullable(clazz.cast(propertyAlias()));
        case "propertyValue":
            return Optional.ofNullable(clazz.cast(propertyValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IotSiteWiseAction, T> g) {
        return obj -> g.apply((IotSiteWiseAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IotSiteWiseAction> {
        /**
         * <p>
         * A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in
         * case of failure. The default is a new unique identifier.
         * </p>
         * 
         * @param entryId
         *        A unique identifier for this entry. You can use the entry ID to track which data entry causes an error
         *        in case of failure. The default is a new unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryId(String entryId);

        /**
         * <p>
         * The ID of the asset that has the specified property.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset that has the specified property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The ID of the asset property.
         * </p>
         * 
         * @param propertyId
         *        The ID of the asset property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyId(String propertyId);

        /**
         * <p>
         * The alias of the asset property.
         * </p>
         * 
         * @param propertyAlias
         *        The alias of the asset property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyAlias(String propertyAlias);

        /**
         * <p>
         * The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information.
         * </p>
         * 
         * @param propertyValue
         *        The value to send to the asset property. This value contains timestamp, quality, and value (TQV)
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyValue(AssetPropertyValue propertyValue);

        /**
         * <p>
         * The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetPropertyValue.Builder} avoiding the
         * need to create one manually via {@link AssetPropertyValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetPropertyValue.Builder#build()} is called immediately and its
         * result is passed to {@link #propertyValue(AssetPropertyValue)}.
         * 
         * @param propertyValue
         *        a consumer that will call methods on {@link AssetPropertyValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyValue(AssetPropertyValue)
         */
        default Builder propertyValue(Consumer<AssetPropertyValue.Builder> propertyValue) {
            return propertyValue(AssetPropertyValue.builder().applyMutation(propertyValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String entryId;

        private String assetId;

        private String propertyId;

        private String propertyAlias;

        private AssetPropertyValue propertyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(IotSiteWiseAction model) {
            entryId(model.entryId);
            assetId(model.assetId);
            propertyId(model.propertyId);
            propertyAlias(model.propertyAlias);
            propertyValue(model.propertyValue);
        }

        public final String getEntryId() {
            return entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getPropertyId() {
            return propertyId;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final String getPropertyAlias() {
            return propertyAlias;
        }

        public final void setPropertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
        }

        @Override
        public final Builder propertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
            return this;
        }

        public final AssetPropertyValue.Builder getPropertyValue() {
            return propertyValue != null ? propertyValue.toBuilder() : null;
        }

        public final void setPropertyValue(AssetPropertyValue.BuilderImpl propertyValue) {
            this.propertyValue = propertyValue != null ? propertyValue.build() : null;
        }

        @Override
        public final Builder propertyValue(AssetPropertyValue propertyValue) {
            this.propertyValue = propertyValue;
            return this;
        }

        @Override
        public IotSiteWiseAction build() {
            return new IotSiteWiseAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
