/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Vehicle Signal Specification (VSS) is a precise language used to describe and model signals in vehicle networks. The
 * JSON file collects signal specificiations in a VSS format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FormattedVss implements SdkPojo, Serializable, ToCopyableBuilder<FormattedVss.Builder, FormattedVss> {
    private static final SdkField<String> VSS_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vssJson").getter(getter(FormattedVss::vssJson)).setter(setter(Builder::vssJson))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vssJson").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VSS_JSON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vssJson;

    private final Type type;

    private FormattedVss(BuilderImpl builder) {
        this.vssJson = builder.vssJson;
        this.type = builder.type;
    }

    /**
     * <p>
     * Provides the VSS in JSON format.
     * </p>
     * 
     * @return Provides the VSS in JSON format.
     */
    public final String vssJson() {
        return vssJson;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vssJson());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormattedVss)) {
            return false;
        }
        FormattedVss other = (FormattedVss) obj;
        return Objects.equals(vssJson(), other.vssJson());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FormattedVss").add("VssJson", vssJson()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vssJson":
            return Optional.ofNullable(clazz.cast(vssJson()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #vssJson()} initialized to the given value.
     *
     * <p>
     * Provides the VSS in JSON format.
     * </p>
     * 
     * @param vssJson
     *        Provides the VSS in JSON format.
     */
    public static FormattedVss fromVssJson(String vssJson) {
        return builder().vssJson(vssJson).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FormattedVss, T> g) {
        return obj -> g.apply((FormattedVss) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FormattedVss> {
        /**
         * <p>
         * Provides the VSS in JSON format.
         * </p>
         * 
         * @param vssJson
         *        Provides the VSS in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vssJson(String vssJson);
    }

    static final class BuilderImpl implements Builder {
        private String vssJson;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FormattedVss model) {
            vssJson(model.vssJson);
        }

        public final String getVssJson() {
            return vssJson;
        }

        public final void setVssJson(String vssJson) {
            Object oldValue = this.vssJson;
            this.vssJson = vssJson;
            handleUnionValueChange(Type.VSS_JSON, oldValue, this.vssJson);
        }

        @Override
        public final Builder vssJson(String vssJson) {
            Object oldValue = this.vssJson;
            this.vssJson = vssJson;
            handleUnionValueChange(Type.VSS_JSON, oldValue, this.vssJson);
            return this;
        }

        @Override
        public FormattedVss build() {
            return new FormattedVss(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FormattedVss#type()
     */
    public enum Type {
        VSS_JSON,

        UNKNOWN_TO_SDK_VERSION
    }
}
