/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterAccountRequest extends IoTFleetWiseRequest implements
        ToCopyableBuilder<RegisterAccountRequest.Builder, RegisterAccountRequest> {
    private static final SdkField<TimestreamResources> TIMESTREAM_RESOURCES_FIELD = SdkField
            .<TimestreamResources> builder(MarshallingType.SDK_POJO).memberName("timestreamResources")
            .getter(getter(RegisterAccountRequest::timestreamResources)).setter(setter(Builder::timestreamResources))
            .constructor(TimestreamResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestreamResources").build())
            .build();

    private static final SdkField<IamResources> IAM_RESOURCES_FIELD = SdkField.<IamResources> builder(MarshallingType.SDK_POJO)
            .memberName("iamResources").getter(getter(RegisterAccountRequest::iamResources))
            .setter(setter(Builder::iamResources)).constructor(IamResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamResources").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTREAM_RESOURCES_FIELD,
            IAM_RESOURCES_FIELD));

    private final TimestreamResources timestreamResources;

    private final IamResources iamResources;

    private RegisterAccountRequest(BuilderImpl builder) {
        super(builder);
        this.timestreamResources = builder.timestreamResources;
        this.iamResources = builder.iamResources;
    }

    /**
     * Returns the value of the TimestreamResources property for this object.
     * 
     * @return The value of the TimestreamResources property for this object.
     */
    public final TimestreamResources timestreamResources() {
        return timestreamResources;
    }

    /**
     * <p>
     * The IAM resource that allows Amazon Web Services IoT FleetWise to send data to Amazon Timestream.
     * </p>
     * 
     * @return The IAM resource that allows Amazon Web Services IoT FleetWise to send data to Amazon Timestream.
     * @deprecated iamResources is no longer used or needed as input
     */
    @Deprecated
    public final IamResources iamResources() {
        return iamResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(timestreamResources());
        hashCode = 31 * hashCode + Objects.hashCode(iamResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterAccountRequest)) {
            return false;
        }
        RegisterAccountRequest other = (RegisterAccountRequest) obj;
        return Objects.equals(timestreamResources(), other.timestreamResources())
                && Objects.equals(iamResources(), other.iamResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterAccountRequest").add("TimestreamResources", timestreamResources())
                .add("IamResources", iamResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timestreamResources":
            return Optional.ofNullable(clazz.cast(timestreamResources()));
        case "iamResources":
            return Optional.ofNullable(clazz.cast(iamResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterAccountRequest, T> g) {
        return obj -> g.apply((RegisterAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTFleetWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterAccountRequest> {
        /**
         * Sets the value of the TimestreamResources property for this object.
         *
         * @param timestreamResources
         *        The new value for the TimestreamResources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestreamResources(TimestreamResources timestreamResources);

        /**
         * Sets the value of the TimestreamResources property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TimestreamResources.Builder} avoiding the
         * need to create one manually via {@link TimestreamResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimestreamResources.Builder#build()} is called immediately and
         * its result is passed to {@link #timestreamResources(TimestreamResources)}.
         * 
         * @param timestreamResources
         *        a consumer that will call methods on {@link TimestreamResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestreamResources(TimestreamResources)
         */
        default Builder timestreamResources(Consumer<TimestreamResources.Builder> timestreamResources) {
            return timestreamResources(TimestreamResources.builder().applyMutation(timestreamResources).build());
        }

        /**
         * <p>
         * The IAM resource that allows Amazon Web Services IoT FleetWise to send data to Amazon Timestream.
         * </p>
         * 
         * @param iamResources
         *        The IAM resource that allows Amazon Web Services IoT FleetWise to send data to Amazon Timestream.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated iamResources is no longer used or needed as input
         */
        @Deprecated
        Builder iamResources(IamResources iamResources);

        /**
         * <p>
         * The IAM resource that allows Amazon Web Services IoT FleetWise to send data to Amazon Timestream.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamResources.Builder} avoiding the need
         * to create one manually via {@link IamResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamResources.Builder#build()} is called immediately and its
         * result is passed to {@link #iamResources(IamResources)}.
         * 
         * @param iamResources
         *        a consumer that will call methods on {@link IamResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamResources(IamResources)
         * @deprecated iamResources is no longer used or needed as input
         */
        @Deprecated
        default Builder iamResources(Consumer<IamResources.Builder> iamResources) {
            return iamResources(IamResources.builder().applyMutation(iamResources).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTFleetWiseRequest.BuilderImpl implements Builder {
        private TimestreamResources timestreamResources;

        private IamResources iamResources;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterAccountRequest model) {
            super(model);
            timestreamResources(model.timestreamResources);
            iamResources(model.iamResources);
        }

        public final TimestreamResources.Builder getTimestreamResources() {
            return timestreamResources != null ? timestreamResources.toBuilder() : null;
        }

        public final void setTimestreamResources(TimestreamResources.BuilderImpl timestreamResources) {
            this.timestreamResources = timestreamResources != null ? timestreamResources.build() : null;
        }

        @Override
        public final Builder timestreamResources(TimestreamResources timestreamResources) {
            this.timestreamResources = timestreamResources;
            return this;
        }

        @Deprecated
        public final IamResources.Builder getIamResources() {
            return iamResources != null ? iamResources.toBuilder() : null;
        }

        @Deprecated
        public final void setIamResources(IamResources.BuilderImpl iamResources) {
            this.iamResources = iamResources != null ? iamResources.build() : null;
        }

        @Override
        @Deprecated
        public final Builder iamResources(IamResources iamResources) {
            this.iamResources = iamResources;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterAccountRequest build() {
            return new RegisterAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
