/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a ROS 2 compliant primitive type message of the complex data structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ROS2PrimitiveMessageDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ROS2PrimitiveMessageDefinition.Builder, ROS2PrimitiveMessageDefinition> {
    private static final SdkField<String> PRIMITIVE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("primitiveType").getter(getter(ROS2PrimitiveMessageDefinition::primitiveTypeAsString))
            .setter(setter(Builder::primitiveType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primitiveType").build()).build();

    private static final SdkField<Double> OFFSET_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("offset")
            .getter(getter(ROS2PrimitiveMessageDefinition::offset)).setter(setter(Builder::offset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offset").build()).build();

    private static final SdkField<Double> SCALING_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("scaling")
            .getter(getter(ROS2PrimitiveMessageDefinition::scaling)).setter(setter(Builder::scaling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaling").build()).build();

    private static final SdkField<Long> UPPER_BOUND_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("upperBound").getter(getter(ROS2PrimitiveMessageDefinition::upperBound))
            .setter(setter(Builder::upperBound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upperBound").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMITIVE_TYPE_FIELD,
            OFFSET_FIELD, SCALING_FIELD, UPPER_BOUND_FIELD));

    private static final long serialVersionUID = 1L;

    private final String primitiveType;

    private final Double offset;

    private final Double scaling;

    private final Long upperBound;

    private ROS2PrimitiveMessageDefinition(BuilderImpl builder) {
        this.primitiveType = builder.primitiveType;
        this.offset = builder.offset;
        this.scaling = builder.scaling;
        this.upperBound = builder.upperBound;
    }

    /**
     * <p>
     * The primitive type (integer, floating point, boolean, etc.) for the ROS 2 primitive message definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #primitiveType}
     * will return {@link ROS2PrimitiveType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #primitiveTypeAsString}.
     * </p>
     * 
     * @return The primitive type (integer, floating point, boolean, etc.) for the ROS 2 primitive message definition.
     * @see ROS2PrimitiveType
     */
    public final ROS2PrimitiveType primitiveType() {
        return ROS2PrimitiveType.fromValue(primitiveType);
    }

    /**
     * <p>
     * The primitive type (integer, floating point, boolean, etc.) for the ROS 2 primitive message definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #primitiveType}
     * will return {@link ROS2PrimitiveType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #primitiveTypeAsString}.
     * </p>
     * 
     * @return The primitive type (integer, floating point, boolean, etc.) for the ROS 2 primitive message definition.
     * @see ROS2PrimitiveType
     */
    public final String primitiveTypeAsString() {
        return primitiveType;
    }

    /**
     * <p>
     * The offset used to calculate the signal value. Combined with scaling, the calculation is
     * <code>value = raw_value * scaling + offset</code>.
     * </p>
     * 
     * @return The offset used to calculate the signal value. Combined with scaling, the calculation is
     *         <code>value = raw_value * scaling + offset</code>.
     */
    public final Double offset() {
        return offset;
    }

    /**
     * <p>
     * A multiplier used to decode the message.
     * </p>
     * 
     * @return A multiplier used to decode the message.
     */
    public final Double scaling() {
        return scaling;
    }

    /**
     * <p>
     * An optional attribute specifying the upper bound for <code>STRING</code> and <code>WSTRING</code>.
     * </p>
     * 
     * @return An optional attribute specifying the upper bound for <code>STRING</code> and <code>WSTRING</code>.
     */
    public final Long upperBound() {
        return upperBound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primitiveTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offset());
        hashCode = 31 * hashCode + Objects.hashCode(scaling());
        hashCode = 31 * hashCode + Objects.hashCode(upperBound());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ROS2PrimitiveMessageDefinition)) {
            return false;
        }
        ROS2PrimitiveMessageDefinition other = (ROS2PrimitiveMessageDefinition) obj;
        return Objects.equals(primitiveTypeAsString(), other.primitiveTypeAsString()) && Objects.equals(offset(), other.offset())
                && Objects.equals(scaling(), other.scaling()) && Objects.equals(upperBound(), other.upperBound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ROS2PrimitiveMessageDefinition").add("PrimitiveType", primitiveTypeAsString())
                .add("Offset", offset()).add("Scaling", scaling()).add("UpperBound", upperBound()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "primitiveType":
            return Optional.ofNullable(clazz.cast(primitiveTypeAsString()));
        case "offset":
            return Optional.ofNullable(clazz.cast(offset()));
        case "scaling":
            return Optional.ofNullable(clazz.cast(scaling()));
        case "upperBound":
            return Optional.ofNullable(clazz.cast(upperBound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ROS2PrimitiveMessageDefinition, T> g) {
        return obj -> g.apply((ROS2PrimitiveMessageDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ROS2PrimitiveMessageDefinition> {
        /**
         * <p>
         * The primitive type (integer, floating point, boolean, etc.) for the ROS 2 primitive message definition.
         * </p>
         * 
         * @param primitiveType
         *        The primitive type (integer, floating point, boolean, etc.) for the ROS 2 primitive message
         *        definition.
         * @see ROS2PrimitiveType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ROS2PrimitiveType
         */
        Builder primitiveType(String primitiveType);

        /**
         * <p>
         * The primitive type (integer, floating point, boolean, etc.) for the ROS 2 primitive message definition.
         * </p>
         * 
         * @param primitiveType
         *        The primitive type (integer, floating point, boolean, etc.) for the ROS 2 primitive message
         *        definition.
         * @see ROS2PrimitiveType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ROS2PrimitiveType
         */
        Builder primitiveType(ROS2PrimitiveType primitiveType);

        /**
         * <p>
         * The offset used to calculate the signal value. Combined with scaling, the calculation is
         * <code>value = raw_value * scaling + offset</code>.
         * </p>
         * 
         * @param offset
         *        The offset used to calculate the signal value. Combined with scaling, the calculation is
         *        <code>value = raw_value * scaling + offset</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offset(Double offset);

        /**
         * <p>
         * A multiplier used to decode the message.
         * </p>
         * 
         * @param scaling
         *        A multiplier used to decode the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaling(Double scaling);

        /**
         * <p>
         * An optional attribute specifying the upper bound for <code>STRING</code> and <code>WSTRING</code>.
         * </p>
         * 
         * @param upperBound
         *        An optional attribute specifying the upper bound for <code>STRING</code> and <code>WSTRING</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upperBound(Long upperBound);
    }

    static final class BuilderImpl implements Builder {
        private String primitiveType;

        private Double offset;

        private Double scaling;

        private Long upperBound;

        private BuilderImpl() {
        }

        private BuilderImpl(ROS2PrimitiveMessageDefinition model) {
            primitiveType(model.primitiveType);
            offset(model.offset);
            scaling(model.scaling);
            upperBound(model.upperBound);
        }

        public final String getPrimitiveType() {
            return primitiveType;
        }

        public final void setPrimitiveType(String primitiveType) {
            this.primitiveType = primitiveType;
        }

        @Override
        public final Builder primitiveType(String primitiveType) {
            this.primitiveType = primitiveType;
            return this;
        }

        @Override
        public final Builder primitiveType(ROS2PrimitiveType primitiveType) {
            this.primitiveType(primitiveType == null ? null : primitiveType.toString());
            return this;
        }

        public final Double getOffset() {
            return offset;
        }

        public final void setOffset(Double offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Double offset) {
            this.offset = offset;
            return this;
        }

        public final Double getScaling() {
            return scaling;
        }

        public final void setScaling(Double scaling) {
            this.scaling = scaling;
        }

        @Override
        public final Builder scaling(Double scaling) {
            this.scaling = scaling;
            return this;
        }

        public final Long getUpperBound() {
            return upperBound;
        }

        public final void setUpperBound(Long upperBound) {
            this.upperBound = upperBound;
        }

        @Override
        public final Builder upperBound(Long upperBound) {
            this.upperBound = upperBound;
            return this;
        }

        @Override
        public ROS2PrimitiveMessageDefinition build() {
            return new ROS2PrimitiveMessageDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
