/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum SignalDecoderFailureReason {
    DUPLICATE_SIGNAL("DUPLICATE_SIGNAL"),

    CONFLICTING_SIGNAL("CONFLICTING_SIGNAL"),

    SIGNAL_TO_ADD_ALREADY_EXISTS("SIGNAL_TO_ADD_ALREADY_EXISTS"),

    SIGNAL_NOT_ASSOCIATED_WITH_NETWORK_INTERFACE("SIGNAL_NOT_ASSOCIATED_WITH_NETWORK_INTERFACE"),

    NETWORK_INTERFACE_TYPE_INCOMPATIBLE_WITH_SIGNAL_DECODER_TYPE("NETWORK_INTERFACE_TYPE_INCOMPATIBLE_WITH_SIGNAL_DECODER_TYPE"),

    SIGNAL_NOT_IN_MODEL("SIGNAL_NOT_IN_MODEL"),

    CAN_SIGNAL_INFO_IS_NULL("CAN_SIGNAL_INFO_IS_NULL"),

    OBD_SIGNAL_INFO_IS_NULL("OBD_SIGNAL_INFO_IS_NULL"),

    NO_DECODER_INFO_FOR_SIGNAL_IN_MODEL("NO_DECODER_INFO_FOR_SIGNAL_IN_MODEL"),

    MESSAGE_SIGNAL_INFO_IS_NULL("MESSAGE_SIGNAL_INFO_IS_NULL"),

    SIGNAL_DECODER_TYPE_INCOMPATIBLE_WITH_MESSAGE_SIGNAL_TYPE("SIGNAL_DECODER_TYPE_INCOMPATIBLE_WITH_MESSAGE_SIGNAL_TYPE"),

    STRUCT_SIZE_MISMATCH("STRUCT_SIZE_MISMATCH"),

    NO_SIGNAL_IN_CATALOG_FOR_DECODER_SIGNAL("NO_SIGNAL_IN_CATALOG_FOR_DECODER_SIGNAL"),

    SIGNAL_DECODER_INCOMPATIBLE_WITH_SIGNAL_CATALOG("SIGNAL_DECODER_INCOMPATIBLE_WITH_SIGNAL_CATALOG"),

    EMPTY_MESSAGE_SIGNAL("EMPTY_MESSAGE_SIGNAL"),

    CUSTOMER_DECODED_SIGNAL_INFO_IS_NULL("CUSTOMER_DECODED_SIGNAL_INFO_IS_NULL"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SignalDecoderFailureReason> VALUE_MAP = EnumUtils.uniqueIndex(
            SignalDecoderFailureReason.class, SignalDecoderFailureReason::toString);

    private final String value;

    private SignalDecoderFailureReason(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return SignalDecoderFailureReason corresponding to the value
     */
    public static SignalDecoderFailureReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link SignalDecoderFailureReason}s
     */
    public static Set<SignalDecoderFailureReason> knownValues() {
        Set<SignalDecoderFailureReason> knownValues = EnumSet.allOf(SignalDecoderFailureReason.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
